/*
 * Decompiled with CFR 0.152.
 */
package org.rssys;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import net.jcip.annotations.NotThreadSafe;
import org.rssys.DatagramSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class StatsD
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(StatsD.class);
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final DatagramSocketFactory socketFactory;
    private InetSocketAddress address;
    private DatagramSocket socket;
    private int failures;

    StatsD(String string, int n) {
        this(new InetSocketAddress(string, n), new DatagramSocketFactory());
    }

    StatsD(InetSocketAddress inetSocketAddress, DatagramSocketFactory datagramSocketFactory) {
        this.address = inetSocketAddress;
        this.socketFactory = datagramSocketFactory;
    }

    public void connect() throws IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Already connected");
        }
        if (this.address.getHostName() != null) {
            this.address = new InetSocketAddress(this.address.getHostName(), this.address.getPort());
        }
        this.socket = this.socketFactory.createSocket();
    }

    public void send(String string, String string2) {
        try {
            String string3 = String.format("%s:%s|g", this.sanitize(string), this.sanitize(string2));
            byte[] byArray = string3.getBytes(UTF_8);
            this.socket.send(this.socketFactory.createPacket(byArray, byArray.length, this.address));
            this.failures = 0;
        }
        catch (IOException iOException) {
            ++this.failures;
            if (this.failures == 1) {
                LOG.warn("unable to send packet to statsd at '{}:{}'", (Object)this.address.getHostName(), (Object)this.address.getPort());
            }
            LOG.debug("unable to send packet to statsd at '{}:{}'", (Object)this.address.getHostName(), (Object)this.address.getPort());
        }
    }

    public int getFailures() {
        return this.failures;
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
    }

    private String sanitize(String string) {
        return WHITESPACE.matcher(string).replaceAll("-");
    }
}

