/*
 * Decompiled with CFR 0.152.
 */
package org.rssys;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.jcip.annotations.NotThreadSafe;
import org.rssys.StatsD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class StatsDReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(StatsDReporter.class);
    private final StatsD statsD;
    private final String prefix;

    private StatsDReporter(MetricRegistry metricRegistry, StatsD statsD, String string, TimeUnit timeUnit, TimeUnit timeUnit2, MetricFilter metricFilter) {
        super(metricRegistry, "statsd-reporter", metricFilter, timeUnit, timeUnit2);
        this.statsD = statsD;
        this.prefix = string;
    }

    public static Builder forRegistry(MetricRegistry metricRegistry) {
        return new Builder(metricRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<String, Gauge> sortedMap, SortedMap<String, Counter> sortedMap2, SortedMap<String, Histogram> sortedMap3, SortedMap<String, Meter> sortedMap4, SortedMap<String, Timer> sortedMap5) {
        try {
            this.statsD.connect();
            for (Map.Entry<String, Gauge> entry : sortedMap.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : sortedMap2.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : sortedMap3.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : sortedMap4.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : sortedMap5.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue());
            }
        }
        catch (IOException iOException) {
            LOG.warn("Unable to report to StatsD", (Object)this.statsD, (Object)iOException);
        }
        finally {
            try {
                this.statsD.close();
            }
            catch (IOException iOException) {
                LOG.debug("Error disconnecting from StatsD", (Object)this.statsD, (Object)iOException);
            }
        }
    }

    private void reportTimer(String string, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.statsD.send(this.prefix(string, "max"), this.formatNumber(this.convertDuration(snapshot.getMax())));
        this.statsD.send(this.prefix(string, "mean"), this.formatNumber(this.convertDuration(snapshot.getMean())));
        this.statsD.send(this.prefix(string, "min"), this.formatNumber(this.convertDuration(snapshot.getMin())));
        this.statsD.send(this.prefix(string, "stddev"), this.formatNumber(this.convertDuration(snapshot.getStdDev())));
        this.statsD.send(this.prefix(string, "p50"), this.formatNumber(this.convertDuration(snapshot.getMedian())));
        this.statsD.send(this.prefix(string, "p75"), this.formatNumber(this.convertDuration(snapshot.get75thPercentile())));
        this.statsD.send(this.prefix(string, "p95"), this.formatNumber(this.convertDuration(snapshot.get95thPercentile())));
        this.statsD.send(this.prefix(string, "p98"), this.formatNumber(this.convertDuration(snapshot.get98thPercentile())));
        this.statsD.send(this.prefix(string, "p99"), this.formatNumber(this.convertDuration(snapshot.get99thPercentile())));
        this.statsD.send(this.prefix(string, "p999"), this.formatNumber(this.convertDuration(snapshot.get999thPercentile())));
        this.reportMetered(string, (Metered)timer);
    }

    private void reportMetered(String string, Metered metered) {
        this.statsD.send(this.prefix(string, "samples"), this.formatNumber(metered.getCount()));
        this.statsD.send(this.prefix(string, "m1_rate"), this.formatNumber(this.convertRate(metered.getOneMinuteRate())));
        this.statsD.send(this.prefix(string, "m5_rate"), this.formatNumber(this.convertRate(metered.getFiveMinuteRate())));
        this.statsD.send(this.prefix(string, "m15_rate"), this.formatNumber(this.convertRate(metered.getFifteenMinuteRate())));
        this.statsD.send(this.prefix(string, "mean_rate"), this.formatNumber(this.convertRate(metered.getMeanRate())));
    }

    private void reportHistogram(String string, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        this.statsD.send(this.prefix(string, "samples"), this.formatNumber(histogram.getCount()));
        this.statsD.send(this.prefix(string, "max"), this.formatNumber(snapshot.getMax()));
        this.statsD.send(this.prefix(string, "mean"), this.formatNumber(snapshot.getMean()));
        this.statsD.send(this.prefix(string, "min"), this.formatNumber(snapshot.getMin()));
        this.statsD.send(this.prefix(string, "stddev"), this.formatNumber(snapshot.getStdDev()));
        this.statsD.send(this.prefix(string, "p50"), this.formatNumber(snapshot.getMedian()));
        this.statsD.send(this.prefix(string, "p75"), this.formatNumber(snapshot.get75thPercentile()));
        this.statsD.send(this.prefix(string, "p95"), this.formatNumber(snapshot.get95thPercentile()));
        this.statsD.send(this.prefix(string, "p98"), this.formatNumber(snapshot.get98thPercentile()));
        this.statsD.send(this.prefix(string, "p99"), this.formatNumber(snapshot.get99thPercentile()));
        this.statsD.send(this.prefix(string, "p999"), this.formatNumber(snapshot.get999thPercentile()));
    }

    private void reportCounter(String string, Counter counter) {
        this.statsD.send(this.prefix(string), this.formatNumber(counter.getCount()));
    }

    private void reportGauge(String string, Gauge gauge) {
        String string2 = this.format(gauge.getValue());
        if (string2 != null) {
            this.statsD.send(this.prefix(string), string2);
        }
    }

    @Nullable
    private String format(Object object) {
        if (object instanceof Float) {
            return this.formatNumber(((Float)object).doubleValue());
        }
        if (object instanceof Double) {
            return this.formatNumber((Double)object);
        }
        if (object instanceof Byte) {
            return this.formatNumber(((Byte)object).longValue());
        }
        if (object instanceof Short) {
            return this.formatNumber(((Short)object).longValue());
        }
        if (object instanceof Integer) {
            return this.formatNumber(((Integer)object).longValue());
        }
        if (object instanceof Long) {
            return this.formatNumber((Long)object);
        }
        if (object instanceof BigInteger) {
            return this.formatNumber((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return this.formatNumber(((BigDecimal)object).doubleValue());
        }
        return null;
    }

    private String prefix(String ... stringArray) {
        return MetricRegistry.name((String)this.prefix, (String[])stringArray);
    }

    private String formatNumber(BigInteger bigInteger) {
        return String.valueOf(bigInteger);
    }

    private String formatNumber(long l) {
        return Long.toString(l);
    }

    private String formatNumber(double d) {
        return String.format(Locale.US, "%2.2f", d);
    }

    @NotThreadSafe
    public static final class Builder {
        private final MetricRegistry registry;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry metricRegistry) {
            this.registry = metricRegistry;
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder prefixedWith(@Nullable String string) {
            this.prefix = string;
            return this;
        }

        public Builder convertRatesTo(TimeUnit timeUnit) {
            this.rateUnit = timeUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit timeUnit) {
            this.durationUnit = timeUnit;
            return this;
        }

        public Builder filter(MetricFilter metricFilter) {
            this.filter = metricFilter;
            return this;
        }

        public StatsDReporter build(String string, int n) {
            return this.build(new StatsD(string, n));
        }

        public StatsDReporter build(StatsD statsD) {
            return new StatsDReporter(this.registry, statsD, this.prefix, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

