;  CRAL
;  Copyright (C) 2023-2024 Saidone
;
;  This program is free software: you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation, either version 3 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program.  If not, see <http://www.gnu.org/licenses/>.

(ns cral.model.alfresco.cm)

;; generated with https://saidone.org/#/cm-clj

(def ^:const cm-uri "http://www.alfresco.org/model/content/1.0")
(def ^:const cm-prefix "cm")
(def ^:const rn-uri "http://www.alfresco.org/model/rendition/1.0")
(def ^:const rn-prefix "rn")
(def ^:const exif-uri "http://www.alfresco.org/model/exif/1.0")
(def ^:const exif-prefix "exif")
(def ^:const audio-uri "http://www.alfresco.org/model/audio/1.0")
(def ^:const audio-prefix "audio")
(def ^:const webdav-uri "http://www.alfresco.org/model/webdav/1.0")
(def ^:const webdav-prefix "webdav")
(def ^:const type-cmobject-localname "cmobject")
(def ^:const type-cmobject (keyword (format "%s:%s" cm-prefix type-cmobject-localname)))
(def ^:const type-folder-localname "folder")
(def ^:const type-folder (keyword (format "%s:%s" cm-prefix type-folder-localname)))
(def ^:const type-content-localname "content")
(def ^:const type-content (keyword (format "%s:%s" cm-prefix type-content-localname)))
(def ^:const type-dictionary-model-localname "dictionary-model")
(def ^:const type-dictionary-model (keyword (format "%s:%s" cm-prefix type-dictionary-model-localname)))
(def ^:const type-link-localname "link")
(def ^:const type-link (keyword (format "%s:%s" cm-prefix type-link-localname)))
(def ^:const type-savedquery-localname "savedquery")
(def ^:const type-savedquery (keyword (format "%s:%s" cm-prefix type-savedquery-localname)))
(def ^:const type-systemfolder-localname "systemfolder")
(def ^:const type-systemfolder (keyword (format "%s:%s" cm-prefix type-systemfolder-localname)))
(def ^:const type-authority-localname "authority")
(def ^:const type-authority (keyword (format "%s:%s" cm-prefix type-authority-localname)))
(def ^:const type-person-localname "person")
(def ^:const type-person (keyword (format "%s:%s" cm-prefix type-person-localname)))
(def ^:const type-authority-container-localname "authority-container")
(def ^:const type-authority-container (keyword (format "%s:%s" cm-prefix type-authority-container-localname)))
(def ^:const type-zone-localname "zone")
(def ^:const type-zone (keyword (format "%s:%s" cm-prefix type-zone-localname)))
(def ^:const type-category_root-localname "category_root")
(def ^:const type-category_root (keyword (format "%s:%s" cm-prefix type-category_root-localname)))
(def ^:const type-category-localname "category")
(def ^:const type-category (keyword (format "%s:%s" cm-prefix type-category-localname)))
(def ^:const type-ml-root-localname "ml-root")
(def ^:const type-ml-root (keyword (format "%s:%s" cm-prefix type-ml-root-localname)))
(def ^:const type-ml-container-localname "ml-container")
(def ^:const type-ml-container (keyword (format "%s:%s" cm-prefix type-ml-container-localname)))
(def ^:const type-rating-localname "rating")
(def ^:const type-rating (keyword (format "%s:%s" cm-prefix type-rating-localname)))
(def ^:const type-failed-thumbnail-localname "failed-thumbnail")
(def ^:const type-failed-thumbnail (keyword (format "%s:%s" cm-prefix type-failed-thumbnail-localname)))
(def ^:const type-thumbnail-localname "thumbnail")
(def ^:const type-thumbnail (keyword (format "%s:%s" cm-prefix type-thumbnail-localname)))
(def ^:const asp-titled-localname "titled")
(def ^:const asp-titled (keyword (format "%s:%s" cm-prefix asp-titled-localname)))
(def ^:const asp-auditable-localname "auditable")
(def ^:const asp-auditable (keyword (format "%s:%s" cm-prefix asp-auditable-localname)))
(def ^:const asp-person-disabled-localname "person-disabled")
(def ^:const asp-person-disabled (keyword (format "%s:%s" cm-prefix asp-person-disabled-localname)))
(def ^:const asp-annullable-localname "annullable")
(def ^:const asp-annullable (keyword (format "%s:%s" cm-prefix asp-annullable-localname)))
(def ^:const asp-transformable-localname "transformable")
(def ^:const asp-transformable (keyword (format "%s:%s" cm-prefix asp-transformable-localname)))
(def ^:const asp-templatable-localname "templatable")
(def ^:const asp-templatable (keyword (format "%s:%s" cm-prefix asp-templatable-localname)))
(def ^:const asp-webscriptable-localname "webscriptable")
(def ^:const asp-webscriptable (keyword (format "%s:%s" cm-prefix asp-webscriptable-localname)))
(def ^:const asp-projectsummary-localname "projectsummary")
(def ^:const asp-projectsummary (keyword (format "%s:%s" cm-prefix asp-projectsummary-localname)))
(def ^:const asp-complianceable-localname "complianceable")
(def ^:const asp-complianceable (keyword (format "%s:%s" cm-prefix asp-complianceable-localname)))
(def ^:const asp-ownable-localname "ownable")
(def ^:const asp-ownable (keyword (format "%s:%s" cm-prefix asp-ownable-localname)))
(def ^:const asp-author-localname "author")
(def ^:const asp-author (keyword (format "%s:%s" cm-prefix asp-author-localname)))
(def ^:const asp-dublincore-localname "dublincore")
(def ^:const asp-dublincore (keyword (format "%s:%s" cm-prefix asp-dublincore-localname)))
(def ^:const asp-basable-localname "basable")
(def ^:const asp-basable (keyword (format "%s:%s" cm-prefix asp-basable-localname)))
(def ^:const asp-partable-localname "partable")
(def ^:const asp-partable (keyword (format "%s:%s" cm-prefix asp-partable-localname)))
(def ^:const asp-referencing-localname "referencing")
(def ^:const asp-referencing (keyword (format "%s:%s" cm-prefix asp-referencing-localname)))
(def ^:const asp-replaceable-localname "replaceable")
(def ^:const asp-replaceable (keyword (format "%s:%s" cm-prefix asp-replaceable-localname)))
(def ^:const asp-effectivity-localname "effectivity")
(def ^:const asp-effectivity (keyword (format "%s:%s" cm-prefix asp-effectivity-localname)))
(def ^:const asp-summarizable-localname "summarizable")
(def ^:const asp-summarizable (keyword (format "%s:%s" cm-prefix asp-summarizable-localname)))
(def ^:const asp-countable-localname "countable")
(def ^:const asp-countable (keyword (format "%s:%s" cm-prefix asp-countable-localname)))
(def ^:const asp-copiedfrom-localname "copiedfrom")
(def ^:const asp-copiedfrom (keyword (format "%s:%s" cm-prefix asp-copiedfrom-localname)))
(def ^:const asp-workingcopy-localname "workingcopy")
(def ^:const asp-workingcopy (keyword (format "%s:%s" cm-prefix asp-workingcopy-localname)))
(def ^:const asp-checked-out-localname "checked-out")
(def ^:const asp-checked-out (keyword (format "%s:%s" cm-prefix asp-checked-out-localname)))
(def ^:const asp-cmis-created-checked-out-localname "cmis-created-checked-out")
(def ^:const asp-cmis-created-checked-out (keyword (format "%s:%s" cm-prefix asp-cmis-created-checked-out-localname)))
(def ^:const asp-versionable-localname "versionable")
(def ^:const asp-versionable (keyword (format "%s:%s" cm-prefix asp-versionable-localname)))
(def ^:const asp-lockable-localname "lockable")
(def ^:const asp-lockable (keyword (format "%s:%s" cm-prefix asp-lockable-localname)))
(def ^:const asp-subscribable-localname "subscribable")
(def ^:const asp-subscribable (keyword (format "%s:%s" cm-prefix asp-subscribable-localname)))
(def ^:const asp-classifiable-localname "classifiable")
(def ^:const asp-classifiable (keyword (format "%s:%s" cm-prefix asp-classifiable-localname)))
(def ^:const asp-generalclassifiable-localname "generalclassifiable")
(def ^:const asp-generalclassifiable (keyword (format "%s:%s" cm-prefix asp-generalclassifiable-localname)))
(def ^:const asp-taggable-localname "taggable")
(def ^:const asp-taggable (keyword (format "%s:%s" cm-prefix asp-taggable-localname)))
(def ^:const asp-tagscope-localname "tagscope")
(def ^:const asp-tagscope (keyword (format "%s:%s" cm-prefix asp-tagscope-localname)))
(def ^:const asp-rateable-localname "rateable")
(def ^:const asp-rateable (keyword (format "%s:%s" cm-prefix asp-rateable-localname)))
(def ^:const asp-likes-rating-scheme-rollups-localname "likes-rating-scheme-rollups")
(def ^:const asp-likes-rating-scheme-rollups (keyword (format "%s:%s" cm-prefix asp-likes-rating-scheme-rollups-localname)))
(def ^:const asp-five-star-rating-scheme-rollups-localname "five-star-rating-scheme-rollups")
(def ^:const asp-five-star-rating-scheme-rollups (keyword (format "%s:%s" cm-prefix asp-five-star-rating-scheme-rollups-localname)))
(def ^:const asp-attachable-localname "attachable")
(def ^:const asp-attachable (keyword (format "%s:%s" cm-prefix asp-attachable-localname)))
(def ^:const asp-emailed-localname "emailed")
(def ^:const asp-emailed (keyword (format "%s:%s" cm-prefix asp-emailed-localname)))
(def ^:const asp-referencesnode-localname "referencesnode")
(def ^:const asp-referencesnode (keyword (format "%s:%s" cm-prefix asp-referencesnode-localname)))
(def ^:const asp-ml-document-localname "ml-document")
(def ^:const asp-ml-document (keyword (format "%s:%s" cm-prefix asp-ml-document-localname)))
(def ^:const asp-ml-empty-translation-localname "ml-empty-translation")
(def ^:const asp-ml-empty-translation (keyword (format "%s:%s" cm-prefix asp-ml-empty-translation-localname)))
(def ^:const asp-store-selector-localname "store-selector")
(def ^:const asp-store-selector (keyword (format "%s:%s" cm-prefix asp-store-selector-localname)))
(def ^:const asp-preferences-localname "preferences")
(def ^:const asp-preferences (keyword (format "%s:%s" cm-prefix asp-preferences-localname)))
(def ^:const asp-syndication-localname "syndication")
(def ^:const asp-syndication (keyword (format "%s:%s" cm-prefix asp-syndication-localname)))
(def ^:const asp-geographic-localname "geographic")
(def ^:const asp-geographic (keyword (format "%s:%s" cm-prefix asp-geographic-localname)))
(def ^:const asp-rendition-localname "rendition")
(def ^:const asp-rendition (keyword (format "%s:%s" rn-prefix asp-rendition-localname)))
(def ^:const asp-rendition2-localname "rendition2")
(def ^:const asp-rendition2 (keyword (format "%s:%s" rn-prefix asp-rendition2-localname)))
(def ^:const asp-hidden-rendition-localname "hidden-rendition")
(def ^:const asp-hidden-rendition (keyword (format "%s:%s" rn-prefix asp-hidden-rendition-localname)))
(def ^:const asp-visible-rendition-localname "visible-rendition")
(def ^:const asp-visible-rendition (keyword (format "%s:%s" rn-prefix asp-visible-rendition-localname)))
(def ^:const asp-renditioned-localname "renditioned")
(def ^:const asp-renditioned (keyword (format "%s:%s" rn-prefix asp-renditioned-localname)))
(def ^:const asp-prevent-renditions-localname "prevent-renditions")
(def ^:const asp-prevent-renditions (keyword (format "%s:%s" rn-prefix asp-prevent-renditions-localname)))
(def ^:const asp-failed-thumbnail-source-localname "failed-thumbnail-source")
(def ^:const asp-failed-thumbnail-source (keyword (format "%s:%s" cm-prefix asp-failed-thumbnail-source-localname)))
(def ^:const asp-thumbnail-modification-localname "thumbnail-modification")
(def ^:const asp-thumbnail-modification (keyword (format "%s:%s" cm-prefix asp-thumbnail-modification-localname)))
(def ^:const asp-exif-localname "exif")
(def ^:const asp-exif (keyword (format "%s:%s" exif-prefix asp-exif-localname)))
(def ^:const asp-audio-localname "audio")
(def ^:const asp-audio (keyword (format "%s:%s" audio-prefix asp-audio-localname)))
(def ^:const asp-index-control-localname "index-control")
(def ^:const asp-index-control (keyword (format "%s:%s" cm-prefix asp-index-control-localname)))
(def ^:const asp-object-localname "object")
(def ^:const asp-object (keyword (format "%s:%s" webdav-prefix asp-object-localname)))
(def ^:const asp-localizable-localname "localizable")
(def ^:const asp-localizable (keyword (format "%s:%s" cm-prefix asp-localizable-localname)))
(def ^:const asp-translatable-localname "translatable")
(def ^:const asp-translatable (keyword (format "%s:%s" cm-prefix asp-translatable-localname)))
(def ^:const asp-thumbnailed-localname "thumbnailed")
(def ^:const asp-thumbnailed (keyword (format "%s:%s" cm-prefix asp-thumbnailed-localname)))
(def ^:const assoc-formats-localname "formats")
(def ^:const assoc-formats (keyword (format "%s:%s" cm-prefix assoc-formats-localname)))
(def ^:const assoc-basis-localname "basis")
(def ^:const assoc-basis (keyword (format "%s:%s" cm-prefix assoc-basis-localname)))
(def ^:const assoc-parts-localname "parts")
(def ^:const assoc-parts (keyword (format "%s:%s" cm-prefix assoc-parts-localname)))
(def ^:const assoc-references-localname "references")
(def ^:const assoc-references (keyword (format "%s:%s" cm-prefix assoc-references-localname)))
(def ^:const assoc-replaces-localname "replaces")
(def ^:const assoc-replaces (keyword (format "%s:%s" cm-prefix assoc-replaces-localname)))
(def ^:const assoc-original-localname "original")
(def ^:const assoc-original (keyword (format "%s:%s" cm-prefix assoc-original-localname)))
(def ^:const assoc-workingcopylink-localname "workingcopylink")
(def ^:const assoc-workingcopylink (keyword (format "%s:%s" cm-prefix assoc-workingcopylink-localname)))
(def ^:const assoc-subscribed-by-localname "subscribed-by")
(def ^:const assoc-subscribed-by (keyword (format "%s:%s" cm-prefix assoc-subscribed-by-localname)))
(def ^:const assoc-ratings-localname "ratings")
(def ^:const assoc-ratings (keyword (format "%s:%s" cm-prefix assoc-ratings-localname)))
(def ^:const assoc-attachments-localname "attachments")
(def ^:const assoc-attachments (keyword (format "%s:%s" cm-prefix assoc-attachments-localname)))
(def ^:const assoc-preference-image-localname "preference-image")
(def ^:const assoc-preference-image (keyword (format "%s:%s" cm-prefix assoc-preference-image-localname)))
(def ^:const assoc-rendition-localname "rendition")
(def ^:const assoc-rendition (keyword (format "%s:%s" rn-prefix assoc-rendition-localname)))
(def ^:const assoc-failed-thumbnail-localname "failed-thumbnail")
(def ^:const assoc-failed-thumbnail (keyword (format "%s:%s" cm-prefix assoc-failed-thumbnail-localname)))
(def ^:const assoc-translations-localname "translations")
(def ^:const assoc-translations (keyword (format "%s:%s" cm-prefix assoc-translations-localname)))
(def ^:const assoc-contains-localname "contains")
(def ^:const assoc-contains (keyword (format "%s:%s" cm-prefix assoc-contains-localname)))
(def ^:const assoc-avatar-localname "avatar")
(def ^:const assoc-avatar (keyword (format "%s:%s" cm-prefix assoc-avatar-localname)))
(def ^:const assoc-member-localname "member")
(def ^:const assoc-member (keyword (format "%s:%s" cm-prefix assoc-member-localname)))
(def ^:const assoc-in-zone-localname "in-zone")
(def ^:const assoc-in-zone (keyword (format "%s:%s" cm-prefix assoc-in-zone-localname)))
(def ^:const assoc-categories-localname "categories")
(def ^:const assoc-categories (keyword (format "%s:%s" cm-prefix assoc-categories-localname)))
(def ^:const assoc-subcategories-localname "subcategories")
(def ^:const assoc-subcategories (keyword (format "%s:%s" cm-prefix assoc-subcategories-localname)))
(def ^:const assoc-ml-container-localname "ml-container")
(def ^:const assoc-ml-container (keyword (format "%s:%s" cm-prefix assoc-ml-container-localname)))
(def ^:const assoc-ml-child-localname "ml-child")
(def ^:const assoc-ml-child (keyword (format "%s:%s" cm-prefix assoc-ml-child-localname)))
(def ^:const prop-title-localname "title")
(def ^:const prop-title (keyword (format "%s:%s" cm-prefix prop-title-localname)))
(def ^:const prop-description-localname "description")
(def ^:const prop-description (keyword (format "%s:%s" cm-prefix prop-description-localname)))
(def ^:const prop-created-localname "created")
(def ^:const prop-created (keyword (format "%s:%s" cm-prefix prop-created-localname)))
(def ^:const prop-creator-localname "creator")
(def ^:const prop-creator (keyword (format "%s:%s" cm-prefix prop-creator-localname)))
(def ^:const prop-modified-localname "modified")
(def ^:const prop-modified (keyword (format "%s:%s" cm-prefix prop-modified-localname)))
(def ^:const prop-modifier-localname "modifier")
(def ^:const prop-modifier (keyword (format "%s:%s" cm-prefix prop-modifier-localname)))
(def ^:const prop-accessed-localname "accessed")
(def ^:const prop-accessed (keyword (format "%s:%s" cm-prefix prop-accessed-localname)))
(def ^:const prop-template-localname "template")
(def ^:const prop-template (keyword (format "%s:%s" cm-prefix prop-template-localname)))
(def ^:const prop-webscript-localname "webscript")
(def ^:const prop-webscript (keyword (format "%s:%s" cm-prefix prop-webscript-localname)))
(def ^:const prop-summary-webscript-localname "summary-webscript")
(def ^:const prop-summary-webscript (keyword (format "%s:%s" cm-prefix prop-summary-webscript-localname)))
(def ^:const prop-remove-after-localname "remove-after")
(def ^:const prop-remove-after (keyword (format "%s:%s" cm-prefix prop-remove-after-localname)))
(def ^:const prop-owner-localname "owner")
(def ^:const prop-owner (keyword (format "%s:%s" cm-prefix prop-owner-localname)))
(def ^:const prop-author-localname "author")
(def ^:const prop-author (keyword (format "%s:%s" cm-prefix prop-author-localname)))
(def ^:const prop-publisher-localname "publisher")
(def ^:const prop-publisher (keyword (format "%s:%s" cm-prefix prop-publisher-localname)))
(def ^:const prop-contributor-localname "contributor")
(def ^:const prop-contributor (keyword (format "%s:%s" cm-prefix prop-contributor-localname)))
(def ^:const prop-type-localname "type")
(def ^:const prop-type (keyword (format "%s:%s" cm-prefix prop-type-localname)))
(def ^:const prop-identifier-localname "identifier")
(def ^:const prop-identifier (keyword (format "%s:%s" cm-prefix prop-identifier-localname)))
(def ^:const prop-dcsource-localname "dcsource")
(def ^:const prop-dcsource (keyword (format "%s:%s" cm-prefix prop-dcsource-localname)))
(def ^:const prop-coverage-localname "coverage")
(def ^:const prop-coverage (keyword (format "%s:%s" cm-prefix prop-coverage-localname)))
(def ^:const prop-rights-localname "rights")
(def ^:const prop-rights (keyword (format "%s:%s" cm-prefix prop-rights-localname)))
(def ^:const prop-subject-localname "subject")
(def ^:const prop-subject (keyword (format "%s:%s" cm-prefix prop-subject-localname)))
(def ^:const prop-from-localname "from")
(def ^:const prop-from (keyword (format "%s:%s" cm-prefix prop-from-localname)))
(def ^:const prop-to-localname "to")
(def ^:const prop-to (keyword (format "%s:%s" cm-prefix prop-to-localname)))
(def ^:const prop-summary-localname "summary")
(def ^:const prop-summary (keyword (format "%s:%s" cm-prefix prop-summary-localname)))
(def ^:const prop-hits-localname "hits")
(def ^:const prop-hits (keyword (format "%s:%s" cm-prefix prop-hits-localname)))
(def ^:const prop-counter-localname "counter")
(def ^:const prop-counter (keyword (format "%s:%s" cm-prefix prop-counter-localname)))
(def ^:const prop-working-copy-owner-localname "working-copy-owner")
(def ^:const prop-working-copy-owner (keyword (format "%s:%s" cm-prefix prop-working-copy-owner-localname)))
(def ^:const prop-working-copy-mode-localname "working-copy-mode")
(def ^:const prop-working-copy-mode (keyword (format "%s:%s" cm-prefix prop-working-copy-mode-localname)))
(def ^:const prop-working-copy-label-localname "working-copy-label")
(def ^:const prop-working-copy-label (keyword (format "%s:%s" cm-prefix prop-working-copy-label-localname)))
(def ^:const prop-version-label-localname "version-label")
(def ^:const prop-version-label (keyword (format "%s:%s" cm-prefix prop-version-label-localname)))
(def ^:const prop-version-type-localname "version-type")
(def ^:const prop-version-type (keyword (format "%s:%s" cm-prefix prop-version-type-localname)))
(def ^:const prop-initial-version-localname "initial-version")
(def ^:const prop-initial-version (keyword (format "%s:%s" cm-prefix prop-initial-version-localname)))
(def ^:const prop-auto-version-localname "auto-version")
(def ^:const prop-auto-version (keyword (format "%s:%s" cm-prefix prop-auto-version-localname)))
(def ^:const prop-auto-version-on-update-props-localname "auto-version-on-update-props")
(def ^:const prop-auto-version-on-update-props (keyword (format "%s:%s" cm-prefix prop-auto-version-on-update-props-localname)))
(def ^:const prop-lock-owner-localname "lock-owner")
(def ^:const prop-lock-owner (keyword (format "%s:%s" cm-prefix prop-lock-owner-localname)))
(def ^:const prop-lock-type-localname "lock-type")
(def ^:const prop-lock-type (keyword (format "%s:%s" cm-prefix prop-lock-type-localname)))
(def ^:const prop-lock-lifetime-localname "lock-lifetime")
(def ^:const prop-lock-lifetime (keyword (format "%s:%s" cm-prefix prop-lock-lifetime-localname)))
(def ^:const prop-expiry-date-localname "expiry-date")
(def ^:const prop-expiry-date (keyword (format "%s:%s" cm-prefix prop-expiry-date-localname)))
(def ^:const prop-lock-is-deep-localname "lock-is-deep")
(def ^:const prop-lock-is-deep (keyword (format "%s:%s" cm-prefix prop-lock-is-deep-localname)))
(def ^:const prop-lock-additional-info-localname "lock-additional-info")
(def ^:const prop-lock-additional-info (keyword (format "%s:%s" cm-prefix prop-lock-additional-info-localname)))
(def ^:const prop-categories-localname "categories")
(def ^:const prop-categories (keyword (format "%s:%s" cm-prefix prop-categories-localname)))
(def ^:const prop-taggable-localname "taggable")
(def ^:const prop-taggable (keyword (format "%s:%s" cm-prefix prop-taggable-localname)))
(def ^:const prop-tag-scope-cache-localname "tag-scope-cache")
(def ^:const prop-tag-scope-cache (keyword (format "%s:%s" cm-prefix prop-tag-scope-cache-localname)))
(def ^:const prop-tag-scope-summary-localname "tag-scope-summary")
(def ^:const prop-tag-scope-summary (keyword (format "%s:%s" cm-prefix prop-tag-scope-summary-localname)))
(def ^:const prop-likes-rating-scheme-count-localname "likes-rating-scheme-count")
(def ^:const prop-likes-rating-scheme-count (keyword (format "%s:%s" cm-prefix prop-likes-rating-scheme-count-localname)))
(def ^:const prop-likes-rating-scheme-total-localname "likes-rating-scheme-total")
(def ^:const prop-likes-rating-scheme-total (keyword (format "%s:%s" cm-prefix prop-likes-rating-scheme-total-localname)))
(def ^:const prop-five-star-rating-scheme-count-localname "five-star-rating-scheme-count")
(def ^:const prop-five-star-rating-scheme-count (keyword (format "%s:%s" cm-prefix prop-five-star-rating-scheme-count-localname)))
(def ^:const prop-five-star-rating-scheme-total-localname "five-star-rating-scheme-total")
(def ^:const prop-five-star-rating-scheme-total (keyword (format "%s:%s" cm-prefix prop-five-star-rating-scheme-total-localname)))
(def ^:const prop-originator-localname "originator")
(def ^:const prop-originator (keyword (format "%s:%s" cm-prefix prop-originator-localname)))
(def ^:const prop-addressee-localname "addressee")
(def ^:const prop-addressee (keyword (format "%s:%s" cm-prefix prop-addressee-localname)))
(def ^:const prop-addressees-localname "addressees")
(def ^:const prop-addressees (keyword (format "%s:%s" cm-prefix prop-addressees-localname)))
(def ^:const prop-subjectline-localname "subjectline")
(def ^:const prop-subjectline (keyword (format "%s:%s" cm-prefix prop-subjectline-localname)))
(def ^:const prop-sentdate-localname "sentdate")
(def ^:const prop-sentdate (keyword (format "%s:%s" cm-prefix prop-sentdate-localname)))
(def ^:const prop-noderef-localname "noderef")
(def ^:const prop-noderef (keyword (format "%s:%s" cm-prefix prop-noderef-localname)))
(def ^:const prop-store-name-localname "store-name")
(def ^:const prop-store-name (keyword (format "%s:%s" cm-prefix prop-store-name-localname)))
(def ^:const prop-preference-values-localname "preference-values")
(def ^:const prop-preference-values (keyword (format "%s:%s" cm-prefix prop-preference-values-localname)))
(def ^:const prop-published-localname "published")
(def ^:const prop-published (keyword (format "%s:%s" cm-prefix prop-published-localname)))
(def ^:const prop-updated-localname "updated")
(def ^:const prop-updated (keyword (format "%s:%s" cm-prefix prop-updated-localname)))
(def ^:const prop-latitude-localname "latitude")
(def ^:const prop-latitude (keyword (format "%s:%s" cm-prefix prop-latitude-localname)))
(def ^:const prop-longitude-localname "longitude")
(def ^:const prop-longitude (keyword (format "%s:%s" cm-prefix prop-longitude-localname)))
(def ^:const prop-content-url-hash-code-localname "content-url-hash-code")
(def ^:const prop-content-url-hash-code (keyword (format "%s:%s" rn-prefix prop-content-url-hash-code-localname)))
(def ^:const prop-last-thumbnail-modification-localname "last-thumbnail-modification")
(def ^:const prop-last-thumbnail-modification (keyword (format "%s:%s" cm-prefix prop-last-thumbnail-modification-localname)))
(def ^:const prop-date-time-original-localname "date-time-original")
(def ^:const prop-date-time-original (keyword (format "%s:%s" exif-prefix prop-date-time-original-localname)))
(def ^:const prop-pixel-xdimension-localname "pixel-xdimension")
(def ^:const prop-pixel-xdimension (keyword (format "%s:%s" exif-prefix prop-pixel-xdimension-localname)))
(def ^:const prop-pixel-ydimension-localname "pixel-ydimension")
(def ^:const prop-pixel-ydimension (keyword (format "%s:%s" exif-prefix prop-pixel-ydimension-localname)))
(def ^:const prop-exposure-time-localname "exposure-time")
(def ^:const prop-exposure-time (keyword (format "%s:%s" exif-prefix prop-exposure-time-localname)))
(def ^:const prop-f-number-localname "f-number")
(def ^:const prop-f-number (keyword (format "%s:%s" exif-prefix prop-f-number-localname)))
(def ^:const prop-flash-localname "flash")
(def ^:const prop-flash (keyword (format "%s:%s" exif-prefix prop-flash-localname)))
(def ^:const prop-focal-length-localname "focal-length")
(def ^:const prop-focal-length (keyword (format "%s:%s" exif-prefix prop-focal-length-localname)))
(def ^:const prop-iso-speed-ratings-localname "iso-speed-ratings")
(def ^:const prop-iso-speed-ratings (keyword (format "%s:%s" exif-prefix prop-iso-speed-ratings-localname)))
(def ^:const prop-manufacturer-localname "manufacturer")
(def ^:const prop-manufacturer (keyword (format "%s:%s" exif-prefix prop-manufacturer-localname)))
(def ^:const prop-model-localname "model")
(def ^:const prop-model (keyword (format "%s:%s" exif-prefix prop-model-localname)))
(def ^:const prop-software-localname "software")
(def ^:const prop-software (keyword (format "%s:%s" exif-prefix prop-software-localname)))
(def ^:const prop-orientation-localname "orientation")
(def ^:const prop-orientation (keyword (format "%s:%s" exif-prefix prop-orientation-localname)))
(def ^:const prop-x-resolution-localname "x-resolution")
(def ^:const prop-x-resolution (keyword (format "%s:%s" exif-prefix prop-x-resolution-localname)))
(def ^:const prop-y-resolution-localname "y-resolution")
(def ^:const prop-y-resolution (keyword (format "%s:%s" exif-prefix prop-y-resolution-localname)))
(def ^:const prop-resolution-unit-localname "resolution-unit")
(def ^:const prop-resolution-unit (keyword (format "%s:%s" exif-prefix prop-resolution-unit-localname)))
(def ^:const prop-album-localname "album")
(def ^:const prop-album (keyword (format "%s:%s" audio-prefix prop-album-localname)))
(def ^:const prop-artist-localname "artist")
(def ^:const prop-artist (keyword (format "%s:%s" audio-prefix prop-artist-localname)))
(def ^:const prop-composer-localname "composer")
(def ^:const prop-composer (keyword (format "%s:%s" audio-prefix prop-composer-localname)))
(def ^:const prop-engineer-localname "engineer")
(def ^:const prop-engineer (keyword (format "%s:%s" audio-prefix prop-engineer-localname)))
(def ^:const prop-genre-localname "genre")
(def ^:const prop-genre (keyword (format "%s:%s" audio-prefix prop-genre-localname)))
(def ^:const prop-track-number-localname "track-number")
(def ^:const prop-track-number (keyword (format "%s:%s" audio-prefix prop-track-number-localname)))
(def ^:const prop-release-date-localname "release-date")
(def ^:const prop-release-date (keyword (format "%s:%s" audio-prefix prop-release-date-localname)))
(def ^:const prop-sample-rate-localname "sample-rate")
(def ^:const prop-sample-rate (keyword (format "%s:%s" audio-prefix prop-sample-rate-localname)))
(def ^:const prop-sample-type-localname "sample-type")
(def ^:const prop-sample-type (keyword (format "%s:%s" audio-prefix prop-sample-type-localname)))
(def ^:const prop-channel-type-localname "channel-type")
(def ^:const prop-channel-type (keyword (format "%s:%s" audio-prefix prop-channel-type-localname)))
(def ^:const prop-compressor-localname "compressor")
(def ^:const prop-compressor (keyword (format "%s:%s" audio-prefix prop-compressor-localname)))
(def ^:const prop-is-indexed-localname "is-indexed")
(def ^:const prop-is-indexed (keyword (format "%s:%s" cm-prefix prop-is-indexed-localname)))
(def ^:const prop-is-content-indexed-localname "is-content-indexed")
(def ^:const prop-is-content-indexed (keyword (format "%s:%s" cm-prefix prop-is-content-indexed-localname)))
(def ^:const prop-deadproperties-localname "deadproperties")
(def ^:const prop-deadproperties (keyword (format "%s:%s" webdav-prefix prop-deadproperties-localname)))
(def ^:const prop-locale-localname "locale")
(def ^:const prop-locale (keyword (format "%s:%s" cm-prefix prop-locale-localname)))
(def ^:const prop-automatic-update-localname "automatic-update")
(def ^:const prop-automatic-update (keyword (format "%s:%s" cm-prefix prop-automatic-update-localname)))
(def ^:const prop-name-localname "name")
(def ^:const prop-name (keyword (format "%s:%s" cm-prefix prop-name-localname)))
(def ^:const prop-content-localname "content")
(def ^:const prop-content (keyword (format "%s:%s" cm-prefix prop-content-localname)))
(def ^:const prop-model-name-localname "model-name")
(def ^:const prop-model-name (keyword (format "%s:%s" cm-prefix prop-model-name-localname)))
(def ^:const prop-model-description-localname "model-description")
(def ^:const prop-model-description (keyword (format "%s:%s" cm-prefix prop-model-description-localname)))
(def ^:const prop-model-author-localname "model-author")
(def ^:const prop-model-author (keyword (format "%s:%s" cm-prefix prop-model-author-localname)))
(def ^:const prop-model-published-date-localname "model-published-date")
(def ^:const prop-model-published-date (keyword (format "%s:%s" cm-prefix prop-model-published-date-localname)))
(def ^:const prop-model-version-localname "model-version")
(def ^:const prop-model-version (keyword (format "%s:%s" cm-prefix prop-model-version-localname)))
(def ^:const prop-model-active-localname "model-active")
(def ^:const prop-model-active (keyword (format "%s:%s" cm-prefix prop-model-active-localname)))
(def ^:const prop-destination-localname "destination")
(def ^:const prop-destination (keyword (format "%s:%s" cm-prefix prop-destination-localname)))
(def ^:const prop-user-name-localname "user-name")
(def ^:const prop-user-name (keyword (format "%s:%s" cm-prefix prop-user-name-localname)))
(def ^:const prop-home-folder-localname "home-folder")
(def ^:const prop-home-folder (keyword (format "%s:%s" cm-prefix prop-home-folder-localname)))
(def ^:const prop-first-name-localname "first-name")
(def ^:const prop-first-name (keyword (format "%s:%s" cm-prefix prop-first-name-localname)))
(def ^:const prop-last-name-localname "last-name")
(def ^:const prop-last-name (keyword (format "%s:%s" cm-prefix prop-last-name-localname)))
(def ^:const prop-middle-name-localname "middle-name")
(def ^:const prop-middle-name (keyword (format "%s:%s" cm-prefix prop-middle-name-localname)))
(def ^:const prop-email-localname "email")
(def ^:const prop-email (keyword (format "%s:%s" cm-prefix prop-email-localname)))
(def ^:const prop-organization-id-localname "organization-id")
(def ^:const prop-organization-id (keyword (format "%s:%s" cm-prefix prop-organization-id-localname)))
(def ^:const prop-home-folder-provider-localname "home-folder-provider")
(def ^:const prop-home-folder-provider (keyword (format "%s:%s" cm-prefix prop-home-folder-provider-localname)))
(def ^:const prop-default-home-folder-path-localname "default-home-folder-path")
(def ^:const prop-default-home-folder-path (keyword (format "%s:%s" cm-prefix prop-default-home-folder-path-localname)))
(def ^:const prop-presence-provider-localname "presence-provider")
(def ^:const prop-presence-provider (keyword (format "%s:%s" cm-prefix prop-presence-provider-localname)))
(def ^:const prop-presence-username-localname "presence-username")
(def ^:const prop-presence-username (keyword (format "%s:%s" cm-prefix prop-presence-username-localname)))
(def ^:const prop-organization-localname "organization")
(def ^:const prop-organization (keyword (format "%s:%s" cm-prefix prop-organization-localname)))
(def ^:const prop-jobtitle-localname "jobtitle")
(def ^:const prop-jobtitle (keyword (format "%s:%s" cm-prefix prop-jobtitle-localname)))
(def ^:const prop-location-localname "location")
(def ^:const prop-location (keyword (format "%s:%s" cm-prefix prop-location-localname)))
(def ^:const prop-persondescription-localname "persondescription")
(def ^:const prop-persondescription (keyword (format "%s:%s" cm-prefix prop-persondescription-localname)))
(def ^:const prop-telephone-localname "telephone")
(def ^:const prop-telephone (keyword (format "%s:%s" cm-prefix prop-telephone-localname)))
(def ^:const prop-mobile-localname "mobile")
(def ^:const prop-mobile (keyword (format "%s:%s" cm-prefix prop-mobile-localname)))
(def ^:const prop-companyaddress1-localname "companyaddress1")
(def ^:const prop-companyaddress1 (keyword (format "%s:%s" cm-prefix prop-companyaddress1-localname)))
(def ^:const prop-companyaddress2-localname "companyaddress2")
(def ^:const prop-companyaddress2 (keyword (format "%s:%s" cm-prefix prop-companyaddress2-localname)))
(def ^:const prop-companyaddress3-localname "companyaddress3")
(def ^:const prop-companyaddress3 (keyword (format "%s:%s" cm-prefix prop-companyaddress3-localname)))
(def ^:const prop-companypostcode-localname "companypostcode")
(def ^:const prop-companypostcode (keyword (format "%s:%s" cm-prefix prop-companypostcode-localname)))
(def ^:const prop-companytelephone-localname "companytelephone")
(def ^:const prop-companytelephone (keyword (format "%s:%s" cm-prefix prop-companytelephone-localname)))
(def ^:const prop-companyfax-localname "companyfax")
(def ^:const prop-companyfax (keyword (format "%s:%s" cm-prefix prop-companyfax-localname)))
(def ^:const prop-companyemail-localname "companyemail")
(def ^:const prop-companyemail (keyword (format "%s:%s" cm-prefix prop-companyemail-localname)))
(def ^:const prop-skype-localname "skype")
(def ^:const prop-skype (keyword (format "%s:%s" cm-prefix prop-skype-localname)))
(def ^:const prop-instantmsg-localname "instantmsg")
(def ^:const prop-instantmsg (keyword (format "%s:%s" cm-prefix prop-instantmsg-localname)))
(def ^:const prop-user-status-localname "user-status")
(def ^:const prop-user-status (keyword (format "%s:%s" cm-prefix prop-user-status-localname)))
(def ^:const prop-user-status-time-localname "user-status-time")
(def ^:const prop-user-status-time (keyword (format "%s:%s" cm-prefix prop-user-status-time-localname)))
(def ^:const prop-googleusername-localname "googleusername")
(def ^:const prop-googleusername (keyword (format "%s:%s" cm-prefix prop-googleusername-localname)))
(def ^:const prop-email-feed-disabled-localname "email-feed-disabled")
(def ^:const prop-email-feed-disabled (keyword (format "%s:%s" cm-prefix prop-email-feed-disabled-localname)))
(def ^:const prop-subscriptions-private-localname "subscriptions-private")
(def ^:const prop-subscriptions-private (keyword (format "%s:%s" cm-prefix prop-subscriptions-private-localname)))
(def ^:const prop-email-feed-id-localname "email-feed-id")
(def ^:const prop-email-feed-id (keyword (format "%s:%s" cm-prefix prop-email-feed-id-localname)))
(def ^:const prop-size-current-localname "size-current")
(def ^:const prop-size-current (keyword (format "%s:%s" cm-prefix prop-size-current-localname)))
(def ^:const prop-size-quota-localname "size-quota")
(def ^:const prop-size-quota (keyword (format "%s:%s" cm-prefix prop-size-quota-localname)))
(def ^:const prop-authority-name-localname "authority-name")
(def ^:const prop-authority-name (keyword (format "%s:%s" cm-prefix prop-authority-name-localname)))
(def ^:const prop-authority-display-name-localname "authority-display-name")
(def ^:const prop-authority-display-name (keyword (format "%s:%s" cm-prefix prop-authority-display-name-localname)))
(def ^:const prop-rating-score-localname "rating-score")
(def ^:const prop-rating-score (keyword (format "%s:%s" cm-prefix prop-rating-score-localname)))
(def ^:const prop-rating-scheme-localname "rating-scheme")
(def ^:const prop-rating-scheme (keyword (format "%s:%s" cm-prefix prop-rating-scheme-localname)))
(def ^:const prop-rated-at-localname "rated-at")
(def ^:const prop-rated-at (keyword (format "%s:%s" cm-prefix prop-rated-at-localname)))
(def ^:const prop-failure-count-localname "failure-count")
(def ^:const prop-failure-count (keyword (format "%s:%s" cm-prefix prop-failure-count-localname)))
(def ^:const prop-failed-thumbnail-time-localname "failed-thumbnail-time")
(def ^:const prop-failed-thumbnail-time (keyword (format "%s:%s" cm-prefix prop-failed-thumbnail-time-localname)))
(def ^:const prop-thumbnail-name-localname "thumbnail-name")
(def ^:const prop-thumbnail-name (keyword (format "%s:%s" cm-prefix prop-thumbnail-name-localname)))
(def ^:const prop-content-property-name-localname "content-property-name")
(def ^:const prop-content-property-name (keyword (format "%s:%s" cm-prefix prop-content-property-name-localname)))