(ns ifast.fasting
  (:require #?(:clj [clojure.spec.alpha :as s]
               :cljs [cljs.spec.alpha :as s])))

(s/def ::id #{:20-4 :16-8})

(s/def ::period (s/and int? pos?))

(s/def ::short-fasting (s/keys :req [::period ::id]))

(s/fdef short-fast
        :args (s/cat :id ::id :hours ::period)
        :ret ::short-fasting)

(defn short-fast
  "Create a new short fasting description with a `id` and the time in hours the fast should be."
  [id hours]
  {::id id ::period hours})

(def twenty-four (short-fast :20-4 20))

(def sixteen-eight (short-fast :16-8 16))

(def ms-in-an-hour (* 60 60 1000))

(defn hours-since-last-meal
  "Calculate the hours between 2 points in time."
  [last-meal-timestamp time-of-interest]
  (-> time-of-interest (- last-meal-timestamp)
      (/ ms-in-an-hour)))

(defn can-eat?
  "Given a fasting, determine if eating would already be allowed with it."
  [fasting last-meal-timestamp current-time]
  (let [{:keys [::period]} fasting
        hours-of-fasting   ((fnil hours-since-last-meal 0 0) last-meal-timestamp current-time)]
    (>= hours-of-fasting period)))

