(ns scicloj.clay.v1.lib.tmd
  (:require [scicloj.kindly.v2.api :as kindly]
            [scicloj.kindly.v2.kindness :as kindness]))

(def lib
  {:dep '{techascent/tech.ml.dataset {:mvn/version "6.078"}}
   :setup (fn []
            (require '[tech.v3.dataset]
                     '[tech.v3.dataset.impl.dataset.])
            (extend-protocol kindness/Kindness
              tech.v3.dataset.impl.dataset.Dataset
              (kind [this]
                :kind/dataset))

            (kindly/define-kind-behaviour!
              :kind/dataset
              {:portal.viewer (fn [v]
                                [:portal.viewer/hiccup
                                 [:portal.viewer/markdown (-> v
                                                              println
                                                              with-out-str)]])})
            (kindly/define-kind-behaviour!
              :kind/dataset
              {:clerk.viewer (fn [v]
                               (-> v
                                   ds/mapseq-reader
                                   clerk/table))}))})
