(ns scicloj.noj.v1.vis.gg
  (:require [tablecloth.api :as tc]
            [scicloj.noj.v1.vis :as vis]
            [scicloj.noj.v1.stats :as stats]
            [aerial.hanami.templates :as ht]
            [aerial.hanami.common :as hc]
            [scicloj.kindly.v3.kind :as kind]
            [clojure2d.color :as color]
            [scicloj.noj.v1.datasets :as datasets]
            [tech.v3.datatype :as dtype]))






(defn only-one [values]
  (-> values count (= 1) assert)
  (first values))

(defn at-most-one [values]
  (-> values count (<= 1) assert)
  (first values))


(defn ppret [x tag]
  (clojure.pprint/pprint [tag x])
  x)



;; (defn ggplot [dataset
;;               mapping
;;               layers]
;;   (let [facet-layer (-> layers
;;                         (->> (filter (fn [layer-type & _]
;;                                        (= layer-type :facet-grid))))
;;                         only-one)
;;         grouping (-> (concat (->> grouping-aesthetics
;;                                   (map mapping)
;;                                   (filter identity))
;;                              (some->> facet-layer
;;                                       ((juxt :row :column))))
;;                      (ppret :grouping1)
;;                      distinct
;;                      sort
;;                      seq)
;;         maybe-grouped-dataset (if (seq grouping)
;;                                 (-> dataset
;;                                     (tc/group-by grouping))
;;                                 dataset)]
;;     maybe-grouped-dataset))


(def aesthetics-which-always-group
  [:group])

(def aesthetics-which-group-when-nonnumeric
  [:colour :size])

(defn numeric? [dataset column-name]
  (-> column-name
      dataset
      dtype/elemwise-datatype
      (#{:int16 :int32 :int64
         :float16 :float32 :float64})
      some?))



(defn ggplot [dataset
              {:keys [mapping options]}
              layers]
  (let [facet-grid-layer (->> layers
                              (filter (fn [[layer-type & _]]
                                        (= layer-type :facet-grid)))
                              at-most-one)
        all-mappings (->> layers
                          (map :mapping)
                          (cons mapping))
        grouping-columns (->> (concat
                               (-> facet-grid-layer
                                   ((juxt :row :column)))
                               (->> all-mappings
                                    (mapcat (fn [mapping]
                                              (map mapping aesthetics-which-always-group))))
                               (->> all-mappings
                                    (mapcat (fn [mapping]
                                              (map mapping aesthetics-which-group-when-nonnumeric)))
                                    (filter (fn [column-name]
                                              (-> dataset
                                                  (numeric? column-name)
                                                  not)))))
                              distinct
                              (remove nil?)
                              sort)]
    grouping-columns))



(-> datasets/mtcars
    (ggplot {:mapping {:x :wt
                       :y :mpg
                       :colour :gear}}
            [[:geom-point {:options {:size 200}}]
             [:geom-smooth {:options {:type :regression-line
                                      :size 5}}]
             [:facet-grid {:options {:row :gear}}]]))
