
(let [pallete (->> :accent
                   color/palette
                   (mapv color/format-hex))]
  (-> mtcars
      (tc/group-by :gear {:result-type :as-map})
      (->> (sort-by key)
           (map-indexed
            (fn [i [group-name ds]]
              (-> ds
                  (stats/add-predictions :mpg [:wt]
                                         {:model-type :smile.regression/ordinary-least-square})
                  (vis/hanami-layers {:TITLE (str "grear=" group-name)}
                                     [(vis/hanami-plot nil
                                                       ht/point-chart
                                                       {:X :wt
                                                        :Y :mpg
                                                        :MSIZE 200
                                                        :MCOLOR (pallete i)
                                                        :HEIGHT 200
                                                        :WIDTH 200})
                                      (vis/hanami-plot nil
                                                       ht/line-chart
                                                       {:X :wt
                                                        :Y :mpg-prediction
                                                        :MSIZE 5
                                                        :MCOLOR (pallete i)
                                                        :YTITLE :mpg})]
                                     ))))
           (vis/hanami-hconcat nil {}))))


























(-> iris
    (ggplot {:x :sepal-width
             :y :sepal-length
             :colour :species}
            [[:geom-point {:size 20}]
             [:geom-smooth {:method :linear-model}]
             [:facet-grid {:column :species}]]))








(-> iris
    (ggplot {:x :sepal-width
             :y :sepal-length
             :colour :species}
            [[:geom-point
              {:size 20}]]))



(-> iris
    (ggplot {}
            [[:geom-point
              :aes{:x :sepal-width
                   :y :sepal-length
                   :colour :species}
              {:size 20}]]))



(-> iris
    (ggplot {}
            [[:geom-point
              {:aes/x :sepal-width
               :aes/y :sepal-length
               :aes/color :species
               :size 20}]]))





(-> iris
    (ggplot {}
            [[:geom-point
              {:mapping {:x :sepal-width
                         :y :sepal-length
                         :colour :species}
               :options {:size 20}}]]))

(-> iris
    (ggplot {}
            [[:geom-point
              {:mapping {:x :sepal-width
                         :y :sepal-length}
               :options {:size 20
                         :colour "purple"}}]]))



(-> iris
    (ggplot {:mapping {:x "Sepal.Width"
                       :y "Sepal.Length"}}
            [[:geom-point
              {:mapping {:colour "Species"}
               :options {:size 20}}]]))
