(ns scicloj.viz.try-histogram
  (:require [aerial.hanami.common :as hc]
            [aerial.hanami.templates :as ht]
            [aerial.hanami.core :as hmi]
            [clojure.java.io :as io]
            [cheshire.core]
            [tablecloth.api :as tablecloth]
            [notespace.api :as notespace]
            [scicloj.viz.api :as api]
            [tech.v3.dataset :as tmd]))

(def diamond-data (tmd/->dataset "resources/data/diamonds.csv"))


;; ^kind/vega
(hc/xform ht/bar-chart
          :DATA (take 4 (tablecloth/rows diamond-data :as-maps))
          :X "cut"
          :XTYPE "nominal"
          :YAGG "count")


;; ^kind/vega
(hc/xform ht/bar-chart
          :DATA (take 4 (tablecloth/rows diamond-data :as-maps))
          :X "price"
          :XBIN true
          :YAGG "count")

(hc/xform ht/bar-chart
          :ENCODING (merge (hc/get-default :ENCODING)
                           {:y {:aggregate "count"}})
          :DATA (take 4 (tablecloth/rows diamond-data :as-maps))
          :X "price"
          :XBIN true)


(hc/get-default :ENCODING)
(hc/get-default :TOOLTIP)

:X-AND-TYPE {:field :X :type :XTYPE}

:ok

@hc/_defaults













(hc/xform ht/bar-chart
          :X "price"
          :XTYPE "nominal")


(hc/xform ht/bar-chart
          :X-AND-TYPE {:x    "price"
                       :type "nominal"}
          :X (:x :X-AND-TYPE)
          :XTYPE (:type :X-AND-TYPE))



