(ns scicloj.viz.try-hanami
  (:require [aerial.hanami.common :as hc]
            [aerial.hanami.templates :as ht]
            [aerial.hanami.core :as hmi]
            [clojure.java.io :as io]
            [cheshire.core]
            [tablecloth.api :as tablecloth]
            [notespace.api :as notespace]
            [notespace.kinds :as kind]
            [scicloj.viz.api :as api]
            [tech.v3.dataset :as tmd]))


(hc/get-default :BACKGROUND)
(hc/get-default :TITLE)
(hc/get-default :XTYPE)
(hc/get-default :X)
(hc/get-default :ENCODING)

ht/point-chart


(hc/get-default :TOOLTIP)



(hc/xform ht/point-chart :X "abcd")


(hc/xform ht/point-chart
          :ENCODING {:x {:field "efgh"}}
          :X "abcd")


(hc/xform ht/point-chart
          :ENCODING (merge (hc/get-default :ENCODING)
                           {:y {:aggregate "count"}})
          :X "abcd")

{:encoding {:y {:aggregate "count"},
            :x {:field "abcd", :type "quantitative"},
            :tooltip [{:field "abcd", :type "quantitative"}
                      {:field "y", :type "quantitative"}]},
 :mark {:type "circle"},
 :width 400,
 :background "floralwhite",
 :height 300}


(hc/xform ht/point-chart
          :ENCODING (merge (hc/get-default :ENCODING)
                           {:y {:aggregate "count"}})
          :X "abcd")






