


(ns scicloj.viz.as-vega
  (:require [tech.v3.dataset :as tmd]
            [scicloj.viz.util :as util]
            [scicloj.viz.api :as viz]))


(defn layer-guess-if-no-marks [vis]
  (if (:marks vis)
    vis
    (layer-guess vis)))

(defn combine-data-props [marks]
  )

(defn gather-scales [vis]
  (->> x
      :marks
      (filter mark-group?)
      (map :scales)
      (apply concat (:scales x))))

(defn mark-group->vega [mark-group]
  )

(defn mark->vega [mark]
  )


(defn props->vega
  ([props]
   (props->vega props nil))
  ([props {:keys [default-scales]}]
   (->> props
        (util/fmap (fn [prop]
                     (map prop-vega prop (or default-scales
                                             (propname->scale props))))))))

(defn axis->vega [axis]
  (when-not (:hide axis)
    (-> axis
        (update :properties props->vega))))

(def legend->vega axis->vega)

(defn dataset->hanami [ds]
  (viz/data ds))


(defn vis->vega [vis]
  (let [vis                  (layer-guess vis)
        data-props         (-> vis
                               :marks
                               combine-data-props)
        data-ids           (keys data-props)
        data-table         (-> vis
                               :data
                               (select-keys data-ids))
        vis                  (collapse-scales vis)
        scale-data-table   (scale-domain-data vis)
        data-as-vega (->> data-table
                                (util/fmap dataset->vega))
        scale-data-as-vega (->> scale-data-table
                                (util/fmap dataset->vega))
        _                  (check-scales-complete! vis)
        vis (-> vis
                add-missing-axes
                apply-axes-defaults
                add-missing-legends
                fortify-legends
                apply-legends-defaults
                add-default-options)]
    {:data (merge data-as-vega scale-data-as-vega)
     :scales (->> vis
                  :scales
                  vals
                  (map scale->vega))
     :marks (->> vis
                 :marks
                 (map mark->vega))
     :legends (->> vis
                   :legends
                   (map mark->vega))
     :axes (->> vis
               :axes
               (map axis->vega))
     :paddding (-> vis
                   :options
                   :padding
                   padding->vega)
     :vis-opts (-> vis
                   :options)})


)


