(ns scicloj.viz.gg
  (:require
   [tech.v3.dataset :as tmd]))

(defn add-props [vis props]
  (-> vis
      (update :props conj props)
      (assoc :cur-props props)))

(defn add-data [vis data
                {:keys [name]
                 :or {name (tmd/dataset-name
                            data)}}]
  (-> vis
      (update :data assoc name data)
      (assoc :cur-data data)))


(defn ->vis [data props]
  (-> {:marks     {}
       :scales    {}
       :axes      {}
       :legends   {}
       :options   {}
       :data      {}
       :cur-data  nil
       :props     []
       :cur-props nil}
      (add-data data)
      (add-props props)))

(defn register-scales-from-props
  ([vis]
   (-> vis
       (register-scales-from-props (:cur-props vis))))
  ([vis props]
   vis))

(defn append [vis field value]
  (update vis field conj value))

(defn add-mark [vis {:keys [typ props data data-name]}]
  (-> vis
      (add-data data data-name)
      (add-props props)
      register-scales-from-props
      (append :marks (->mark typ props))))
