(ns scicloj.viz.scratch
  (:require [aerial.hanami.common :as hc]
            [aerial.hanami.templates :as ht]
            [aerial.hanami.core :as hmi]
            [clojure.java.io :as io]
            [cheshire.core]
            [tablecloth.api :as tablecloth]
            [notespace.api :as notespace]
            [notespace.kinds :as kind]
            [scicloj.viz.api :as viz]
            [tech.v3.dataset :as tmd]))

(hc/xform ht/point-chart
          :UDATA "data/cars.json"
          :X "Horsepower" :Y "Miles_per_Gallon" :COLOR "Origin")

(viz/viz {:type ht/point-chart
          :UDATA "data/cars.json"
          :X "Horsepower" :Y "Miles_per_Gallon" :COLOR "Origin"})

;; pseudocode for a possible alternative
#_(-> "data/cars.json"
      (viz/viz ht/point-chart
               :X     "Horsepower"
               :Y "Miles_per_Gallon"
               :COLOR "Origin"))


(hc/xform ht/point-chart
          :UDATA "data/cars.json"
          :X "Horsepower"
          :Y "Miles_per_Gallon"
          :COLOR {:field "Origin"
                  :type "nominal"
                  :abcd "efgh"})



(viz/viz {:type  ht/point-chart
          :UDATA "data/cars.json"
          :X     "Horsepower" :Y "Miles_per_Gallon" :COLOR "Origin"})


(-> "data/cars.json"
    viz/data
    (viz/type ht/point-chart)
    (viz/x "Horsepower")
    (viz/y "Miles_per_Gallon")
    (viz/color "Origin")
    viz/viz)


(-> "data/cars.json"
    viz/data
    (viz/type ht/point-chart)
    (viz/x "Horsepower")
    (viz/y "Miles_per_Gallon")
    (viz/color "Origin")
    (assoc :SIZE 200)
    viz/viz)


qplot

