(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16468,        487]
NotebookOptionsPosition[     14595,        424]
NotebookOutlinePosition[     14976,        440]
CellTagsIndexPosition[     14933,        437]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", 
   RowBox[{"\"\<HashMaps`\>\"", ",", " ", 
    RowBox[{"{", "\"\<FunctionalExtras`\>\"", "}"}]}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463285661565*^9, 3.46328567205*^9}, {3.463285939401*^9, 
  3.4632859448190002`*^9}}],

Cell[BoxData[
 RowBox[{"HashMap", ";", " ", "HashMapObject", ";", " ", "HashMapValue", ";", 
  " ", "Rules", ";", " ", "Lookup", ";", "Associate", ";", " ", "ZipMap", ";",
   "Disassociate", ";", " ", "MapOntoValues", ";", " ", 
  "MapAtValue"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4632856748050003`*^9, 3.4632856933719997`*^9}, {
  3.463285900495*^9, 3.4632859021070004`*^9}, {3.463286490087*^9, 
  3.463286493349*^9}, {3.4632873915629997`*^9, 3.463287396336*^9}, {
  3.463287713645*^9, 3.463287715609*^9}, {3.466296253547036*^9, 
  3.466296254855111*^9}, {3.466297682300756*^9, 3.466297686860017*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463285698314*^9, 3.4632857053129997`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HashMap", "[", 
   RowBox[{"rules", ":", 
    RowBox[{"{", "___Rule", "}"}]}], "]"}], " ", ":=", "\[IndentingNewLine]", 
  RowBox[{"Let", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"markedRules", " ", "=", " ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"First", "[", "#", "]"}], " ", "\[Rule]", " ", 
          RowBox[{"HashMapValue", "[", 
           RowBox[{"Last", "[", "#", "]"}], "]"}]}], "&"}], ",", " ", 
        "rules"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"HashMapObject", "[", 
     RowBox[{"Dispatch", "[", "markedRules", "]"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463285713209*^9, 3.4632857582720003`*^9}, {
  3.463287053862*^9, 3.463287060851*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HashMap", "[", "rules___Rule", "]"}], " ", ":=", " ", 
  RowBox[{"HashMap", "[", 
   RowBox[{"{", "rules", "}"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.46372772534*^9, 3.463727741355*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HashMap", "[", "dispatch_Dispatch", "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"HashMap", "[", 
   RowBox[{"Extract", "[", 
    RowBox[{"dispatch", ",", " ", 
     RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463285713209*^9, 3.4632857582720003`*^9}, {
  3.46328697067*^9, 3.463286988773*^9}, {3.463287071264*^9, 
  3.463287076928*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HashMapObject", "[", "rules_", "]"}], "[", "key_", "]"}], " ", ":=",
   "\[IndentingNewLine]", 
  RowBox[{"Let", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"value", " ", "=", " ", 
      RowBox[{"key", " ", "/.", " ", "rules"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Head", "[", "value", "]"}], " ", "=!=", " ", "HashMapValue"}],
       ",", "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", 
      RowBox[{"Extract", "[", 
       RowBox[{"value", ",", 
        RowBox[{"{", "1", "}"}]}], "]"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4632857248710003`*^9, 3.463285725098*^9}, {
  3.4632864705950003`*^9, 3.463286471447*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HashMapObject", "[", "rules_", "]"}], "[", "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Rules", "[", 
   RowBox[{"HashMapObject", "[", "rules", "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463691243267*^9, 3.463691285602*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Rules", "[", 
   RowBox[{"HashMapObject", "[", "dispatch_Dispatch", "]"}], "]"}], " ", ":=",
   " ", 
  RowBox[{"StripTags", "[", 
   RowBox[{"Extract", "[", 
    RowBox[{"dispatch", ",", " ", 
     RowBox[{"{", "1", "}"}]}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463285779244*^9, 3.463285818856*^9}, {
  3.4632861104960003`*^9, 3.46328611371*^9}, {3.463286160277*^9, 
  3.46328616074*^9}, {3.463286304274*^9, 3.463286307469*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Rules", "[", 
   RowBox[{"HashMapObject", "[", 
    RowBox[{"rules", ":", 
     RowBox[{"{", "___Rule", "}"}]}], "]"}], "]"}], " ", ":=", " ", 
  RowBox[{"StripTags", "[", "rules", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463285824608*^9, 3.4632858559700003`*^9}, {
  3.463285992818*^9, 3.463286025699*^9}, {3.46328610292*^9, 
  3.463286107182*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lookup", "[", 
   RowBox[{
    RowBox[{"rules", ":", 
     RowBox[{"{", "___Rule", "}"}]}], ",", " ", "key_"}], "]"}], " ", ":=", 
  " ", 
  RowBox[{
   RowBox[{"HashMap", "[", "rules", "]"}], "[", "key", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4632863911540003`*^9, 3.4632864509700003`*^9}, {
  3.463286481733*^9, 3.463286483976*^9}, {3.4632870382320004`*^9, 
  3.4632870435699997`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lookup", "[", 
   RowBox[{"dispatch_Dispatch", ",", " ", "key_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"HashMap", "[", "dispatch", "]"}], "[", "key", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463286924329*^9, 3.463286934634*^9}, {3.46328700066*^9, 
  3.463287001934*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Associate", "[", 
   RowBox[{"o_HashMapObject", ",", " ", 
    RowBox[{"rules", ":", 
     RowBox[{"{", "___Rule", "}"}]}]}], "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"HashMap", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Rules", "[", 
      RowBox[{"Disassociate", "[", 
       RowBox[{"o", ",", " ", 
        RowBox[{"Map", "[", 
         RowBox[{"First", ",", " ", "rules"}], "]"}]}], "]"}], "]"}], ",", 
     " ", "rules"}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463287170038*^9, 3.463287246182*^9}, {
  3.4662967196326942`*^9, 3.46629675189754*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Associate", "[", 
   RowBox[{"o_HashMapObject", ",", " ", "rules___Rule"}], "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Associate", "[", 
   RowBox[{"o", ",", " ", 
    RowBox[{"{", "rules", "}"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4663021516593885`*^9, 3.4663021834612074`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Associate", "[", 
    RowBox[{"o_HashMapObject", ",", " ", 
     RowBox[{"more", ":", 
      RowBox[{"{", "__HashMapObject", "}"}]}]}], "]"}], " ", ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Associate", "[", 
    RowBox[{"o", ",", " ", 
     RowBox[{"Associate", "[", 
      RowBox[{
       RowBox[{"First", "[", "more", "]"}], ",", " ", 
       RowBox[{"Rest", "[", "more", "]"}]}], "]"}]}], "]"}]}], 
  "*)"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.466302481627262*^9, 3.466302566067092*^9}, {
   3.466302652134014*^9, 3.466302681317683*^9}, {3.466302782015443*^9, 
   3.466302785163623*^9}, {3.466302849919327*^9, 3.4663028506043663`*^9}, 
   3.466302883035221*^9, {3.466303019334017*^9, 3.466303021300129*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Disassociate", "[", 
   RowBox[{"o_HashMapObject", ",", " ", 
    RowBox[{"keys", ":", 
     RowBox[{"{", "___", "}"}]}]}], "]"}], " ", ":=", "\[IndentingNewLine]", 
  RowBox[{"HashMap", "[", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Rules", "[", "o", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"keys", ",", " ", 
         RowBox[{"First", "[", "#", "]"}]}], "]"}]}], " ", "&"}]}], "]"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463287256575*^9, 3.46328736659*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Disassociate", "[", 
   RowBox[{"o_HashMapObject", ",", " ", "keys___"}], "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Disassociate", "[", 
   RowBox[{"o", ",", " ", 
    RowBox[{"{", "keys", "}"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4663021945108395`*^9, 3.4663022246485634`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ZipMap", "[", 
    RowBox[{"keys_List", ",", " ", "values_List"}], "]"}], " ", ":=", "\n", 
   "\t", 
   RowBox[{"HashMap", "[", 
    RowBox[{"MapThread", "[", 
     RowBox[{"Rule", ",", " ", 
      RowBox[{"{", 
       RowBox[{"keys", ",", " ", "values"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.463287709524*^9, {3.463287755513*^9, 3.463287758332*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"MapOntoValues", "[", 
   RowBox[{"f_", ",", " ", "o_HashMapObject"}], "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"HashMap", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"MapAt", "[", 
      RowBox[{"f", ",", " ", "#", ",", " ", "2"}], "]"}], "&"}], " ", "/@", 
    " ", 
    RowBox[{"Rules", "[", "o", "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.466296041697919*^9, 3.4662960418999305`*^9}, {
  3.4662961020223694`*^9, 3.4662961168222156`*^9}, {3.466296166329047*^9, 
  3.466296216762932*^9}, {3.4662963486344748`*^9, 3.466296360681164*^9}, {
  3.466296395532157*^9, 3.466296488211458*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"MapAtValue", "[", 
   RowBox[{"f_", ",", " ", "o_HashMapObject", ",", " ", "key_"}], "]"}], " ", 
  ":=", "\[IndentingNewLine]", 
  RowBox[{"Associate", "[", 
   RowBox[{"o", ",", " ", 
    RowBox[{"{", 
     RowBox[{"key", "\[Rule]", 
      RowBox[{"f", "[", 
       RowBox[{"o", "[", "key", "]"}], "]"}]}], "}"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4662965586784887`*^9, 3.4662966046561184`*^9}, {
  3.466297558333666*^9, 3.466297612504764*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StripTags", "[", 
   RowBox[{"rules", ":", " ", 
    RowBox[{"{", "___Rule", "}"}]}], "]"}], " ", ":=", " ", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"First", "[", "#", "]"}], "\[Rule]", " ", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"Last", "[", "#", "]"}], ",", " ", 
        RowBox[{"{", "1", "}"}]}], "]"}]}], " ", "&"}], ",", " ", "rules"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.463286068691*^9, 3.463286098367*^9}, {3.463286241566*^9,
   3.463286280683*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4632858726280003`*^9, 3.463285874543*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4632858756879997`*^9, 3.4632858775620003`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HashMap", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"i", "\[Rule]", 
       RowBox[{"i", "^", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}], "]"}], "//", 
   RowBox[{
    RowBox[{"Disassociate", "[", 
     RowBox[{"#", ",", " ", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}]}], "]"}], "&"}]}], " ", "//", 
  RowBox[{
   RowBox[{"Associate", "[", 
    RowBox[{"#", ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"7", "\[Rule]", "20"}], ",", " ", 
       RowBox[{"\"\<foo\>\"", "\[Rule]", "\"\<bar\>\""}]}], "}"}]}], "]"}], 
   "&"}]}]], "Input",
 CellChangeTimes->{{3.463287406943*^9, 3.4632874279189997`*^9}, {
  3.463287461401*^9, 3.463287491627*^9}}],

Cell[BoxData[
 RowBox[{"HashMapObject", "[", 
  TagBox[
   RowBox[{"Dispatch", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "1", "]"}]}], ",", 
       RowBox[{"2", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "4", "]"}]}], ",", 
       RowBox[{"3", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "9", "]"}]}], ",", 
       RowBox[{"4", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "16", "]"}]}], ",", 
       RowBox[{"7", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "49", "]"}]}], ",", 
       RowBox[{"8", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "64", "]"}]}], ",", 
       RowBox[{"9", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "81", "]"}]}], ",", 
       RowBox[{"10", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "100", "]"}]}], ",", 
       RowBox[{"11", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "121", "]"}]}], ",", 
       RowBox[{"12", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "144", "]"}]}], ",", 
       RowBox[{"13", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "169", "]"}]}], ",", 
       RowBox[{"14", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "196", "]"}]}], ",", 
       RowBox[{"15", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "225", "]"}]}], ",", 
       RowBox[{"16", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "256", "]"}]}], ",", 
       RowBox[{"17", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "289", "]"}]}], ",", 
       RowBox[{"18", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "324", "]"}]}], ",", 
       RowBox[{"19", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "361", "]"}]}], ",", 
       RowBox[{"20", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "400", "]"}]}], ",", 
       RowBox[{"7", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "20", "]"}]}], ",", 
       RowBox[{"\<\"foo\"\>", "\[Rule]", 
        RowBox[{"HashMapValue", "[", "\<\"bar\"\>", "]"}]}]}], "}"}], ",", 
     TagBox[
      InterpretationBox[
       RowBox[{"-", "DispatchTables", "-"}],
       1],
      DisplayForm]}], "]"}],
   Function[BoxForm`arg, 
    ReplacePart[
     HoldComplete[
      Dispatch[ProgrammingDump`dumy]], 
     HoldComplete[BoxForm`arg], {1, 1}, {1, 1}], {HoldAllComplete}]], 
  "]"}]], "Output",
 CellChangeTimes->{{3.463287409227*^9, 3.463287491988*^9}}]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{817, 649},
WindowMargins->{{Automatic, -213}, {Automatic, -23}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 311, 7, 31, "Input",
 InitializationCell->True],
Cell[859, 29, 627, 10, 72, "Input",
 InitializationCell->True],
Cell[1489, 41, 184, 4, 31, "Input",
 InitializationCell->True],
Cell[1676, 47, 821, 21, 72, "Input",
 InitializationCell->True],
Cell[2500, 70, 253, 6, 31, "Input",
 InitializationCell->True],
Cell[2756, 78, 440, 11, 52, "Input",
 InitializationCell->True],
Cell[3199, 91, 801, 21, 112, "Input",
 InitializationCell->True],
Cell[4003, 114, 314, 8, 52, "Input",
 InitializationCell->True],
Cell[4320, 124, 502, 12, 31, "Input",
 InitializationCell->True],
Cell[4825, 138, 411, 10, 31, "Input",
 InitializationCell->True],
Cell[5239, 150, 451, 12, 31, "Input",
 InitializationCell->True],
Cell[5693, 164, 342, 8, 31, "Input",
 InitializationCell->True],
Cell[6038, 174, 654, 18, 52, "Input",
 InitializationCell->True],
Cell[6695, 194, 362, 9, 52, "Input",
 InitializationCell->True],
Cell[7060, 205, 791, 19, 52, "Input",
 InitializationCell->True],
Cell[7854, 226, 602, 17, 52, "Input",
 InitializationCell->True],
Cell[8459, 245, 362, 9, 52, "Input",
 InitializationCell->True],
Cell[8824, 256, 455, 13, 52, "Input",
 InitializationCell->True],
Cell[9282, 271, 669, 16, 52, "Input",
 InitializationCell->True],
Cell[9954, 289, 517, 13, 52, "Input",
 InitializationCell->True],
Cell[10474, 304, 592, 17, 31, "Input",
 InitializationCell->True],
Cell[11069, 323, 161, 4, 31, "Input",
 InitializationCell->True],
Cell[11233, 329, 173, 4, 31, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[11431, 337, 791, 24, 52, "Input"],
Cell[12225, 363, 2354, 58, 145, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
