/*
 * Decompiled with CFR 0.152.
 */
package org.sift.batch.tag;

import java.net.URI;
import java.util.Stack;
import org.sift.batch.tag.TagCloudFactory;
import org.sift.runtime.Fields;
import org.sift.runtime.Tuple;
import org.sift.runtime.spi.OutputCollector;
import org.sift.tagcloud.ui.DisplayTag;
import org.sift.tagcloud.ui.DisplayTagCloud;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;

public class TagCloudInputReader
implements ItemReader<DisplayTagCloud<DisplayTag>> {
    private static final Object MONITOR = new Object();
    private OutputCollector collector;
    private Stack<DisplayTagCloud<DisplayTag>> tagCloudList = new Stack();
    private TagCloudFactory tagCloudFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayTagCloud<DisplayTag> read() throws Exception, UnexpectedInputException, ParseException {
        Object object = MONITOR;
        synchronized (object) {
            if (!this.tagCloudList.empty()) {
                return this.tagCloudList.pop();
            }
            if (this.collector.getEmittedTuples().size() == 0) {
                return null;
            }
            if (this.tagCloudList.empty()) {
                String[] tupleValues = this.getSubjectAndTag(((Tuple)this.collector.getEmittedTuples().get(0)).getString(Fields.KEY));
                String subject = tupleValues[0];
                this.tagCloudFactory = new TagCloudFactory((Tuple)this.collector.getEmittedTuples().get(0));
                while (!this.collector.getEmittedTuples().isEmpty()) {
                    Tuple t = (Tuple)this.collector.getEmittedTuples().get(0);
                    tupleValues = this.getSubjectAndTag(t.getString(Fields.KEY));
                    String displayText = this.getSubjectAndTag(t.getString(Fields.KEY))[1];
                    if (!tupleValues[0].equals(subject)) break;
                    if (displayText.length() > 1) {
                        DisplayTag displayTag = new DisplayTag(displayText, ((Integer)t.getList(Fields.VALUES).get(0)).intValue());
                        for (Object source : t.getList(Fields.SOURCES)) {
                            displayTag.getTagSourcesURIs().add((URI)source);
                        }
                        this.tagCloudFactory.add(t, displayTag);
                        this.collector.getEmittedTuples().remove(0);
                        continue;
                    }
                    this.collector.getEmittedTuples().remove(0);
                }
                this.tagCloudList.addAll(this.tagCloudFactory.getAll());
            }
            return this.tagCloudList.pop();
        }
    }

    private String[] getSubjectAndTag(String key) {
        String[] values = new String[]{key.substring(0, key.indexOf(":")), key.substring(key.indexOf(":") + 1, key.length())};
        return values;
    }

    public OutputCollector getCollector() {
        return this.collector;
    }

    public void setCollector(OutputCollector collector) {
        this.collector = collector;
    }

    public TagCloudFactory getTagCloudFactory() {
        return this.tagCloudFactory;
    }

    public void setTagCloudFactory(TagCloudFactory tagCloudFactory) {
        this.tagCloudFactory = tagCloudFactory;
    }
}

