/*
 * Decompiled with CFR 0.152.
 */
package org.sift.batch.tag;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.sift.tagcloud.Tag;
import org.sift.tagcloud.ui.DisplayTag;
import org.sift.tagcloud.ui.DisplayTagCloud;
import org.springframework.batch.item.ItemProcessor;

public class TagCloudProcessor
implements ItemProcessor<DisplayTagCloud<DisplayTag>, DisplayTagCloud<DisplayTag>>,
Comparator<DisplayTag> {
    private static final int MAX_TAGS = Integer.MAX_VALUE;
    private int maxTags = Integer.MAX_VALUE;

    public DisplayTagCloud<DisplayTag> process(DisplayTagCloud<DisplayTag> tagCloud) throws Exception {
        Collections.sort(tagCloud.getTagsList(), this);
        LinkedList finalDisplayTags = new LinkedList();
        int maxSize = Math.min(tagCloud.getTagsList().size(), this.getMaxTags());
        for (int i = 0; i < maxSize; ++i) {
            finalDisplayTags.add(tagCloud.getTagsList().get(i));
        }
        tagCloud.removeAllTags();
        for (DisplayTag tag : finalDisplayTags) {
            tagCloud.addTag((Tag)tag);
        }
        return tagCloud;
    }

    @Override
    public int compare(DisplayTag tag1, DisplayTag tag2) {
        return tag2.getWeight() - tag1.getWeight();
    }

    public int getMaxTags() {
        return this.maxTags;
    }

    public void setMaxTags(int maxTags) {
        this.maxTags = maxTags;
    }
}

