/*
 * Decompiled with CFR 0.152.
 */
package org.sift.batch.tag.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sift.runtime.model.tagcloud.TagCloudModel;
import org.sift.runtime.model.tagcloud.TagModel;
import org.sift.tagcloud.Tag;
import org.sift.tagcloud.TagCloud;
import org.sift.tagcloud.spi.service.PersistenceService;
import org.sift.tagcloud.ui.DisplayTag;
import org.sift.tagcloud.ui.DisplayTagCloud;
import org.springframework.beans.factory.InitializingBean;
import org.trpr.platform.integration.spi.marshalling.Marshaller;

public class TagCloudMarshallerService<T extends Tag, S extends TagCloud<T>>
implements PersistenceService<T, S>,
InitializingBean {
    public static final Map<String, String> FILE_EXTENSION_PARTS = new HashMap<String, String>();
    private Marshaller marshaller;
    private String fileExtensionPart;
    private String tagCloudsDirectory;

    public void persistTagCloud(S tagCloud) throws RuntimeException {
        if (tagCloud.getSubject() == null || tagCloud.getSubject().trim().length() == 0) {
            throw new RuntimeException("Tag cloud's subject cannot be empty! File cannot be created with empty name.");
        }
        TagCloudModel tagCloudModel = new TagCloudModel();
        tagCloudModel.setSubject(tagCloud.getSubject());
        for (Tag tag : tagCloud.getTagsList()) {
            TagModel tModel = new TagModel();
            tModel.setDisplayText(tag.getDisplayText());
            tModel.setWeight(tag.getWeight());
            tModel.setDescription(tag.getDescription());
            if (tag.getTagURL() != null) {
                tModel.setTagURL(tag.getTagURL().toExternalForm());
            }
            if (tag.getTagSourcesURIs() != null) {
                List tagSourceURIs = tModel.getTagSourcesURIs();
                for (URI uri : tag.getTagSourcesURIs()) {
                    tagSourceURIs.add(uri.toASCIIString());
                }
            }
            tModel.setTitle(tag.getTitle());
            tagCloudModel.getTags().add(tModel);
        }
        try {
            this.marshallTagCloud(this.getTagCloudsDirectory() + File.separator + tagCloud.getSubject() + this.fileExtensionPart, tagCloudModel);
        }
        catch (RuntimeException pe) {
            throw new RuntimeException("Error persisting tag cloud with subject : " + tagCloud.getSubject(), pe);
        }
    }

    public S loadTagCloud(S tagCloud) throws RuntimeException {
        File tagCloudDataFile = new File(this.getTagCloudsDirectory() + File.separator + tagCloud.getSubject() + this.fileExtensionPart);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(tagCloudDataFile));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            TagCloudModel tagCloudModel = (TagCloudModel)this.marshaller.unmarshal(stringBuilder.toString(), TagCloudModel.class);
            tagCloud = new DisplayTagCloud(tagCloudModel.getSubject());
            for (TagModel tag : tagCloudModel.getTags()) {
                DisplayTag dTag = new DisplayTag(tag.getDisplayText(), tag.getWeight());
                dTag.setDescription(tag.getDescription());
                dTag.setTagURL(new URL(tag.getTagURL()));
                for (String uri : tag.getTagSourcesURIs()) {
                    dTag.getTagSourcesURIs().add(new URI(uri));
                }
                dTag.setTitle(tag.getTitle());
                tagCloud.addTag((Tag)dTag);
            }
            return tagCloud;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading tag cloud image for : " + tagCloud.getSubject() + " from file : " + tagCloudDataFile.getAbsolutePath(), e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (String filePartIdentifier : FILE_EXTENSION_PARTS.keySet()) {
            if (!this.marshaller.getClass().getName().toLowerCase().contains(filePartIdentifier)) continue;
            this.fileExtensionPart = FILE_EXTENSION_PARTS.get(filePartIdentifier);
        }
    }

    private void marshallTagCloud(String filePath, TagCloudModel tagCloudModel) throws RuntimeException {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            String data = this.marshaller.marshal((Object)tagCloudModel);
            FileWriter writer = new FileWriter(file);
            writer.write(data);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing tag cloud image for : " + tagCloudModel.getSubject() + " to file : " + filePath, e);
        }
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public String getTagCloudsDirectory() {
        return this.tagCloudsDirectory;
    }

    public void setTagCloudsDirectory(String tagCloudsDirectory) {
        this.tagCloudsDirectory = tagCloudsDirectory;
    }

    static {
        FILE_EXTENSION_PARTS.put("json", ".json");
        FILE_EXTENSION_PARTS.put("xml", ".xml");
    }
}

