/*
 * Decompiled with CFR 0.152.
 */
package org.sift.batch.tuple;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.sift.runtime.Tuple;
import org.sift.runtime.impl.MemOutputCollector;
import org.sift.runtime.spi.OutputCollector;
import org.sift.runtime.spi.Processor;
import org.springframework.batch.item.ItemProcessor;

public class ProcessorChainItemProcessor<T, S>
implements ItemProcessor<T, S> {
    private List<Processor> processors = new LinkedList<Processor>();

    public S process(T paramTuple) throws Exception {
        Tuple tuple = (Tuple)paramTuple;
        Stack<Tuple> returnedTuples = new Stack<Tuple>();
        returnedTuples.push(tuple);
        for (Processor p : this.getProcessors()) {
            MemOutputCollector collector = new MemOutputCollector();
            for (Tuple returnTuple : returnedTuples) {
                p.process(returnTuple, (OutputCollector)collector);
            }
            returnedTuples.clear();
            returnedTuples.addAll(collector.getEmittedTuples());
            collector.getEmittedTuples().clear();
        }
        LinkedList returnTuples = new LinkedList(returnedTuples);
        return (S)returnTuples;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }
}

