/*
 * Decompiled with CFR 0.152.
 */
package org.sift.batch.tag;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.sift.runtime.Fields;
import org.sift.runtime.Tuple;
import org.sift.tagcloud.Tag;
import org.sift.tagcloud.ui.DisplayTag;
import org.sift.tagcloud.ui.DisplayTagCloud;

public class TagCloudFactory {
    public static final String POSITIVE_LABEL = "positive";
    public static final String NEGATIVE_LABEL = "negative";
    public static final String NEUTRAL_LABEL = "neutral";
    private final int POS_INDEX = 0;
    private final int NEG_INDEX = 1;
    private final int NEUTRAL_INDEX = 2;
    private List<DisplayTagCloud<DisplayTag>> tagCloudList = new ArrayList<DisplayTagCloud<DisplayTag>>();

    public TagCloudFactory(Tuple tuple) {
        String key = tuple.getString(Fields.KEY);
        String subject = key.substring(0, key.indexOf(":"));
        if (tuple.contains(Fields.SENTIMENT)) {
            DisplayTagCloud tagCloudPositive = new DisplayTagCloud(String.valueOf(subject) + "_" + POSITIVE_LABEL);
            DisplayTagCloud tagCloudNegative = new DisplayTagCloud(String.valueOf(subject) + "_" + NEGATIVE_LABEL);
            DisplayTagCloud tagCloudNeutral = new DisplayTagCloud(String.valueOf(subject) + "_" + NEUTRAL_LABEL);
            this.tagCloudList.add((DisplayTagCloud<DisplayTag>)tagCloudPositive);
            this.tagCloudList.add((DisplayTagCloud<DisplayTag>)tagCloudNegative);
            this.tagCloudList.add((DisplayTagCloud<DisplayTag>)tagCloudNeutral);
        } else {
            this.tagCloudList.add((DisplayTagCloud<DisplayTag>)new DisplayTagCloud(subject));
        }
    }

    public void add(Tuple tuple, DisplayTag displayTag) {
        block6: {
            try {
                if (this.tagCloudList.size() == 1) {
                    this.tagCloudList.get(0).addTag((Tag)displayTag);
                    break block6;
                }
                if (this.tagCloudList.size() != 3) break block6;
                if (tuple.getString(Fields.SENTIMENT).equals(POSITIVE_LABEL)) {
                    this.tagCloudList.get(0).addTag((Tag)displayTag);
                    break block6;
                }
                if (tuple.getString(Fields.SENTIMENT).equals(NEGATIVE_LABEL)) {
                    this.tagCloudList.get(1).addTag((Tag)displayTag);
                    break block6;
                }
                if (tuple.getString(Fields.SENTIMENT).equals(NEUTRAL_LABEL)) {
                    this.tagCloudList.get(2).addTag((Tag)displayTag);
                    break block6;
                }
                throw new RuntimeException("Error while getting tag sentiment");
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("Mix of Tuples with and without sentiments");
            }
        }
    }

    public List<DisplayTagCloud<DisplayTag>> getAll() {
        LinkedList<DisplayTagCloud<DisplayTag>> tagCloudList = new LinkedList<DisplayTagCloud<DisplayTag>>();
        for (DisplayTagCloud<DisplayTag> tagCloud : this.tagCloudList) {
            if (tagCloud.getTagsList().size() <= 0) continue;
            tagCloudList.add(tagCloud);
        }
        return tagCloudList;
    }
}

