/*
 * Decompiled with CFR 0.152.
 */
package org.sift.batch.tuple;

import java.net.URI;
import java.util.ArrayList;
import org.sift.batch.tuple.MultiThreadedMultiResourceItemReader;
import org.sift.runtime.Fields;
import org.sift.runtime.Tuple;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class TupleLineMapper
implements LineMapper<Tuple>,
InitializingBean {
    private Resource resource;
    private MultiThreadedMultiResourceItemReader<Tuple> itemReader;

    public Tuple mapLine(String line, int lineNumber) throws Exception {
        Resource currentResource = this.itemReader == null ? this.resource : this.itemReader.getCurrentResource();
        URI reviewURI = new URI(String.valueOf(currentResource.getFile().getAbsolutePath()) + "#" + String.valueOf(lineNumber));
        Tuple tuple = new Tuple(new Fields[]{Fields.KEY, Fields.SOURCES, Fields.VALUES});
        tuple.setValue(Fields.KEY, (Object)String.valueOf(lineNumber));
        ArrayList<URI> sourceURI = new ArrayList<URI>();
        sourceURI.add(reviewURI);
        tuple.setValue(Fields.SOURCES, sourceURI);
        ArrayList<String> initialValues = new ArrayList<String>();
        initialValues.add(line);
        tuple.setValue(Fields.VALUES, initialValues);
        return tuple;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getResource() == null && this.itemReader == null) {
            throw new Exception("Atleast one of 'resource' or 'itemReader' must be set!");
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public MultiThreadedMultiResourceItemReader<Tuple> getItemReader() {
        return this.itemReader;
    }

    public void setItemReader(MultiThreadedMultiResourceItemReader<Tuple> itemReader) {
        this.itemReader = itemReader;
    }
}

