// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18632 = [];
var len__7651__auto___18638 = arguments.length;
var i__7652__auto___18639 = (0);
while(true){
if((i__7652__auto___18639 < len__7651__auto___18638)){
args18632.push((arguments[i__7652__auto___18639]));

var G__18640 = (i__7652__auto___18639 + (1));
i__7652__auto___18639 = G__18640;
continue;
} else {
}
break;
}

var G__18634 = args18632.length;
switch (G__18634) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18632.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18635 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18635 = (function (f,blockable,meta18636){
this.f = f;
this.blockable = blockable;
this.meta18636 = meta18636;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18635.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18637,meta18636__$1){
var self__ = this;
var _18637__$1 = this;
return (new cljs.core.async.t_cljs$core$async18635(self__.f,self__.blockable,meta18636__$1));
});

cljs.core.async.t_cljs$core$async18635.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18637){
var self__ = this;
var _18637__$1 = this;
return self__.meta18636;
});

cljs.core.async.t_cljs$core$async18635.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18635.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18635.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18635.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18635.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18636","meta18636",79527092,null)], null);
});

cljs.core.async.t_cljs$core$async18635.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18635.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18635";

cljs.core.async.t_cljs$core$async18635.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async18635");
});

cljs.core.async.__GT_t_cljs$core$async18635 = (function cljs$core$async$__GT_t_cljs$core$async18635(f__$1,blockable__$1,meta18636){
return (new cljs.core.async.t_cljs$core$async18635(f__$1,blockable__$1,meta18636));
});

}

return (new cljs.core.async.t_cljs$core$async18635(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args18644 = [];
var len__7651__auto___18647 = arguments.length;
var i__7652__auto___18648 = (0);
while(true){
if((i__7652__auto___18648 < len__7651__auto___18647)){
args18644.push((arguments[i__7652__auto___18648]));

var G__18649 = (i__7652__auto___18648 + (1));
i__7652__auto___18648 = G__18649;
continue;
} else {
}
break;
}

var G__18646 = args18644.length;
switch (G__18646) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18644.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args18651 = [];
var len__7651__auto___18654 = arguments.length;
var i__7652__auto___18655 = (0);
while(true){
if((i__7652__auto___18655 < len__7651__auto___18654)){
args18651.push((arguments[i__7652__auto___18655]));

var G__18656 = (i__7652__auto___18655 + (1));
i__7652__auto___18655 = G__18656;
continue;
} else {
}
break;
}

var G__18653 = args18651.length;
switch (G__18653) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18651.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args18658 = [];
var len__7651__auto___18661 = arguments.length;
var i__7652__auto___18662 = (0);
while(true){
if((i__7652__auto___18662 < len__7651__auto___18661)){
args18658.push((arguments[i__7652__auto___18662]));

var G__18663 = (i__7652__auto___18662 + (1));
i__7652__auto___18662 = G__18663;
continue;
} else {
}
break;
}

var G__18660 = args18658.length;
switch (G__18660) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18658.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_18665 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_18665);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_18665,ret){
return (function (){
return fn1.call(null,val_18665);
});})(val_18665,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args18666 = [];
var len__7651__auto___18669 = arguments.length;
var i__7652__auto___18670 = (0);
while(true){
if((i__7652__auto___18670 < len__7651__auto___18669)){
args18666.push((arguments[i__7652__auto___18670]));

var G__18671 = (i__7652__auto___18670 + (1));
i__7652__auto___18670 = G__18671;
continue;
} else {
}
break;
}

var G__18668 = args18666.length;
switch (G__18668) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18666.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7461__auto___18673 = n;
var x_18674 = (0);
while(true){
if((x_18674 < n__7461__auto___18673)){
(a[x_18674] = (0));

var G__18675 = (x_18674 + (1));
x_18674 = G__18675;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__18676 = (i + (1));
i = G__18676;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async18680 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18680 = (function (flag,meta18681){
this.flag = flag;
this.meta18681 = meta18681;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18680.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_18682,meta18681__$1){
var self__ = this;
var _18682__$1 = this;
return (new cljs.core.async.t_cljs$core$async18680(self__.flag,meta18681__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async18680.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_18682){
var self__ = this;
var _18682__$1 = this;
return self__.meta18681;
});})(flag))
;

cljs.core.async.t_cljs$core$async18680.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18680.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async18680.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18680.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18680.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta18681","meta18681",-1199923652,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async18680.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18680.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18680";

cljs.core.async.t_cljs$core$async18680.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async18680");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async18680 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18680(flag__$1,meta18681){
return (new cljs.core.async.t_cljs$core$async18680(flag__$1,meta18681));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async18680(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async18686 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18686 = (function (flag,cb,meta18687){
this.flag = flag;
this.cb = cb;
this.meta18687 = meta18687;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18686.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18688,meta18687__$1){
var self__ = this;
var _18688__$1 = this;
return (new cljs.core.async.t_cljs$core$async18686(self__.flag,self__.cb,meta18687__$1));
});

cljs.core.async.t_cljs$core$async18686.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18688){
var self__ = this;
var _18688__$1 = this;
return self__.meta18687;
});

cljs.core.async.t_cljs$core$async18686.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18686.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async18686.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18686.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async18686.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta18687","meta18687",-1712134082,null)], null);
});

cljs.core.async.t_cljs$core$async18686.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18686.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18686";

cljs.core.async.t_cljs$core$async18686.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async18686");
});

cljs.core.async.__GT_t_cljs$core$async18686 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18686(flag__$1,cb__$1,meta18687){
return (new cljs.core.async.t_cljs$core$async18686(flag__$1,cb__$1,meta18687));
});

}

return (new cljs.core.async.t_cljs$core$async18686(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18689_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18689_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18690_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18690_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6543__auto__ = wport;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18691 = (i + (1));
i = G__18691;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6543__auto__ = ret;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6531__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___18697 = arguments.length;
var i__7652__auto___18698 = (0);
while(true){
if((i__7652__auto___18698 < len__7651__auto___18697)){
args__7658__auto__.push((arguments[i__7652__auto___18698]));

var G__18699 = (i__7652__auto___18698 + (1));
i__7652__auto___18698 = G__18699;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18694){
var map__18695 = p__18694;
var map__18695__$1 = ((((!((map__18695 == null)))?((((map__18695.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18695.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18695):map__18695);
var opts = map__18695__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18692){
var G__18693 = cljs.core.first.call(null,seq18692);
var seq18692__$1 = cljs.core.next.call(null,seq18692);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18693,seq18692__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args18700 = [];
var len__7651__auto___18750 = arguments.length;
var i__7652__auto___18751 = (0);
while(true){
if((i__7652__auto___18751 < len__7651__auto___18750)){
args18700.push((arguments[i__7652__auto___18751]));

var G__18752 = (i__7652__auto___18751 + (1));
i__7652__auto___18751 = G__18752;
continue;
} else {
}
break;
}

var G__18702 = args18700.length;
switch (G__18702) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18700.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__18587__auto___18754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___18754){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___18754){
return (function (state_18726){
var state_val_18727 = (state_18726[(1)]);
if((state_val_18727 === (7))){
var inst_18722 = (state_18726[(2)]);
var state_18726__$1 = state_18726;
var statearr_18728_18755 = state_18726__$1;
(statearr_18728_18755[(2)] = inst_18722);

(statearr_18728_18755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (1))){
var state_18726__$1 = state_18726;
var statearr_18729_18756 = state_18726__$1;
(statearr_18729_18756[(2)] = null);

(statearr_18729_18756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (4))){
var inst_18705 = (state_18726[(7)]);
var inst_18705__$1 = (state_18726[(2)]);
var inst_18706 = (inst_18705__$1 == null);
var state_18726__$1 = (function (){var statearr_18730 = state_18726;
(statearr_18730[(7)] = inst_18705__$1);

return statearr_18730;
})();
if(cljs.core.truth_(inst_18706)){
var statearr_18731_18757 = state_18726__$1;
(statearr_18731_18757[(1)] = (5));

} else {
var statearr_18732_18758 = state_18726__$1;
(statearr_18732_18758[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (13))){
var state_18726__$1 = state_18726;
var statearr_18733_18759 = state_18726__$1;
(statearr_18733_18759[(2)] = null);

(statearr_18733_18759[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (6))){
var inst_18705 = (state_18726[(7)]);
var state_18726__$1 = state_18726;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18726__$1,(11),to,inst_18705);
} else {
if((state_val_18727 === (3))){
var inst_18724 = (state_18726[(2)]);
var state_18726__$1 = state_18726;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18726__$1,inst_18724);
} else {
if((state_val_18727 === (12))){
var state_18726__$1 = state_18726;
var statearr_18734_18760 = state_18726__$1;
(statearr_18734_18760[(2)] = null);

(statearr_18734_18760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (2))){
var state_18726__$1 = state_18726;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18726__$1,(4),from);
} else {
if((state_val_18727 === (11))){
var inst_18715 = (state_18726[(2)]);
var state_18726__$1 = state_18726;
if(cljs.core.truth_(inst_18715)){
var statearr_18735_18761 = state_18726__$1;
(statearr_18735_18761[(1)] = (12));

} else {
var statearr_18736_18762 = state_18726__$1;
(statearr_18736_18762[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (9))){
var state_18726__$1 = state_18726;
var statearr_18737_18763 = state_18726__$1;
(statearr_18737_18763[(2)] = null);

(statearr_18737_18763[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (5))){
var state_18726__$1 = state_18726;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18738_18764 = state_18726__$1;
(statearr_18738_18764[(1)] = (8));

} else {
var statearr_18739_18765 = state_18726__$1;
(statearr_18739_18765[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (14))){
var inst_18720 = (state_18726[(2)]);
var state_18726__$1 = state_18726;
var statearr_18740_18766 = state_18726__$1;
(statearr_18740_18766[(2)] = inst_18720);

(statearr_18740_18766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (10))){
var inst_18712 = (state_18726[(2)]);
var state_18726__$1 = state_18726;
var statearr_18741_18767 = state_18726__$1;
(statearr_18741_18767[(2)] = inst_18712);

(statearr_18741_18767[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18727 === (8))){
var inst_18709 = cljs.core.async.close_BANG_.call(null,to);
var state_18726__$1 = state_18726;
var statearr_18742_18768 = state_18726__$1;
(statearr_18742_18768[(2)] = inst_18709);

(statearr_18742_18768[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___18754))
;
return ((function (switch__18475__auto__,c__18587__auto___18754){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_18746 = [null,null,null,null,null,null,null,null];
(statearr_18746[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_18746[(1)] = (1));

return statearr_18746;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_18726){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_18726);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e18747){if((e18747 instanceof Object)){
var ex__18479__auto__ = e18747;
var statearr_18748_18769 = state_18726;
(statearr_18748_18769[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18726);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18770 = state_18726;
state_18726 = G__18770;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_18726){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_18726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___18754))
})();
var state__18589__auto__ = (function (){var statearr_18749 = f__18588__auto__.call(null);
(statearr_18749[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___18754);

return statearr_18749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___18754))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__18958){
var vec__18959 = p__18958;
var v = cljs.core.nth.call(null,vec__18959,(0),null);
var p = cljs.core.nth.call(null,vec__18959,(1),null);
var job = vec__18959;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__18587__auto___19145 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___19145,res,vec__18959,v,p,job,jobs,results){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___19145,res,vec__18959,v,p,job,jobs,results){
return (function (state_18966){
var state_val_18967 = (state_18966[(1)]);
if((state_val_18967 === (1))){
var state_18966__$1 = state_18966;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18966__$1,(2),res,v);
} else {
if((state_val_18967 === (2))){
var inst_18963 = (state_18966[(2)]);
var inst_18964 = cljs.core.async.close_BANG_.call(null,res);
var state_18966__$1 = (function (){var statearr_18968 = state_18966;
(statearr_18968[(7)] = inst_18963);

return statearr_18968;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18966__$1,inst_18964);
} else {
return null;
}
}
});})(c__18587__auto___19145,res,vec__18959,v,p,job,jobs,results))
;
return ((function (switch__18475__auto__,c__18587__auto___19145,res,vec__18959,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0 = (function (){
var statearr_18972 = [null,null,null,null,null,null,null,null];
(statearr_18972[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__);

(statearr_18972[(1)] = (1));

return statearr_18972;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1 = (function (state_18966){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_18966);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e18973){if((e18973 instanceof Object)){
var ex__18479__auto__ = e18973;
var statearr_18974_19146 = state_18966;
(statearr_18974_19146[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18966);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18973;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19147 = state_18966;
state_18966 = G__19147;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = function(state_18966){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1.call(this,state_18966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___19145,res,vec__18959,v,p,job,jobs,results))
})();
var state__18589__auto__ = (function (){var statearr_18975 = f__18588__auto__.call(null);
(statearr_18975[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___19145);

return statearr_18975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___19145,res,vec__18959,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__18976){
var vec__18977 = p__18976;
var v = cljs.core.nth.call(null,vec__18977,(0),null);
var p = cljs.core.nth.call(null,vec__18977,(1),null);
var job = vec__18977;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7461__auto___19148 = n;
var __19149 = (0);
while(true){
if((__19149 < n__7461__auto___19148)){
var G__18980_19150 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__18980_19150) {
case "compute":
var c__18587__auto___19152 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19149,c__18587__auto___19152,G__18980_19150,n__7461__auto___19148,jobs,results,process,async){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (__19149,c__18587__auto___19152,G__18980_19150,n__7461__auto___19148,jobs,results,process,async){
return (function (state_18993){
var state_val_18994 = (state_18993[(1)]);
if((state_val_18994 === (1))){
var state_18993__$1 = state_18993;
var statearr_18995_19153 = state_18993__$1;
(statearr_18995_19153[(2)] = null);

(statearr_18995_19153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18994 === (2))){
var state_18993__$1 = state_18993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18993__$1,(4),jobs);
} else {
if((state_val_18994 === (3))){
var inst_18991 = (state_18993[(2)]);
var state_18993__$1 = state_18993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18993__$1,inst_18991);
} else {
if((state_val_18994 === (4))){
var inst_18983 = (state_18993[(2)]);
var inst_18984 = process.call(null,inst_18983);
var state_18993__$1 = state_18993;
if(cljs.core.truth_(inst_18984)){
var statearr_18996_19154 = state_18993__$1;
(statearr_18996_19154[(1)] = (5));

} else {
var statearr_18997_19155 = state_18993__$1;
(statearr_18997_19155[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18994 === (5))){
var state_18993__$1 = state_18993;
var statearr_18998_19156 = state_18993__$1;
(statearr_18998_19156[(2)] = null);

(statearr_18998_19156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18994 === (6))){
var state_18993__$1 = state_18993;
var statearr_18999_19157 = state_18993__$1;
(statearr_18999_19157[(2)] = null);

(statearr_18999_19157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18994 === (7))){
var inst_18989 = (state_18993[(2)]);
var state_18993__$1 = state_18993;
var statearr_19000_19158 = state_18993__$1;
(statearr_19000_19158[(2)] = inst_18989);

(statearr_19000_19158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19149,c__18587__auto___19152,G__18980_19150,n__7461__auto___19148,jobs,results,process,async))
;
return ((function (__19149,switch__18475__auto__,c__18587__auto___19152,G__18980_19150,n__7461__auto___19148,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0 = (function (){
var statearr_19004 = [null,null,null,null,null,null,null];
(statearr_19004[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__);

(statearr_19004[(1)] = (1));

return statearr_19004;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1 = (function (state_18993){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_18993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e19005){if((e19005 instanceof Object)){
var ex__18479__auto__ = e19005;
var statearr_19006_19159 = state_18993;
(statearr_19006_19159[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19005;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19160 = state_18993;
state_18993 = G__19160;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = function(state_18993){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1.call(this,state_18993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__;
})()
;})(__19149,switch__18475__auto__,c__18587__auto___19152,G__18980_19150,n__7461__auto___19148,jobs,results,process,async))
})();
var state__18589__auto__ = (function (){var statearr_19007 = f__18588__auto__.call(null);
(statearr_19007[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___19152);

return statearr_19007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(__19149,c__18587__auto___19152,G__18980_19150,n__7461__auto___19148,jobs,results,process,async))
);


break;
case "async":
var c__18587__auto___19161 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19149,c__18587__auto___19161,G__18980_19150,n__7461__auto___19148,jobs,results,process,async){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (__19149,c__18587__auto___19161,G__18980_19150,n__7461__auto___19148,jobs,results,process,async){
return (function (state_19020){
var state_val_19021 = (state_19020[(1)]);
if((state_val_19021 === (1))){
var state_19020__$1 = state_19020;
var statearr_19022_19162 = state_19020__$1;
(statearr_19022_19162[(2)] = null);

(statearr_19022_19162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19021 === (2))){
var state_19020__$1 = state_19020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19020__$1,(4),jobs);
} else {
if((state_val_19021 === (3))){
var inst_19018 = (state_19020[(2)]);
var state_19020__$1 = state_19020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19020__$1,inst_19018);
} else {
if((state_val_19021 === (4))){
var inst_19010 = (state_19020[(2)]);
var inst_19011 = async.call(null,inst_19010);
var state_19020__$1 = state_19020;
if(cljs.core.truth_(inst_19011)){
var statearr_19023_19163 = state_19020__$1;
(statearr_19023_19163[(1)] = (5));

} else {
var statearr_19024_19164 = state_19020__$1;
(statearr_19024_19164[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19021 === (5))){
var state_19020__$1 = state_19020;
var statearr_19025_19165 = state_19020__$1;
(statearr_19025_19165[(2)] = null);

(statearr_19025_19165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19021 === (6))){
var state_19020__$1 = state_19020;
var statearr_19026_19166 = state_19020__$1;
(statearr_19026_19166[(2)] = null);

(statearr_19026_19166[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19021 === (7))){
var inst_19016 = (state_19020[(2)]);
var state_19020__$1 = state_19020;
var statearr_19027_19167 = state_19020__$1;
(statearr_19027_19167[(2)] = inst_19016);

(statearr_19027_19167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19149,c__18587__auto___19161,G__18980_19150,n__7461__auto___19148,jobs,results,process,async))
;
return ((function (__19149,switch__18475__auto__,c__18587__auto___19161,G__18980_19150,n__7461__auto___19148,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0 = (function (){
var statearr_19031 = [null,null,null,null,null,null,null];
(statearr_19031[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__);

(statearr_19031[(1)] = (1));

return statearr_19031;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1 = (function (state_19020){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_19020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e19032){if((e19032 instanceof Object)){
var ex__18479__auto__ = e19032;
var statearr_19033_19168 = state_19020;
(statearr_19033_19168[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19020);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19169 = state_19020;
state_19020 = G__19169;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = function(state_19020){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1.call(this,state_19020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__;
})()
;})(__19149,switch__18475__auto__,c__18587__auto___19161,G__18980_19150,n__7461__auto___19148,jobs,results,process,async))
})();
var state__18589__auto__ = (function (){var statearr_19034 = f__18588__auto__.call(null);
(statearr_19034[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___19161);

return statearr_19034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(__19149,c__18587__auto___19161,G__18980_19150,n__7461__auto___19148,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19170 = (__19149 + (1));
__19149 = G__19170;
continue;
} else {
}
break;
}

var c__18587__auto___19171 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___19171,jobs,results,process,async){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___19171,jobs,results,process,async){
return (function (state_19056){
var state_val_19057 = (state_19056[(1)]);
if((state_val_19057 === (1))){
var state_19056__$1 = state_19056;
var statearr_19058_19172 = state_19056__$1;
(statearr_19058_19172[(2)] = null);

(statearr_19058_19172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19057 === (2))){
var state_19056__$1 = state_19056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19056__$1,(4),from);
} else {
if((state_val_19057 === (3))){
var inst_19054 = (state_19056[(2)]);
var state_19056__$1 = state_19056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19056__$1,inst_19054);
} else {
if((state_val_19057 === (4))){
var inst_19037 = (state_19056[(7)]);
var inst_19037__$1 = (state_19056[(2)]);
var inst_19038 = (inst_19037__$1 == null);
var state_19056__$1 = (function (){var statearr_19059 = state_19056;
(statearr_19059[(7)] = inst_19037__$1);

return statearr_19059;
})();
if(cljs.core.truth_(inst_19038)){
var statearr_19060_19173 = state_19056__$1;
(statearr_19060_19173[(1)] = (5));

} else {
var statearr_19061_19174 = state_19056__$1;
(statearr_19061_19174[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19057 === (5))){
var inst_19040 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19056__$1 = state_19056;
var statearr_19062_19175 = state_19056__$1;
(statearr_19062_19175[(2)] = inst_19040);

(statearr_19062_19175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19057 === (6))){
var inst_19037 = (state_19056[(7)]);
var inst_19042 = (state_19056[(8)]);
var inst_19042__$1 = cljs.core.async.chan.call(null,(1));
var inst_19043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19044 = [inst_19037,inst_19042__$1];
var inst_19045 = (new cljs.core.PersistentVector(null,2,(5),inst_19043,inst_19044,null));
var state_19056__$1 = (function (){var statearr_19063 = state_19056;
(statearr_19063[(8)] = inst_19042__$1);

return statearr_19063;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19056__$1,(8),jobs,inst_19045);
} else {
if((state_val_19057 === (7))){
var inst_19052 = (state_19056[(2)]);
var state_19056__$1 = state_19056;
var statearr_19064_19176 = state_19056__$1;
(statearr_19064_19176[(2)] = inst_19052);

(statearr_19064_19176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19057 === (8))){
var inst_19042 = (state_19056[(8)]);
var inst_19047 = (state_19056[(2)]);
var state_19056__$1 = (function (){var statearr_19065 = state_19056;
(statearr_19065[(9)] = inst_19047);

return statearr_19065;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19056__$1,(9),results,inst_19042);
} else {
if((state_val_19057 === (9))){
var inst_19049 = (state_19056[(2)]);
var state_19056__$1 = (function (){var statearr_19066 = state_19056;
(statearr_19066[(10)] = inst_19049);

return statearr_19066;
})();
var statearr_19067_19177 = state_19056__$1;
(statearr_19067_19177[(2)] = null);

(statearr_19067_19177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___19171,jobs,results,process,async))
;
return ((function (switch__18475__auto__,c__18587__auto___19171,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0 = (function (){
var statearr_19071 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19071[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__);

(statearr_19071[(1)] = (1));

return statearr_19071;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1 = (function (state_19056){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_19056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e19072){if((e19072 instanceof Object)){
var ex__18479__auto__ = e19072;
var statearr_19073_19178 = state_19056;
(statearr_19073_19178[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19056);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19072;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19179 = state_19056;
state_19056 = G__19179;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = function(state_19056){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1.call(this,state_19056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___19171,jobs,results,process,async))
})();
var state__18589__auto__ = (function (){var statearr_19074 = f__18588__auto__.call(null);
(statearr_19074[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___19171);

return statearr_19074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___19171,jobs,results,process,async))
);


var c__18587__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto__,jobs,results,process,async){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto__,jobs,results,process,async){
return (function (state_19112){
var state_val_19113 = (state_19112[(1)]);
if((state_val_19113 === (7))){
var inst_19108 = (state_19112[(2)]);
var state_19112__$1 = state_19112;
var statearr_19114_19180 = state_19112__$1;
(statearr_19114_19180[(2)] = inst_19108);

(statearr_19114_19180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (20))){
var state_19112__$1 = state_19112;
var statearr_19115_19181 = state_19112__$1;
(statearr_19115_19181[(2)] = null);

(statearr_19115_19181[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (1))){
var state_19112__$1 = state_19112;
var statearr_19116_19182 = state_19112__$1;
(statearr_19116_19182[(2)] = null);

(statearr_19116_19182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (4))){
var inst_19077 = (state_19112[(7)]);
var inst_19077__$1 = (state_19112[(2)]);
var inst_19078 = (inst_19077__$1 == null);
var state_19112__$1 = (function (){var statearr_19117 = state_19112;
(statearr_19117[(7)] = inst_19077__$1);

return statearr_19117;
})();
if(cljs.core.truth_(inst_19078)){
var statearr_19118_19183 = state_19112__$1;
(statearr_19118_19183[(1)] = (5));

} else {
var statearr_19119_19184 = state_19112__$1;
(statearr_19119_19184[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (15))){
var inst_19090 = (state_19112[(8)]);
var state_19112__$1 = state_19112;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19112__$1,(18),to,inst_19090);
} else {
if((state_val_19113 === (21))){
var inst_19103 = (state_19112[(2)]);
var state_19112__$1 = state_19112;
var statearr_19120_19185 = state_19112__$1;
(statearr_19120_19185[(2)] = inst_19103);

(statearr_19120_19185[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (13))){
var inst_19105 = (state_19112[(2)]);
var state_19112__$1 = (function (){var statearr_19121 = state_19112;
(statearr_19121[(9)] = inst_19105);

return statearr_19121;
})();
var statearr_19122_19186 = state_19112__$1;
(statearr_19122_19186[(2)] = null);

(statearr_19122_19186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (6))){
var inst_19077 = (state_19112[(7)]);
var state_19112__$1 = state_19112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19112__$1,(11),inst_19077);
} else {
if((state_val_19113 === (17))){
var inst_19098 = (state_19112[(2)]);
var state_19112__$1 = state_19112;
if(cljs.core.truth_(inst_19098)){
var statearr_19123_19187 = state_19112__$1;
(statearr_19123_19187[(1)] = (19));

} else {
var statearr_19124_19188 = state_19112__$1;
(statearr_19124_19188[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (3))){
var inst_19110 = (state_19112[(2)]);
var state_19112__$1 = state_19112;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19112__$1,inst_19110);
} else {
if((state_val_19113 === (12))){
var inst_19087 = (state_19112[(10)]);
var state_19112__$1 = state_19112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19112__$1,(14),inst_19087);
} else {
if((state_val_19113 === (2))){
var state_19112__$1 = state_19112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19112__$1,(4),results);
} else {
if((state_val_19113 === (19))){
var state_19112__$1 = state_19112;
var statearr_19125_19189 = state_19112__$1;
(statearr_19125_19189[(2)] = null);

(statearr_19125_19189[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (11))){
var inst_19087 = (state_19112[(2)]);
var state_19112__$1 = (function (){var statearr_19126 = state_19112;
(statearr_19126[(10)] = inst_19087);

return statearr_19126;
})();
var statearr_19127_19190 = state_19112__$1;
(statearr_19127_19190[(2)] = null);

(statearr_19127_19190[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (9))){
var state_19112__$1 = state_19112;
var statearr_19128_19191 = state_19112__$1;
(statearr_19128_19191[(2)] = null);

(statearr_19128_19191[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (5))){
var state_19112__$1 = state_19112;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19129_19192 = state_19112__$1;
(statearr_19129_19192[(1)] = (8));

} else {
var statearr_19130_19193 = state_19112__$1;
(statearr_19130_19193[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (14))){
var inst_19092 = (state_19112[(11)]);
var inst_19090 = (state_19112[(8)]);
var inst_19090__$1 = (state_19112[(2)]);
var inst_19091 = (inst_19090__$1 == null);
var inst_19092__$1 = cljs.core.not.call(null,inst_19091);
var state_19112__$1 = (function (){var statearr_19131 = state_19112;
(statearr_19131[(11)] = inst_19092__$1);

(statearr_19131[(8)] = inst_19090__$1);

return statearr_19131;
})();
if(inst_19092__$1){
var statearr_19132_19194 = state_19112__$1;
(statearr_19132_19194[(1)] = (15));

} else {
var statearr_19133_19195 = state_19112__$1;
(statearr_19133_19195[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (16))){
var inst_19092 = (state_19112[(11)]);
var state_19112__$1 = state_19112;
var statearr_19134_19196 = state_19112__$1;
(statearr_19134_19196[(2)] = inst_19092);

(statearr_19134_19196[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (10))){
var inst_19084 = (state_19112[(2)]);
var state_19112__$1 = state_19112;
var statearr_19135_19197 = state_19112__$1;
(statearr_19135_19197[(2)] = inst_19084);

(statearr_19135_19197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (18))){
var inst_19095 = (state_19112[(2)]);
var state_19112__$1 = state_19112;
var statearr_19136_19198 = state_19112__$1;
(statearr_19136_19198[(2)] = inst_19095);

(statearr_19136_19198[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19113 === (8))){
var inst_19081 = cljs.core.async.close_BANG_.call(null,to);
var state_19112__$1 = state_19112;
var statearr_19137_19199 = state_19112__$1;
(statearr_19137_19199[(2)] = inst_19081);

(statearr_19137_19199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto__,jobs,results,process,async))
;
return ((function (switch__18475__auto__,c__18587__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0 = (function (){
var statearr_19141 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19141[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__);

(statearr_19141[(1)] = (1));

return statearr_19141;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1 = (function (state_19112){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_19112);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e19142){if((e19142 instanceof Object)){
var ex__18479__auto__ = e19142;
var statearr_19143_19200 = state_19112;
(statearr_19143_19200[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19112);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19142;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19201 = state_19112;
state_19112 = G__19201;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__ = function(state_19112){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1.call(this,state_19112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18476__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto__,jobs,results,process,async))
})();
var state__18589__auto__ = (function (){var statearr_19144 = f__18588__auto__.call(null);
(statearr_19144[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto__);

return statearr_19144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto__,jobs,results,process,async))
);

return c__18587__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19202 = [];
var len__7651__auto___19205 = arguments.length;
var i__7652__auto___19206 = (0);
while(true){
if((i__7652__auto___19206 < len__7651__auto___19205)){
args19202.push((arguments[i__7652__auto___19206]));

var G__19207 = (i__7652__auto___19206 + (1));
i__7652__auto___19206 = G__19207;
continue;
} else {
}
break;
}

var G__19204 = args19202.length;
switch (G__19204) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19202.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19209 = [];
var len__7651__auto___19212 = arguments.length;
var i__7652__auto___19213 = (0);
while(true){
if((i__7652__auto___19213 < len__7651__auto___19212)){
args19209.push((arguments[i__7652__auto___19213]));

var G__19214 = (i__7652__auto___19213 + (1));
i__7652__auto___19213 = G__19214;
continue;
} else {
}
break;
}

var G__19211 = args19209.length;
switch (G__19211) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19209.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19216 = [];
var len__7651__auto___19269 = arguments.length;
var i__7652__auto___19270 = (0);
while(true){
if((i__7652__auto___19270 < len__7651__auto___19269)){
args19216.push((arguments[i__7652__auto___19270]));

var G__19271 = (i__7652__auto___19270 + (1));
i__7652__auto___19270 = G__19271;
continue;
} else {
}
break;
}

var G__19218 = args19216.length;
switch (G__19218) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19216.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__18587__auto___19273 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___19273,tc,fc){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___19273,tc,fc){
return (function (state_19244){
var state_val_19245 = (state_19244[(1)]);
if((state_val_19245 === (7))){
var inst_19240 = (state_19244[(2)]);
var state_19244__$1 = state_19244;
var statearr_19246_19274 = state_19244__$1;
(statearr_19246_19274[(2)] = inst_19240);

(statearr_19246_19274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (1))){
var state_19244__$1 = state_19244;
var statearr_19247_19275 = state_19244__$1;
(statearr_19247_19275[(2)] = null);

(statearr_19247_19275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (4))){
var inst_19221 = (state_19244[(7)]);
var inst_19221__$1 = (state_19244[(2)]);
var inst_19222 = (inst_19221__$1 == null);
var state_19244__$1 = (function (){var statearr_19248 = state_19244;
(statearr_19248[(7)] = inst_19221__$1);

return statearr_19248;
})();
if(cljs.core.truth_(inst_19222)){
var statearr_19249_19276 = state_19244__$1;
(statearr_19249_19276[(1)] = (5));

} else {
var statearr_19250_19277 = state_19244__$1;
(statearr_19250_19277[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (13))){
var state_19244__$1 = state_19244;
var statearr_19251_19278 = state_19244__$1;
(statearr_19251_19278[(2)] = null);

(statearr_19251_19278[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (6))){
var inst_19221 = (state_19244[(7)]);
var inst_19227 = p.call(null,inst_19221);
var state_19244__$1 = state_19244;
if(cljs.core.truth_(inst_19227)){
var statearr_19252_19279 = state_19244__$1;
(statearr_19252_19279[(1)] = (9));

} else {
var statearr_19253_19280 = state_19244__$1;
(statearr_19253_19280[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (3))){
var inst_19242 = (state_19244[(2)]);
var state_19244__$1 = state_19244;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19244__$1,inst_19242);
} else {
if((state_val_19245 === (12))){
var state_19244__$1 = state_19244;
var statearr_19254_19281 = state_19244__$1;
(statearr_19254_19281[(2)] = null);

(statearr_19254_19281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (2))){
var state_19244__$1 = state_19244;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19244__$1,(4),ch);
} else {
if((state_val_19245 === (11))){
var inst_19221 = (state_19244[(7)]);
var inst_19231 = (state_19244[(2)]);
var state_19244__$1 = state_19244;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19244__$1,(8),inst_19231,inst_19221);
} else {
if((state_val_19245 === (9))){
var state_19244__$1 = state_19244;
var statearr_19255_19282 = state_19244__$1;
(statearr_19255_19282[(2)] = tc);

(statearr_19255_19282[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (5))){
var inst_19224 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19225 = cljs.core.async.close_BANG_.call(null,fc);
var state_19244__$1 = (function (){var statearr_19256 = state_19244;
(statearr_19256[(8)] = inst_19224);

return statearr_19256;
})();
var statearr_19257_19283 = state_19244__$1;
(statearr_19257_19283[(2)] = inst_19225);

(statearr_19257_19283[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (14))){
var inst_19238 = (state_19244[(2)]);
var state_19244__$1 = state_19244;
var statearr_19258_19284 = state_19244__$1;
(statearr_19258_19284[(2)] = inst_19238);

(statearr_19258_19284[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (10))){
var state_19244__$1 = state_19244;
var statearr_19259_19285 = state_19244__$1;
(statearr_19259_19285[(2)] = fc);

(statearr_19259_19285[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (8))){
var inst_19233 = (state_19244[(2)]);
var state_19244__$1 = state_19244;
if(cljs.core.truth_(inst_19233)){
var statearr_19260_19286 = state_19244__$1;
(statearr_19260_19286[(1)] = (12));

} else {
var statearr_19261_19287 = state_19244__$1;
(statearr_19261_19287[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___19273,tc,fc))
;
return ((function (switch__18475__auto__,c__18587__auto___19273,tc,fc){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_19265 = [null,null,null,null,null,null,null,null,null];
(statearr_19265[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_19265[(1)] = (1));

return statearr_19265;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_19244){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_19244);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e19266){if((e19266 instanceof Object)){
var ex__18479__auto__ = e19266;
var statearr_19267_19288 = state_19244;
(statearr_19267_19288[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19244);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19266;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19289 = state_19244;
state_19244 = G__19289;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_19244){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_19244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___19273,tc,fc))
})();
var state__18589__auto__ = (function (){var statearr_19268 = f__18588__auto__.call(null);
(statearr_19268[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___19273);

return statearr_19268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___19273,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__18587__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto__){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto__){
return (function (state_19353){
var state_val_19354 = (state_19353[(1)]);
if((state_val_19354 === (7))){
var inst_19349 = (state_19353[(2)]);
var state_19353__$1 = state_19353;
var statearr_19355_19376 = state_19353__$1;
(statearr_19355_19376[(2)] = inst_19349);

(statearr_19355_19376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (1))){
var inst_19333 = init;
var state_19353__$1 = (function (){var statearr_19356 = state_19353;
(statearr_19356[(7)] = inst_19333);

return statearr_19356;
})();
var statearr_19357_19377 = state_19353__$1;
(statearr_19357_19377[(2)] = null);

(statearr_19357_19377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (4))){
var inst_19336 = (state_19353[(8)]);
var inst_19336__$1 = (state_19353[(2)]);
var inst_19337 = (inst_19336__$1 == null);
var state_19353__$1 = (function (){var statearr_19358 = state_19353;
(statearr_19358[(8)] = inst_19336__$1);

return statearr_19358;
})();
if(cljs.core.truth_(inst_19337)){
var statearr_19359_19378 = state_19353__$1;
(statearr_19359_19378[(1)] = (5));

} else {
var statearr_19360_19379 = state_19353__$1;
(statearr_19360_19379[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (6))){
var inst_19336 = (state_19353[(8)]);
var inst_19333 = (state_19353[(7)]);
var inst_19340 = (state_19353[(9)]);
var inst_19340__$1 = f.call(null,inst_19333,inst_19336);
var inst_19341 = cljs.core.reduced_QMARK_.call(null,inst_19340__$1);
var state_19353__$1 = (function (){var statearr_19361 = state_19353;
(statearr_19361[(9)] = inst_19340__$1);

return statearr_19361;
})();
if(inst_19341){
var statearr_19362_19380 = state_19353__$1;
(statearr_19362_19380[(1)] = (8));

} else {
var statearr_19363_19381 = state_19353__$1;
(statearr_19363_19381[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (3))){
var inst_19351 = (state_19353[(2)]);
var state_19353__$1 = state_19353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19353__$1,inst_19351);
} else {
if((state_val_19354 === (2))){
var state_19353__$1 = state_19353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19353__$1,(4),ch);
} else {
if((state_val_19354 === (9))){
var inst_19340 = (state_19353[(9)]);
var inst_19333 = inst_19340;
var state_19353__$1 = (function (){var statearr_19364 = state_19353;
(statearr_19364[(7)] = inst_19333);

return statearr_19364;
})();
var statearr_19365_19382 = state_19353__$1;
(statearr_19365_19382[(2)] = null);

(statearr_19365_19382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (5))){
var inst_19333 = (state_19353[(7)]);
var state_19353__$1 = state_19353;
var statearr_19366_19383 = state_19353__$1;
(statearr_19366_19383[(2)] = inst_19333);

(statearr_19366_19383[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (10))){
var inst_19347 = (state_19353[(2)]);
var state_19353__$1 = state_19353;
var statearr_19367_19384 = state_19353__$1;
(statearr_19367_19384[(2)] = inst_19347);

(statearr_19367_19384[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (8))){
var inst_19340 = (state_19353[(9)]);
var inst_19343 = cljs.core.deref.call(null,inst_19340);
var state_19353__$1 = state_19353;
var statearr_19368_19385 = state_19353__$1;
(statearr_19368_19385[(2)] = inst_19343);

(statearr_19368_19385[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto__))
;
return ((function (switch__18475__auto__,c__18587__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__18476__auto__ = null;
var cljs$core$async$reduce_$_state_machine__18476__auto____0 = (function (){
var statearr_19372 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19372[(0)] = cljs$core$async$reduce_$_state_machine__18476__auto__);

(statearr_19372[(1)] = (1));

return statearr_19372;
});
var cljs$core$async$reduce_$_state_machine__18476__auto____1 = (function (state_19353){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_19353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e19373){if((e19373 instanceof Object)){
var ex__18479__auto__ = e19373;
var statearr_19374_19386 = state_19353;
(statearr_19374_19386[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19373;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19387 = state_19353;
state_19353 = G__19387;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__18476__auto__ = function(state_19353){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__18476__auto____1.call(this,state_19353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__18476__auto____0;
cljs$core$async$reduce_$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__18476__auto____1;
return cljs$core$async$reduce_$_state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto__))
})();
var state__18589__auto__ = (function (){var statearr_19375 = f__18588__auto__.call(null);
(statearr_19375[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto__);

return statearr_19375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto__))
);

return c__18587__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19388 = [];
var len__7651__auto___19440 = arguments.length;
var i__7652__auto___19441 = (0);
while(true){
if((i__7652__auto___19441 < len__7651__auto___19440)){
args19388.push((arguments[i__7652__auto___19441]));

var G__19442 = (i__7652__auto___19441 + (1));
i__7652__auto___19441 = G__19442;
continue;
} else {
}
break;
}

var G__19390 = args19388.length;
switch (G__19390) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19388.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__18587__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto__){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto__){
return (function (state_19415){
var state_val_19416 = (state_19415[(1)]);
if((state_val_19416 === (7))){
var inst_19397 = (state_19415[(2)]);
var state_19415__$1 = state_19415;
var statearr_19417_19444 = state_19415__$1;
(statearr_19417_19444[(2)] = inst_19397);

(statearr_19417_19444[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (1))){
var inst_19391 = cljs.core.seq.call(null,coll);
var inst_19392 = inst_19391;
var state_19415__$1 = (function (){var statearr_19418 = state_19415;
(statearr_19418[(7)] = inst_19392);

return statearr_19418;
})();
var statearr_19419_19445 = state_19415__$1;
(statearr_19419_19445[(2)] = null);

(statearr_19419_19445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (4))){
var inst_19392 = (state_19415[(7)]);
var inst_19395 = cljs.core.first.call(null,inst_19392);
var state_19415__$1 = state_19415;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19415__$1,(7),ch,inst_19395);
} else {
if((state_val_19416 === (13))){
var inst_19409 = (state_19415[(2)]);
var state_19415__$1 = state_19415;
var statearr_19420_19446 = state_19415__$1;
(statearr_19420_19446[(2)] = inst_19409);

(statearr_19420_19446[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (6))){
var inst_19400 = (state_19415[(2)]);
var state_19415__$1 = state_19415;
if(cljs.core.truth_(inst_19400)){
var statearr_19421_19447 = state_19415__$1;
(statearr_19421_19447[(1)] = (8));

} else {
var statearr_19422_19448 = state_19415__$1;
(statearr_19422_19448[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (3))){
var inst_19413 = (state_19415[(2)]);
var state_19415__$1 = state_19415;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19415__$1,inst_19413);
} else {
if((state_val_19416 === (12))){
var state_19415__$1 = state_19415;
var statearr_19423_19449 = state_19415__$1;
(statearr_19423_19449[(2)] = null);

(statearr_19423_19449[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (2))){
var inst_19392 = (state_19415[(7)]);
var state_19415__$1 = state_19415;
if(cljs.core.truth_(inst_19392)){
var statearr_19424_19450 = state_19415__$1;
(statearr_19424_19450[(1)] = (4));

} else {
var statearr_19425_19451 = state_19415__$1;
(statearr_19425_19451[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (11))){
var inst_19406 = cljs.core.async.close_BANG_.call(null,ch);
var state_19415__$1 = state_19415;
var statearr_19426_19452 = state_19415__$1;
(statearr_19426_19452[(2)] = inst_19406);

(statearr_19426_19452[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (9))){
var state_19415__$1 = state_19415;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19427_19453 = state_19415__$1;
(statearr_19427_19453[(1)] = (11));

} else {
var statearr_19428_19454 = state_19415__$1;
(statearr_19428_19454[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (5))){
var inst_19392 = (state_19415[(7)]);
var state_19415__$1 = state_19415;
var statearr_19429_19455 = state_19415__$1;
(statearr_19429_19455[(2)] = inst_19392);

(statearr_19429_19455[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (10))){
var inst_19411 = (state_19415[(2)]);
var state_19415__$1 = state_19415;
var statearr_19430_19456 = state_19415__$1;
(statearr_19430_19456[(2)] = inst_19411);

(statearr_19430_19456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (8))){
var inst_19392 = (state_19415[(7)]);
var inst_19402 = cljs.core.next.call(null,inst_19392);
var inst_19392__$1 = inst_19402;
var state_19415__$1 = (function (){var statearr_19431 = state_19415;
(statearr_19431[(7)] = inst_19392__$1);

return statearr_19431;
})();
var statearr_19432_19457 = state_19415__$1;
(statearr_19432_19457[(2)] = null);

(statearr_19432_19457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto__))
;
return ((function (switch__18475__auto__,c__18587__auto__){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_19436 = [null,null,null,null,null,null,null,null];
(statearr_19436[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_19436[(1)] = (1));

return statearr_19436;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_19415){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_19415);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e19437){if((e19437 instanceof Object)){
var ex__18479__auto__ = e19437;
var statearr_19438_19458 = state_19415;
(statearr_19438_19458[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19415);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19437;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19459 = state_19415;
state_19415 = G__19459;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_19415){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_19415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto__))
})();
var state__18589__auto__ = (function (){var statearr_19439 = f__18588__auto__.call(null);
(statearr_19439[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto__);

return statearr_19439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto__))
);

return c__18587__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7206__auto__ = (((_ == null))?null:_);
var m__7207__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,_);
} else {
var m__7207__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7207__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,ch);
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m);
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19685 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19685 = (function (ch,cs,meta19686){
this.ch = ch;
this.cs = cs;
this.meta19686 = meta19686;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19685.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_19687,meta19686__$1){
var self__ = this;
var _19687__$1 = this;
return (new cljs.core.async.t_cljs$core$async19685(self__.ch,self__.cs,meta19686__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async19685.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_19687){
var self__ = this;
var _19687__$1 = this;
return self__.meta19686;
});})(cs))
;

cljs.core.async.t_cljs$core$async19685.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19685.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async19685.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19685.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19685.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19685.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19685.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta19686","meta19686",-1018690466,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async19685.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19685.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19685";

cljs.core.async.t_cljs$core$async19685.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async19685");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async19685 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async19685(ch__$1,cs__$1,meta19686){
return (new cljs.core.async.t_cljs$core$async19685(ch__$1,cs__$1,meta19686));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async19685(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__18587__auto___19910 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___19910,cs,m,dchan,dctr,done){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___19910,cs,m,dchan,dctr,done){
return (function (state_19822){
var state_val_19823 = (state_19822[(1)]);
if((state_val_19823 === (7))){
var inst_19818 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19824_19911 = state_19822__$1;
(statearr_19824_19911[(2)] = inst_19818);

(statearr_19824_19911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (20))){
var inst_19721 = (state_19822[(7)]);
var inst_19733 = cljs.core.first.call(null,inst_19721);
var inst_19734 = cljs.core.nth.call(null,inst_19733,(0),null);
var inst_19735 = cljs.core.nth.call(null,inst_19733,(1),null);
var state_19822__$1 = (function (){var statearr_19825 = state_19822;
(statearr_19825[(8)] = inst_19734);

return statearr_19825;
})();
if(cljs.core.truth_(inst_19735)){
var statearr_19826_19912 = state_19822__$1;
(statearr_19826_19912[(1)] = (22));

} else {
var statearr_19827_19913 = state_19822__$1;
(statearr_19827_19913[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (27))){
var inst_19765 = (state_19822[(9)]);
var inst_19770 = (state_19822[(10)]);
var inst_19690 = (state_19822[(11)]);
var inst_19763 = (state_19822[(12)]);
var inst_19770__$1 = cljs.core._nth.call(null,inst_19763,inst_19765);
var inst_19771 = cljs.core.async.put_BANG_.call(null,inst_19770__$1,inst_19690,done);
var state_19822__$1 = (function (){var statearr_19828 = state_19822;
(statearr_19828[(10)] = inst_19770__$1);

return statearr_19828;
})();
if(cljs.core.truth_(inst_19771)){
var statearr_19829_19914 = state_19822__$1;
(statearr_19829_19914[(1)] = (30));

} else {
var statearr_19830_19915 = state_19822__$1;
(statearr_19830_19915[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (1))){
var state_19822__$1 = state_19822;
var statearr_19831_19916 = state_19822__$1;
(statearr_19831_19916[(2)] = null);

(statearr_19831_19916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (24))){
var inst_19721 = (state_19822[(7)]);
var inst_19740 = (state_19822[(2)]);
var inst_19741 = cljs.core.next.call(null,inst_19721);
var inst_19699 = inst_19741;
var inst_19700 = null;
var inst_19701 = (0);
var inst_19702 = (0);
var state_19822__$1 = (function (){var statearr_19832 = state_19822;
(statearr_19832[(13)] = inst_19740);

(statearr_19832[(14)] = inst_19702);

(statearr_19832[(15)] = inst_19701);

(statearr_19832[(16)] = inst_19700);

(statearr_19832[(17)] = inst_19699);

return statearr_19832;
})();
var statearr_19833_19917 = state_19822__$1;
(statearr_19833_19917[(2)] = null);

(statearr_19833_19917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (39))){
var state_19822__$1 = state_19822;
var statearr_19837_19918 = state_19822__$1;
(statearr_19837_19918[(2)] = null);

(statearr_19837_19918[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (4))){
var inst_19690 = (state_19822[(11)]);
var inst_19690__$1 = (state_19822[(2)]);
var inst_19691 = (inst_19690__$1 == null);
var state_19822__$1 = (function (){var statearr_19838 = state_19822;
(statearr_19838[(11)] = inst_19690__$1);

return statearr_19838;
})();
if(cljs.core.truth_(inst_19691)){
var statearr_19839_19919 = state_19822__$1;
(statearr_19839_19919[(1)] = (5));

} else {
var statearr_19840_19920 = state_19822__$1;
(statearr_19840_19920[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (15))){
var inst_19702 = (state_19822[(14)]);
var inst_19701 = (state_19822[(15)]);
var inst_19700 = (state_19822[(16)]);
var inst_19699 = (state_19822[(17)]);
var inst_19717 = (state_19822[(2)]);
var inst_19718 = (inst_19702 + (1));
var tmp19834 = inst_19701;
var tmp19835 = inst_19700;
var tmp19836 = inst_19699;
var inst_19699__$1 = tmp19836;
var inst_19700__$1 = tmp19835;
var inst_19701__$1 = tmp19834;
var inst_19702__$1 = inst_19718;
var state_19822__$1 = (function (){var statearr_19841 = state_19822;
(statearr_19841[(14)] = inst_19702__$1);

(statearr_19841[(15)] = inst_19701__$1);

(statearr_19841[(16)] = inst_19700__$1);

(statearr_19841[(18)] = inst_19717);

(statearr_19841[(17)] = inst_19699__$1);

return statearr_19841;
})();
var statearr_19842_19921 = state_19822__$1;
(statearr_19842_19921[(2)] = null);

(statearr_19842_19921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (21))){
var inst_19744 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19846_19922 = state_19822__$1;
(statearr_19846_19922[(2)] = inst_19744);

(statearr_19846_19922[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (31))){
var inst_19770 = (state_19822[(10)]);
var inst_19774 = done.call(null,null);
var inst_19775 = cljs.core.async.untap_STAR_.call(null,m,inst_19770);
var state_19822__$1 = (function (){var statearr_19847 = state_19822;
(statearr_19847[(19)] = inst_19774);

return statearr_19847;
})();
var statearr_19848_19923 = state_19822__$1;
(statearr_19848_19923[(2)] = inst_19775);

(statearr_19848_19923[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (32))){
var inst_19764 = (state_19822[(20)]);
var inst_19765 = (state_19822[(9)]);
var inst_19762 = (state_19822[(21)]);
var inst_19763 = (state_19822[(12)]);
var inst_19777 = (state_19822[(2)]);
var inst_19778 = (inst_19765 + (1));
var tmp19843 = inst_19764;
var tmp19844 = inst_19762;
var tmp19845 = inst_19763;
var inst_19762__$1 = tmp19844;
var inst_19763__$1 = tmp19845;
var inst_19764__$1 = tmp19843;
var inst_19765__$1 = inst_19778;
var state_19822__$1 = (function (){var statearr_19849 = state_19822;
(statearr_19849[(20)] = inst_19764__$1);

(statearr_19849[(9)] = inst_19765__$1);

(statearr_19849[(21)] = inst_19762__$1);

(statearr_19849[(22)] = inst_19777);

(statearr_19849[(12)] = inst_19763__$1);

return statearr_19849;
})();
var statearr_19850_19924 = state_19822__$1;
(statearr_19850_19924[(2)] = null);

(statearr_19850_19924[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (40))){
var inst_19790 = (state_19822[(23)]);
var inst_19794 = done.call(null,null);
var inst_19795 = cljs.core.async.untap_STAR_.call(null,m,inst_19790);
var state_19822__$1 = (function (){var statearr_19851 = state_19822;
(statearr_19851[(24)] = inst_19794);

return statearr_19851;
})();
var statearr_19852_19925 = state_19822__$1;
(statearr_19852_19925[(2)] = inst_19795);

(statearr_19852_19925[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (33))){
var inst_19781 = (state_19822[(25)]);
var inst_19783 = cljs.core.chunked_seq_QMARK_.call(null,inst_19781);
var state_19822__$1 = state_19822;
if(inst_19783){
var statearr_19853_19926 = state_19822__$1;
(statearr_19853_19926[(1)] = (36));

} else {
var statearr_19854_19927 = state_19822__$1;
(statearr_19854_19927[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (13))){
var inst_19711 = (state_19822[(26)]);
var inst_19714 = cljs.core.async.close_BANG_.call(null,inst_19711);
var state_19822__$1 = state_19822;
var statearr_19855_19928 = state_19822__$1;
(statearr_19855_19928[(2)] = inst_19714);

(statearr_19855_19928[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (22))){
var inst_19734 = (state_19822[(8)]);
var inst_19737 = cljs.core.async.close_BANG_.call(null,inst_19734);
var state_19822__$1 = state_19822;
var statearr_19856_19929 = state_19822__$1;
(statearr_19856_19929[(2)] = inst_19737);

(statearr_19856_19929[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (36))){
var inst_19781 = (state_19822[(25)]);
var inst_19785 = cljs.core.chunk_first.call(null,inst_19781);
var inst_19786 = cljs.core.chunk_rest.call(null,inst_19781);
var inst_19787 = cljs.core.count.call(null,inst_19785);
var inst_19762 = inst_19786;
var inst_19763 = inst_19785;
var inst_19764 = inst_19787;
var inst_19765 = (0);
var state_19822__$1 = (function (){var statearr_19857 = state_19822;
(statearr_19857[(20)] = inst_19764);

(statearr_19857[(9)] = inst_19765);

(statearr_19857[(21)] = inst_19762);

(statearr_19857[(12)] = inst_19763);

return statearr_19857;
})();
var statearr_19858_19930 = state_19822__$1;
(statearr_19858_19930[(2)] = null);

(statearr_19858_19930[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (41))){
var inst_19781 = (state_19822[(25)]);
var inst_19797 = (state_19822[(2)]);
var inst_19798 = cljs.core.next.call(null,inst_19781);
var inst_19762 = inst_19798;
var inst_19763 = null;
var inst_19764 = (0);
var inst_19765 = (0);
var state_19822__$1 = (function (){var statearr_19859 = state_19822;
(statearr_19859[(20)] = inst_19764);

(statearr_19859[(9)] = inst_19765);

(statearr_19859[(21)] = inst_19762);

(statearr_19859[(27)] = inst_19797);

(statearr_19859[(12)] = inst_19763);

return statearr_19859;
})();
var statearr_19860_19931 = state_19822__$1;
(statearr_19860_19931[(2)] = null);

(statearr_19860_19931[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (43))){
var state_19822__$1 = state_19822;
var statearr_19861_19932 = state_19822__$1;
(statearr_19861_19932[(2)] = null);

(statearr_19861_19932[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (29))){
var inst_19806 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19862_19933 = state_19822__$1;
(statearr_19862_19933[(2)] = inst_19806);

(statearr_19862_19933[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (44))){
var inst_19815 = (state_19822[(2)]);
var state_19822__$1 = (function (){var statearr_19863 = state_19822;
(statearr_19863[(28)] = inst_19815);

return statearr_19863;
})();
var statearr_19864_19934 = state_19822__$1;
(statearr_19864_19934[(2)] = null);

(statearr_19864_19934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (6))){
var inst_19754 = (state_19822[(29)]);
var inst_19753 = cljs.core.deref.call(null,cs);
var inst_19754__$1 = cljs.core.keys.call(null,inst_19753);
var inst_19755 = cljs.core.count.call(null,inst_19754__$1);
var inst_19756 = cljs.core.reset_BANG_.call(null,dctr,inst_19755);
var inst_19761 = cljs.core.seq.call(null,inst_19754__$1);
var inst_19762 = inst_19761;
var inst_19763 = null;
var inst_19764 = (0);
var inst_19765 = (0);
var state_19822__$1 = (function (){var statearr_19865 = state_19822;
(statearr_19865[(20)] = inst_19764);

(statearr_19865[(9)] = inst_19765);

(statearr_19865[(21)] = inst_19762);

(statearr_19865[(29)] = inst_19754__$1);

(statearr_19865[(30)] = inst_19756);

(statearr_19865[(12)] = inst_19763);

return statearr_19865;
})();
var statearr_19866_19935 = state_19822__$1;
(statearr_19866_19935[(2)] = null);

(statearr_19866_19935[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (28))){
var inst_19762 = (state_19822[(21)]);
var inst_19781 = (state_19822[(25)]);
var inst_19781__$1 = cljs.core.seq.call(null,inst_19762);
var state_19822__$1 = (function (){var statearr_19867 = state_19822;
(statearr_19867[(25)] = inst_19781__$1);

return statearr_19867;
})();
if(inst_19781__$1){
var statearr_19868_19936 = state_19822__$1;
(statearr_19868_19936[(1)] = (33));

} else {
var statearr_19869_19937 = state_19822__$1;
(statearr_19869_19937[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (25))){
var inst_19764 = (state_19822[(20)]);
var inst_19765 = (state_19822[(9)]);
var inst_19767 = (inst_19765 < inst_19764);
var inst_19768 = inst_19767;
var state_19822__$1 = state_19822;
if(cljs.core.truth_(inst_19768)){
var statearr_19870_19938 = state_19822__$1;
(statearr_19870_19938[(1)] = (27));

} else {
var statearr_19871_19939 = state_19822__$1;
(statearr_19871_19939[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (34))){
var state_19822__$1 = state_19822;
var statearr_19872_19940 = state_19822__$1;
(statearr_19872_19940[(2)] = null);

(statearr_19872_19940[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (17))){
var state_19822__$1 = state_19822;
var statearr_19873_19941 = state_19822__$1;
(statearr_19873_19941[(2)] = null);

(statearr_19873_19941[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (3))){
var inst_19820 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19822__$1,inst_19820);
} else {
if((state_val_19823 === (12))){
var inst_19749 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19874_19942 = state_19822__$1;
(statearr_19874_19942[(2)] = inst_19749);

(statearr_19874_19942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (2))){
var state_19822__$1 = state_19822;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19822__$1,(4),ch);
} else {
if((state_val_19823 === (23))){
var state_19822__$1 = state_19822;
var statearr_19875_19943 = state_19822__$1;
(statearr_19875_19943[(2)] = null);

(statearr_19875_19943[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (35))){
var inst_19804 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19876_19944 = state_19822__$1;
(statearr_19876_19944[(2)] = inst_19804);

(statearr_19876_19944[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (19))){
var inst_19721 = (state_19822[(7)]);
var inst_19725 = cljs.core.chunk_first.call(null,inst_19721);
var inst_19726 = cljs.core.chunk_rest.call(null,inst_19721);
var inst_19727 = cljs.core.count.call(null,inst_19725);
var inst_19699 = inst_19726;
var inst_19700 = inst_19725;
var inst_19701 = inst_19727;
var inst_19702 = (0);
var state_19822__$1 = (function (){var statearr_19877 = state_19822;
(statearr_19877[(14)] = inst_19702);

(statearr_19877[(15)] = inst_19701);

(statearr_19877[(16)] = inst_19700);

(statearr_19877[(17)] = inst_19699);

return statearr_19877;
})();
var statearr_19878_19945 = state_19822__$1;
(statearr_19878_19945[(2)] = null);

(statearr_19878_19945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (11))){
var inst_19721 = (state_19822[(7)]);
var inst_19699 = (state_19822[(17)]);
var inst_19721__$1 = cljs.core.seq.call(null,inst_19699);
var state_19822__$1 = (function (){var statearr_19879 = state_19822;
(statearr_19879[(7)] = inst_19721__$1);

return statearr_19879;
})();
if(inst_19721__$1){
var statearr_19880_19946 = state_19822__$1;
(statearr_19880_19946[(1)] = (16));

} else {
var statearr_19881_19947 = state_19822__$1;
(statearr_19881_19947[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (9))){
var inst_19751 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19882_19948 = state_19822__$1;
(statearr_19882_19948[(2)] = inst_19751);

(statearr_19882_19948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (5))){
var inst_19697 = cljs.core.deref.call(null,cs);
var inst_19698 = cljs.core.seq.call(null,inst_19697);
var inst_19699 = inst_19698;
var inst_19700 = null;
var inst_19701 = (0);
var inst_19702 = (0);
var state_19822__$1 = (function (){var statearr_19883 = state_19822;
(statearr_19883[(14)] = inst_19702);

(statearr_19883[(15)] = inst_19701);

(statearr_19883[(16)] = inst_19700);

(statearr_19883[(17)] = inst_19699);

return statearr_19883;
})();
var statearr_19884_19949 = state_19822__$1;
(statearr_19884_19949[(2)] = null);

(statearr_19884_19949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (14))){
var state_19822__$1 = state_19822;
var statearr_19885_19950 = state_19822__$1;
(statearr_19885_19950[(2)] = null);

(statearr_19885_19950[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (45))){
var inst_19812 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19886_19951 = state_19822__$1;
(statearr_19886_19951[(2)] = inst_19812);

(statearr_19886_19951[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (26))){
var inst_19754 = (state_19822[(29)]);
var inst_19808 = (state_19822[(2)]);
var inst_19809 = cljs.core.seq.call(null,inst_19754);
var state_19822__$1 = (function (){var statearr_19887 = state_19822;
(statearr_19887[(31)] = inst_19808);

return statearr_19887;
})();
if(inst_19809){
var statearr_19888_19952 = state_19822__$1;
(statearr_19888_19952[(1)] = (42));

} else {
var statearr_19889_19953 = state_19822__$1;
(statearr_19889_19953[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (16))){
var inst_19721 = (state_19822[(7)]);
var inst_19723 = cljs.core.chunked_seq_QMARK_.call(null,inst_19721);
var state_19822__$1 = state_19822;
if(inst_19723){
var statearr_19890_19954 = state_19822__$1;
(statearr_19890_19954[(1)] = (19));

} else {
var statearr_19891_19955 = state_19822__$1;
(statearr_19891_19955[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (38))){
var inst_19801 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19892_19956 = state_19822__$1;
(statearr_19892_19956[(2)] = inst_19801);

(statearr_19892_19956[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (30))){
var state_19822__$1 = state_19822;
var statearr_19893_19957 = state_19822__$1;
(statearr_19893_19957[(2)] = null);

(statearr_19893_19957[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (10))){
var inst_19702 = (state_19822[(14)]);
var inst_19700 = (state_19822[(16)]);
var inst_19710 = cljs.core._nth.call(null,inst_19700,inst_19702);
var inst_19711 = cljs.core.nth.call(null,inst_19710,(0),null);
var inst_19712 = cljs.core.nth.call(null,inst_19710,(1),null);
var state_19822__$1 = (function (){var statearr_19894 = state_19822;
(statearr_19894[(26)] = inst_19711);

return statearr_19894;
})();
if(cljs.core.truth_(inst_19712)){
var statearr_19895_19958 = state_19822__$1;
(statearr_19895_19958[(1)] = (13));

} else {
var statearr_19896_19959 = state_19822__$1;
(statearr_19896_19959[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (18))){
var inst_19747 = (state_19822[(2)]);
var state_19822__$1 = state_19822;
var statearr_19897_19960 = state_19822__$1;
(statearr_19897_19960[(2)] = inst_19747);

(statearr_19897_19960[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (42))){
var state_19822__$1 = state_19822;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19822__$1,(45),dchan);
} else {
if((state_val_19823 === (37))){
var inst_19781 = (state_19822[(25)]);
var inst_19790 = (state_19822[(23)]);
var inst_19690 = (state_19822[(11)]);
var inst_19790__$1 = cljs.core.first.call(null,inst_19781);
var inst_19791 = cljs.core.async.put_BANG_.call(null,inst_19790__$1,inst_19690,done);
var state_19822__$1 = (function (){var statearr_19898 = state_19822;
(statearr_19898[(23)] = inst_19790__$1);

return statearr_19898;
})();
if(cljs.core.truth_(inst_19791)){
var statearr_19899_19961 = state_19822__$1;
(statearr_19899_19961[(1)] = (39));

} else {
var statearr_19900_19962 = state_19822__$1;
(statearr_19900_19962[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19823 === (8))){
var inst_19702 = (state_19822[(14)]);
var inst_19701 = (state_19822[(15)]);
var inst_19704 = (inst_19702 < inst_19701);
var inst_19705 = inst_19704;
var state_19822__$1 = state_19822;
if(cljs.core.truth_(inst_19705)){
var statearr_19901_19963 = state_19822__$1;
(statearr_19901_19963[(1)] = (10));

} else {
var statearr_19902_19964 = state_19822__$1;
(statearr_19902_19964[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___19910,cs,m,dchan,dctr,done))
;
return ((function (switch__18475__auto__,c__18587__auto___19910,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__18476__auto__ = null;
var cljs$core$async$mult_$_state_machine__18476__auto____0 = (function (){
var statearr_19906 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19906[(0)] = cljs$core$async$mult_$_state_machine__18476__auto__);

(statearr_19906[(1)] = (1));

return statearr_19906;
});
var cljs$core$async$mult_$_state_machine__18476__auto____1 = (function (state_19822){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_19822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e19907){if((e19907 instanceof Object)){
var ex__18479__auto__ = e19907;
var statearr_19908_19965 = state_19822;
(statearr_19908_19965[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19822);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19907;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19966 = state_19822;
state_19822 = G__19966;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__18476__auto__ = function(state_19822){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__18476__auto____1.call(this,state_19822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__18476__auto____0;
cljs$core$async$mult_$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__18476__auto____1;
return cljs$core$async$mult_$_state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___19910,cs,m,dchan,dctr,done))
})();
var state__18589__auto__ = (function (){var statearr_19909 = f__18588__auto__.call(null);
(statearr_19909[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___19910);

return statearr_19909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___19910,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args19967 = [];
var len__7651__auto___19970 = arguments.length;
var i__7652__auto___19971 = (0);
while(true){
if((i__7652__auto___19971 < len__7651__auto___19970)){
args19967.push((arguments[i__7652__auto___19971]));

var G__19972 = (i__7652__auto___19971 + (1));
i__7652__auto___19971 = G__19972;
continue;
} else {
}
break;
}

var G__19969 = args19967.length;
switch (G__19969) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19967.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,ch);
} else {
var m__7207__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,ch);
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m);
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,state_map);
} else {
var m__7207__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,mode);
} else {
var m__7207__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___19984 = arguments.length;
var i__7652__auto___19985 = (0);
while(true){
if((i__7652__auto___19985 < len__7651__auto___19984)){
args__7658__auto__.push((arguments[i__7652__auto___19985]));

var G__19986 = (i__7652__auto___19985 + (1));
i__7652__auto___19985 = G__19986;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__19978){
var map__19979 = p__19978;
var map__19979__$1 = ((((!((map__19979 == null)))?((((map__19979.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19979.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19979):map__19979);
var opts = map__19979__$1;
var statearr_19981_19987 = state;
(statearr_19981_19987[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__19979,map__19979__$1,opts){
return (function (val){
var statearr_19982_19988 = state;
(statearr_19982_19988[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__19979,map__19979__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_19983_19989 = state;
(statearr_19983_19989[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq19974){
var G__19975 = cljs.core.first.call(null,seq19974);
var seq19974__$1 = cljs.core.next.call(null,seq19974);
var G__19976 = cljs.core.first.call(null,seq19974__$1);
var seq19974__$2 = cljs.core.next.call(null,seq19974__$1);
var G__19977 = cljs.core.first.call(null,seq19974__$2);
var seq19974__$3 = cljs.core.next.call(null,seq19974__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19975,G__19976,G__19977,seq19974__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20157 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20157 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta20158){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta20158 = meta20158;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20159,meta20158__$1){
var self__ = this;
var _20159__$1 = this;
return (new cljs.core.async.t_cljs$core$async20157(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta20158__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20159){
var self__ = this;
var _20159__$1 = this;
return self__.meta20158;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta20158","meta20158",-390663040,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20157.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20157.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20157";

cljs.core.async.t_cljs$core$async20157.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20157");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20157 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20157(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta20158){
return (new cljs.core.async.t_cljs$core$async20157(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta20158));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20157(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18587__auto___20324 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___20324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___20324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20261){
var state_val_20262 = (state_20261[(1)]);
if((state_val_20262 === (7))){
var inst_20176 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
var statearr_20263_20325 = state_20261__$1;
(statearr_20263_20325[(2)] = inst_20176);

(statearr_20263_20325[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (20))){
var inst_20188 = (state_20261[(7)]);
var state_20261__$1 = state_20261;
var statearr_20264_20326 = state_20261__$1;
(statearr_20264_20326[(2)] = inst_20188);

(statearr_20264_20326[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (27))){
var state_20261__$1 = state_20261;
var statearr_20265_20327 = state_20261__$1;
(statearr_20265_20327[(2)] = null);

(statearr_20265_20327[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (1))){
var inst_20163 = (state_20261[(8)]);
var inst_20163__$1 = calc_state.call(null);
var inst_20165 = (inst_20163__$1 == null);
var inst_20166 = cljs.core.not.call(null,inst_20165);
var state_20261__$1 = (function (){var statearr_20266 = state_20261;
(statearr_20266[(8)] = inst_20163__$1);

return statearr_20266;
})();
if(inst_20166){
var statearr_20267_20328 = state_20261__$1;
(statearr_20267_20328[(1)] = (2));

} else {
var statearr_20268_20329 = state_20261__$1;
(statearr_20268_20329[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (24))){
var inst_20221 = (state_20261[(9)]);
var inst_20235 = (state_20261[(10)]);
var inst_20212 = (state_20261[(11)]);
var inst_20235__$1 = inst_20212.call(null,inst_20221);
var state_20261__$1 = (function (){var statearr_20269 = state_20261;
(statearr_20269[(10)] = inst_20235__$1);

return statearr_20269;
})();
if(cljs.core.truth_(inst_20235__$1)){
var statearr_20270_20330 = state_20261__$1;
(statearr_20270_20330[(1)] = (29));

} else {
var statearr_20271_20331 = state_20261__$1;
(statearr_20271_20331[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (4))){
var inst_20179 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
if(cljs.core.truth_(inst_20179)){
var statearr_20272_20332 = state_20261__$1;
(statearr_20272_20332[(1)] = (8));

} else {
var statearr_20273_20333 = state_20261__$1;
(statearr_20273_20333[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (15))){
var inst_20206 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
if(cljs.core.truth_(inst_20206)){
var statearr_20274_20334 = state_20261__$1;
(statearr_20274_20334[(1)] = (19));

} else {
var statearr_20275_20335 = state_20261__$1;
(statearr_20275_20335[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (21))){
var inst_20211 = (state_20261[(12)]);
var inst_20211__$1 = (state_20261[(2)]);
var inst_20212 = cljs.core.get.call(null,inst_20211__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20213 = cljs.core.get.call(null,inst_20211__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20214 = cljs.core.get.call(null,inst_20211__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20261__$1 = (function (){var statearr_20276 = state_20261;
(statearr_20276[(12)] = inst_20211__$1);

(statearr_20276[(13)] = inst_20213);

(statearr_20276[(11)] = inst_20212);

return statearr_20276;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20261__$1,(22),inst_20214);
} else {
if((state_val_20262 === (31))){
var inst_20243 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
if(cljs.core.truth_(inst_20243)){
var statearr_20277_20336 = state_20261__$1;
(statearr_20277_20336[(1)] = (32));

} else {
var statearr_20278_20337 = state_20261__$1;
(statearr_20278_20337[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (32))){
var inst_20220 = (state_20261[(14)]);
var state_20261__$1 = state_20261;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20261__$1,(35),out,inst_20220);
} else {
if((state_val_20262 === (33))){
var inst_20211 = (state_20261[(12)]);
var inst_20188 = inst_20211;
var state_20261__$1 = (function (){var statearr_20279 = state_20261;
(statearr_20279[(7)] = inst_20188);

return statearr_20279;
})();
var statearr_20280_20338 = state_20261__$1;
(statearr_20280_20338[(2)] = null);

(statearr_20280_20338[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (13))){
var inst_20188 = (state_20261[(7)]);
var inst_20195 = inst_20188.cljs$lang$protocol_mask$partition0$;
var inst_20196 = (inst_20195 & (64));
var inst_20197 = inst_20188.cljs$core$ISeq$;
var inst_20198 = (cljs.core.PROTOCOL_SENTINEL === inst_20197);
var inst_20199 = (inst_20196) || (inst_20198);
var state_20261__$1 = state_20261;
if(cljs.core.truth_(inst_20199)){
var statearr_20281_20339 = state_20261__$1;
(statearr_20281_20339[(1)] = (16));

} else {
var statearr_20282_20340 = state_20261__$1;
(statearr_20282_20340[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (22))){
var inst_20221 = (state_20261[(9)]);
var inst_20220 = (state_20261[(14)]);
var inst_20219 = (state_20261[(2)]);
var inst_20220__$1 = cljs.core.nth.call(null,inst_20219,(0),null);
var inst_20221__$1 = cljs.core.nth.call(null,inst_20219,(1),null);
var inst_20222 = (inst_20220__$1 == null);
var inst_20223 = cljs.core._EQ_.call(null,inst_20221__$1,change);
var inst_20224 = (inst_20222) || (inst_20223);
var state_20261__$1 = (function (){var statearr_20283 = state_20261;
(statearr_20283[(9)] = inst_20221__$1);

(statearr_20283[(14)] = inst_20220__$1);

return statearr_20283;
})();
if(cljs.core.truth_(inst_20224)){
var statearr_20284_20341 = state_20261__$1;
(statearr_20284_20341[(1)] = (23));

} else {
var statearr_20285_20342 = state_20261__$1;
(statearr_20285_20342[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (36))){
var inst_20211 = (state_20261[(12)]);
var inst_20188 = inst_20211;
var state_20261__$1 = (function (){var statearr_20286 = state_20261;
(statearr_20286[(7)] = inst_20188);

return statearr_20286;
})();
var statearr_20287_20343 = state_20261__$1;
(statearr_20287_20343[(2)] = null);

(statearr_20287_20343[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (29))){
var inst_20235 = (state_20261[(10)]);
var state_20261__$1 = state_20261;
var statearr_20288_20344 = state_20261__$1;
(statearr_20288_20344[(2)] = inst_20235);

(statearr_20288_20344[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (6))){
var state_20261__$1 = state_20261;
var statearr_20289_20345 = state_20261__$1;
(statearr_20289_20345[(2)] = false);

(statearr_20289_20345[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (28))){
var inst_20231 = (state_20261[(2)]);
var inst_20232 = calc_state.call(null);
var inst_20188 = inst_20232;
var state_20261__$1 = (function (){var statearr_20290 = state_20261;
(statearr_20290[(15)] = inst_20231);

(statearr_20290[(7)] = inst_20188);

return statearr_20290;
})();
var statearr_20291_20346 = state_20261__$1;
(statearr_20291_20346[(2)] = null);

(statearr_20291_20346[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (25))){
var inst_20257 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
var statearr_20292_20347 = state_20261__$1;
(statearr_20292_20347[(2)] = inst_20257);

(statearr_20292_20347[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (34))){
var inst_20255 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
var statearr_20293_20348 = state_20261__$1;
(statearr_20293_20348[(2)] = inst_20255);

(statearr_20293_20348[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (17))){
var state_20261__$1 = state_20261;
var statearr_20294_20349 = state_20261__$1;
(statearr_20294_20349[(2)] = false);

(statearr_20294_20349[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (3))){
var state_20261__$1 = state_20261;
var statearr_20295_20350 = state_20261__$1;
(statearr_20295_20350[(2)] = false);

(statearr_20295_20350[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (12))){
var inst_20259 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20261__$1,inst_20259);
} else {
if((state_val_20262 === (2))){
var inst_20163 = (state_20261[(8)]);
var inst_20168 = inst_20163.cljs$lang$protocol_mask$partition0$;
var inst_20169 = (inst_20168 & (64));
var inst_20170 = inst_20163.cljs$core$ISeq$;
var inst_20171 = (cljs.core.PROTOCOL_SENTINEL === inst_20170);
var inst_20172 = (inst_20169) || (inst_20171);
var state_20261__$1 = state_20261;
if(cljs.core.truth_(inst_20172)){
var statearr_20296_20351 = state_20261__$1;
(statearr_20296_20351[(1)] = (5));

} else {
var statearr_20297_20352 = state_20261__$1;
(statearr_20297_20352[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (23))){
var inst_20220 = (state_20261[(14)]);
var inst_20226 = (inst_20220 == null);
var state_20261__$1 = state_20261;
if(cljs.core.truth_(inst_20226)){
var statearr_20298_20353 = state_20261__$1;
(statearr_20298_20353[(1)] = (26));

} else {
var statearr_20299_20354 = state_20261__$1;
(statearr_20299_20354[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (35))){
var inst_20246 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
if(cljs.core.truth_(inst_20246)){
var statearr_20300_20355 = state_20261__$1;
(statearr_20300_20355[(1)] = (36));

} else {
var statearr_20301_20356 = state_20261__$1;
(statearr_20301_20356[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (19))){
var inst_20188 = (state_20261[(7)]);
var inst_20208 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20188);
var state_20261__$1 = state_20261;
var statearr_20302_20357 = state_20261__$1;
(statearr_20302_20357[(2)] = inst_20208);

(statearr_20302_20357[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (11))){
var inst_20188 = (state_20261[(7)]);
var inst_20192 = (inst_20188 == null);
var inst_20193 = cljs.core.not.call(null,inst_20192);
var state_20261__$1 = state_20261;
if(inst_20193){
var statearr_20303_20358 = state_20261__$1;
(statearr_20303_20358[(1)] = (13));

} else {
var statearr_20304_20359 = state_20261__$1;
(statearr_20304_20359[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (9))){
var inst_20163 = (state_20261[(8)]);
var state_20261__$1 = state_20261;
var statearr_20305_20360 = state_20261__$1;
(statearr_20305_20360[(2)] = inst_20163);

(statearr_20305_20360[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (5))){
var state_20261__$1 = state_20261;
var statearr_20306_20361 = state_20261__$1;
(statearr_20306_20361[(2)] = true);

(statearr_20306_20361[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (14))){
var state_20261__$1 = state_20261;
var statearr_20307_20362 = state_20261__$1;
(statearr_20307_20362[(2)] = false);

(statearr_20307_20362[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (26))){
var inst_20221 = (state_20261[(9)]);
var inst_20228 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20221);
var state_20261__$1 = state_20261;
var statearr_20308_20363 = state_20261__$1;
(statearr_20308_20363[(2)] = inst_20228);

(statearr_20308_20363[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (16))){
var state_20261__$1 = state_20261;
var statearr_20309_20364 = state_20261__$1;
(statearr_20309_20364[(2)] = true);

(statearr_20309_20364[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (38))){
var inst_20251 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
var statearr_20310_20365 = state_20261__$1;
(statearr_20310_20365[(2)] = inst_20251);

(statearr_20310_20365[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (30))){
var inst_20221 = (state_20261[(9)]);
var inst_20213 = (state_20261[(13)]);
var inst_20212 = (state_20261[(11)]);
var inst_20238 = cljs.core.empty_QMARK_.call(null,inst_20212);
var inst_20239 = inst_20213.call(null,inst_20221);
var inst_20240 = cljs.core.not.call(null,inst_20239);
var inst_20241 = (inst_20238) && (inst_20240);
var state_20261__$1 = state_20261;
var statearr_20311_20366 = state_20261__$1;
(statearr_20311_20366[(2)] = inst_20241);

(statearr_20311_20366[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (10))){
var inst_20163 = (state_20261[(8)]);
var inst_20184 = (state_20261[(2)]);
var inst_20185 = cljs.core.get.call(null,inst_20184,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20186 = cljs.core.get.call(null,inst_20184,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20187 = cljs.core.get.call(null,inst_20184,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20188 = inst_20163;
var state_20261__$1 = (function (){var statearr_20312 = state_20261;
(statearr_20312[(16)] = inst_20186);

(statearr_20312[(17)] = inst_20187);

(statearr_20312[(7)] = inst_20188);

(statearr_20312[(18)] = inst_20185);

return statearr_20312;
})();
var statearr_20313_20367 = state_20261__$1;
(statearr_20313_20367[(2)] = null);

(statearr_20313_20367[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (18))){
var inst_20203 = (state_20261[(2)]);
var state_20261__$1 = state_20261;
var statearr_20314_20368 = state_20261__$1;
(statearr_20314_20368[(2)] = inst_20203);

(statearr_20314_20368[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (37))){
var state_20261__$1 = state_20261;
var statearr_20315_20369 = state_20261__$1;
(statearr_20315_20369[(2)] = null);

(statearr_20315_20369[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20262 === (8))){
var inst_20163 = (state_20261[(8)]);
var inst_20181 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20163);
var state_20261__$1 = state_20261;
var statearr_20316_20370 = state_20261__$1;
(statearr_20316_20370[(2)] = inst_20181);

(statearr_20316_20370[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___20324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__18475__auto__,c__18587__auto___20324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__18476__auto__ = null;
var cljs$core$async$mix_$_state_machine__18476__auto____0 = (function (){
var statearr_20320 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20320[(0)] = cljs$core$async$mix_$_state_machine__18476__auto__);

(statearr_20320[(1)] = (1));

return statearr_20320;
});
var cljs$core$async$mix_$_state_machine__18476__auto____1 = (function (state_20261){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_20261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e20321){if((e20321 instanceof Object)){
var ex__18479__auto__ = e20321;
var statearr_20322_20371 = state_20261;
(statearr_20322_20371[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20321;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20372 = state_20261;
state_20261 = G__20372;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__18476__auto__ = function(state_20261){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__18476__auto____1.call(this,state_20261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__18476__auto____0;
cljs$core$async$mix_$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__18476__auto____1;
return cljs$core$async$mix_$_state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___20324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__18589__auto__ = (function (){var statearr_20323 = f__18588__auto__.call(null);
(statearr_20323[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___20324);

return statearr_20323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___20324,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7207__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,p,v,ch);
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20373 = [];
var len__7651__auto___20376 = arguments.length;
var i__7652__auto___20377 = (0);
while(true){
if((i__7652__auto___20377 < len__7651__auto___20376)){
args20373.push((arguments[i__7652__auto___20377]));

var G__20378 = (i__7652__auto___20377 + (1));
i__7652__auto___20377 = G__20378;
continue;
} else {
}
break;
}

var G__20375 = args20373.length;
switch (G__20375) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20373.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,p);
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,p,v);
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20381 = [];
var len__7651__auto___20506 = arguments.length;
var i__7652__auto___20507 = (0);
while(true){
if((i__7652__auto___20507 < len__7651__auto___20506)){
args20381.push((arguments[i__7652__auto___20507]));

var G__20508 = (i__7652__auto___20507 + (1));
i__7652__auto___20507 = G__20508;
continue;
} else {
}
break;
}

var G__20383 = args20381.length;
switch (G__20383) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20381.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6543__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6543__auto__,mults){
return (function (p1__20380_SHARP_){
if(cljs.core.truth_(p1__20380_SHARP_.call(null,topic))){
return p1__20380_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20380_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6543__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20384 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20384 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20385){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20385 = meta20385;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20386,meta20385__$1){
var self__ = this;
var _20386__$1 = this;
return (new cljs.core.async.t_cljs$core$async20384(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20385__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20386){
var self__ = this;
var _20386__$1 = this;
return self__.meta20385;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20384.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20384.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20385","meta20385",2111405143,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20384.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20384.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20384";

cljs.core.async.t_cljs$core$async20384.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20384");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20384 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20384(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20385){
return (new cljs.core.async.t_cljs$core$async20384(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20385));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20384(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18587__auto___20510 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___20510,mults,ensure_mult,p){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___20510,mults,ensure_mult,p){
return (function (state_20458){
var state_val_20459 = (state_20458[(1)]);
if((state_val_20459 === (7))){
var inst_20454 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20460_20511 = state_20458__$1;
(statearr_20460_20511[(2)] = inst_20454);

(statearr_20460_20511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (20))){
var state_20458__$1 = state_20458;
var statearr_20461_20512 = state_20458__$1;
(statearr_20461_20512[(2)] = null);

(statearr_20461_20512[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (1))){
var state_20458__$1 = state_20458;
var statearr_20462_20513 = state_20458__$1;
(statearr_20462_20513[(2)] = null);

(statearr_20462_20513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (24))){
var inst_20437 = (state_20458[(7)]);
var inst_20446 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20437);
var state_20458__$1 = state_20458;
var statearr_20463_20514 = state_20458__$1;
(statearr_20463_20514[(2)] = inst_20446);

(statearr_20463_20514[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (4))){
var inst_20389 = (state_20458[(8)]);
var inst_20389__$1 = (state_20458[(2)]);
var inst_20390 = (inst_20389__$1 == null);
var state_20458__$1 = (function (){var statearr_20464 = state_20458;
(statearr_20464[(8)] = inst_20389__$1);

return statearr_20464;
})();
if(cljs.core.truth_(inst_20390)){
var statearr_20465_20515 = state_20458__$1;
(statearr_20465_20515[(1)] = (5));

} else {
var statearr_20466_20516 = state_20458__$1;
(statearr_20466_20516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (15))){
var inst_20431 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20467_20517 = state_20458__$1;
(statearr_20467_20517[(2)] = inst_20431);

(statearr_20467_20517[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (21))){
var inst_20451 = (state_20458[(2)]);
var state_20458__$1 = (function (){var statearr_20468 = state_20458;
(statearr_20468[(9)] = inst_20451);

return statearr_20468;
})();
var statearr_20469_20518 = state_20458__$1;
(statearr_20469_20518[(2)] = null);

(statearr_20469_20518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (13))){
var inst_20413 = (state_20458[(10)]);
var inst_20415 = cljs.core.chunked_seq_QMARK_.call(null,inst_20413);
var state_20458__$1 = state_20458;
if(inst_20415){
var statearr_20470_20519 = state_20458__$1;
(statearr_20470_20519[(1)] = (16));

} else {
var statearr_20471_20520 = state_20458__$1;
(statearr_20471_20520[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (22))){
var inst_20443 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
if(cljs.core.truth_(inst_20443)){
var statearr_20472_20521 = state_20458__$1;
(statearr_20472_20521[(1)] = (23));

} else {
var statearr_20473_20522 = state_20458__$1;
(statearr_20473_20522[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (6))){
var inst_20389 = (state_20458[(8)]);
var inst_20439 = (state_20458[(11)]);
var inst_20437 = (state_20458[(7)]);
var inst_20437__$1 = topic_fn.call(null,inst_20389);
var inst_20438 = cljs.core.deref.call(null,mults);
var inst_20439__$1 = cljs.core.get.call(null,inst_20438,inst_20437__$1);
var state_20458__$1 = (function (){var statearr_20474 = state_20458;
(statearr_20474[(11)] = inst_20439__$1);

(statearr_20474[(7)] = inst_20437__$1);

return statearr_20474;
})();
if(cljs.core.truth_(inst_20439__$1)){
var statearr_20475_20523 = state_20458__$1;
(statearr_20475_20523[(1)] = (19));

} else {
var statearr_20476_20524 = state_20458__$1;
(statearr_20476_20524[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (25))){
var inst_20448 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20477_20525 = state_20458__$1;
(statearr_20477_20525[(2)] = inst_20448);

(statearr_20477_20525[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (17))){
var inst_20413 = (state_20458[(10)]);
var inst_20422 = cljs.core.first.call(null,inst_20413);
var inst_20423 = cljs.core.async.muxch_STAR_.call(null,inst_20422);
var inst_20424 = cljs.core.async.close_BANG_.call(null,inst_20423);
var inst_20425 = cljs.core.next.call(null,inst_20413);
var inst_20399 = inst_20425;
var inst_20400 = null;
var inst_20401 = (0);
var inst_20402 = (0);
var state_20458__$1 = (function (){var statearr_20478 = state_20458;
(statearr_20478[(12)] = inst_20402);

(statearr_20478[(13)] = inst_20424);

(statearr_20478[(14)] = inst_20399);

(statearr_20478[(15)] = inst_20400);

(statearr_20478[(16)] = inst_20401);

return statearr_20478;
})();
var statearr_20479_20526 = state_20458__$1;
(statearr_20479_20526[(2)] = null);

(statearr_20479_20526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (3))){
var inst_20456 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20458__$1,inst_20456);
} else {
if((state_val_20459 === (12))){
var inst_20433 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20480_20527 = state_20458__$1;
(statearr_20480_20527[(2)] = inst_20433);

(statearr_20480_20527[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (2))){
var state_20458__$1 = state_20458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20458__$1,(4),ch);
} else {
if((state_val_20459 === (23))){
var state_20458__$1 = state_20458;
var statearr_20481_20528 = state_20458__$1;
(statearr_20481_20528[(2)] = null);

(statearr_20481_20528[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (19))){
var inst_20389 = (state_20458[(8)]);
var inst_20439 = (state_20458[(11)]);
var inst_20441 = cljs.core.async.muxch_STAR_.call(null,inst_20439);
var state_20458__$1 = state_20458;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20458__$1,(22),inst_20441,inst_20389);
} else {
if((state_val_20459 === (11))){
var inst_20399 = (state_20458[(14)]);
var inst_20413 = (state_20458[(10)]);
var inst_20413__$1 = cljs.core.seq.call(null,inst_20399);
var state_20458__$1 = (function (){var statearr_20482 = state_20458;
(statearr_20482[(10)] = inst_20413__$1);

return statearr_20482;
})();
if(inst_20413__$1){
var statearr_20483_20529 = state_20458__$1;
(statearr_20483_20529[(1)] = (13));

} else {
var statearr_20484_20530 = state_20458__$1;
(statearr_20484_20530[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (9))){
var inst_20435 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20485_20531 = state_20458__$1;
(statearr_20485_20531[(2)] = inst_20435);

(statearr_20485_20531[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (5))){
var inst_20396 = cljs.core.deref.call(null,mults);
var inst_20397 = cljs.core.vals.call(null,inst_20396);
var inst_20398 = cljs.core.seq.call(null,inst_20397);
var inst_20399 = inst_20398;
var inst_20400 = null;
var inst_20401 = (0);
var inst_20402 = (0);
var state_20458__$1 = (function (){var statearr_20486 = state_20458;
(statearr_20486[(12)] = inst_20402);

(statearr_20486[(14)] = inst_20399);

(statearr_20486[(15)] = inst_20400);

(statearr_20486[(16)] = inst_20401);

return statearr_20486;
})();
var statearr_20487_20532 = state_20458__$1;
(statearr_20487_20532[(2)] = null);

(statearr_20487_20532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (14))){
var state_20458__$1 = state_20458;
var statearr_20491_20533 = state_20458__$1;
(statearr_20491_20533[(2)] = null);

(statearr_20491_20533[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (16))){
var inst_20413 = (state_20458[(10)]);
var inst_20417 = cljs.core.chunk_first.call(null,inst_20413);
var inst_20418 = cljs.core.chunk_rest.call(null,inst_20413);
var inst_20419 = cljs.core.count.call(null,inst_20417);
var inst_20399 = inst_20418;
var inst_20400 = inst_20417;
var inst_20401 = inst_20419;
var inst_20402 = (0);
var state_20458__$1 = (function (){var statearr_20492 = state_20458;
(statearr_20492[(12)] = inst_20402);

(statearr_20492[(14)] = inst_20399);

(statearr_20492[(15)] = inst_20400);

(statearr_20492[(16)] = inst_20401);

return statearr_20492;
})();
var statearr_20493_20534 = state_20458__$1;
(statearr_20493_20534[(2)] = null);

(statearr_20493_20534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (10))){
var inst_20402 = (state_20458[(12)]);
var inst_20399 = (state_20458[(14)]);
var inst_20400 = (state_20458[(15)]);
var inst_20401 = (state_20458[(16)]);
var inst_20407 = cljs.core._nth.call(null,inst_20400,inst_20402);
var inst_20408 = cljs.core.async.muxch_STAR_.call(null,inst_20407);
var inst_20409 = cljs.core.async.close_BANG_.call(null,inst_20408);
var inst_20410 = (inst_20402 + (1));
var tmp20488 = inst_20399;
var tmp20489 = inst_20400;
var tmp20490 = inst_20401;
var inst_20399__$1 = tmp20488;
var inst_20400__$1 = tmp20489;
var inst_20401__$1 = tmp20490;
var inst_20402__$1 = inst_20410;
var state_20458__$1 = (function (){var statearr_20494 = state_20458;
(statearr_20494[(12)] = inst_20402__$1);

(statearr_20494[(17)] = inst_20409);

(statearr_20494[(14)] = inst_20399__$1);

(statearr_20494[(15)] = inst_20400__$1);

(statearr_20494[(16)] = inst_20401__$1);

return statearr_20494;
})();
var statearr_20495_20535 = state_20458__$1;
(statearr_20495_20535[(2)] = null);

(statearr_20495_20535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (18))){
var inst_20428 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20496_20536 = state_20458__$1;
(statearr_20496_20536[(2)] = inst_20428);

(statearr_20496_20536[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (8))){
var inst_20402 = (state_20458[(12)]);
var inst_20401 = (state_20458[(16)]);
var inst_20404 = (inst_20402 < inst_20401);
var inst_20405 = inst_20404;
var state_20458__$1 = state_20458;
if(cljs.core.truth_(inst_20405)){
var statearr_20497_20537 = state_20458__$1;
(statearr_20497_20537[(1)] = (10));

} else {
var statearr_20498_20538 = state_20458__$1;
(statearr_20498_20538[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___20510,mults,ensure_mult,p))
;
return ((function (switch__18475__auto__,c__18587__auto___20510,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_20502 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20502[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_20502[(1)] = (1));

return statearr_20502;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_20458){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_20458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e20503){if((e20503 instanceof Object)){
var ex__18479__auto__ = e20503;
var statearr_20504_20539 = state_20458;
(statearr_20504_20539[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20458);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20503;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20540 = state_20458;
state_20458 = G__20540;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_20458){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_20458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___20510,mults,ensure_mult,p))
})();
var state__18589__auto__ = (function (){var statearr_20505 = f__18588__auto__.call(null);
(statearr_20505[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___20510);

return statearr_20505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___20510,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20541 = [];
var len__7651__auto___20544 = arguments.length;
var i__7652__auto___20545 = (0);
while(true){
if((i__7652__auto___20545 < len__7651__auto___20544)){
args20541.push((arguments[i__7652__auto___20545]));

var G__20546 = (i__7652__auto___20545 + (1));
i__7652__auto___20545 = G__20546;
continue;
} else {
}
break;
}

var G__20543 = args20541.length;
switch (G__20543) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20541.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20548 = [];
var len__7651__auto___20551 = arguments.length;
var i__7652__auto___20552 = (0);
while(true){
if((i__7652__auto___20552 < len__7651__auto___20551)){
args20548.push((arguments[i__7652__auto___20552]));

var G__20553 = (i__7652__auto___20552 + (1));
i__7652__auto___20552 = G__20553;
continue;
} else {
}
break;
}

var G__20550 = args20548.length;
switch (G__20550) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20548.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20555 = [];
var len__7651__auto___20626 = arguments.length;
var i__7652__auto___20627 = (0);
while(true){
if((i__7652__auto___20627 < len__7651__auto___20626)){
args20555.push((arguments[i__7652__auto___20627]));

var G__20628 = (i__7652__auto___20627 + (1));
i__7652__auto___20627 = G__20628;
continue;
} else {
}
break;
}

var G__20557 = args20555.length;
switch (G__20557) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20555.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__18587__auto___20630 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___20630,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___20630,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20596){
var state_val_20597 = (state_20596[(1)]);
if((state_val_20597 === (7))){
var state_20596__$1 = state_20596;
var statearr_20598_20631 = state_20596__$1;
(statearr_20598_20631[(2)] = null);

(statearr_20598_20631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (1))){
var state_20596__$1 = state_20596;
var statearr_20599_20632 = state_20596__$1;
(statearr_20599_20632[(2)] = null);

(statearr_20599_20632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (4))){
var inst_20560 = (state_20596[(7)]);
var inst_20562 = (inst_20560 < cnt);
var state_20596__$1 = state_20596;
if(cljs.core.truth_(inst_20562)){
var statearr_20600_20633 = state_20596__$1;
(statearr_20600_20633[(1)] = (6));

} else {
var statearr_20601_20634 = state_20596__$1;
(statearr_20601_20634[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (15))){
var inst_20592 = (state_20596[(2)]);
var state_20596__$1 = state_20596;
var statearr_20602_20635 = state_20596__$1;
(statearr_20602_20635[(2)] = inst_20592);

(statearr_20602_20635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (13))){
var inst_20585 = cljs.core.async.close_BANG_.call(null,out);
var state_20596__$1 = state_20596;
var statearr_20603_20636 = state_20596__$1;
(statearr_20603_20636[(2)] = inst_20585);

(statearr_20603_20636[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (6))){
var state_20596__$1 = state_20596;
var statearr_20604_20637 = state_20596__$1;
(statearr_20604_20637[(2)] = null);

(statearr_20604_20637[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (3))){
var inst_20594 = (state_20596[(2)]);
var state_20596__$1 = state_20596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20596__$1,inst_20594);
} else {
if((state_val_20597 === (12))){
var inst_20582 = (state_20596[(8)]);
var inst_20582__$1 = (state_20596[(2)]);
var inst_20583 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20582__$1);
var state_20596__$1 = (function (){var statearr_20605 = state_20596;
(statearr_20605[(8)] = inst_20582__$1);

return statearr_20605;
})();
if(cljs.core.truth_(inst_20583)){
var statearr_20606_20638 = state_20596__$1;
(statearr_20606_20638[(1)] = (13));

} else {
var statearr_20607_20639 = state_20596__$1;
(statearr_20607_20639[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (2))){
var inst_20559 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20560 = (0);
var state_20596__$1 = (function (){var statearr_20608 = state_20596;
(statearr_20608[(7)] = inst_20560);

(statearr_20608[(9)] = inst_20559);

return statearr_20608;
})();
var statearr_20609_20640 = state_20596__$1;
(statearr_20609_20640[(2)] = null);

(statearr_20609_20640[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (11))){
var inst_20560 = (state_20596[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20596,(10),Object,null,(9));
var inst_20569 = chs__$1.call(null,inst_20560);
var inst_20570 = done.call(null,inst_20560);
var inst_20571 = cljs.core.async.take_BANG_.call(null,inst_20569,inst_20570);
var state_20596__$1 = state_20596;
var statearr_20610_20641 = state_20596__$1;
(statearr_20610_20641[(2)] = inst_20571);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20596__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (9))){
var inst_20560 = (state_20596[(7)]);
var inst_20573 = (state_20596[(2)]);
var inst_20574 = (inst_20560 + (1));
var inst_20560__$1 = inst_20574;
var state_20596__$1 = (function (){var statearr_20611 = state_20596;
(statearr_20611[(7)] = inst_20560__$1);

(statearr_20611[(10)] = inst_20573);

return statearr_20611;
})();
var statearr_20612_20642 = state_20596__$1;
(statearr_20612_20642[(2)] = null);

(statearr_20612_20642[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (5))){
var inst_20580 = (state_20596[(2)]);
var state_20596__$1 = (function (){var statearr_20613 = state_20596;
(statearr_20613[(11)] = inst_20580);

return statearr_20613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20596__$1,(12),dchan);
} else {
if((state_val_20597 === (14))){
var inst_20582 = (state_20596[(8)]);
var inst_20587 = cljs.core.apply.call(null,f,inst_20582);
var state_20596__$1 = state_20596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20596__$1,(16),out,inst_20587);
} else {
if((state_val_20597 === (16))){
var inst_20589 = (state_20596[(2)]);
var state_20596__$1 = (function (){var statearr_20614 = state_20596;
(statearr_20614[(12)] = inst_20589);

return statearr_20614;
})();
var statearr_20615_20643 = state_20596__$1;
(statearr_20615_20643[(2)] = null);

(statearr_20615_20643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (10))){
var inst_20564 = (state_20596[(2)]);
var inst_20565 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20596__$1 = (function (){var statearr_20616 = state_20596;
(statearr_20616[(13)] = inst_20564);

return statearr_20616;
})();
var statearr_20617_20644 = state_20596__$1;
(statearr_20617_20644[(2)] = inst_20565);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20596__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20597 === (8))){
var inst_20578 = (state_20596[(2)]);
var state_20596__$1 = state_20596;
var statearr_20618_20645 = state_20596__$1;
(statearr_20618_20645[(2)] = inst_20578);

(statearr_20618_20645[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___20630,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__18475__auto__,c__18587__auto___20630,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_20622 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20622[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_20622[(1)] = (1));

return statearr_20622;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_20596){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_20596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e20623){if((e20623 instanceof Object)){
var ex__18479__auto__ = e20623;
var statearr_20624_20646 = state_20596;
(statearr_20624_20646[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20623;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20647 = state_20596;
state_20596 = G__20647;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_20596){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_20596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___20630,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__18589__auto__ = (function (){var statearr_20625 = f__18588__auto__.call(null);
(statearr_20625[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___20630);

return statearr_20625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___20630,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20649 = [];
var len__7651__auto___20707 = arguments.length;
var i__7652__auto___20708 = (0);
while(true){
if((i__7652__auto___20708 < len__7651__auto___20707)){
args20649.push((arguments[i__7652__auto___20708]));

var G__20709 = (i__7652__auto___20708 + (1));
i__7652__auto___20708 = G__20709;
continue;
} else {
}
break;
}

var G__20651 = args20649.length;
switch (G__20651) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20649.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18587__auto___20711 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___20711,out){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___20711,out){
return (function (state_20683){
var state_val_20684 = (state_20683[(1)]);
if((state_val_20684 === (7))){
var inst_20662 = (state_20683[(7)]);
var inst_20663 = (state_20683[(8)]);
var inst_20662__$1 = (state_20683[(2)]);
var inst_20663__$1 = cljs.core.nth.call(null,inst_20662__$1,(0),null);
var inst_20664 = cljs.core.nth.call(null,inst_20662__$1,(1),null);
var inst_20665 = (inst_20663__$1 == null);
var state_20683__$1 = (function (){var statearr_20685 = state_20683;
(statearr_20685[(7)] = inst_20662__$1);

(statearr_20685[(9)] = inst_20664);

(statearr_20685[(8)] = inst_20663__$1);

return statearr_20685;
})();
if(cljs.core.truth_(inst_20665)){
var statearr_20686_20712 = state_20683__$1;
(statearr_20686_20712[(1)] = (8));

} else {
var statearr_20687_20713 = state_20683__$1;
(statearr_20687_20713[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (1))){
var inst_20652 = cljs.core.vec.call(null,chs);
var inst_20653 = inst_20652;
var state_20683__$1 = (function (){var statearr_20688 = state_20683;
(statearr_20688[(10)] = inst_20653);

return statearr_20688;
})();
var statearr_20689_20714 = state_20683__$1;
(statearr_20689_20714[(2)] = null);

(statearr_20689_20714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (4))){
var inst_20653 = (state_20683[(10)]);
var state_20683__$1 = state_20683;
return cljs.core.async.ioc_alts_BANG_.call(null,state_20683__$1,(7),inst_20653);
} else {
if((state_val_20684 === (6))){
var inst_20679 = (state_20683[(2)]);
var state_20683__$1 = state_20683;
var statearr_20690_20715 = state_20683__$1;
(statearr_20690_20715[(2)] = inst_20679);

(statearr_20690_20715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (3))){
var inst_20681 = (state_20683[(2)]);
var state_20683__$1 = state_20683;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20683__$1,inst_20681);
} else {
if((state_val_20684 === (2))){
var inst_20653 = (state_20683[(10)]);
var inst_20655 = cljs.core.count.call(null,inst_20653);
var inst_20656 = (inst_20655 > (0));
var state_20683__$1 = state_20683;
if(cljs.core.truth_(inst_20656)){
var statearr_20692_20716 = state_20683__$1;
(statearr_20692_20716[(1)] = (4));

} else {
var statearr_20693_20717 = state_20683__$1;
(statearr_20693_20717[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (11))){
var inst_20653 = (state_20683[(10)]);
var inst_20672 = (state_20683[(2)]);
var tmp20691 = inst_20653;
var inst_20653__$1 = tmp20691;
var state_20683__$1 = (function (){var statearr_20694 = state_20683;
(statearr_20694[(10)] = inst_20653__$1);

(statearr_20694[(11)] = inst_20672);

return statearr_20694;
})();
var statearr_20695_20718 = state_20683__$1;
(statearr_20695_20718[(2)] = null);

(statearr_20695_20718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (9))){
var inst_20663 = (state_20683[(8)]);
var state_20683__$1 = state_20683;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20683__$1,(11),out,inst_20663);
} else {
if((state_val_20684 === (5))){
var inst_20677 = cljs.core.async.close_BANG_.call(null,out);
var state_20683__$1 = state_20683;
var statearr_20696_20719 = state_20683__$1;
(statearr_20696_20719[(2)] = inst_20677);

(statearr_20696_20719[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (10))){
var inst_20675 = (state_20683[(2)]);
var state_20683__$1 = state_20683;
var statearr_20697_20720 = state_20683__$1;
(statearr_20697_20720[(2)] = inst_20675);

(statearr_20697_20720[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (8))){
var inst_20653 = (state_20683[(10)]);
var inst_20662 = (state_20683[(7)]);
var inst_20664 = (state_20683[(9)]);
var inst_20663 = (state_20683[(8)]);
var inst_20667 = (function (){var cs = inst_20653;
var vec__20658 = inst_20662;
var v = inst_20663;
var c = inst_20664;
return ((function (cs,vec__20658,v,c,inst_20653,inst_20662,inst_20664,inst_20663,state_val_20684,c__18587__auto___20711,out){
return (function (p1__20648_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20648_SHARP_);
});
;})(cs,vec__20658,v,c,inst_20653,inst_20662,inst_20664,inst_20663,state_val_20684,c__18587__auto___20711,out))
})();
var inst_20668 = cljs.core.filterv.call(null,inst_20667,inst_20653);
var inst_20653__$1 = inst_20668;
var state_20683__$1 = (function (){var statearr_20698 = state_20683;
(statearr_20698[(10)] = inst_20653__$1);

return statearr_20698;
})();
var statearr_20699_20721 = state_20683__$1;
(statearr_20699_20721[(2)] = null);

(statearr_20699_20721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___20711,out))
;
return ((function (switch__18475__auto__,c__18587__auto___20711,out){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_20703 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20703[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_20703[(1)] = (1));

return statearr_20703;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_20683){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_20683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e20704){if((e20704 instanceof Object)){
var ex__18479__auto__ = e20704;
var statearr_20705_20722 = state_20683;
(statearr_20705_20722[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20683);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20704;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20723 = state_20683;
state_20683 = G__20723;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_20683){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_20683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___20711,out))
})();
var state__18589__auto__ = (function (){var statearr_20706 = f__18588__auto__.call(null);
(statearr_20706[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___20711);

return statearr_20706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___20711,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args20724 = [];
var len__7651__auto___20773 = arguments.length;
var i__7652__auto___20774 = (0);
while(true){
if((i__7652__auto___20774 < len__7651__auto___20773)){
args20724.push((arguments[i__7652__auto___20774]));

var G__20775 = (i__7652__auto___20774 + (1));
i__7652__auto___20774 = G__20775;
continue;
} else {
}
break;
}

var G__20726 = args20724.length;
switch (G__20726) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20724.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18587__auto___20777 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___20777,out){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___20777,out){
return (function (state_20750){
var state_val_20751 = (state_20750[(1)]);
if((state_val_20751 === (7))){
var inst_20732 = (state_20750[(7)]);
var inst_20732__$1 = (state_20750[(2)]);
var inst_20733 = (inst_20732__$1 == null);
var inst_20734 = cljs.core.not.call(null,inst_20733);
var state_20750__$1 = (function (){var statearr_20752 = state_20750;
(statearr_20752[(7)] = inst_20732__$1);

return statearr_20752;
})();
if(inst_20734){
var statearr_20753_20778 = state_20750__$1;
(statearr_20753_20778[(1)] = (8));

} else {
var statearr_20754_20779 = state_20750__$1;
(statearr_20754_20779[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20751 === (1))){
var inst_20727 = (0);
var state_20750__$1 = (function (){var statearr_20755 = state_20750;
(statearr_20755[(8)] = inst_20727);

return statearr_20755;
})();
var statearr_20756_20780 = state_20750__$1;
(statearr_20756_20780[(2)] = null);

(statearr_20756_20780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20751 === (4))){
var state_20750__$1 = state_20750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20750__$1,(7),ch);
} else {
if((state_val_20751 === (6))){
var inst_20745 = (state_20750[(2)]);
var state_20750__$1 = state_20750;
var statearr_20757_20781 = state_20750__$1;
(statearr_20757_20781[(2)] = inst_20745);

(statearr_20757_20781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20751 === (3))){
var inst_20747 = (state_20750[(2)]);
var inst_20748 = cljs.core.async.close_BANG_.call(null,out);
var state_20750__$1 = (function (){var statearr_20758 = state_20750;
(statearr_20758[(9)] = inst_20747);

return statearr_20758;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20750__$1,inst_20748);
} else {
if((state_val_20751 === (2))){
var inst_20727 = (state_20750[(8)]);
var inst_20729 = (inst_20727 < n);
var state_20750__$1 = state_20750;
if(cljs.core.truth_(inst_20729)){
var statearr_20759_20782 = state_20750__$1;
(statearr_20759_20782[(1)] = (4));

} else {
var statearr_20760_20783 = state_20750__$1;
(statearr_20760_20783[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20751 === (11))){
var inst_20727 = (state_20750[(8)]);
var inst_20737 = (state_20750[(2)]);
var inst_20738 = (inst_20727 + (1));
var inst_20727__$1 = inst_20738;
var state_20750__$1 = (function (){var statearr_20761 = state_20750;
(statearr_20761[(8)] = inst_20727__$1);

(statearr_20761[(10)] = inst_20737);

return statearr_20761;
})();
var statearr_20762_20784 = state_20750__$1;
(statearr_20762_20784[(2)] = null);

(statearr_20762_20784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20751 === (9))){
var state_20750__$1 = state_20750;
var statearr_20763_20785 = state_20750__$1;
(statearr_20763_20785[(2)] = null);

(statearr_20763_20785[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20751 === (5))){
var state_20750__$1 = state_20750;
var statearr_20764_20786 = state_20750__$1;
(statearr_20764_20786[(2)] = null);

(statearr_20764_20786[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20751 === (10))){
var inst_20742 = (state_20750[(2)]);
var state_20750__$1 = state_20750;
var statearr_20765_20787 = state_20750__$1;
(statearr_20765_20787[(2)] = inst_20742);

(statearr_20765_20787[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20751 === (8))){
var inst_20732 = (state_20750[(7)]);
var state_20750__$1 = state_20750;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20750__$1,(11),out,inst_20732);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___20777,out))
;
return ((function (switch__18475__auto__,c__18587__auto___20777,out){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_20769 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20769[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_20769[(1)] = (1));

return statearr_20769;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_20750){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_20750);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e20770){if((e20770 instanceof Object)){
var ex__18479__auto__ = e20770;
var statearr_20771_20788 = state_20750;
(statearr_20771_20788[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20750);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20770;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20789 = state_20750;
state_20750 = G__20789;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_20750){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_20750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___20777,out))
})();
var state__18589__auto__ = (function (){var statearr_20772 = f__18588__auto__.call(null);
(statearr_20772[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___20777);

return statearr_20772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___20777,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20797 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20797 = (function (f,ch,meta20798){
this.f = f;
this.ch = ch;
this.meta20798 = meta20798;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20799,meta20798__$1){
var self__ = this;
var _20799__$1 = this;
return (new cljs.core.async.t_cljs$core$async20797(self__.f,self__.ch,meta20798__$1));
});

cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20799){
var self__ = this;
var _20799__$1 = this;
return self__.meta20798;
});

cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async20800 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20800 = (function (f,ch,meta20798,_,fn1,meta20801){
this.f = f;
this.ch = ch;
this.meta20798 = meta20798;
this._ = _;
this.fn1 = fn1;
this.meta20801 = meta20801;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20800.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_20802,meta20801__$1){
var self__ = this;
var _20802__$1 = this;
return (new cljs.core.async.t_cljs$core$async20800(self__.f,self__.ch,self__.meta20798,self__._,self__.fn1,meta20801__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async20800.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_20802){
var self__ = this;
var _20802__$1 = this;
return self__.meta20801;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20800.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20800.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20800.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20800.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__20790_SHARP_){
return f1.call(null,(((p1__20790_SHARP_ == null))?null:self__.f.call(null,p1__20790_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async20800.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20798","meta20798",-1425865954,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async20797","cljs.core.async/t_cljs$core$async20797",-1936728670,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta20801","meta20801",-633698252,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20800.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20800.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20800";

cljs.core.async.t_cljs$core$async20800.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20800");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async20800 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20800(f__$1,ch__$1,meta20798__$1,___$2,fn1__$1,meta20801){
return (new cljs.core.async.t_cljs$core$async20800(f__$1,ch__$1,meta20798__$1,___$2,fn1__$1,meta20801));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async20800(self__.f,self__.ch,self__.meta20798,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6531__auto__ = ret;
if(cljs.core.truth_(and__6531__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20797.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async20797.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20798","meta20798",-1425865954,null)], null);
});

cljs.core.async.t_cljs$core$async20797.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20797.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20797";

cljs.core.async.t_cljs$core$async20797.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20797");
});

cljs.core.async.__GT_t_cljs$core$async20797 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20797(f__$1,ch__$1,meta20798){
return (new cljs.core.async.t_cljs$core$async20797(f__$1,ch__$1,meta20798));
});

}

return (new cljs.core.async.t_cljs$core$async20797(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20806 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20806 = (function (f,ch,meta20807){
this.f = f;
this.ch = ch;
this.meta20807 = meta20807;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20808,meta20807__$1){
var self__ = this;
var _20808__$1 = this;
return (new cljs.core.async.t_cljs$core$async20806(self__.f,self__.ch,meta20807__$1));
});

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20808){
var self__ = this;
var _20808__$1 = this;
return self__.meta20807;
});

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async20806.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20807","meta20807",1150901440,null)], null);
});

cljs.core.async.t_cljs$core$async20806.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20806.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20806";

cljs.core.async.t_cljs$core$async20806.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20806");
});

cljs.core.async.__GT_t_cljs$core$async20806 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async20806(f__$1,ch__$1,meta20807){
return (new cljs.core.async.t_cljs$core$async20806(f__$1,ch__$1,meta20807));
});

}

return (new cljs.core.async.t_cljs$core$async20806(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async20812 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20812 = (function (p,ch,meta20813){
this.p = p;
this.ch = ch;
this.meta20813 = meta20813;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20814,meta20813__$1){
var self__ = this;
var _20814__$1 = this;
return (new cljs.core.async.t_cljs$core$async20812(self__.p,self__.ch,meta20813__$1));
});

cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20814){
var self__ = this;
var _20814__$1 = this;
return self__.meta20813;
});

cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20812.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async20812.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20813","meta20813",1284753248,null)], null);
});

cljs.core.async.t_cljs$core$async20812.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20812.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20812";

cljs.core.async.t_cljs$core$async20812.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20812");
});

cljs.core.async.__GT_t_cljs$core$async20812 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async20812(p__$1,ch__$1,meta20813){
return (new cljs.core.async.t_cljs$core$async20812(p__$1,ch__$1,meta20813));
});

}

return (new cljs.core.async.t_cljs$core$async20812(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args20815 = [];
var len__7651__auto___20859 = arguments.length;
var i__7652__auto___20860 = (0);
while(true){
if((i__7652__auto___20860 < len__7651__auto___20859)){
args20815.push((arguments[i__7652__auto___20860]));

var G__20861 = (i__7652__auto___20860 + (1));
i__7652__auto___20860 = G__20861;
continue;
} else {
}
break;
}

var G__20817 = args20815.length;
switch (G__20817) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20815.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18587__auto___20863 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___20863,out){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___20863,out){
return (function (state_20838){
var state_val_20839 = (state_20838[(1)]);
if((state_val_20839 === (7))){
var inst_20834 = (state_20838[(2)]);
var state_20838__$1 = state_20838;
var statearr_20840_20864 = state_20838__$1;
(statearr_20840_20864[(2)] = inst_20834);

(statearr_20840_20864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (1))){
var state_20838__$1 = state_20838;
var statearr_20841_20865 = state_20838__$1;
(statearr_20841_20865[(2)] = null);

(statearr_20841_20865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (4))){
var inst_20820 = (state_20838[(7)]);
var inst_20820__$1 = (state_20838[(2)]);
var inst_20821 = (inst_20820__$1 == null);
var state_20838__$1 = (function (){var statearr_20842 = state_20838;
(statearr_20842[(7)] = inst_20820__$1);

return statearr_20842;
})();
if(cljs.core.truth_(inst_20821)){
var statearr_20843_20866 = state_20838__$1;
(statearr_20843_20866[(1)] = (5));

} else {
var statearr_20844_20867 = state_20838__$1;
(statearr_20844_20867[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (6))){
var inst_20820 = (state_20838[(7)]);
var inst_20825 = p.call(null,inst_20820);
var state_20838__$1 = state_20838;
if(cljs.core.truth_(inst_20825)){
var statearr_20845_20868 = state_20838__$1;
(statearr_20845_20868[(1)] = (8));

} else {
var statearr_20846_20869 = state_20838__$1;
(statearr_20846_20869[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (3))){
var inst_20836 = (state_20838[(2)]);
var state_20838__$1 = state_20838;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20838__$1,inst_20836);
} else {
if((state_val_20839 === (2))){
var state_20838__$1 = state_20838;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20838__$1,(4),ch);
} else {
if((state_val_20839 === (11))){
var inst_20828 = (state_20838[(2)]);
var state_20838__$1 = state_20838;
var statearr_20847_20870 = state_20838__$1;
(statearr_20847_20870[(2)] = inst_20828);

(statearr_20847_20870[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (9))){
var state_20838__$1 = state_20838;
var statearr_20848_20871 = state_20838__$1;
(statearr_20848_20871[(2)] = null);

(statearr_20848_20871[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (5))){
var inst_20823 = cljs.core.async.close_BANG_.call(null,out);
var state_20838__$1 = state_20838;
var statearr_20849_20872 = state_20838__$1;
(statearr_20849_20872[(2)] = inst_20823);

(statearr_20849_20872[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (10))){
var inst_20831 = (state_20838[(2)]);
var state_20838__$1 = (function (){var statearr_20850 = state_20838;
(statearr_20850[(8)] = inst_20831);

return statearr_20850;
})();
var statearr_20851_20873 = state_20838__$1;
(statearr_20851_20873[(2)] = null);

(statearr_20851_20873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (8))){
var inst_20820 = (state_20838[(7)]);
var state_20838__$1 = state_20838;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20838__$1,(11),out,inst_20820);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___20863,out))
;
return ((function (switch__18475__auto__,c__18587__auto___20863,out){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_20855 = [null,null,null,null,null,null,null,null,null];
(statearr_20855[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_20855[(1)] = (1));

return statearr_20855;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_20838){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_20838);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e20856){if((e20856 instanceof Object)){
var ex__18479__auto__ = e20856;
var statearr_20857_20874 = state_20838;
(statearr_20857_20874[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20838);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20856;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20875 = state_20838;
state_20838 = G__20875;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_20838){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_20838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___20863,out))
})();
var state__18589__auto__ = (function (){var statearr_20858 = f__18588__auto__.call(null);
(statearr_20858[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___20863);

return statearr_20858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___20863,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args20876 = [];
var len__7651__auto___20879 = arguments.length;
var i__7652__auto___20880 = (0);
while(true){
if((i__7652__auto___20880 < len__7651__auto___20879)){
args20876.push((arguments[i__7652__auto___20880]));

var G__20881 = (i__7652__auto___20880 + (1));
i__7652__auto___20880 = G__20881;
continue;
} else {
}
break;
}

var G__20878 = args20876.length;
switch (G__20878) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20876.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__18587__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto__){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto__){
return (function (state_21048){
var state_val_21049 = (state_21048[(1)]);
if((state_val_21049 === (7))){
var inst_21044 = (state_21048[(2)]);
var state_21048__$1 = state_21048;
var statearr_21050_21091 = state_21048__$1;
(statearr_21050_21091[(2)] = inst_21044);

(statearr_21050_21091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (20))){
var inst_21014 = (state_21048[(7)]);
var inst_21025 = (state_21048[(2)]);
var inst_21026 = cljs.core.next.call(null,inst_21014);
var inst_21000 = inst_21026;
var inst_21001 = null;
var inst_21002 = (0);
var inst_21003 = (0);
var state_21048__$1 = (function (){var statearr_21051 = state_21048;
(statearr_21051[(8)] = inst_21002);

(statearr_21051[(9)] = inst_21001);

(statearr_21051[(10)] = inst_21003);

(statearr_21051[(11)] = inst_21025);

(statearr_21051[(12)] = inst_21000);

return statearr_21051;
})();
var statearr_21052_21092 = state_21048__$1;
(statearr_21052_21092[(2)] = null);

(statearr_21052_21092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (1))){
var state_21048__$1 = state_21048;
var statearr_21053_21093 = state_21048__$1;
(statearr_21053_21093[(2)] = null);

(statearr_21053_21093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (4))){
var inst_20989 = (state_21048[(13)]);
var inst_20989__$1 = (state_21048[(2)]);
var inst_20990 = (inst_20989__$1 == null);
var state_21048__$1 = (function (){var statearr_21054 = state_21048;
(statearr_21054[(13)] = inst_20989__$1);

return statearr_21054;
})();
if(cljs.core.truth_(inst_20990)){
var statearr_21055_21094 = state_21048__$1;
(statearr_21055_21094[(1)] = (5));

} else {
var statearr_21056_21095 = state_21048__$1;
(statearr_21056_21095[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (15))){
var state_21048__$1 = state_21048;
var statearr_21060_21096 = state_21048__$1;
(statearr_21060_21096[(2)] = null);

(statearr_21060_21096[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (21))){
var state_21048__$1 = state_21048;
var statearr_21061_21097 = state_21048__$1;
(statearr_21061_21097[(2)] = null);

(statearr_21061_21097[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (13))){
var inst_21002 = (state_21048[(8)]);
var inst_21001 = (state_21048[(9)]);
var inst_21003 = (state_21048[(10)]);
var inst_21000 = (state_21048[(12)]);
var inst_21010 = (state_21048[(2)]);
var inst_21011 = (inst_21003 + (1));
var tmp21057 = inst_21002;
var tmp21058 = inst_21001;
var tmp21059 = inst_21000;
var inst_21000__$1 = tmp21059;
var inst_21001__$1 = tmp21058;
var inst_21002__$1 = tmp21057;
var inst_21003__$1 = inst_21011;
var state_21048__$1 = (function (){var statearr_21062 = state_21048;
(statearr_21062[(8)] = inst_21002__$1);

(statearr_21062[(9)] = inst_21001__$1);

(statearr_21062[(10)] = inst_21003__$1);

(statearr_21062[(14)] = inst_21010);

(statearr_21062[(12)] = inst_21000__$1);

return statearr_21062;
})();
var statearr_21063_21098 = state_21048__$1;
(statearr_21063_21098[(2)] = null);

(statearr_21063_21098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (22))){
var state_21048__$1 = state_21048;
var statearr_21064_21099 = state_21048__$1;
(statearr_21064_21099[(2)] = null);

(statearr_21064_21099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (6))){
var inst_20989 = (state_21048[(13)]);
var inst_20998 = f.call(null,inst_20989);
var inst_20999 = cljs.core.seq.call(null,inst_20998);
var inst_21000 = inst_20999;
var inst_21001 = null;
var inst_21002 = (0);
var inst_21003 = (0);
var state_21048__$1 = (function (){var statearr_21065 = state_21048;
(statearr_21065[(8)] = inst_21002);

(statearr_21065[(9)] = inst_21001);

(statearr_21065[(10)] = inst_21003);

(statearr_21065[(12)] = inst_21000);

return statearr_21065;
})();
var statearr_21066_21100 = state_21048__$1;
(statearr_21066_21100[(2)] = null);

(statearr_21066_21100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (17))){
var inst_21014 = (state_21048[(7)]);
var inst_21018 = cljs.core.chunk_first.call(null,inst_21014);
var inst_21019 = cljs.core.chunk_rest.call(null,inst_21014);
var inst_21020 = cljs.core.count.call(null,inst_21018);
var inst_21000 = inst_21019;
var inst_21001 = inst_21018;
var inst_21002 = inst_21020;
var inst_21003 = (0);
var state_21048__$1 = (function (){var statearr_21067 = state_21048;
(statearr_21067[(8)] = inst_21002);

(statearr_21067[(9)] = inst_21001);

(statearr_21067[(10)] = inst_21003);

(statearr_21067[(12)] = inst_21000);

return statearr_21067;
})();
var statearr_21068_21101 = state_21048__$1;
(statearr_21068_21101[(2)] = null);

(statearr_21068_21101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (3))){
var inst_21046 = (state_21048[(2)]);
var state_21048__$1 = state_21048;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21048__$1,inst_21046);
} else {
if((state_val_21049 === (12))){
var inst_21034 = (state_21048[(2)]);
var state_21048__$1 = state_21048;
var statearr_21069_21102 = state_21048__$1;
(statearr_21069_21102[(2)] = inst_21034);

(statearr_21069_21102[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (2))){
var state_21048__$1 = state_21048;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21048__$1,(4),in$);
} else {
if((state_val_21049 === (23))){
var inst_21042 = (state_21048[(2)]);
var state_21048__$1 = state_21048;
var statearr_21070_21103 = state_21048__$1;
(statearr_21070_21103[(2)] = inst_21042);

(statearr_21070_21103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (19))){
var inst_21029 = (state_21048[(2)]);
var state_21048__$1 = state_21048;
var statearr_21071_21104 = state_21048__$1;
(statearr_21071_21104[(2)] = inst_21029);

(statearr_21071_21104[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (11))){
var inst_21000 = (state_21048[(12)]);
var inst_21014 = (state_21048[(7)]);
var inst_21014__$1 = cljs.core.seq.call(null,inst_21000);
var state_21048__$1 = (function (){var statearr_21072 = state_21048;
(statearr_21072[(7)] = inst_21014__$1);

return statearr_21072;
})();
if(inst_21014__$1){
var statearr_21073_21105 = state_21048__$1;
(statearr_21073_21105[(1)] = (14));

} else {
var statearr_21074_21106 = state_21048__$1;
(statearr_21074_21106[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (9))){
var inst_21036 = (state_21048[(2)]);
var inst_21037 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21048__$1 = (function (){var statearr_21075 = state_21048;
(statearr_21075[(15)] = inst_21036);

return statearr_21075;
})();
if(cljs.core.truth_(inst_21037)){
var statearr_21076_21107 = state_21048__$1;
(statearr_21076_21107[(1)] = (21));

} else {
var statearr_21077_21108 = state_21048__$1;
(statearr_21077_21108[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (5))){
var inst_20992 = cljs.core.async.close_BANG_.call(null,out);
var state_21048__$1 = state_21048;
var statearr_21078_21109 = state_21048__$1;
(statearr_21078_21109[(2)] = inst_20992);

(statearr_21078_21109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (14))){
var inst_21014 = (state_21048[(7)]);
var inst_21016 = cljs.core.chunked_seq_QMARK_.call(null,inst_21014);
var state_21048__$1 = state_21048;
if(inst_21016){
var statearr_21079_21110 = state_21048__$1;
(statearr_21079_21110[(1)] = (17));

} else {
var statearr_21080_21111 = state_21048__$1;
(statearr_21080_21111[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (16))){
var inst_21032 = (state_21048[(2)]);
var state_21048__$1 = state_21048;
var statearr_21081_21112 = state_21048__$1;
(statearr_21081_21112[(2)] = inst_21032);

(statearr_21081_21112[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21049 === (10))){
var inst_21001 = (state_21048[(9)]);
var inst_21003 = (state_21048[(10)]);
var inst_21008 = cljs.core._nth.call(null,inst_21001,inst_21003);
var state_21048__$1 = state_21048;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21048__$1,(13),out,inst_21008);
} else {
if((state_val_21049 === (18))){
var inst_21014 = (state_21048[(7)]);
var inst_21023 = cljs.core.first.call(null,inst_21014);
var state_21048__$1 = state_21048;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21048__$1,(20),out,inst_21023);
} else {
if((state_val_21049 === (8))){
var inst_21002 = (state_21048[(8)]);
var inst_21003 = (state_21048[(10)]);
var inst_21005 = (inst_21003 < inst_21002);
var inst_21006 = inst_21005;
var state_21048__$1 = state_21048;
if(cljs.core.truth_(inst_21006)){
var statearr_21082_21113 = state_21048__$1;
(statearr_21082_21113[(1)] = (10));

} else {
var statearr_21083_21114 = state_21048__$1;
(statearr_21083_21114[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto__))
;
return ((function (switch__18475__auto__,c__18587__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__18476__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__18476__auto____0 = (function (){
var statearr_21087 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21087[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__18476__auto__);

(statearr_21087[(1)] = (1));

return statearr_21087;
});
var cljs$core$async$mapcat_STAR__$_state_machine__18476__auto____1 = (function (state_21048){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_21048);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e21088){if((e21088 instanceof Object)){
var ex__18479__auto__ = e21088;
var statearr_21089_21115 = state_21048;
(statearr_21089_21115[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21048);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21088;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21116 = state_21048;
state_21048 = G__21116;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__18476__auto__ = function(state_21048){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__18476__auto____1.call(this,state_21048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__18476__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__18476__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto__))
})();
var state__18589__auto__ = (function (){var statearr_21090 = f__18588__auto__.call(null);
(statearr_21090[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto__);

return statearr_21090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto__))
);

return c__18587__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21117 = [];
var len__7651__auto___21120 = arguments.length;
var i__7652__auto___21121 = (0);
while(true){
if((i__7652__auto___21121 < len__7651__auto___21120)){
args21117.push((arguments[i__7652__auto___21121]));

var G__21122 = (i__7652__auto___21121 + (1));
i__7652__auto___21121 = G__21122;
continue;
} else {
}
break;
}

var G__21119 = args21117.length;
switch (G__21119) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21117.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21124 = [];
var len__7651__auto___21127 = arguments.length;
var i__7652__auto___21128 = (0);
while(true){
if((i__7652__auto___21128 < len__7651__auto___21127)){
args21124.push((arguments[i__7652__auto___21128]));

var G__21129 = (i__7652__auto___21128 + (1));
i__7652__auto___21128 = G__21129;
continue;
} else {
}
break;
}

var G__21126 = args21124.length;
switch (G__21126) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21124.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21131 = [];
var len__7651__auto___21182 = arguments.length;
var i__7652__auto___21183 = (0);
while(true){
if((i__7652__auto___21183 < len__7651__auto___21182)){
args21131.push((arguments[i__7652__auto___21183]));

var G__21184 = (i__7652__auto___21183 + (1));
i__7652__auto___21183 = G__21184;
continue;
} else {
}
break;
}

var G__21133 = args21131.length;
switch (G__21133) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21131.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18587__auto___21186 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___21186,out){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___21186,out){
return (function (state_21157){
var state_val_21158 = (state_21157[(1)]);
if((state_val_21158 === (7))){
var inst_21152 = (state_21157[(2)]);
var state_21157__$1 = state_21157;
var statearr_21159_21187 = state_21157__$1;
(statearr_21159_21187[(2)] = inst_21152);

(statearr_21159_21187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21158 === (1))){
var inst_21134 = null;
var state_21157__$1 = (function (){var statearr_21160 = state_21157;
(statearr_21160[(7)] = inst_21134);

return statearr_21160;
})();
var statearr_21161_21188 = state_21157__$1;
(statearr_21161_21188[(2)] = null);

(statearr_21161_21188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21158 === (4))){
var inst_21137 = (state_21157[(8)]);
var inst_21137__$1 = (state_21157[(2)]);
var inst_21138 = (inst_21137__$1 == null);
var inst_21139 = cljs.core.not.call(null,inst_21138);
var state_21157__$1 = (function (){var statearr_21162 = state_21157;
(statearr_21162[(8)] = inst_21137__$1);

return statearr_21162;
})();
if(inst_21139){
var statearr_21163_21189 = state_21157__$1;
(statearr_21163_21189[(1)] = (5));

} else {
var statearr_21164_21190 = state_21157__$1;
(statearr_21164_21190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21158 === (6))){
var state_21157__$1 = state_21157;
var statearr_21165_21191 = state_21157__$1;
(statearr_21165_21191[(2)] = null);

(statearr_21165_21191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21158 === (3))){
var inst_21154 = (state_21157[(2)]);
var inst_21155 = cljs.core.async.close_BANG_.call(null,out);
var state_21157__$1 = (function (){var statearr_21166 = state_21157;
(statearr_21166[(9)] = inst_21154);

return statearr_21166;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21157__$1,inst_21155);
} else {
if((state_val_21158 === (2))){
var state_21157__$1 = state_21157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21157__$1,(4),ch);
} else {
if((state_val_21158 === (11))){
var inst_21137 = (state_21157[(8)]);
var inst_21146 = (state_21157[(2)]);
var inst_21134 = inst_21137;
var state_21157__$1 = (function (){var statearr_21167 = state_21157;
(statearr_21167[(10)] = inst_21146);

(statearr_21167[(7)] = inst_21134);

return statearr_21167;
})();
var statearr_21168_21192 = state_21157__$1;
(statearr_21168_21192[(2)] = null);

(statearr_21168_21192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21158 === (9))){
var inst_21137 = (state_21157[(8)]);
var state_21157__$1 = state_21157;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21157__$1,(11),out,inst_21137);
} else {
if((state_val_21158 === (5))){
var inst_21134 = (state_21157[(7)]);
var inst_21137 = (state_21157[(8)]);
var inst_21141 = cljs.core._EQ_.call(null,inst_21137,inst_21134);
var state_21157__$1 = state_21157;
if(inst_21141){
var statearr_21170_21193 = state_21157__$1;
(statearr_21170_21193[(1)] = (8));

} else {
var statearr_21171_21194 = state_21157__$1;
(statearr_21171_21194[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21158 === (10))){
var inst_21149 = (state_21157[(2)]);
var state_21157__$1 = state_21157;
var statearr_21172_21195 = state_21157__$1;
(statearr_21172_21195[(2)] = inst_21149);

(statearr_21172_21195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21158 === (8))){
var inst_21134 = (state_21157[(7)]);
var tmp21169 = inst_21134;
var inst_21134__$1 = tmp21169;
var state_21157__$1 = (function (){var statearr_21173 = state_21157;
(statearr_21173[(7)] = inst_21134__$1);

return statearr_21173;
})();
var statearr_21174_21196 = state_21157__$1;
(statearr_21174_21196[(2)] = null);

(statearr_21174_21196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___21186,out))
;
return ((function (switch__18475__auto__,c__18587__auto___21186,out){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_21178 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21178[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_21178[(1)] = (1));

return statearr_21178;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_21157){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_21157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e21179){if((e21179 instanceof Object)){
var ex__18479__auto__ = e21179;
var statearr_21180_21197 = state_21157;
(statearr_21180_21197[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21179;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21198 = state_21157;
state_21157 = G__21198;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_21157){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_21157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___21186,out))
})();
var state__18589__auto__ = (function (){var statearr_21181 = f__18588__auto__.call(null);
(statearr_21181[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___21186);

return statearr_21181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___21186,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21199 = [];
var len__7651__auto___21269 = arguments.length;
var i__7652__auto___21270 = (0);
while(true){
if((i__7652__auto___21270 < len__7651__auto___21269)){
args21199.push((arguments[i__7652__auto___21270]));

var G__21271 = (i__7652__auto___21270 + (1));
i__7652__auto___21270 = G__21271;
continue;
} else {
}
break;
}

var G__21201 = args21199.length;
switch (G__21201) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21199.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18587__auto___21273 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___21273,out){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___21273,out){
return (function (state_21239){
var state_val_21240 = (state_21239[(1)]);
if((state_val_21240 === (7))){
var inst_21235 = (state_21239[(2)]);
var state_21239__$1 = state_21239;
var statearr_21241_21274 = state_21239__$1;
(statearr_21241_21274[(2)] = inst_21235);

(statearr_21241_21274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (1))){
var inst_21202 = (new Array(n));
var inst_21203 = inst_21202;
var inst_21204 = (0);
var state_21239__$1 = (function (){var statearr_21242 = state_21239;
(statearr_21242[(7)] = inst_21203);

(statearr_21242[(8)] = inst_21204);

return statearr_21242;
})();
var statearr_21243_21275 = state_21239__$1;
(statearr_21243_21275[(2)] = null);

(statearr_21243_21275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (4))){
var inst_21207 = (state_21239[(9)]);
var inst_21207__$1 = (state_21239[(2)]);
var inst_21208 = (inst_21207__$1 == null);
var inst_21209 = cljs.core.not.call(null,inst_21208);
var state_21239__$1 = (function (){var statearr_21244 = state_21239;
(statearr_21244[(9)] = inst_21207__$1);

return statearr_21244;
})();
if(inst_21209){
var statearr_21245_21276 = state_21239__$1;
(statearr_21245_21276[(1)] = (5));

} else {
var statearr_21246_21277 = state_21239__$1;
(statearr_21246_21277[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (15))){
var inst_21229 = (state_21239[(2)]);
var state_21239__$1 = state_21239;
var statearr_21247_21278 = state_21239__$1;
(statearr_21247_21278[(2)] = inst_21229);

(statearr_21247_21278[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (13))){
var state_21239__$1 = state_21239;
var statearr_21248_21279 = state_21239__$1;
(statearr_21248_21279[(2)] = null);

(statearr_21248_21279[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (6))){
var inst_21204 = (state_21239[(8)]);
var inst_21225 = (inst_21204 > (0));
var state_21239__$1 = state_21239;
if(cljs.core.truth_(inst_21225)){
var statearr_21249_21280 = state_21239__$1;
(statearr_21249_21280[(1)] = (12));

} else {
var statearr_21250_21281 = state_21239__$1;
(statearr_21250_21281[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (3))){
var inst_21237 = (state_21239[(2)]);
var state_21239__$1 = state_21239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21239__$1,inst_21237);
} else {
if((state_val_21240 === (12))){
var inst_21203 = (state_21239[(7)]);
var inst_21227 = cljs.core.vec.call(null,inst_21203);
var state_21239__$1 = state_21239;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21239__$1,(15),out,inst_21227);
} else {
if((state_val_21240 === (2))){
var state_21239__$1 = state_21239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21239__$1,(4),ch);
} else {
if((state_val_21240 === (11))){
var inst_21219 = (state_21239[(2)]);
var inst_21220 = (new Array(n));
var inst_21203 = inst_21220;
var inst_21204 = (0);
var state_21239__$1 = (function (){var statearr_21251 = state_21239;
(statearr_21251[(7)] = inst_21203);

(statearr_21251[(8)] = inst_21204);

(statearr_21251[(10)] = inst_21219);

return statearr_21251;
})();
var statearr_21252_21282 = state_21239__$1;
(statearr_21252_21282[(2)] = null);

(statearr_21252_21282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (9))){
var inst_21203 = (state_21239[(7)]);
var inst_21217 = cljs.core.vec.call(null,inst_21203);
var state_21239__$1 = state_21239;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21239__$1,(11),out,inst_21217);
} else {
if((state_val_21240 === (5))){
var inst_21203 = (state_21239[(7)]);
var inst_21207 = (state_21239[(9)]);
var inst_21212 = (state_21239[(11)]);
var inst_21204 = (state_21239[(8)]);
var inst_21211 = (inst_21203[inst_21204] = inst_21207);
var inst_21212__$1 = (inst_21204 + (1));
var inst_21213 = (inst_21212__$1 < n);
var state_21239__$1 = (function (){var statearr_21253 = state_21239;
(statearr_21253[(12)] = inst_21211);

(statearr_21253[(11)] = inst_21212__$1);

return statearr_21253;
})();
if(cljs.core.truth_(inst_21213)){
var statearr_21254_21283 = state_21239__$1;
(statearr_21254_21283[(1)] = (8));

} else {
var statearr_21255_21284 = state_21239__$1;
(statearr_21255_21284[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (14))){
var inst_21232 = (state_21239[(2)]);
var inst_21233 = cljs.core.async.close_BANG_.call(null,out);
var state_21239__$1 = (function (){var statearr_21257 = state_21239;
(statearr_21257[(13)] = inst_21232);

return statearr_21257;
})();
var statearr_21258_21285 = state_21239__$1;
(statearr_21258_21285[(2)] = inst_21233);

(statearr_21258_21285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (10))){
var inst_21223 = (state_21239[(2)]);
var state_21239__$1 = state_21239;
var statearr_21259_21286 = state_21239__$1;
(statearr_21259_21286[(2)] = inst_21223);

(statearr_21259_21286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21240 === (8))){
var inst_21203 = (state_21239[(7)]);
var inst_21212 = (state_21239[(11)]);
var tmp21256 = inst_21203;
var inst_21203__$1 = tmp21256;
var inst_21204 = inst_21212;
var state_21239__$1 = (function (){var statearr_21260 = state_21239;
(statearr_21260[(7)] = inst_21203__$1);

(statearr_21260[(8)] = inst_21204);

return statearr_21260;
})();
var statearr_21261_21287 = state_21239__$1;
(statearr_21261_21287[(2)] = null);

(statearr_21261_21287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___21273,out))
;
return ((function (switch__18475__auto__,c__18587__auto___21273,out){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_21265 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21265[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_21265[(1)] = (1));

return statearr_21265;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_21239){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_21239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e21266){if((e21266 instanceof Object)){
var ex__18479__auto__ = e21266;
var statearr_21267_21288 = state_21239;
(statearr_21267_21288[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21239);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21266;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21289 = state_21239;
state_21239 = G__21289;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_21239){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_21239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___21273,out))
})();
var state__18589__auto__ = (function (){var statearr_21268 = f__18588__auto__.call(null);
(statearr_21268[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___21273);

return statearr_21268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___21273,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21290 = [];
var len__7651__auto___21364 = arguments.length;
var i__7652__auto___21365 = (0);
while(true){
if((i__7652__auto___21365 < len__7651__auto___21364)){
args21290.push((arguments[i__7652__auto___21365]));

var G__21366 = (i__7652__auto___21365 + (1));
i__7652__auto___21365 = G__21366;
continue;
} else {
}
break;
}

var G__21292 = args21290.length;
switch (G__21292) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21290.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18587__auto___21368 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18587__auto___21368,out){
return (function (){
var f__18588__auto__ = (function (){var switch__18475__auto__ = ((function (c__18587__auto___21368,out){
return (function (state_21334){
var state_val_21335 = (state_21334[(1)]);
if((state_val_21335 === (7))){
var inst_21330 = (state_21334[(2)]);
var state_21334__$1 = state_21334;
var statearr_21336_21369 = state_21334__$1;
(statearr_21336_21369[(2)] = inst_21330);

(statearr_21336_21369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (1))){
var inst_21293 = [];
var inst_21294 = inst_21293;
var inst_21295 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21334__$1 = (function (){var statearr_21337 = state_21334;
(statearr_21337[(7)] = inst_21295);

(statearr_21337[(8)] = inst_21294);

return statearr_21337;
})();
var statearr_21338_21370 = state_21334__$1;
(statearr_21338_21370[(2)] = null);

(statearr_21338_21370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (4))){
var inst_21298 = (state_21334[(9)]);
var inst_21298__$1 = (state_21334[(2)]);
var inst_21299 = (inst_21298__$1 == null);
var inst_21300 = cljs.core.not.call(null,inst_21299);
var state_21334__$1 = (function (){var statearr_21339 = state_21334;
(statearr_21339[(9)] = inst_21298__$1);

return statearr_21339;
})();
if(inst_21300){
var statearr_21340_21371 = state_21334__$1;
(statearr_21340_21371[(1)] = (5));

} else {
var statearr_21341_21372 = state_21334__$1;
(statearr_21341_21372[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (15))){
var inst_21324 = (state_21334[(2)]);
var state_21334__$1 = state_21334;
var statearr_21342_21373 = state_21334__$1;
(statearr_21342_21373[(2)] = inst_21324);

(statearr_21342_21373[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (13))){
var state_21334__$1 = state_21334;
var statearr_21343_21374 = state_21334__$1;
(statearr_21343_21374[(2)] = null);

(statearr_21343_21374[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (6))){
var inst_21294 = (state_21334[(8)]);
var inst_21319 = inst_21294.length;
var inst_21320 = (inst_21319 > (0));
var state_21334__$1 = state_21334;
if(cljs.core.truth_(inst_21320)){
var statearr_21344_21375 = state_21334__$1;
(statearr_21344_21375[(1)] = (12));

} else {
var statearr_21345_21376 = state_21334__$1;
(statearr_21345_21376[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (3))){
var inst_21332 = (state_21334[(2)]);
var state_21334__$1 = state_21334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21334__$1,inst_21332);
} else {
if((state_val_21335 === (12))){
var inst_21294 = (state_21334[(8)]);
var inst_21322 = cljs.core.vec.call(null,inst_21294);
var state_21334__$1 = state_21334;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21334__$1,(15),out,inst_21322);
} else {
if((state_val_21335 === (2))){
var state_21334__$1 = state_21334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21334__$1,(4),ch);
} else {
if((state_val_21335 === (11))){
var inst_21302 = (state_21334[(10)]);
var inst_21298 = (state_21334[(9)]);
var inst_21312 = (state_21334[(2)]);
var inst_21313 = [];
var inst_21314 = inst_21313.push(inst_21298);
var inst_21294 = inst_21313;
var inst_21295 = inst_21302;
var state_21334__$1 = (function (){var statearr_21346 = state_21334;
(statearr_21346[(11)] = inst_21314);

(statearr_21346[(7)] = inst_21295);

(statearr_21346[(12)] = inst_21312);

(statearr_21346[(8)] = inst_21294);

return statearr_21346;
})();
var statearr_21347_21377 = state_21334__$1;
(statearr_21347_21377[(2)] = null);

(statearr_21347_21377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (9))){
var inst_21294 = (state_21334[(8)]);
var inst_21310 = cljs.core.vec.call(null,inst_21294);
var state_21334__$1 = state_21334;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21334__$1,(11),out,inst_21310);
} else {
if((state_val_21335 === (5))){
var inst_21302 = (state_21334[(10)]);
var inst_21295 = (state_21334[(7)]);
var inst_21298 = (state_21334[(9)]);
var inst_21302__$1 = f.call(null,inst_21298);
var inst_21303 = cljs.core._EQ_.call(null,inst_21302__$1,inst_21295);
var inst_21304 = cljs.core.keyword_identical_QMARK_.call(null,inst_21295,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21305 = (inst_21303) || (inst_21304);
var state_21334__$1 = (function (){var statearr_21348 = state_21334;
(statearr_21348[(10)] = inst_21302__$1);

return statearr_21348;
})();
if(cljs.core.truth_(inst_21305)){
var statearr_21349_21378 = state_21334__$1;
(statearr_21349_21378[(1)] = (8));

} else {
var statearr_21350_21379 = state_21334__$1;
(statearr_21350_21379[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (14))){
var inst_21327 = (state_21334[(2)]);
var inst_21328 = cljs.core.async.close_BANG_.call(null,out);
var state_21334__$1 = (function (){var statearr_21352 = state_21334;
(statearr_21352[(13)] = inst_21327);

return statearr_21352;
})();
var statearr_21353_21380 = state_21334__$1;
(statearr_21353_21380[(2)] = inst_21328);

(statearr_21353_21380[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (10))){
var inst_21317 = (state_21334[(2)]);
var state_21334__$1 = state_21334;
var statearr_21354_21381 = state_21334__$1;
(statearr_21354_21381[(2)] = inst_21317);

(statearr_21354_21381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21335 === (8))){
var inst_21302 = (state_21334[(10)]);
var inst_21298 = (state_21334[(9)]);
var inst_21294 = (state_21334[(8)]);
var inst_21307 = inst_21294.push(inst_21298);
var tmp21351 = inst_21294;
var inst_21294__$1 = tmp21351;
var inst_21295 = inst_21302;
var state_21334__$1 = (function (){var statearr_21355 = state_21334;
(statearr_21355[(14)] = inst_21307);

(statearr_21355[(7)] = inst_21295);

(statearr_21355[(8)] = inst_21294__$1);

return statearr_21355;
})();
var statearr_21356_21382 = state_21334__$1;
(statearr_21356_21382[(2)] = null);

(statearr_21356_21382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18587__auto___21368,out))
;
return ((function (switch__18475__auto__,c__18587__auto___21368,out){
return (function() {
var cljs$core$async$state_machine__18476__auto__ = null;
var cljs$core$async$state_machine__18476__auto____0 = (function (){
var statearr_21360 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21360[(0)] = cljs$core$async$state_machine__18476__auto__);

(statearr_21360[(1)] = (1));

return statearr_21360;
});
var cljs$core$async$state_machine__18476__auto____1 = (function (state_21334){
while(true){
var ret_value__18477__auto__ = (function (){try{while(true){
var result__18478__auto__ = switch__18475__auto__.call(null,state_21334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18478__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18478__auto__;
}
break;
}
}catch (e21361){if((e21361 instanceof Object)){
var ex__18479__auto__ = e21361;
var statearr_21362_21383 = state_21334;
(statearr_21362_21383[(5)] = ex__18479__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21334);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21361;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21384 = state_21334;
state_21334 = G__21384;
continue;
} else {
return ret_value__18477__auto__;
}
break;
}
});
cljs$core$async$state_machine__18476__auto__ = function(state_21334){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18476__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18476__auto____1.call(this,state_21334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18476__auto____0;
cljs$core$async$state_machine__18476__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18476__auto____1;
return cljs$core$async$state_machine__18476__auto__;
})()
;})(switch__18475__auto__,c__18587__auto___21368,out))
})();
var state__18589__auto__ = (function (){var statearr_21363 = f__18588__auto__.call(null);
(statearr_21363[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18587__auto___21368);

return statearr_21363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18589__auto__);
});})(c__18587__auto___21368,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

