// Compiled by ClojureScript 1.9.293 {}
goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16662 = arguments.length;
var i__7652__auto___16663 = (0);
while(true){
if((i__7652__auto___16663 < len__7651__auto___16662)){
args__7658__auto__.push((arguments[i__7652__auto___16663]));

var G__16664 = (i__7652__auto___16663 + (1));
i__7652__auto___16663 = G__16664;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,cljs.core.vec.call(null,apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq16661){
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16661));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
return com.rpl.specter.compiled_select.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
return com.rpl.specter.compiled_select_one.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
return com.rpl.specter.compiled_select_one_BANG_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
return com.rpl.specter.compiled_select_first.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
return com.rpl.specter.compiled_select_any.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
return com.rpl.specter.compiled_selected_any_QMARK_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
return com.rpl.specter.compiled_traverse.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath),structure);
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
return com.rpl.specter.compiled_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure);
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal`. Error is thrown if navigation finishes
 * at a non-`terminal` navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
return com.rpl.specter.compiled_multi_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
return com.rpl.specter.compiled_setval.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),val,structure);
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16672 = arguments.length;
var i__7652__auto___16673 = (0);
while(true){
if((i__7652__auto___16673 < len__7651__auto___16672)){
args__7658__auto__.push((arguments[i__7652__auto___16673]));

var G__16674 = (i__7652__auto___16673 + (1));
i__7652__auto___16673 = G__16674;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__16669){
var map__16670 = p__16669;
var map__16670__$1 = ((((!((map__16670 == null)))?((((map__16670.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16670.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16670):map__16670);
var merge_fn = cljs.core.get.call(null,map__16670__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
return com.rpl.specter.compiled_replace_in.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),merge_fn);
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq16665){
var G__16666 = cljs.core.first.call(null,seq16665);
var seq16665__$1 = cljs.core.next.call(null,seq16665);
var G__16667 = cljs.core.first.call(null,seq16665__$1);
var seq16665__$2 = cljs.core.next.call(null,seq16665__$1);
var G__16668 = cljs.core.first.call(null,seq16665__$2);
var seq16665__$3 = cljs.core.next.call(null,seq16665__$2);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__16666,G__16667,G__16668,seq16665__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.call(null,(function (navfn){
var latenavfn = com.rpl.specter.late_resolved_fn.call(null,navfn);
return cljs.core.vary_meta.call(null,((function (latenavfn){
return (function() { 
var G__16675__delegate = function (args){
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,args))){
return latenavfn.call(null,cljs.core.first.call(null,args));
} else {
return cljs.core.map.call(null,latenavfn,args);
}
};
var G__16675 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16676__i = 0, G__16676__a = new Array(arguments.length -  0);
while (G__16676__i < G__16676__a.length) {G__16676__a[G__16676__i] = arguments[G__16676__i + 0]; ++G__16676__i;}
  args = new cljs.core.IndexedSeq(G__16676__a,0);
} 
return G__16675__delegate.call(this,args);};
G__16675.cljs$lang$maxFixedArity = 0;
G__16675.cljs$lang$applyTo = (function (arglist__16677){
var args = cljs.core.seq(arglist__16677);
return G__16675__delegate(args);
});
G__16675.cljs$core$IFn$_invoke$arity$variadic = G__16675__delegate;
return G__16675;
})()
;})(latenavfn))
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16678 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16678 = (function (meta16679){
this.meta16679 = meta16679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16680,meta16679__$1){
var self__ = this;
var _16680__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16678(meta16679__$1));
});

com.rpl.specter.t_com$rpl$specter16678.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16680){
var self__ = this;
var _16680__$1 = this;
return self__.meta16679;
});

com.rpl.specter.t_com$rpl$specter16678.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16678.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.NONE;
});

com.rpl.specter.t_com$rpl$specter16678.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter16678.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16679","meta16679",716422171,null)], null);
});

com.rpl.specter.t_com$rpl$specter16678.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16678.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16678";

com.rpl.specter.t_com$rpl$specter16678.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16678");
});

com.rpl.specter.__GT_t_com$rpl$specter16678 = (function com$rpl$specter$__GT_t_com$rpl$specter16678(meta16679){
return (new com.rpl.specter.t_com$rpl$specter16678(meta16679));
});

}

return (new com.rpl.specter.t_com$rpl$specter16678(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * For usage with `multi-transform`, defines an endpoint in the navigation
 *        that will have the parameterized transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter16681 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16681 = (function (afn,meta16682){
this.afn = afn;
this.meta16682 = meta16682;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16681.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16683,meta16682__$1){
var self__ = this;
var _16683__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16681(self__.afn,meta16682__$1));
});

com.rpl.specter.t_com$rpl$specter16681.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16683){
var self__ = this;
var _16683__$1 = this;
return self__.meta16682;
});

com.rpl.specter.t_com$rpl$specter16681.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16681.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"'terminal' should only be used in multi-transform")));
});

com.rpl.specter.t_com$rpl$specter16681.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_.call(null,self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter16681.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta16682","meta16682",-1901360270,null)], null);
});

com.rpl.specter.t_com$rpl$specter16681.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16681.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16681";

com.rpl.specter.t_com$rpl$specter16681.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16681");
});

com.rpl.specter.__GT_t_com$rpl$specter16681 = (function com$rpl$specter$__GT_t_com$rpl$specter16681(afn__$1,meta16682){
return (new com.rpl.specter.t_com$rpl$specter16681(afn__$1,meta16682));
});

}

return (new com.rpl.specter.t_com$rpl$specter16681(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
return com.rpl.specter.terminal.call(null,com.rpl.specter.impl.fast_constantly.call(null,v));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16684 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16684 = (function (meta16685){
this.meta16685 = meta16685;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16684.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16686,meta16685__$1){
var self__ = this;
var _16686__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16684(meta16685__$1));
});

com.rpl.specter.t_com$rpl$specter16684.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16686){
var self__ = this;
var _16686__$1 = this;
return self__.meta16685;
});

com.rpl.specter.t_com$rpl$specter16684.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16684.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter16684.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter16684.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16685","meta16685",-615497030,null)], null);
});

com.rpl.specter.t_com$rpl$specter16684.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16684.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16684";

com.rpl.specter.t_com$rpl$specter16684.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16684");
});

com.rpl.specter.__GT_t_com$rpl$specter16684 = (function com$rpl$specter$__GT_t_com$rpl$specter16684(meta16685){
return (new com.rpl.specter.t_com$rpl$specter16684(meta16685));
});

}

return (new com.rpl.specter.t_com$rpl$specter16684(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__13661__auto__,v){
var ret__13662__auto__ = next_fn.call(null,v);
if((ret__13662__auto__ === com.rpl.specter.NONE)){
return curr__13661__auto__;
} else {
return ret__13662__auto__;
}
}),com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16687 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16687 = (function (meta16688){
this.meta16688 = meta16688;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16687.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16689,meta16688__$1){
var self__ = this;
var _16689__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16687(meta16688__$1));
});

com.rpl.specter.t_com$rpl$specter16687.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16689){
var self__ = this;
var _16689__$1 = this;
return self__.meta16688;
});

com.rpl.specter.t_com$rpl$specter16687.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16687.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__15409__auto____$1){
return (function (curr__13661__auto__,v){
var ret__13662__auto__ = next_fn.call(null,v);
if((ret__13662__auto__ === com.rpl.specter.NONE)){
return curr__13661__auto__;
} else {
return ret__13662__auto__;
}
});})(next_fn,this__15409__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16687.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter16687.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16688","meta16688",-1108060049,null)], null);
});

com.rpl.specter.t_com$rpl$specter16687.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16687.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16687";

com.rpl.specter.t_com$rpl$specter16687.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16687");
});

com.rpl.specter.__GT_t_com$rpl$specter16687 = (function com$rpl$specter$__GT_t_com$rpl$specter16687(meta16688){
return (new com.rpl.specter.t_com$rpl$specter16687(meta16688));
});

}

return (new com.rpl.specter.t_com$rpl$specter16687(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16690 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16690 = (function (meta16691){
this.meta16691 = meta16691;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16690.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16692,meta16691__$1){
var self__ = this;
var _16692__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16690(meta16691__$1));
});

com.rpl.specter.t_com$rpl$specter16690.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16692){
var self__ = this;
var _16692__$1 = this;
return self__.meta16691;
});

com.rpl.specter.t_com$rpl$specter16690.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16690.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16044__auto__,vals__16045__auto__,structure,next_fn__16046__auto__){
var self__ = this;
var this__16044__auto____$1 = this;
return next_fn__16046__auto__.call(null,cljs.core.conj.call(null,vals__16045__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter16690.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16044__auto__,vals__16045__auto__,structure,next_fn__16046__auto__){
var self__ = this;
var this__16044__auto____$1 = this;
return next_fn__16046__auto__.call(null,cljs.core.conj.call(null,vals__16045__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter16690.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16691","meta16691",1514389306,null)], null);
});

com.rpl.specter.t_com$rpl$specter16690.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16690.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16690";

com.rpl.specter.t_com$rpl$specter16690.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16690");
});

com.rpl.specter.__GT_t_com$rpl$specter16690 = (function com$rpl$specter$__GT_t_com$rpl$specter16690(meta16691){
return (new com.rpl.specter.t_com$rpl$specter16690(meta16691));
});

}

return (new com.rpl.specter.t_com$rpl$specter16690(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last);
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first);


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_fn,end_fn,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start_fn.call(null,structure),end_fn.call(null,structure),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_fn,end_fn,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start_fn.call(null,structure),end_fn.call(null,structure),next_fn);
});

/**
 * Uses start-fn and end-fn to determine the bounds of the subsequence
 *        to select when navigating. Each function takes in the structure as input.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start_fn,end_fn){
if(typeof com.rpl.specter.t_com$rpl$specter16693 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16693 = (function (start_fn,end_fn,meta16694){
this.start_fn = start_fn;
this.end_fn = end_fn;
this.meta16694 = meta16694;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16693.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16695,meta16694__$1){
var self__ = this;
var _16695__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16693(self__.start_fn,self__.end_fn,meta16694__$1));
});

com.rpl.specter.t_com$rpl$specter16693.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16695){
var self__ = this;
var _16695__$1 = this;
return self__.meta16694;
});

com.rpl.specter.t_com$rpl$specter16693.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16693.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start_fn.call(null,structure),self__.end_fn.call(null,structure),next_fn);
});

com.rpl.specter.t_com$rpl$specter16693.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start_fn.call(null,structure),self__.end_fn.call(null,structure),next_fn);
});

com.rpl.specter.t_com$rpl$specter16693.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-fn","start-fn",-1617360859,null),new cljs.core.Symbol(null,"end-fn","end-fn",1694587211,null),new cljs.core.Symbol(null,"meta16694","meta16694",1859235043,null)], null);
});

com.rpl.specter.t_com$rpl$specter16693.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16693.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16693";

com.rpl.specter.t_com$rpl$specter16693.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16693");
});

com.rpl.specter.__GT_t_com$rpl$specter16693 = (function com$rpl$specter$__GT_t_com$rpl$specter16693(start_fn__$1,end_fn__$1,meta16694){
return (new com.rpl.specter.t_com$rpl$specter16693(start_fn__$1,end_fn__$1,meta16694));
});

}

return (new com.rpl.specter.t_com$rpl$specter16693(start_fn,end_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn);
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter16696 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16696 = (function (start,end,meta16697){
this.start = start;
this.end = end;
this.meta16697 = meta16697;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16696.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16698,meta16697__$1){
var self__ = this;
var _16698__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16696(self__.start,self__.end,meta16697__$1));
});

com.rpl.specter.t_com$rpl$specter16696.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16698){
var self__ = this;
var _16698__$1 = this;
return self__.meta16697;
});

com.rpl.specter.t_com$rpl$specter16696.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16696.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter16696.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter16696.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta16697","meta16697",1053509191,null)], null);
});

com.rpl.specter.t_com$rpl$specter16696.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16696.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16696";

com.rpl.specter.t_com$rpl$specter16696.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16696");
});

com.rpl.specter.__GT_t_com$rpl$specter16696 = (function com$rpl$specter$__GT_t_com$rpl$specter16696(start__$1,end__$1,meta16697){
return (new com.rpl.specter.t_com$rpl$specter16696(start__$1,end__$1,meta16697));
});

}

return (new com.rpl.specter.t_com$rpl$specter16696(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__13661__auto__,p__16703){
var vec__16704 = p__16703;
var s = cljs.core.nth.call(null,vec__16704,(0),null);
var e = cljs.core.nth.call(null,vec__16704,(1),null);
var ret__13662__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__13662__auto__ === com.rpl.specter.NONE)){
return curr__13661__auto__;
} else {
return ret__13662__auto__;
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj.call(null,(function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter16707 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16707 = (function (pred,meta16708){
this.pred = pred;
this.meta16708 = meta16708;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16707.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16709,meta16708__$1){
var self__ = this;
var _16709__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16707(self__.pred,meta16708__$1));
});

com.rpl.specter.t_com$rpl$specter16707.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16709){
var self__ = this;
var _16709__$1 = this;
return self__.meta16708;
});

com.rpl.specter.t_com$rpl$specter16707.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16707.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__15409__auto____$1){
return (function (curr__13661__auto__,p__16710){
var vec__16711 = p__16710;
var s = cljs.core.nth.call(null,vec__16711,(0),null);
var e = cljs.core.nth.call(null,vec__16711,(1),null);
var ret__13662__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__13662__auto__ === com.rpl.specter.NONE)){
return curr__13661__auto__;
} else {
return ret__13662__auto__;
}
});})(next_fn,this__15409__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,self__.pred));
});

com.rpl.specter.t_com$rpl$specter16707.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter16707.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta16708","meta16708",-1110130615,null)], null);
});

com.rpl.specter.t_com$rpl$specter16707.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16707.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16707";

com.rpl.specter.t_com$rpl$specter16707.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16707");
});

com.rpl.specter.__GT_t_com$rpl$specter16707 = (function com$rpl$specter$__GT_t_com$rpl$specter16707(pred__$1,meta16708){
return (new com.rpl.specter.t_com$rpl$specter16707(pred__$1,meta16708));
});

}

return (new com.rpl.specter.t_com$rpl$specter16707(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16714 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16714 = (function (meta16715){
this.meta16715 = meta16715;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16714.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16716,meta16715__$1){
var self__ = this;
var _16716__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16714(meta16715__$1));
});

com.rpl.specter.t_com$rpl$specter16714.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16716){
var self__ = this;
var _16716__$1 = this;
return self__.meta16715;
});

com.rpl.specter.t_com$rpl$specter16714.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16714.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.t_com$rpl$specter16714.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
});

com.rpl.specter.t_com$rpl$specter16714.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16715","meta16715",1589230636,null)], null);
});

com.rpl.specter.t_com$rpl$specter16714.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16714.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16714";

com.rpl.specter.t_com$rpl$specter16714.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16714");
});

com.rpl.specter.__GT_t_com$rpl$specter16714 = (function com$rpl$specter$__GT_t_com$rpl$specter16714(meta16715){
return (new com.rpl.specter.t_com$rpl$specter16714(meta16715));
});

}

return (new com.rpl.specter.t_com$rpl$specter16714(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16717 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16717 = (function (meta16718){
this.meta16718 = meta16718;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16717.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16719,meta16718__$1){
var self__ = this;
var _16719__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16717(meta16718__$1));
});

com.rpl.specter.t_com$rpl$specter16717.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16719){
var self__ = this;
var _16719__$1 = this;
return self__.meta16718;
});

com.rpl.specter.t_com$rpl$specter16717.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16717.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.t_com$rpl$specter16717.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
});

com.rpl.specter.t_com$rpl$specter16717.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16718","meta16718",-54424553,null)], null);
});

com.rpl.specter.t_com$rpl$specter16717.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16717.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16717";

com.rpl.specter.t_com$rpl$specter16717.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16717");
});

com.rpl.specter.__GT_t_com$rpl$specter16717 = (function com$rpl$specter$__GT_t_com$rpl$specter16717(meta16718){
return (new com.rpl.specter.t_com$rpl$specter16717(meta16718));
});

}

return (new com.rpl.specter.t_com$rpl$specter16717(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
return next_fn.call(null,clojure.set.intersection.call(null,structure,aset));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.call(null,structure,aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj.call(null,(function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter16720 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16720 = (function (aset,meta16721){
this.aset = aset;
this.meta16721 = meta16721;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16720.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16722,meta16721__$1){
var self__ = this;
var _16722__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16720(self__.aset,meta16721__$1));
});

com.rpl.specter.t_com$rpl$specter16720.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16722){
var self__ = this;
var _16722__$1 = this;
return self__.meta16721;
});

com.rpl.specter.t_com$rpl$specter16720.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16720.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,clojure.set.intersection.call(null,structure,self__.aset));
});

com.rpl.specter.t_com$rpl$specter16720.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
var subset = clojure.set.intersection.call(null,structure,self__.aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter16720.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta16721","meta16721",-1831136573,null)], null);
});

com.rpl.specter.t_com$rpl$specter16720.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16720.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16720";

com.rpl.specter.t_com$rpl$specter16720.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16720");
});

com.rpl.specter.__GT_t_com$rpl$specter16720 = (function com$rpl$specter$__GT_t_com$rpl$specter16720(aset__$1,meta16721){
return (new com.rpl.specter.t_com$rpl$specter16720(aset__$1,meta16721));
});

}

return (new com.rpl.specter.t_com$rpl$specter16720(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
return next_fn.call(null,cljs.core.select_keys.call(null,structure,m_keys));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys.call(null,structure,m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,m_keys),newmap);
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj.call(null,(function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter16723 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16723 = (function (m_keys,meta16724){
this.m_keys = m_keys;
this.meta16724 = meta16724;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16723.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16725,meta16724__$1){
var self__ = this;
var _16725__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16723(self__.m_keys,meta16724__$1));
});

com.rpl.specter.t_com$rpl$specter16723.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16725){
var self__ = this;
var _16725__$1 = this;
return self__.meta16724;
});

com.rpl.specter.t_com$rpl$specter16723.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16723.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,cljs.core.select_keys.call(null,structure,self__.m_keys));
});

com.rpl.specter.t_com$rpl$specter16723.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
var submap = cljs.core.select_keys.call(null,structure,self__.m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,self__.m_keys),newmap);
});

com.rpl.specter.t_com$rpl$specter16723.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta16724","meta16724",-1397282417,null)], null);
});

com.rpl.specter.t_com$rpl$specter16723.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16723.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16723";

com.rpl.specter.t_com$rpl$specter16723.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16723");
});

com.rpl.specter.__GT_t_com$rpl$specter16723 = (function com$rpl$specter$__GT_t_com$rpl$specter16723(m_keys__$1,meta16724){
return (new com.rpl.specter.t_com$rpl$specter16723(m_keys__$1,meta16724));
});

}

return (new com.rpl.specter.t_com$rpl$specter16723(m_keys,null));
}));


com.rpl.specter.walker_select_STAR_ = (function com$rpl$specter$walker_select_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_select.call(null,afn,next_fn,structure);
});

com.rpl.specter.walker_transform_STAR_ = (function com$rpl$specter$walker_transform_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_until.call(null,afn,next_fn,structure);
});

/**
 * Using clojure.walk, navigate the data structure until reaching
 *        a value for which `afn` returns truthy.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter16726 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16726 = (function (afn,meta16727){
this.afn = afn;
this.meta16727 = meta16727;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16726.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16728,meta16727__$1){
var self__ = this;
var _16728__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16726(self__.afn,meta16727__$1));
});

com.rpl.specter.t_com$rpl$specter16726.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16728){
var self__ = this;
var _16728__$1 = this;
return self__.meta16727;
});

com.rpl.specter.t_com$rpl$specter16726.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16726.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.walk_select.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter16726.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.walk_until.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter16726.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta16727","meta16727",1942526736,null)], null);
});

com.rpl.specter.t_com$rpl$specter16726.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16726.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16726";

com.rpl.specter.t_com$rpl$specter16726.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16726");
});

com.rpl.specter.__GT_t_com$rpl$specter16726 = (function com$rpl$specter$__GT_t_com$rpl$specter16726(afn__$1,meta16727){
return (new com.rpl.specter.t_com$rpl$specter16726(afn__$1,meta16727));
});

}

return (new com.rpl.specter.t_com$rpl$specter16726(afn,null));
}));


com.rpl.specter.codewalker_select_STAR_ = (function com$rpl$specter$codewalker_select_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_select.call(null,afn,next_fn,structure);
});

com.rpl.specter.codewalker_transform_STAR_ = (function com$rpl$specter$codewalker_transform_STAR_(afn,structure,next_fn){
return com.rpl.specter.impl.codewalk_until.call(null,afn,next_fn,structure);
});

/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter16729 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16729 = (function (afn,meta16730){
this.afn = afn;
this.meta16730 = meta16730;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16729.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16731,meta16730__$1){
var self__ = this;
var _16731__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16729(self__.afn,meta16730__$1));
});

com.rpl.specter.t_com$rpl$specter16729.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16731){
var self__ = this;
var _16731__$1 = this;
return self__.meta16730;
});

com.rpl.specter.t_com$rpl$specter16729.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16729.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.navs.walk_select.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter16729.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return com.rpl.specter.impl.codewalk_until.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter16729.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta16730","meta16730",-628622941,null)], null);
});

com.rpl.specter.t_com$rpl$specter16729.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16729.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16729";

com.rpl.specter.t_com$rpl$specter16729.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16729");
});

com.rpl.specter.__GT_t_com$rpl$specter16729 = (function com$rpl$specter$__GT_t_com$rpl$specter16729(afn__$1,meta16730){
return (new com.rpl.specter.t_com$rpl$specter16729(afn__$1,meta16730));
});

}

return (new com.rpl.specter.t_com$rpl$specter16729(afn,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 */
com.rpl.specter.subselect = cljs.core.vary_meta.call(null,(function() { 
var G__16735__delegate = function (path){
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16732 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16732 = (function (path,late,meta16733){
this.path = path;
this.late = late;
this.meta16733 = meta16733;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16732.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16734,meta16733__$1){
var self__ = this;
var _16734__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16732(self__.path,self__.late,meta16733__$1));
});

com.rpl.specter.t_com$rpl$specter16732.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16734){
var self__ = this;
var _16734__$1 = this;
return self__.meta16733;
});

com.rpl.specter.t_com$rpl$specter16732.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16732.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_select.call(null,self__.late,structure));
});

com.rpl.specter.t_com$rpl$specter16732.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
var select_result = com.rpl.specter.compiled_select.call(null,self__.late,structure);
var transformed = next_fn.call(null,select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.call(null,transformed);
return com.rpl.specter.compiled_transform.call(null,self__.late,((function (select_result,transformed,values_to_insert,next_fn,this__15409__auto____$1){
return (function (_){
var next_val = cljs.core.first.call(null,com.rpl.specter.impl.get_cell.call(null,values_to_insert));
com.rpl.specter.impl.update_cell_BANG_.call(null,values_to_insert,cljs.core.rest);

return next_val;
});})(select_result,transformed,values_to_insert,next_fn,this__15409__auto____$1))
,structure);
});

com.rpl.specter.t_com$rpl$specter16732.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16733","meta16733",-1148252690,null)], null);
});

com.rpl.specter.t_com$rpl$specter16732.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16732.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16732";

com.rpl.specter.t_com$rpl$specter16732.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16732");
});

com.rpl.specter.__GT_t_com$rpl$specter16732 = (function com$rpl$specter$__GT_t_com$rpl$specter16732(path__$1,late__$1,meta16733){
return (new com.rpl.specter.t_com$rpl$specter16732(path__$1,late__$1,meta16733));
});

}

return (new com.rpl.specter.t_com$rpl$specter16732(path,late,null));
}));
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
};
var G__16735 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16736__i = 0, G__16736__a = new Array(arguments.length -  0);
while (G__16736__i < G__16736__a.length) {G__16736__a[G__16736__i] = arguments[G__16736__i + 0]; ++G__16736__i;}
  path = new cljs.core.IndexedSeq(G__16736__a,0);
} 
return G__16735__delegate.call(this,path);};
G__16735.cljs$lang$maxFixedArity = 0;
G__16735.cljs$lang$applyTo = (function (arglist__16737){
var path = cljs.core.seq(arglist__16737);
return G__16735__delegate(path);
});
G__16735.cljs$core$IFn$_invoke$arity$variadic = G__16735__delegate;
return G__16735;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.keypath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_);
com.rpl.specter.must = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_);
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter16738 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16738 = (function (afn,meta16739){
this.afn = afn;
this.meta16739 = meta16739;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16738.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16740,meta16739__$1){
var self__ = this;
var _16740__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16738(self__.afn,meta16739__$1));
});

com.rpl.specter.t_com$rpl$specter16738.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16740){
var self__ = this;
var _16740__$1 = this;
return self__.meta16739;
});

com.rpl.specter.t_com$rpl$specter16738.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16738.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16738.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16738.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta16739","meta16739",-583437524,null)], null);
});

com.rpl.specter.t_com$rpl$specter16738.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16738.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16738";

com.rpl.specter.t_com$rpl$specter16738.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16738");
});

com.rpl.specter.__GT_t_com$rpl$specter16738 = (function com$rpl$specter$__GT_t_com$rpl$specter16738(afn__$1,meta16739){
return (new com.rpl.specter.t_com$rpl$specter16738(afn__$1,meta16739));
});

}

return (new com.rpl.specter.t_com$rpl$specter16738(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
return next_fn.call(null,parse_fn.call(null,structure));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
return unparse_fn.call(null,next_fn.call(null,parse_fn.call(null,structure)));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj.call(null,(function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter16741 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16741 = (function (parse_fn,unparse_fn,meta16742){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta16742 = meta16742;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16741.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16743,meta16742__$1){
var self__ = this;
var _16743__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16741(self__.parse_fn,self__.unparse_fn,meta16742__$1));
});

com.rpl.specter.t_com$rpl$specter16741.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16743){
var self__ = this;
var _16743__$1 = this;
return self__.meta16742;
});

com.rpl.specter.t_com$rpl$specter16741.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16741.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,self__.parse_fn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16741.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return self__.unparse_fn.call(null,next_fn.call(null,self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter16741.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta16742","meta16742",1243002870,null)], null);
});

com.rpl.specter.t_com$rpl$specter16741.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16741.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16741";

com.rpl.specter.t_com$rpl$specter16741.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16741");
});

com.rpl.specter.__GT_t_com$rpl$specter16741 = (function com$rpl$specter$__GT_t_com$rpl$specter16741(parse_fn__$1,unparse_fn__$1,meta16742){
return (new com.rpl.specter.t_com$rpl$specter16741(parse_fn__$1,unparse_fn__$1,meta16742));
});

}

return (new com.rpl.specter.t_com$rpl$specter16741(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16744 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16744 = (function (meta16745){
this.meta16745 = meta16745;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16744.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16746,meta16745__$1){
var self__ = this;
var _16746__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16744(meta16745__$1));
});

com.rpl.specter.t_com$rpl$specter16744.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16746){
var self__ = this;
var _16746__$1 = this;
return self__.meta16745;
});

com.rpl.specter.t_com$rpl$specter16744.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16744.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16744.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter16744.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16745","meta16745",834720163,null)], null);
});

com.rpl.specter.t_com$rpl$specter16744.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16744.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16744";

com.rpl.specter.t_com$rpl$specter16744.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16744");
});

com.rpl.specter.__GT_t_com$rpl$specter16744 = (function com$rpl$specter$__GT_t_com$rpl$specter16744(meta16745){
return (new com.rpl.specter.t_com$rpl$specter16744(meta16745));
});

}

return (new com.rpl.specter.t_com$rpl$specter16744(null));
})()
;
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.call(null,(function() { 
var G__16752__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return afn;
} else {
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16749 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16749 = (function (path,temp__4655__auto__,late,meta16750){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta16750 = meta16750;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16749.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_16751,meta16750__$1){
var self__ = this;
var _16751__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16749(self__.path,self__.temp__4655__auto__,self__.late,meta16750__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16749.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_16751){
var self__ = this;
var _16751__$1 = this;
return self__.meta16750;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16749.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16749.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1,temp__4655__auto__){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_select.call(null,((function (next_fn,this__15409__auto____$1,temp__4655__auto__){
return (function (p1__16747_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,p1__16747_SHARP_);
});})(next_fn,this__15409__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16749.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1,temp__4655__auto__){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_transform.call(null,((function (next_fn,this__15409__auto____$1,temp__4655__auto__){
return (function (p1__16748_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,p1__16748_SHARP_);
});})(next_fn,this__15409__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16749.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16750","meta16750",1108205003,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16749.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16749.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16749";

com.rpl.specter.t_com$rpl$specter16749.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16749");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter16749 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter16749(path__$1,temp__4655__auto____$1,late__$1,meta16750){
return (new com.rpl.specter.t_com$rpl$specter16749(path__$1,temp__4655__auto____$1,late__$1,meta16750));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter16749(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
}
};
var G__16752 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16753__i = 0, G__16753__a = new Array(arguments.length -  0);
while (G__16753__i < G__16753__a.length) {G__16753__a[G__16753__i] = arguments[G__16753__i + 0]; ++G__16753__i;}
  path = new cljs.core.IndexedSeq(G__16753__a,0);
} 
return G__16752__delegate.call(this,path);};
G__16752.cljs$lang$maxFixedArity = 0;
G__16752.cljs$lang$applyTo = (function (arglist__16754){
var path = cljs.core.seq(arglist__16754);
return G__16752__delegate(path);
});
G__16752.cljs$core$IFn$_invoke$arity$variadic = G__16752__delegate;
return G__16752;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.call(null,(function() { 
var G__16760__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return ((function (afn,temp__4655__auto__){
return (function (s){
return cljs.core.not.call(null,afn.call(null,s));
});
;})(afn,temp__4655__auto__))
} else {
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16757 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16757 = (function (path,temp__4655__auto__,late,meta16758){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta16758 = meta16758;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16757.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_16759,meta16758__$1){
var self__ = this;
var _16759__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16757(self__.path,self__.temp__4655__auto__,self__.late,meta16758__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16757.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_16759){
var self__ = this;
var _16759__$1 = this;
return self__.meta16758;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16757.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16757.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1,temp__4655__auto__){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_select.call(null,((function (next_fn,this__15409__auto____$1,temp__4655__auto__){
return (function (p1__16755_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,p1__16755_SHARP_);
});})(next_fn,this__15409__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16757.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1,temp__4655__auto__){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_transform.call(null,((function (next_fn,this__15409__auto____$1,temp__4655__auto__){
return (function (p1__16756_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,p1__16756_SHARP_);
});})(next_fn,this__15409__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16757.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16758","meta16758",-296592380,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16757.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16757.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16757";

com.rpl.specter.t_com$rpl$specter16757.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16757");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter16757 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter16757(path__$1,temp__4655__auto____$1,late__$1,meta16758){
return (new com.rpl.specter.t_com$rpl$specter16757(path__$1,temp__4655__auto____$1,late__$1,meta16758));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter16757(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
}
};
var G__16760 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16761__i = 0, G__16761__a = new Array(arguments.length -  0);
while (G__16761__i < G__16761__a.length) {G__16761__a[G__16761__i] = arguments[G__16761__i + 0]; ++G__16761__i;}
  path = new cljs.core.IndexedSeq(G__16761__a,0);
} 
return G__16760__delegate.call(this,path);};
G__16760.cljs$lang$maxFixedArity = 0;
G__16760.cljs$lang$applyTo = (function (arglist__16762){
var path = cljs.core.seq(arglist__16762);
return G__16760__delegate(path);
});
G__16760.cljs$core$IFn$_invoke$arity$variadic = G__16760__delegate;
return G__16760;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.call(null,(function() { 
var G__16763__delegate = function (path){
return com.rpl.specter.subselect.call(null,com.rpl.specter.ALL,com.rpl.specter.selected_QMARK_.call(null,path));
};
var G__16763 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16764__i = 0, G__16764__a = new Array(arguments.length -  0);
while (G__16764__i < G__16764__a.length) {G__16764__a[G__16764__i] = arguments[G__16764__i + 0]; ++G__16764__i;}
  path = new cljs.core.IndexedSeq(G__16764__a,0);
} 
return G__16763__delegate.call(this,path);};
G__16763.cljs$lang$maxFixedArity = 0;
G__16763.cljs$lang$applyTo = (function (arglist__16765){
var path = cljs.core.seq(arglist__16765);
return G__16763__delegate(path);
});
G__16763.cljs$core$IFn$_invoke$arity$variadic = G__16763__delegate;
return G__16763;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.call(null,(function (path,update_fn){
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter16766 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16766 = (function (path,update_fn,late,late_fn,meta16767){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta16767 = meta16767;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16768,meta16767__$1){
var self__ = this;
var _16768__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16766(self__.path,self__.update_fn,self__.late,self__.late_fn,meta16767__$1));
});

com.rpl.specter.t_com$rpl$specter16766.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16768){
var self__ = this;
var _16768__$1 = this;
return self__.meta16767;
});

com.rpl.specter.t_com$rpl$specter16766.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16766.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter16766.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter16766.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta16767","meta16767",744247799,null)], null);
});

com.rpl.specter.t_com$rpl$specter16766.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16766.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16766";

com.rpl.specter.t_com$rpl$specter16766.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16766");
});

com.rpl.specter.__GT_t_com$rpl$specter16766 = (function com$rpl$specter$__GT_t_com$rpl$specter16766(path__$1,update_fn__$1,late__$1,late_fn__$1,meta16767){
return (new com.rpl.specter.t_com$rpl$specter16766(path__$1,update_fn__$1,late__$1,late_fn__$1,meta16767));
});

}

return (new com.rpl.specter.t_com$rpl$specter16766(path,update_fn,late,late_fn,null));
}));
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),update_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.call(null,(function (path,reduce_fn){
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter16769 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16769 = (function (path,reduce_fn,late,late_fn,meta16770){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta16770 = meta16770;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16769.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16771,meta16770__$1){
var self__ = this;
var _16771__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16769(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta16770__$1));
});

com.rpl.specter.t_com$rpl$specter16769.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16771){
var self__ = this;
var _16771__$1 = this;
return self__.meta16770;
});

com.rpl.specter.t_com$rpl$specter16769.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16769.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter16769.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter16769.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta16770","meta16770",-1445877735,null)], null);
});

com.rpl.specter.t_com$rpl$specter16769.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16769.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16769";

com.rpl.specter.t_com$rpl$specter16769.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16769");
});

com.rpl.specter.__GT_t_com$rpl$specter16769 = (function com$rpl$specter$__GT_t_com$rpl$specter16769(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta16770){
return (new com.rpl.specter.t_com$rpl$specter16769(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta16770));
});

}

return (new com.rpl.specter.t_com$rpl$specter16769(path,reduce_fn,late,late_fn,null));
}));
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),reduce_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. This is the
 *        late-bound parameterized version of using a function directly in a path.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
(com.rpl.specter.protocols.ImplicitNav["null"] = true);

(com.rpl.specter.protocols.implicit_nav["null"] = (function (this$){
return com.rpl.specter.STAY;
}));
cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1);
});
(com.rpl.specter.protocols.ImplicitNav["function"] = true);

(com.rpl.specter.protocols.implicit_nav["function"] = (function (this$){
return com.rpl.specter.pred.call(null,this$);
}));
cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.pred.call(null,this$__$1);
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj.call(null,(function (v){
if(typeof com.rpl.specter.t_com$rpl$specter16772 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16772 = (function (v,meta16773){
this.v = v;
this.meta16773 = meta16773;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16772.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16774,meta16773__$1){
var self__ = this;
var _16774__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16772(self__.v,meta16773__$1));
});

com.rpl.specter.t_com$rpl$specter16772.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16774){
var self__ = this;
var _16774__$1 = this;
return self__.meta16773;
});

com.rpl.specter.t_com$rpl$specter16772.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16772.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter16772.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter16772.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta16773","meta16773",2012155398,null)], null);
});

com.rpl.specter.t_com$rpl$specter16772.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16772.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16772";

com.rpl.specter.t_com$rpl$specter16772.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16772");
});

com.rpl.specter.__GT_t_com$rpl$specter16772 = (function com$rpl$specter$__GT_t_com$rpl$specter16772(v__$1,meta16773){
return (new com.rpl.specter.t_com$rpl$specter16772(v__$1,meta16773));
});

}

return (new com.rpl.specter.t_com$rpl$specter16772(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentHashSet.EMPTY);
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = com.rpl.specter.nil__GT_val.call(null,cljs.core.List.EMPTY);
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentVector.EMPTY);


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16775 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16775 = (function (meta16776){
this.meta16776 = meta16776;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16775.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16777,meta16776__$1){
var self__ = this;
var _16777__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16775(meta16776__$1));
});

com.rpl.specter.t_com$rpl$specter16775.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16777){
var self__ = this;
var _16777__$1 = this;
return self__.meta16776;
});

com.rpl.specter.t_com$rpl$specter16775.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16775.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16775.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15409__auto__,vals__15410__auto__,structure,next_fn__15411__auto__){
var self__ = this;
var this__15409__auto____$1 = this;
var next_fn = ((function (this__15409__auto____$1){
return (function (s__15412__auto__){
return next_fn__15411__auto__.call(null,vals__15410__auto__,s__15412__auto__);
});})(this__15409__auto____$1))
;
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter16775.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16776","meta16776",-108046564,null)], null);
});

com.rpl.specter.t_com$rpl$specter16775.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16775.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16775";

com.rpl.specter.t_com$rpl$specter16775.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16775");
});

com.rpl.specter.__GT_t_com$rpl$specter16775 = (function com$rpl$specter$__GT_t_com$rpl$specter16775(meta16776){
return (new com.rpl.specter.t_com$rpl$specter16775(meta16776));
});

}

return (new com.rpl.specter.t_com$rpl$specter16775(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.call(null,(function() { 
var G__16781__delegate = function (path){
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16778 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16778 = (function (path,late,meta16779){
this.path = path;
this.late = late;
this.meta16779 = meta16779;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16778.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16780,meta16779__$1){
var self__ = this;
var _16780__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16778(self__.path,self__.late,meta16779__$1));
});

com.rpl.specter.t_com$rpl$specter16778.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16780){
var self__ = this;
var _16780__$1 = this;
return self__.meta16779;
});

com.rpl.specter.t_com$rpl$specter16778.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16778.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16044__auto__,vals__16045__auto__,structure,next_fn__16046__auto__){
var self__ = this;
var this__16044__auto____$1 = this;
return next_fn__16046__auto__.call(null,cljs.core.conj.call(null,vals__16045__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter16778.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16044__auto__,vals__16045__auto__,structure,next_fn__16046__auto__){
var self__ = this;
var this__16044__auto____$1 = this;
return next_fn__16046__auto__.call(null,cljs.core.conj.call(null,vals__16045__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter16778.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16779","meta16779",1310857609,null)], null);
});

com.rpl.specter.t_com$rpl$specter16778.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16778.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16778";

com.rpl.specter.t_com$rpl$specter16778.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16778");
});

com.rpl.specter.__GT_t_com$rpl$specter16778 = (function com$rpl$specter$__GT_t_com$rpl$specter16778(path__$1,late__$1,meta16779){
return (new com.rpl.specter.t_com$rpl$specter16778(path__$1,late__$1,meta16779));
});

}

return (new com.rpl.specter.t_com$rpl$specter16778(path,late,null));
}));
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
};
var G__16781 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16782__i = 0, G__16782__a = new Array(arguments.length -  0);
while (G__16782__i < G__16782__a.length) {G__16782__a[G__16782__i] = arguments[G__16782__i + 0]; ++G__16782__i;}
  path = new cljs.core.IndexedSeq(G__16782__a,0);
} 
return G__16781__delegate.call(this,path);};
G__16781.cljs$lang$maxFixedArity = 0;
G__16781.cljs$lang$applyTo = (function (arglist__16783){
var path = cljs.core.seq(arglist__16783);
return G__16781__delegate(path);
});
G__16781.cljs$core$IFn$_invoke$arity$variadic = G__16781__delegate;
return G__16781;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.call(null,(function() { 
var G__16787__delegate = function (path){
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16784 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16784 = (function (path,late,meta16785){
this.path = path;
this.late = late;
this.meta16785 = meta16785;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16784.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16786,meta16785__$1){
var self__ = this;
var _16786__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16784(self__.path,self__.late,meta16785__$1));
});

com.rpl.specter.t_com$rpl$specter16784.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16786){
var self__ = this;
var _16786__$1 = this;
return self__.meta16785;
});

com.rpl.specter.t_com$rpl$specter16784.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16784.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16044__auto__,vals__16045__auto__,structure,next_fn__16046__auto__){
var self__ = this;
var this__16044__auto____$1 = this;
return next_fn__16046__auto__.call(null,cljs.core.conj.call(null,vals__16045__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter16784.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16044__auto__,vals__16045__auto__,structure,next_fn__16046__auto__){
var self__ = this;
var this__16044__auto____$1 = this;
return next_fn__16046__auto__.call(null,cljs.core.conj.call(null,vals__16045__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter16784.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16785","meta16785",-645450188,null)], null);
});

com.rpl.specter.t_com$rpl$specter16784.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16784.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16784";

com.rpl.specter.t_com$rpl$specter16784.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16784");
});

com.rpl.specter.__GT_t_com$rpl$specter16784 = (function com$rpl$specter$__GT_t_com$rpl$specter16784(path__$1,late__$1,meta16785){
return (new com.rpl.specter.t_com$rpl$specter16784(path__$1,late__$1,meta16785));
});

}

return (new com.rpl.specter.t_com$rpl$specter16784(path,late,null));
}));
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
};
var G__16787 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16788__i = 0, G__16788__a = new Array(arguments.length -  0);
while (G__16788__i < G__16788__a.length) {G__16788__a[G__16788__i] = arguments[G__16788__i + 0]; ++G__16788__i;}
  path = new cljs.core.IndexedSeq(G__16788__a,0);
} 
return G__16787__delegate.call(this,path);};
G__16787.cljs$lang$maxFixedArity = 0;
G__16787.cljs$lang$applyTo = (function (arglist__16789){
var path = cljs.core.seq(arglist__16789);
return G__16787__delegate(path);
});
G__16787.cljs$core$IFn$_invoke$arity$variadic = G__16787__delegate;
return G__16787;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj.call(null,(function (val){
if(typeof com.rpl.specter.t_com$rpl$specter16790 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16790 = (function (val,meta16791){
this.val = val;
this.meta16791 = meta16791;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16790.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16792,meta16791__$1){
var self__ = this;
var _16792__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16790(self__.val,meta16791__$1));
});

com.rpl.specter.t_com$rpl$specter16790.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16792){
var self__ = this;
var _16792__$1 = this;
return self__.meta16791;
});

com.rpl.specter.t_com$rpl$specter16790.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16790.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16044__auto__,vals__16045__auto__,structure,next_fn__16046__auto__){
var self__ = this;
var this__16044__auto____$1 = this;
return next_fn__16046__auto__.call(null,cljs.core.conj.call(null,vals__16045__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter16790.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16044__auto__,vals__16045__auto__,structure,next_fn__16046__auto__){
var self__ = this;
var this__16044__auto____$1 = this;
return next_fn__16046__auto__.call(null,cljs.core.conj.call(null,vals__16045__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter16790.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta16791","meta16791",-2012110249,null)], null);
});

com.rpl.specter.t_com$rpl$specter16790.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16790.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16790";

com.rpl.specter.t_com$rpl$specter16790.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16790");
});

com.rpl.specter.__GT_t_com$rpl$specter16790 = (function com$rpl$specter$__GT_t_com$rpl$specter16790(val__$1,meta16791){
return (new com.rpl.specter.t_com$rpl$specter16790(val__$1,meta16791));
});

}

return (new com.rpl.specter.t_com$rpl$specter16790(val,null));
}));
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16793 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16793 = (function (meta16794){
this.meta16794 = meta16794;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16793.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16795,meta16794__$1){
var self__ = this;
var _16795__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16793(meta16794__$1));
});

com.rpl.specter.t_com$rpl$specter16793.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16795){
var self__ = this;
var _16795__$1 = this;
return self__.meta16794;
});

com.rpl.specter.t_com$rpl$specter16793.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16793.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter16793.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter16793.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16794","meta16794",-1335473197,null)], null);
});

com.rpl.specter.t_com$rpl$specter16793.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16793.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16793";

com.rpl.specter.t_com$rpl$specter16793.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16793");
});

com.rpl.specter.__GT_t_com$rpl$specter16793 = (function com$rpl$specter$__GT_t_com$rpl$specter16793(meta16794){
return (new com.rpl.specter.t_com$rpl$specter16793(meta16794));
});

}

return (new com.rpl.specter.t_com$rpl$specter16793(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.call(null,(function() {
var G__16804 = null;
var G__16804__2 = (function (cond_p,then_path){
return com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP);
});
var G__16804__3 = (function (cond_p,then_path,else_path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,cond_p);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (afn,temp__4655__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter16798 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16798 = (function (cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,meta16799){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta16799 = meta16799;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16798.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__4655__auto__){
return (function (_16800,meta16799__$1){
var self__ = this;
var _16800__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16798(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.afn,self__.late_then,self__.late_else,meta16799__$1));
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16798.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__4655__auto__){
return (function (_16800){
var self__ = this;
var _16800__$1 = this;
return self__.meta16799;
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16798.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16798.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16798.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16798.getBasis = ((function (afn,temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta16799","meta16799",1899190250,null)], null);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16798.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16798.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16798";

com.rpl.specter.t_com$rpl$specter16798.cljs$lang$ctorPrWriter = ((function (afn,temp__4655__auto__){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16798");
});})(afn,temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter16798 = ((function (afn,temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter16798(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta16799){
return (new com.rpl.specter.t_com$rpl$specter16798(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta16799));
});})(afn,temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter16798(cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,null));
});})(afn,temp__4655__auto__))
);
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
} else {
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter16801 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16801 = (function (cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,meta16802){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta16802 = meta16802;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16801.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_16803,meta16802__$1){
var self__ = this;
var _16803__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16801(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.late_cond,self__.late_then,self__.late_else,meta16802__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16801.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_16803){
var self__ = this;
var _16803__$1 = this;
return self__.meta16802;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16801.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16801.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__16796_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,p1__16796_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16801.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__16797_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,p1__16797_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16801.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta16802","meta16802",-1424586909,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16801.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16801.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16801";

com.rpl.specter.t_com$rpl$specter16801.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16801");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter16801 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter16801(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta16802){
return (new com.rpl.specter.t_com$rpl$specter16801(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta16802));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter16801(cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,null));
});})(temp__4655__auto__))
);
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,cond_p),com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
}
});
G__16804 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__16804__2.call(this,cond_p,then_path);
case 3:
return G__16804__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16804.cljs$core$IFn$_invoke$arity$2 = G__16804__2;
G__16804.cljs$core$IFn$_invoke$arity$3 = G__16804__3;
return G__16804;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 * 
 * The input paths may be parameterized, in which case the result of cond-path
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.call(null,(function() { 
var G__16809__delegate = function (conds){
var pairs = cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),conds));
return cljs.core.reduce.call(null,((function (pairs){
return (function (p,p__16805){
var vec__16806 = p__16805;
var tester = cljs.core.nth.call(null,vec__16806,(0),null);
var apath = cljs.core.nth.call(null,vec__16806,(1),null);
return com.rpl.specter.if_path.call(null,tester,apath,p);
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__16809 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__16810__i = 0, G__16810__a = new Array(arguments.length -  0);
while (G__16810__i < G__16810__a.length) {G__16810__a[G__16810__i] = arguments[G__16810__i + 0]; ++G__16810__i;}
  conds = new cljs.core.IndexedSeq(G__16810__a,0);
} 
return G__16809__delegate.call(this,conds);};
G__16809.cljs$lang$maxFixedArity = 0;
G__16809.cljs$lang$applyTo = (function (arglist__16811){
var conds = cljs.core.seq(arglist__16811);
return G__16809__delegate(conds);
});
G__16809.cljs$core$IFn$_invoke$arity$variadic = G__16809__delegate;
return G__16809;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.call(null,(function() {
var G__16819 = null;
var G__16819__0 = (function (){
return com.rpl.specter.STAY;
});
var G__16819__1 = (function (path){
return path;
});
var G__16819__2 = (function (path1,path2){
var builder__16047__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter16812 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16812 = (function (path1,path2,late1,late2,meta16813){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta16813 = meta16813;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16812.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16814,meta16813__$1){
var self__ = this;
var _16814__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16812(self__.path1,self__.path2,self__.late1,self__.late2,meta16813__$1));
});

com.rpl.specter.t_com$rpl$specter16812.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16814){
var self__ = this;
var _16814__$1 = this;
return self__.meta16813;
});

com.rpl.specter.t_com$rpl$specter16812.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16812.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late1,vals,structure,next_fn);
var res2 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res2)){
return res1;
} else {
return res2;
}
});

com.rpl.specter.t_com$rpl$specter16812.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_.call(null,self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late2,vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter16812.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta16813","meta16813",-1190665343,null)], null);
});

com.rpl.specter.t_com$rpl$specter16812.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16812.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16812";

com.rpl.specter.t_com$rpl$specter16812.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16812");
});

com.rpl.specter.__GT_t_com$rpl$specter16812 = (function com$rpl$specter$__GT_t_com$rpl$specter16812(path1__$1,path2__$1,late1__$1,late2__$1,meta16813){
return (new com.rpl.specter.t_com$rpl$specter16812(path1__$1,path2__$1,late1__$1,late2__$1,meta16813));
});

}

return (new com.rpl.specter.t_com$rpl$specter16812(path1,path2,late1,late2,null));
}));
var curr_params__16048__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path1),com.rpl.specter.late_path.call(null,path2)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16048__auto__)){
return cljs.core.apply.call(null,builder__16047__auto__,curr_params__16048__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16047__auto__,curr_params__16048__auto__);
}
});
var G__16819__3 = (function() { 
var G__16820__delegate = function (path1,path2,paths){
return cljs.core.reduce.call(null,com.rpl.specter.multi_path,com.rpl.specter.multi_path.call(null,path1,path2),paths);
};
var G__16820 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__16821__i = 0, G__16821__a = new Array(arguments.length -  2);
while (G__16821__i < G__16821__a.length) {G__16821__a[G__16821__i] = arguments[G__16821__i + 2]; ++G__16821__i;}
  paths = new cljs.core.IndexedSeq(G__16821__a,0);
} 
return G__16820__delegate.call(this,path1,path2,paths);};
G__16820.cljs$lang$maxFixedArity = 2;
G__16820.cljs$lang$applyTo = (function (arglist__16822){
var path1 = cljs.core.first(arglist__16822);
arglist__16822 = cljs.core.next(arglist__16822);
var path2 = cljs.core.first(arglist__16822);
var paths = cljs.core.rest(arglist__16822);
return G__16820__delegate(path1,path2,paths);
});
G__16820.cljs$core$IFn$_invoke$arity$variadic = G__16820__delegate;
return G__16820;
})()
;
G__16819 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__16819__0.call(this);
case 1:
return G__16819__1.call(this,path1);
case 2:
return G__16819__2.call(this,path1,path2);
default:
var G__16823 = null;
if (arguments.length > 2) {
var G__16824__i = 0, G__16824__a = new Array(arguments.length -  2);
while (G__16824__i < G__16824__a.length) {G__16824__a[G__16824__i] = arguments[G__16824__i + 2]; ++G__16824__i;}
G__16823 = new cljs.core.IndexedSeq(G__16824__a,0);
}
return G__16819__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__16823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16819.cljs$lang$maxFixedArity = 2;
G__16819.cljs$lang$applyTo = G__16819__3.cljs$lang$applyTo;
G__16819.cljs$core$IFn$_invoke$arity$0 = G__16819__0;
G__16819.cljs$core$IFn$_invoke$arity$1 = G__16819__1;
G__16819.cljs$core$IFn$_invoke$arity$2 = G__16819__2;
G__16819.cljs$core$IFn$_invoke$arity$variadic = G__16819__3.cljs$core$IFn$_invoke$arity$variadic;
return G__16819;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.call(null,(function() { 
var G__16825__delegate = function (path){
return com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path);
};
var G__16825 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16826__i = 0, G__16826__a = new Array(arguments.length -  0);
while (G__16826__i < G__16826__a.length) {G__16826__a[G__16826__i] = arguments[G__16826__i + 0]; ++G__16826__i;}
  path = new cljs.core.IndexedSeq(G__16826__a,0);
} 
return G__16825__delegate.call(this,path);};
G__16825.cljs$lang$maxFixedArity = 0;
G__16825.cljs$lang$applyTo = (function (arglist__16827){
var path = cljs.core.seq(arglist__16827);
return G__16825__delegate(path);
});
G__16825.cljs$core$IFn$_invoke$arity$variadic = G__16825__delegate;
return G__16825;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.call(null,(function() { 
var G__16828__delegate = function (path){
return com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY);
};
var G__16828 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16829__i = 0, G__16829__a = new Array(arguments.length -  0);
while (G__16829__i < G__16829__a.length) {G__16829__a[G__16829__i] = arguments[G__16829__i + 0]; ++G__16829__i;}
  path = new cljs.core.IndexedSeq(G__16829__a,0);
} 
return G__16828__delegate.call(this,path);};
G__16828.cljs$lang$maxFixedArity = 0;
G__16828.cljs$lang$applyTo = (function (arglist__16830){
var path = cljs.core.seq(arglist__16830);
return G__16828__delegate(path);
});
G__16828.cljs$core$IFn$_invoke$arity$variadic = G__16828__delegate;
return G__16828;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
