// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18750 = [];
var len__7651__auto___18756 = arguments.length;
var i__7652__auto___18757 = (0);
while(true){
if((i__7652__auto___18757 < len__7651__auto___18756)){
args18750.push((arguments[i__7652__auto___18757]));

var G__18758 = (i__7652__auto___18757 + (1));
i__7652__auto___18757 = G__18758;
continue;
} else {
}
break;
}

var G__18752 = args18750.length;
switch (G__18752) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18750.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18753 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18753 = (function (f,blockable,meta18754){
this.f = f;
this.blockable = blockable;
this.meta18754 = meta18754;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18753.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18755,meta18754__$1){
var self__ = this;
var _18755__$1 = this;
return (new cljs.core.async.t_cljs$core$async18753(self__.f,self__.blockable,meta18754__$1));
});

cljs.core.async.t_cljs$core$async18753.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18755){
var self__ = this;
var _18755__$1 = this;
return self__.meta18754;
});

cljs.core.async.t_cljs$core$async18753.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18753.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18753.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18753.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18753.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18754","meta18754",1085292231,null)], null);
});

cljs.core.async.t_cljs$core$async18753.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18753.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18753";

cljs.core.async.t_cljs$core$async18753.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async18753");
});

cljs.core.async.__GT_t_cljs$core$async18753 = (function cljs$core$async$__GT_t_cljs$core$async18753(f__$1,blockable__$1,meta18754){
return (new cljs.core.async.t_cljs$core$async18753(f__$1,blockable__$1,meta18754));
});

}

return (new cljs.core.async.t_cljs$core$async18753(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args18762 = [];
var len__7651__auto___18765 = arguments.length;
var i__7652__auto___18766 = (0);
while(true){
if((i__7652__auto___18766 < len__7651__auto___18765)){
args18762.push((arguments[i__7652__auto___18766]));

var G__18767 = (i__7652__auto___18766 + (1));
i__7652__auto___18766 = G__18767;
continue;
} else {
}
break;
}

var G__18764 = args18762.length;
switch (G__18764) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18762.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args18769 = [];
var len__7651__auto___18772 = arguments.length;
var i__7652__auto___18773 = (0);
while(true){
if((i__7652__auto___18773 < len__7651__auto___18772)){
args18769.push((arguments[i__7652__auto___18773]));

var G__18774 = (i__7652__auto___18773 + (1));
i__7652__auto___18773 = G__18774;
continue;
} else {
}
break;
}

var G__18771 = args18769.length;
switch (G__18771) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18769.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args18776 = [];
var len__7651__auto___18779 = arguments.length;
var i__7652__auto___18780 = (0);
while(true){
if((i__7652__auto___18780 < len__7651__auto___18779)){
args18776.push((arguments[i__7652__auto___18780]));

var G__18781 = (i__7652__auto___18780 + (1));
i__7652__auto___18780 = G__18781;
continue;
} else {
}
break;
}

var G__18778 = args18776.length;
switch (G__18778) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18776.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_18783 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_18783);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_18783,ret){
return (function (){
return fn1.call(null,val_18783);
});})(val_18783,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args18784 = [];
var len__7651__auto___18787 = arguments.length;
var i__7652__auto___18788 = (0);
while(true){
if((i__7652__auto___18788 < len__7651__auto___18787)){
args18784.push((arguments[i__7652__auto___18788]));

var G__18789 = (i__7652__auto___18788 + (1));
i__7652__auto___18788 = G__18789;
continue;
} else {
}
break;
}

var G__18786 = args18784.length;
switch (G__18786) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18784.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7461__auto___18791 = n;
var x_18792 = (0);
while(true){
if((x_18792 < n__7461__auto___18791)){
(a[x_18792] = (0));

var G__18793 = (x_18792 + (1));
x_18792 = G__18793;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__18794 = (i + (1));
i = G__18794;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async18798 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18798 = (function (flag,meta18799){
this.flag = flag;
this.meta18799 = meta18799;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18798.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_18800,meta18799__$1){
var self__ = this;
var _18800__$1 = this;
return (new cljs.core.async.t_cljs$core$async18798(self__.flag,meta18799__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async18798.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_18800){
var self__ = this;
var _18800__$1 = this;
return self__.meta18799;
});})(flag))
;

cljs.core.async.t_cljs$core$async18798.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18798.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async18798.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18798.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18798.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta18799","meta18799",-943115174,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async18798.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18798.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18798";

cljs.core.async.t_cljs$core$async18798.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async18798");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async18798 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18798(flag__$1,meta18799){
return (new cljs.core.async.t_cljs$core$async18798(flag__$1,meta18799));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async18798(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async18804 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18804 = (function (flag,cb,meta18805){
this.flag = flag;
this.cb = cb;
this.meta18805 = meta18805;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18804.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18806,meta18805__$1){
var self__ = this;
var _18806__$1 = this;
return (new cljs.core.async.t_cljs$core$async18804(self__.flag,self__.cb,meta18805__$1));
});

cljs.core.async.t_cljs$core$async18804.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18806){
var self__ = this;
var _18806__$1 = this;
return self__.meta18805;
});

cljs.core.async.t_cljs$core$async18804.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18804.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async18804.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18804.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async18804.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta18805","meta18805",958183526,null)], null);
});

cljs.core.async.t_cljs$core$async18804.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18804.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18804";

cljs.core.async.t_cljs$core$async18804.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async18804");
});

cljs.core.async.__GT_t_cljs$core$async18804 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18804(flag__$1,cb__$1,meta18805){
return (new cljs.core.async.t_cljs$core$async18804(flag__$1,cb__$1,meta18805));
});

}

return (new cljs.core.async.t_cljs$core$async18804(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18807_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18807_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18808_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18808_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6543__auto__ = wport;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18809 = (i + (1));
i = G__18809;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6543__auto__ = ret;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6531__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___18815 = arguments.length;
var i__7652__auto___18816 = (0);
while(true){
if((i__7652__auto___18816 < len__7651__auto___18815)){
args__7658__auto__.push((arguments[i__7652__auto___18816]));

var G__18817 = (i__7652__auto___18816 + (1));
i__7652__auto___18816 = G__18817;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18812){
var map__18813 = p__18812;
var map__18813__$1 = ((((!((map__18813 == null)))?((((map__18813.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18813.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18813):map__18813);
var opts = map__18813__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18810){
var G__18811 = cljs.core.first.call(null,seq18810);
var seq18810__$1 = cljs.core.next.call(null,seq18810);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18811,seq18810__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args18818 = [];
var len__7651__auto___18868 = arguments.length;
var i__7652__auto___18869 = (0);
while(true){
if((i__7652__auto___18869 < len__7651__auto___18868)){
args18818.push((arguments[i__7652__auto___18869]));

var G__18870 = (i__7652__auto___18869 + (1));
i__7652__auto___18869 = G__18870;
continue;
} else {
}
break;
}

var G__18820 = args18818.length;
switch (G__18820) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18818.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__18705__auto___18872 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___18872){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___18872){
return (function (state_18844){
var state_val_18845 = (state_18844[(1)]);
if((state_val_18845 === (7))){
var inst_18840 = (state_18844[(2)]);
var state_18844__$1 = state_18844;
var statearr_18846_18873 = state_18844__$1;
(statearr_18846_18873[(2)] = inst_18840);

(statearr_18846_18873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (1))){
var state_18844__$1 = state_18844;
var statearr_18847_18874 = state_18844__$1;
(statearr_18847_18874[(2)] = null);

(statearr_18847_18874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (4))){
var inst_18823 = (state_18844[(7)]);
var inst_18823__$1 = (state_18844[(2)]);
var inst_18824 = (inst_18823__$1 == null);
var state_18844__$1 = (function (){var statearr_18848 = state_18844;
(statearr_18848[(7)] = inst_18823__$1);

return statearr_18848;
})();
if(cljs.core.truth_(inst_18824)){
var statearr_18849_18875 = state_18844__$1;
(statearr_18849_18875[(1)] = (5));

} else {
var statearr_18850_18876 = state_18844__$1;
(statearr_18850_18876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (13))){
var state_18844__$1 = state_18844;
var statearr_18851_18877 = state_18844__$1;
(statearr_18851_18877[(2)] = null);

(statearr_18851_18877[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (6))){
var inst_18823 = (state_18844[(7)]);
var state_18844__$1 = state_18844;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18844__$1,(11),to,inst_18823);
} else {
if((state_val_18845 === (3))){
var inst_18842 = (state_18844[(2)]);
var state_18844__$1 = state_18844;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18844__$1,inst_18842);
} else {
if((state_val_18845 === (12))){
var state_18844__$1 = state_18844;
var statearr_18852_18878 = state_18844__$1;
(statearr_18852_18878[(2)] = null);

(statearr_18852_18878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (2))){
var state_18844__$1 = state_18844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18844__$1,(4),from);
} else {
if((state_val_18845 === (11))){
var inst_18833 = (state_18844[(2)]);
var state_18844__$1 = state_18844;
if(cljs.core.truth_(inst_18833)){
var statearr_18853_18879 = state_18844__$1;
(statearr_18853_18879[(1)] = (12));

} else {
var statearr_18854_18880 = state_18844__$1;
(statearr_18854_18880[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (9))){
var state_18844__$1 = state_18844;
var statearr_18855_18881 = state_18844__$1;
(statearr_18855_18881[(2)] = null);

(statearr_18855_18881[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (5))){
var state_18844__$1 = state_18844;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18856_18882 = state_18844__$1;
(statearr_18856_18882[(1)] = (8));

} else {
var statearr_18857_18883 = state_18844__$1;
(statearr_18857_18883[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (14))){
var inst_18838 = (state_18844[(2)]);
var state_18844__$1 = state_18844;
var statearr_18858_18884 = state_18844__$1;
(statearr_18858_18884[(2)] = inst_18838);

(statearr_18858_18884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (10))){
var inst_18830 = (state_18844[(2)]);
var state_18844__$1 = state_18844;
var statearr_18859_18885 = state_18844__$1;
(statearr_18859_18885[(2)] = inst_18830);

(statearr_18859_18885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18845 === (8))){
var inst_18827 = cljs.core.async.close_BANG_.call(null,to);
var state_18844__$1 = state_18844;
var statearr_18860_18886 = state_18844__$1;
(statearr_18860_18886[(2)] = inst_18827);

(statearr_18860_18886[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___18872))
;
return ((function (switch__18593__auto__,c__18705__auto___18872){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_18864 = [null,null,null,null,null,null,null,null];
(statearr_18864[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_18864[(1)] = (1));

return statearr_18864;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_18844){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_18844);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e18865){if((e18865 instanceof Object)){
var ex__18597__auto__ = e18865;
var statearr_18866_18887 = state_18844;
(statearr_18866_18887[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18844);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18865;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18888 = state_18844;
state_18844 = G__18888;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_18844){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_18844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___18872))
})();
var state__18707__auto__ = (function (){var statearr_18867 = f__18706__auto__.call(null);
(statearr_18867[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___18872);

return statearr_18867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___18872))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19076){
var vec__19077 = p__19076;
var v = cljs.core.nth.call(null,vec__19077,(0),null);
var p = cljs.core.nth.call(null,vec__19077,(1),null);
var job = vec__19077;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__18705__auto___19263 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___19263,res,vec__19077,v,p,job,jobs,results){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___19263,res,vec__19077,v,p,job,jobs,results){
return (function (state_19084){
var state_val_19085 = (state_19084[(1)]);
if((state_val_19085 === (1))){
var state_19084__$1 = state_19084;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19084__$1,(2),res,v);
} else {
if((state_val_19085 === (2))){
var inst_19081 = (state_19084[(2)]);
var inst_19082 = cljs.core.async.close_BANG_.call(null,res);
var state_19084__$1 = (function (){var statearr_19086 = state_19084;
(statearr_19086[(7)] = inst_19081);

return statearr_19086;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19084__$1,inst_19082);
} else {
return null;
}
}
});})(c__18705__auto___19263,res,vec__19077,v,p,job,jobs,results))
;
return ((function (switch__18593__auto__,c__18705__auto___19263,res,vec__19077,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0 = (function (){
var statearr_19090 = [null,null,null,null,null,null,null,null];
(statearr_19090[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__);

(statearr_19090[(1)] = (1));

return statearr_19090;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1 = (function (state_19084){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19084);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e19091){if((e19091 instanceof Object)){
var ex__18597__auto__ = e19091;
var statearr_19092_19264 = state_19084;
(statearr_19092_19264[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19084);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19091;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19265 = state_19084;
state_19084 = G__19265;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = function(state_19084){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1.call(this,state_19084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___19263,res,vec__19077,v,p,job,jobs,results))
})();
var state__18707__auto__ = (function (){var statearr_19093 = f__18706__auto__.call(null);
(statearr_19093[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___19263);

return statearr_19093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___19263,res,vec__19077,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19094){
var vec__19095 = p__19094;
var v = cljs.core.nth.call(null,vec__19095,(0),null);
var p = cljs.core.nth.call(null,vec__19095,(1),null);
var job = vec__19095;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7461__auto___19266 = n;
var __19267 = (0);
while(true){
if((__19267 < n__7461__auto___19266)){
var G__19098_19268 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19098_19268) {
case "compute":
var c__18705__auto___19270 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19267,c__18705__auto___19270,G__19098_19268,n__7461__auto___19266,jobs,results,process,async){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (__19267,c__18705__auto___19270,G__19098_19268,n__7461__auto___19266,jobs,results,process,async){
return (function (state_19111){
var state_val_19112 = (state_19111[(1)]);
if((state_val_19112 === (1))){
var state_19111__$1 = state_19111;
var statearr_19113_19271 = state_19111__$1;
(statearr_19113_19271[(2)] = null);

(statearr_19113_19271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19112 === (2))){
var state_19111__$1 = state_19111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19111__$1,(4),jobs);
} else {
if((state_val_19112 === (3))){
var inst_19109 = (state_19111[(2)]);
var state_19111__$1 = state_19111;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19111__$1,inst_19109);
} else {
if((state_val_19112 === (4))){
var inst_19101 = (state_19111[(2)]);
var inst_19102 = process.call(null,inst_19101);
var state_19111__$1 = state_19111;
if(cljs.core.truth_(inst_19102)){
var statearr_19114_19272 = state_19111__$1;
(statearr_19114_19272[(1)] = (5));

} else {
var statearr_19115_19273 = state_19111__$1;
(statearr_19115_19273[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19112 === (5))){
var state_19111__$1 = state_19111;
var statearr_19116_19274 = state_19111__$1;
(statearr_19116_19274[(2)] = null);

(statearr_19116_19274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19112 === (6))){
var state_19111__$1 = state_19111;
var statearr_19117_19275 = state_19111__$1;
(statearr_19117_19275[(2)] = null);

(statearr_19117_19275[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19112 === (7))){
var inst_19107 = (state_19111[(2)]);
var state_19111__$1 = state_19111;
var statearr_19118_19276 = state_19111__$1;
(statearr_19118_19276[(2)] = inst_19107);

(statearr_19118_19276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19267,c__18705__auto___19270,G__19098_19268,n__7461__auto___19266,jobs,results,process,async))
;
return ((function (__19267,switch__18593__auto__,c__18705__auto___19270,G__19098_19268,n__7461__auto___19266,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0 = (function (){
var statearr_19122 = [null,null,null,null,null,null,null];
(statearr_19122[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__);

(statearr_19122[(1)] = (1));

return statearr_19122;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1 = (function (state_19111){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19111);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e19123){if((e19123 instanceof Object)){
var ex__18597__auto__ = e19123;
var statearr_19124_19277 = state_19111;
(statearr_19124_19277[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19111);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19123;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19278 = state_19111;
state_19111 = G__19278;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = function(state_19111){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1.call(this,state_19111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__;
})()
;})(__19267,switch__18593__auto__,c__18705__auto___19270,G__19098_19268,n__7461__auto___19266,jobs,results,process,async))
})();
var state__18707__auto__ = (function (){var statearr_19125 = f__18706__auto__.call(null);
(statearr_19125[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___19270);

return statearr_19125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(__19267,c__18705__auto___19270,G__19098_19268,n__7461__auto___19266,jobs,results,process,async))
);


break;
case "async":
var c__18705__auto___19279 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19267,c__18705__auto___19279,G__19098_19268,n__7461__auto___19266,jobs,results,process,async){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (__19267,c__18705__auto___19279,G__19098_19268,n__7461__auto___19266,jobs,results,process,async){
return (function (state_19138){
var state_val_19139 = (state_19138[(1)]);
if((state_val_19139 === (1))){
var state_19138__$1 = state_19138;
var statearr_19140_19280 = state_19138__$1;
(statearr_19140_19280[(2)] = null);

(statearr_19140_19280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19139 === (2))){
var state_19138__$1 = state_19138;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19138__$1,(4),jobs);
} else {
if((state_val_19139 === (3))){
var inst_19136 = (state_19138[(2)]);
var state_19138__$1 = state_19138;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19138__$1,inst_19136);
} else {
if((state_val_19139 === (4))){
var inst_19128 = (state_19138[(2)]);
var inst_19129 = async.call(null,inst_19128);
var state_19138__$1 = state_19138;
if(cljs.core.truth_(inst_19129)){
var statearr_19141_19281 = state_19138__$1;
(statearr_19141_19281[(1)] = (5));

} else {
var statearr_19142_19282 = state_19138__$1;
(statearr_19142_19282[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19139 === (5))){
var state_19138__$1 = state_19138;
var statearr_19143_19283 = state_19138__$1;
(statearr_19143_19283[(2)] = null);

(statearr_19143_19283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19139 === (6))){
var state_19138__$1 = state_19138;
var statearr_19144_19284 = state_19138__$1;
(statearr_19144_19284[(2)] = null);

(statearr_19144_19284[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19139 === (7))){
var inst_19134 = (state_19138[(2)]);
var state_19138__$1 = state_19138;
var statearr_19145_19285 = state_19138__$1;
(statearr_19145_19285[(2)] = inst_19134);

(statearr_19145_19285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19267,c__18705__auto___19279,G__19098_19268,n__7461__auto___19266,jobs,results,process,async))
;
return ((function (__19267,switch__18593__auto__,c__18705__auto___19279,G__19098_19268,n__7461__auto___19266,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0 = (function (){
var statearr_19149 = [null,null,null,null,null,null,null];
(statearr_19149[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__);

(statearr_19149[(1)] = (1));

return statearr_19149;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1 = (function (state_19138){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19138);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e19150){if((e19150 instanceof Object)){
var ex__18597__auto__ = e19150;
var statearr_19151_19286 = state_19138;
(statearr_19151_19286[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19138);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19150;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19287 = state_19138;
state_19138 = G__19287;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = function(state_19138){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1.call(this,state_19138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__;
})()
;})(__19267,switch__18593__auto__,c__18705__auto___19279,G__19098_19268,n__7461__auto___19266,jobs,results,process,async))
})();
var state__18707__auto__ = (function (){var statearr_19152 = f__18706__auto__.call(null);
(statearr_19152[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___19279);

return statearr_19152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(__19267,c__18705__auto___19279,G__19098_19268,n__7461__auto___19266,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19288 = (__19267 + (1));
__19267 = G__19288;
continue;
} else {
}
break;
}

var c__18705__auto___19289 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___19289,jobs,results,process,async){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___19289,jobs,results,process,async){
return (function (state_19174){
var state_val_19175 = (state_19174[(1)]);
if((state_val_19175 === (1))){
var state_19174__$1 = state_19174;
var statearr_19176_19290 = state_19174__$1;
(statearr_19176_19290[(2)] = null);

(statearr_19176_19290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19175 === (2))){
var state_19174__$1 = state_19174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19174__$1,(4),from);
} else {
if((state_val_19175 === (3))){
var inst_19172 = (state_19174[(2)]);
var state_19174__$1 = state_19174;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19174__$1,inst_19172);
} else {
if((state_val_19175 === (4))){
var inst_19155 = (state_19174[(7)]);
var inst_19155__$1 = (state_19174[(2)]);
var inst_19156 = (inst_19155__$1 == null);
var state_19174__$1 = (function (){var statearr_19177 = state_19174;
(statearr_19177[(7)] = inst_19155__$1);

return statearr_19177;
})();
if(cljs.core.truth_(inst_19156)){
var statearr_19178_19291 = state_19174__$1;
(statearr_19178_19291[(1)] = (5));

} else {
var statearr_19179_19292 = state_19174__$1;
(statearr_19179_19292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19175 === (5))){
var inst_19158 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19174__$1 = state_19174;
var statearr_19180_19293 = state_19174__$1;
(statearr_19180_19293[(2)] = inst_19158);

(statearr_19180_19293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19175 === (6))){
var inst_19155 = (state_19174[(7)]);
var inst_19160 = (state_19174[(8)]);
var inst_19160__$1 = cljs.core.async.chan.call(null,(1));
var inst_19161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19162 = [inst_19155,inst_19160__$1];
var inst_19163 = (new cljs.core.PersistentVector(null,2,(5),inst_19161,inst_19162,null));
var state_19174__$1 = (function (){var statearr_19181 = state_19174;
(statearr_19181[(8)] = inst_19160__$1);

return statearr_19181;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19174__$1,(8),jobs,inst_19163);
} else {
if((state_val_19175 === (7))){
var inst_19170 = (state_19174[(2)]);
var state_19174__$1 = state_19174;
var statearr_19182_19294 = state_19174__$1;
(statearr_19182_19294[(2)] = inst_19170);

(statearr_19182_19294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19175 === (8))){
var inst_19160 = (state_19174[(8)]);
var inst_19165 = (state_19174[(2)]);
var state_19174__$1 = (function (){var statearr_19183 = state_19174;
(statearr_19183[(9)] = inst_19165);

return statearr_19183;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19174__$1,(9),results,inst_19160);
} else {
if((state_val_19175 === (9))){
var inst_19167 = (state_19174[(2)]);
var state_19174__$1 = (function (){var statearr_19184 = state_19174;
(statearr_19184[(10)] = inst_19167);

return statearr_19184;
})();
var statearr_19185_19295 = state_19174__$1;
(statearr_19185_19295[(2)] = null);

(statearr_19185_19295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___19289,jobs,results,process,async))
;
return ((function (switch__18593__auto__,c__18705__auto___19289,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0 = (function (){
var statearr_19189 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19189[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__);

(statearr_19189[(1)] = (1));

return statearr_19189;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1 = (function (state_19174){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19174);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e19190){if((e19190 instanceof Object)){
var ex__18597__auto__ = e19190;
var statearr_19191_19296 = state_19174;
(statearr_19191_19296[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19174);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19190;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19297 = state_19174;
state_19174 = G__19297;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = function(state_19174){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1.call(this,state_19174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___19289,jobs,results,process,async))
})();
var state__18707__auto__ = (function (){var statearr_19192 = f__18706__auto__.call(null);
(statearr_19192[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___19289);

return statearr_19192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___19289,jobs,results,process,async))
);


var c__18705__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto__,jobs,results,process,async){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto__,jobs,results,process,async){
return (function (state_19230){
var state_val_19231 = (state_19230[(1)]);
if((state_val_19231 === (7))){
var inst_19226 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
var statearr_19232_19298 = state_19230__$1;
(statearr_19232_19298[(2)] = inst_19226);

(statearr_19232_19298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (20))){
var state_19230__$1 = state_19230;
var statearr_19233_19299 = state_19230__$1;
(statearr_19233_19299[(2)] = null);

(statearr_19233_19299[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (1))){
var state_19230__$1 = state_19230;
var statearr_19234_19300 = state_19230__$1;
(statearr_19234_19300[(2)] = null);

(statearr_19234_19300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (4))){
var inst_19195 = (state_19230[(7)]);
var inst_19195__$1 = (state_19230[(2)]);
var inst_19196 = (inst_19195__$1 == null);
var state_19230__$1 = (function (){var statearr_19235 = state_19230;
(statearr_19235[(7)] = inst_19195__$1);

return statearr_19235;
})();
if(cljs.core.truth_(inst_19196)){
var statearr_19236_19301 = state_19230__$1;
(statearr_19236_19301[(1)] = (5));

} else {
var statearr_19237_19302 = state_19230__$1;
(statearr_19237_19302[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (15))){
var inst_19208 = (state_19230[(8)]);
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19230__$1,(18),to,inst_19208);
} else {
if((state_val_19231 === (21))){
var inst_19221 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
var statearr_19238_19303 = state_19230__$1;
(statearr_19238_19303[(2)] = inst_19221);

(statearr_19238_19303[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (13))){
var inst_19223 = (state_19230[(2)]);
var state_19230__$1 = (function (){var statearr_19239 = state_19230;
(statearr_19239[(9)] = inst_19223);

return statearr_19239;
})();
var statearr_19240_19304 = state_19230__$1;
(statearr_19240_19304[(2)] = null);

(statearr_19240_19304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (6))){
var inst_19195 = (state_19230[(7)]);
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19230__$1,(11),inst_19195);
} else {
if((state_val_19231 === (17))){
var inst_19216 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
if(cljs.core.truth_(inst_19216)){
var statearr_19241_19305 = state_19230__$1;
(statearr_19241_19305[(1)] = (19));

} else {
var statearr_19242_19306 = state_19230__$1;
(statearr_19242_19306[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (3))){
var inst_19228 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19230__$1,inst_19228);
} else {
if((state_val_19231 === (12))){
var inst_19205 = (state_19230[(10)]);
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19230__$1,(14),inst_19205);
} else {
if((state_val_19231 === (2))){
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19230__$1,(4),results);
} else {
if((state_val_19231 === (19))){
var state_19230__$1 = state_19230;
var statearr_19243_19307 = state_19230__$1;
(statearr_19243_19307[(2)] = null);

(statearr_19243_19307[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (11))){
var inst_19205 = (state_19230[(2)]);
var state_19230__$1 = (function (){var statearr_19244 = state_19230;
(statearr_19244[(10)] = inst_19205);

return statearr_19244;
})();
var statearr_19245_19308 = state_19230__$1;
(statearr_19245_19308[(2)] = null);

(statearr_19245_19308[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (9))){
var state_19230__$1 = state_19230;
var statearr_19246_19309 = state_19230__$1;
(statearr_19246_19309[(2)] = null);

(statearr_19246_19309[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (5))){
var state_19230__$1 = state_19230;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19247_19310 = state_19230__$1;
(statearr_19247_19310[(1)] = (8));

} else {
var statearr_19248_19311 = state_19230__$1;
(statearr_19248_19311[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (14))){
var inst_19210 = (state_19230[(11)]);
var inst_19208 = (state_19230[(8)]);
var inst_19208__$1 = (state_19230[(2)]);
var inst_19209 = (inst_19208__$1 == null);
var inst_19210__$1 = cljs.core.not.call(null,inst_19209);
var state_19230__$1 = (function (){var statearr_19249 = state_19230;
(statearr_19249[(11)] = inst_19210__$1);

(statearr_19249[(8)] = inst_19208__$1);

return statearr_19249;
})();
if(inst_19210__$1){
var statearr_19250_19312 = state_19230__$1;
(statearr_19250_19312[(1)] = (15));

} else {
var statearr_19251_19313 = state_19230__$1;
(statearr_19251_19313[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (16))){
var inst_19210 = (state_19230[(11)]);
var state_19230__$1 = state_19230;
var statearr_19252_19314 = state_19230__$1;
(statearr_19252_19314[(2)] = inst_19210);

(statearr_19252_19314[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (10))){
var inst_19202 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
var statearr_19253_19315 = state_19230__$1;
(statearr_19253_19315[(2)] = inst_19202);

(statearr_19253_19315[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (18))){
var inst_19213 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
var statearr_19254_19316 = state_19230__$1;
(statearr_19254_19316[(2)] = inst_19213);

(statearr_19254_19316[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (8))){
var inst_19199 = cljs.core.async.close_BANG_.call(null,to);
var state_19230__$1 = state_19230;
var statearr_19255_19317 = state_19230__$1;
(statearr_19255_19317[(2)] = inst_19199);

(statearr_19255_19317[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto__,jobs,results,process,async))
;
return ((function (switch__18593__auto__,c__18705__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0 = (function (){
var statearr_19259 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19259[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__);

(statearr_19259[(1)] = (1));

return statearr_19259;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1 = (function (state_19230){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e19260){if((e19260 instanceof Object)){
var ex__18597__auto__ = e19260;
var statearr_19261_19318 = state_19230;
(statearr_19261_19318[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19230);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19260;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19319 = state_19230;
state_19230 = G__19319;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__ = function(state_19230){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1.call(this,state_19230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18594__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto__,jobs,results,process,async))
})();
var state__18707__auto__ = (function (){var statearr_19262 = f__18706__auto__.call(null);
(statearr_19262[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto__);

return statearr_19262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto__,jobs,results,process,async))
);

return c__18705__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19320 = [];
var len__7651__auto___19323 = arguments.length;
var i__7652__auto___19324 = (0);
while(true){
if((i__7652__auto___19324 < len__7651__auto___19323)){
args19320.push((arguments[i__7652__auto___19324]));

var G__19325 = (i__7652__auto___19324 + (1));
i__7652__auto___19324 = G__19325;
continue;
} else {
}
break;
}

var G__19322 = args19320.length;
switch (G__19322) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19320.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19327 = [];
var len__7651__auto___19330 = arguments.length;
var i__7652__auto___19331 = (0);
while(true){
if((i__7652__auto___19331 < len__7651__auto___19330)){
args19327.push((arguments[i__7652__auto___19331]));

var G__19332 = (i__7652__auto___19331 + (1));
i__7652__auto___19331 = G__19332;
continue;
} else {
}
break;
}

var G__19329 = args19327.length;
switch (G__19329) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19327.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19334 = [];
var len__7651__auto___19387 = arguments.length;
var i__7652__auto___19388 = (0);
while(true){
if((i__7652__auto___19388 < len__7651__auto___19387)){
args19334.push((arguments[i__7652__auto___19388]));

var G__19389 = (i__7652__auto___19388 + (1));
i__7652__auto___19388 = G__19389;
continue;
} else {
}
break;
}

var G__19336 = args19334.length;
switch (G__19336) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19334.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__18705__auto___19391 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___19391,tc,fc){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___19391,tc,fc){
return (function (state_19362){
var state_val_19363 = (state_19362[(1)]);
if((state_val_19363 === (7))){
var inst_19358 = (state_19362[(2)]);
var state_19362__$1 = state_19362;
var statearr_19364_19392 = state_19362__$1;
(statearr_19364_19392[(2)] = inst_19358);

(statearr_19364_19392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (1))){
var state_19362__$1 = state_19362;
var statearr_19365_19393 = state_19362__$1;
(statearr_19365_19393[(2)] = null);

(statearr_19365_19393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (4))){
var inst_19339 = (state_19362[(7)]);
var inst_19339__$1 = (state_19362[(2)]);
var inst_19340 = (inst_19339__$1 == null);
var state_19362__$1 = (function (){var statearr_19366 = state_19362;
(statearr_19366[(7)] = inst_19339__$1);

return statearr_19366;
})();
if(cljs.core.truth_(inst_19340)){
var statearr_19367_19394 = state_19362__$1;
(statearr_19367_19394[(1)] = (5));

} else {
var statearr_19368_19395 = state_19362__$1;
(statearr_19368_19395[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (13))){
var state_19362__$1 = state_19362;
var statearr_19369_19396 = state_19362__$1;
(statearr_19369_19396[(2)] = null);

(statearr_19369_19396[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (6))){
var inst_19339 = (state_19362[(7)]);
var inst_19345 = p.call(null,inst_19339);
var state_19362__$1 = state_19362;
if(cljs.core.truth_(inst_19345)){
var statearr_19370_19397 = state_19362__$1;
(statearr_19370_19397[(1)] = (9));

} else {
var statearr_19371_19398 = state_19362__$1;
(statearr_19371_19398[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (3))){
var inst_19360 = (state_19362[(2)]);
var state_19362__$1 = state_19362;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19362__$1,inst_19360);
} else {
if((state_val_19363 === (12))){
var state_19362__$1 = state_19362;
var statearr_19372_19399 = state_19362__$1;
(statearr_19372_19399[(2)] = null);

(statearr_19372_19399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (2))){
var state_19362__$1 = state_19362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19362__$1,(4),ch);
} else {
if((state_val_19363 === (11))){
var inst_19339 = (state_19362[(7)]);
var inst_19349 = (state_19362[(2)]);
var state_19362__$1 = state_19362;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19362__$1,(8),inst_19349,inst_19339);
} else {
if((state_val_19363 === (9))){
var state_19362__$1 = state_19362;
var statearr_19373_19400 = state_19362__$1;
(statearr_19373_19400[(2)] = tc);

(statearr_19373_19400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (5))){
var inst_19342 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19343 = cljs.core.async.close_BANG_.call(null,fc);
var state_19362__$1 = (function (){var statearr_19374 = state_19362;
(statearr_19374[(8)] = inst_19342);

return statearr_19374;
})();
var statearr_19375_19401 = state_19362__$1;
(statearr_19375_19401[(2)] = inst_19343);

(statearr_19375_19401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (14))){
var inst_19356 = (state_19362[(2)]);
var state_19362__$1 = state_19362;
var statearr_19376_19402 = state_19362__$1;
(statearr_19376_19402[(2)] = inst_19356);

(statearr_19376_19402[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (10))){
var state_19362__$1 = state_19362;
var statearr_19377_19403 = state_19362__$1;
(statearr_19377_19403[(2)] = fc);

(statearr_19377_19403[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19363 === (8))){
var inst_19351 = (state_19362[(2)]);
var state_19362__$1 = state_19362;
if(cljs.core.truth_(inst_19351)){
var statearr_19378_19404 = state_19362__$1;
(statearr_19378_19404[(1)] = (12));

} else {
var statearr_19379_19405 = state_19362__$1;
(statearr_19379_19405[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___19391,tc,fc))
;
return ((function (switch__18593__auto__,c__18705__auto___19391,tc,fc){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_19383 = [null,null,null,null,null,null,null,null,null];
(statearr_19383[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_19383[(1)] = (1));

return statearr_19383;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_19362){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e19384){if((e19384 instanceof Object)){
var ex__18597__auto__ = e19384;
var statearr_19385_19406 = state_19362;
(statearr_19385_19406[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19384;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19407 = state_19362;
state_19362 = G__19407;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_19362){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_19362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___19391,tc,fc))
})();
var state__18707__auto__ = (function (){var statearr_19386 = f__18706__auto__.call(null);
(statearr_19386[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___19391);

return statearr_19386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___19391,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__18705__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto__){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto__){
return (function (state_19471){
var state_val_19472 = (state_19471[(1)]);
if((state_val_19472 === (7))){
var inst_19467 = (state_19471[(2)]);
var state_19471__$1 = state_19471;
var statearr_19473_19494 = state_19471__$1;
(statearr_19473_19494[(2)] = inst_19467);

(statearr_19473_19494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19472 === (1))){
var inst_19451 = init;
var state_19471__$1 = (function (){var statearr_19474 = state_19471;
(statearr_19474[(7)] = inst_19451);

return statearr_19474;
})();
var statearr_19475_19495 = state_19471__$1;
(statearr_19475_19495[(2)] = null);

(statearr_19475_19495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19472 === (4))){
var inst_19454 = (state_19471[(8)]);
var inst_19454__$1 = (state_19471[(2)]);
var inst_19455 = (inst_19454__$1 == null);
var state_19471__$1 = (function (){var statearr_19476 = state_19471;
(statearr_19476[(8)] = inst_19454__$1);

return statearr_19476;
})();
if(cljs.core.truth_(inst_19455)){
var statearr_19477_19496 = state_19471__$1;
(statearr_19477_19496[(1)] = (5));

} else {
var statearr_19478_19497 = state_19471__$1;
(statearr_19478_19497[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19472 === (6))){
var inst_19454 = (state_19471[(8)]);
var inst_19451 = (state_19471[(7)]);
var inst_19458 = (state_19471[(9)]);
var inst_19458__$1 = f.call(null,inst_19451,inst_19454);
var inst_19459 = cljs.core.reduced_QMARK_.call(null,inst_19458__$1);
var state_19471__$1 = (function (){var statearr_19479 = state_19471;
(statearr_19479[(9)] = inst_19458__$1);

return statearr_19479;
})();
if(inst_19459){
var statearr_19480_19498 = state_19471__$1;
(statearr_19480_19498[(1)] = (8));

} else {
var statearr_19481_19499 = state_19471__$1;
(statearr_19481_19499[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19472 === (3))){
var inst_19469 = (state_19471[(2)]);
var state_19471__$1 = state_19471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19471__$1,inst_19469);
} else {
if((state_val_19472 === (2))){
var state_19471__$1 = state_19471;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19471__$1,(4),ch);
} else {
if((state_val_19472 === (9))){
var inst_19458 = (state_19471[(9)]);
var inst_19451 = inst_19458;
var state_19471__$1 = (function (){var statearr_19482 = state_19471;
(statearr_19482[(7)] = inst_19451);

return statearr_19482;
})();
var statearr_19483_19500 = state_19471__$1;
(statearr_19483_19500[(2)] = null);

(statearr_19483_19500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19472 === (5))){
var inst_19451 = (state_19471[(7)]);
var state_19471__$1 = state_19471;
var statearr_19484_19501 = state_19471__$1;
(statearr_19484_19501[(2)] = inst_19451);

(statearr_19484_19501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19472 === (10))){
var inst_19465 = (state_19471[(2)]);
var state_19471__$1 = state_19471;
var statearr_19485_19502 = state_19471__$1;
(statearr_19485_19502[(2)] = inst_19465);

(statearr_19485_19502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19472 === (8))){
var inst_19458 = (state_19471[(9)]);
var inst_19461 = cljs.core.deref.call(null,inst_19458);
var state_19471__$1 = state_19471;
var statearr_19486_19503 = state_19471__$1;
(statearr_19486_19503[(2)] = inst_19461);

(statearr_19486_19503[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto__))
;
return ((function (switch__18593__auto__,c__18705__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__18594__auto__ = null;
var cljs$core$async$reduce_$_state_machine__18594__auto____0 = (function (){
var statearr_19490 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19490[(0)] = cljs$core$async$reduce_$_state_machine__18594__auto__);

(statearr_19490[(1)] = (1));

return statearr_19490;
});
var cljs$core$async$reduce_$_state_machine__18594__auto____1 = (function (state_19471){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e19491){if((e19491 instanceof Object)){
var ex__18597__auto__ = e19491;
var statearr_19492_19504 = state_19471;
(statearr_19492_19504[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19471);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19491;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19505 = state_19471;
state_19471 = G__19505;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__18594__auto__ = function(state_19471){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__18594__auto____1.call(this,state_19471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__18594__auto____0;
cljs$core$async$reduce_$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__18594__auto____1;
return cljs$core$async$reduce_$_state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto__))
})();
var state__18707__auto__ = (function (){var statearr_19493 = f__18706__auto__.call(null);
(statearr_19493[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto__);

return statearr_19493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto__))
);

return c__18705__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19506 = [];
var len__7651__auto___19558 = arguments.length;
var i__7652__auto___19559 = (0);
while(true){
if((i__7652__auto___19559 < len__7651__auto___19558)){
args19506.push((arguments[i__7652__auto___19559]));

var G__19560 = (i__7652__auto___19559 + (1));
i__7652__auto___19559 = G__19560;
continue;
} else {
}
break;
}

var G__19508 = args19506.length;
switch (G__19508) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19506.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__18705__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto__){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto__){
return (function (state_19533){
var state_val_19534 = (state_19533[(1)]);
if((state_val_19534 === (7))){
var inst_19515 = (state_19533[(2)]);
var state_19533__$1 = state_19533;
var statearr_19535_19562 = state_19533__$1;
(statearr_19535_19562[(2)] = inst_19515);

(statearr_19535_19562[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (1))){
var inst_19509 = cljs.core.seq.call(null,coll);
var inst_19510 = inst_19509;
var state_19533__$1 = (function (){var statearr_19536 = state_19533;
(statearr_19536[(7)] = inst_19510);

return statearr_19536;
})();
var statearr_19537_19563 = state_19533__$1;
(statearr_19537_19563[(2)] = null);

(statearr_19537_19563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (4))){
var inst_19510 = (state_19533[(7)]);
var inst_19513 = cljs.core.first.call(null,inst_19510);
var state_19533__$1 = state_19533;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19533__$1,(7),ch,inst_19513);
} else {
if((state_val_19534 === (13))){
var inst_19527 = (state_19533[(2)]);
var state_19533__$1 = state_19533;
var statearr_19538_19564 = state_19533__$1;
(statearr_19538_19564[(2)] = inst_19527);

(statearr_19538_19564[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (6))){
var inst_19518 = (state_19533[(2)]);
var state_19533__$1 = state_19533;
if(cljs.core.truth_(inst_19518)){
var statearr_19539_19565 = state_19533__$1;
(statearr_19539_19565[(1)] = (8));

} else {
var statearr_19540_19566 = state_19533__$1;
(statearr_19540_19566[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (3))){
var inst_19531 = (state_19533[(2)]);
var state_19533__$1 = state_19533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19533__$1,inst_19531);
} else {
if((state_val_19534 === (12))){
var state_19533__$1 = state_19533;
var statearr_19541_19567 = state_19533__$1;
(statearr_19541_19567[(2)] = null);

(statearr_19541_19567[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (2))){
var inst_19510 = (state_19533[(7)]);
var state_19533__$1 = state_19533;
if(cljs.core.truth_(inst_19510)){
var statearr_19542_19568 = state_19533__$1;
(statearr_19542_19568[(1)] = (4));

} else {
var statearr_19543_19569 = state_19533__$1;
(statearr_19543_19569[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (11))){
var inst_19524 = cljs.core.async.close_BANG_.call(null,ch);
var state_19533__$1 = state_19533;
var statearr_19544_19570 = state_19533__$1;
(statearr_19544_19570[(2)] = inst_19524);

(statearr_19544_19570[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (9))){
var state_19533__$1 = state_19533;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19545_19571 = state_19533__$1;
(statearr_19545_19571[(1)] = (11));

} else {
var statearr_19546_19572 = state_19533__$1;
(statearr_19546_19572[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (5))){
var inst_19510 = (state_19533[(7)]);
var state_19533__$1 = state_19533;
var statearr_19547_19573 = state_19533__$1;
(statearr_19547_19573[(2)] = inst_19510);

(statearr_19547_19573[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (10))){
var inst_19529 = (state_19533[(2)]);
var state_19533__$1 = state_19533;
var statearr_19548_19574 = state_19533__$1;
(statearr_19548_19574[(2)] = inst_19529);

(statearr_19548_19574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19534 === (8))){
var inst_19510 = (state_19533[(7)]);
var inst_19520 = cljs.core.next.call(null,inst_19510);
var inst_19510__$1 = inst_19520;
var state_19533__$1 = (function (){var statearr_19549 = state_19533;
(statearr_19549[(7)] = inst_19510__$1);

return statearr_19549;
})();
var statearr_19550_19575 = state_19533__$1;
(statearr_19550_19575[(2)] = null);

(statearr_19550_19575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto__))
;
return ((function (switch__18593__auto__,c__18705__auto__){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_19554 = [null,null,null,null,null,null,null,null];
(statearr_19554[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_19554[(1)] = (1));

return statearr_19554;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_19533){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e19555){if((e19555 instanceof Object)){
var ex__18597__auto__ = e19555;
var statearr_19556_19576 = state_19533;
(statearr_19556_19576[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19533);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19555;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19577 = state_19533;
state_19533 = G__19577;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_19533){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_19533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto__))
})();
var state__18707__auto__ = (function (){var statearr_19557 = f__18706__auto__.call(null);
(statearr_19557[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto__);

return statearr_19557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto__))
);

return c__18705__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7206__auto__ = (((_ == null))?null:_);
var m__7207__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,_);
} else {
var m__7207__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7207__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,ch);
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m);
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19803 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19803 = (function (ch,cs,meta19804){
this.ch = ch;
this.cs = cs;
this.meta19804 = meta19804;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19803.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_19805,meta19804__$1){
var self__ = this;
var _19805__$1 = this;
return (new cljs.core.async.t_cljs$core$async19803(self__.ch,self__.cs,meta19804__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async19803.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_19805){
var self__ = this;
var _19805__$1 = this;
return self__.meta19804;
});})(cs))
;

cljs.core.async.t_cljs$core$async19803.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19803.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async19803.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19803.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19803.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19803.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19803.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta19804","meta19804",-1825695730,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async19803.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19803.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19803";

cljs.core.async.t_cljs$core$async19803.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async19803");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async19803 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async19803(ch__$1,cs__$1,meta19804){
return (new cljs.core.async.t_cljs$core$async19803(ch__$1,cs__$1,meta19804));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async19803(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__18705__auto___20028 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___20028,cs,m,dchan,dctr,done){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___20028,cs,m,dchan,dctr,done){
return (function (state_19940){
var state_val_19941 = (state_19940[(1)]);
if((state_val_19941 === (7))){
var inst_19936 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_19942_20029 = state_19940__$1;
(statearr_19942_20029[(2)] = inst_19936);

(statearr_19942_20029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (20))){
var inst_19839 = (state_19940[(7)]);
var inst_19851 = cljs.core.first.call(null,inst_19839);
var inst_19852 = cljs.core.nth.call(null,inst_19851,(0),null);
var inst_19853 = cljs.core.nth.call(null,inst_19851,(1),null);
var state_19940__$1 = (function (){var statearr_19943 = state_19940;
(statearr_19943[(8)] = inst_19852);

return statearr_19943;
})();
if(cljs.core.truth_(inst_19853)){
var statearr_19944_20030 = state_19940__$1;
(statearr_19944_20030[(1)] = (22));

} else {
var statearr_19945_20031 = state_19940__$1;
(statearr_19945_20031[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (27))){
var inst_19883 = (state_19940[(9)]);
var inst_19881 = (state_19940[(10)]);
var inst_19888 = (state_19940[(11)]);
var inst_19808 = (state_19940[(12)]);
var inst_19888__$1 = cljs.core._nth.call(null,inst_19881,inst_19883);
var inst_19889 = cljs.core.async.put_BANG_.call(null,inst_19888__$1,inst_19808,done);
var state_19940__$1 = (function (){var statearr_19946 = state_19940;
(statearr_19946[(11)] = inst_19888__$1);

return statearr_19946;
})();
if(cljs.core.truth_(inst_19889)){
var statearr_19947_20032 = state_19940__$1;
(statearr_19947_20032[(1)] = (30));

} else {
var statearr_19948_20033 = state_19940__$1;
(statearr_19948_20033[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (1))){
var state_19940__$1 = state_19940;
var statearr_19949_20034 = state_19940__$1;
(statearr_19949_20034[(2)] = null);

(statearr_19949_20034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (24))){
var inst_19839 = (state_19940[(7)]);
var inst_19858 = (state_19940[(2)]);
var inst_19859 = cljs.core.next.call(null,inst_19839);
var inst_19817 = inst_19859;
var inst_19818 = null;
var inst_19819 = (0);
var inst_19820 = (0);
var state_19940__$1 = (function (){var statearr_19950 = state_19940;
(statearr_19950[(13)] = inst_19818);

(statearr_19950[(14)] = inst_19820);

(statearr_19950[(15)] = inst_19858);

(statearr_19950[(16)] = inst_19819);

(statearr_19950[(17)] = inst_19817);

return statearr_19950;
})();
var statearr_19951_20035 = state_19940__$1;
(statearr_19951_20035[(2)] = null);

(statearr_19951_20035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (39))){
var state_19940__$1 = state_19940;
var statearr_19955_20036 = state_19940__$1;
(statearr_19955_20036[(2)] = null);

(statearr_19955_20036[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (4))){
var inst_19808 = (state_19940[(12)]);
var inst_19808__$1 = (state_19940[(2)]);
var inst_19809 = (inst_19808__$1 == null);
var state_19940__$1 = (function (){var statearr_19956 = state_19940;
(statearr_19956[(12)] = inst_19808__$1);

return statearr_19956;
})();
if(cljs.core.truth_(inst_19809)){
var statearr_19957_20037 = state_19940__$1;
(statearr_19957_20037[(1)] = (5));

} else {
var statearr_19958_20038 = state_19940__$1;
(statearr_19958_20038[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (15))){
var inst_19818 = (state_19940[(13)]);
var inst_19820 = (state_19940[(14)]);
var inst_19819 = (state_19940[(16)]);
var inst_19817 = (state_19940[(17)]);
var inst_19835 = (state_19940[(2)]);
var inst_19836 = (inst_19820 + (1));
var tmp19952 = inst_19818;
var tmp19953 = inst_19819;
var tmp19954 = inst_19817;
var inst_19817__$1 = tmp19954;
var inst_19818__$1 = tmp19952;
var inst_19819__$1 = tmp19953;
var inst_19820__$1 = inst_19836;
var state_19940__$1 = (function (){var statearr_19959 = state_19940;
(statearr_19959[(13)] = inst_19818__$1);

(statearr_19959[(14)] = inst_19820__$1);

(statearr_19959[(18)] = inst_19835);

(statearr_19959[(16)] = inst_19819__$1);

(statearr_19959[(17)] = inst_19817__$1);

return statearr_19959;
})();
var statearr_19960_20039 = state_19940__$1;
(statearr_19960_20039[(2)] = null);

(statearr_19960_20039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (21))){
var inst_19862 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_19964_20040 = state_19940__$1;
(statearr_19964_20040[(2)] = inst_19862);

(statearr_19964_20040[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (31))){
var inst_19888 = (state_19940[(11)]);
var inst_19892 = done.call(null,null);
var inst_19893 = cljs.core.async.untap_STAR_.call(null,m,inst_19888);
var state_19940__$1 = (function (){var statearr_19965 = state_19940;
(statearr_19965[(19)] = inst_19892);

return statearr_19965;
})();
var statearr_19966_20041 = state_19940__$1;
(statearr_19966_20041[(2)] = inst_19893);

(statearr_19966_20041[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (32))){
var inst_19883 = (state_19940[(9)]);
var inst_19881 = (state_19940[(10)]);
var inst_19880 = (state_19940[(20)]);
var inst_19882 = (state_19940[(21)]);
var inst_19895 = (state_19940[(2)]);
var inst_19896 = (inst_19883 + (1));
var tmp19961 = inst_19881;
var tmp19962 = inst_19880;
var tmp19963 = inst_19882;
var inst_19880__$1 = tmp19962;
var inst_19881__$1 = tmp19961;
var inst_19882__$1 = tmp19963;
var inst_19883__$1 = inst_19896;
var state_19940__$1 = (function (){var statearr_19967 = state_19940;
(statearr_19967[(9)] = inst_19883__$1);

(statearr_19967[(10)] = inst_19881__$1);

(statearr_19967[(22)] = inst_19895);

(statearr_19967[(20)] = inst_19880__$1);

(statearr_19967[(21)] = inst_19882__$1);

return statearr_19967;
})();
var statearr_19968_20042 = state_19940__$1;
(statearr_19968_20042[(2)] = null);

(statearr_19968_20042[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (40))){
var inst_19908 = (state_19940[(23)]);
var inst_19912 = done.call(null,null);
var inst_19913 = cljs.core.async.untap_STAR_.call(null,m,inst_19908);
var state_19940__$1 = (function (){var statearr_19969 = state_19940;
(statearr_19969[(24)] = inst_19912);

return statearr_19969;
})();
var statearr_19970_20043 = state_19940__$1;
(statearr_19970_20043[(2)] = inst_19913);

(statearr_19970_20043[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (33))){
var inst_19899 = (state_19940[(25)]);
var inst_19901 = cljs.core.chunked_seq_QMARK_.call(null,inst_19899);
var state_19940__$1 = state_19940;
if(inst_19901){
var statearr_19971_20044 = state_19940__$1;
(statearr_19971_20044[(1)] = (36));

} else {
var statearr_19972_20045 = state_19940__$1;
(statearr_19972_20045[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (13))){
var inst_19829 = (state_19940[(26)]);
var inst_19832 = cljs.core.async.close_BANG_.call(null,inst_19829);
var state_19940__$1 = state_19940;
var statearr_19973_20046 = state_19940__$1;
(statearr_19973_20046[(2)] = inst_19832);

(statearr_19973_20046[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (22))){
var inst_19852 = (state_19940[(8)]);
var inst_19855 = cljs.core.async.close_BANG_.call(null,inst_19852);
var state_19940__$1 = state_19940;
var statearr_19974_20047 = state_19940__$1;
(statearr_19974_20047[(2)] = inst_19855);

(statearr_19974_20047[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (36))){
var inst_19899 = (state_19940[(25)]);
var inst_19903 = cljs.core.chunk_first.call(null,inst_19899);
var inst_19904 = cljs.core.chunk_rest.call(null,inst_19899);
var inst_19905 = cljs.core.count.call(null,inst_19903);
var inst_19880 = inst_19904;
var inst_19881 = inst_19903;
var inst_19882 = inst_19905;
var inst_19883 = (0);
var state_19940__$1 = (function (){var statearr_19975 = state_19940;
(statearr_19975[(9)] = inst_19883);

(statearr_19975[(10)] = inst_19881);

(statearr_19975[(20)] = inst_19880);

(statearr_19975[(21)] = inst_19882);

return statearr_19975;
})();
var statearr_19976_20048 = state_19940__$1;
(statearr_19976_20048[(2)] = null);

(statearr_19976_20048[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (41))){
var inst_19899 = (state_19940[(25)]);
var inst_19915 = (state_19940[(2)]);
var inst_19916 = cljs.core.next.call(null,inst_19899);
var inst_19880 = inst_19916;
var inst_19881 = null;
var inst_19882 = (0);
var inst_19883 = (0);
var state_19940__$1 = (function (){var statearr_19977 = state_19940;
(statearr_19977[(9)] = inst_19883);

(statearr_19977[(10)] = inst_19881);

(statearr_19977[(20)] = inst_19880);

(statearr_19977[(21)] = inst_19882);

(statearr_19977[(27)] = inst_19915);

return statearr_19977;
})();
var statearr_19978_20049 = state_19940__$1;
(statearr_19978_20049[(2)] = null);

(statearr_19978_20049[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (43))){
var state_19940__$1 = state_19940;
var statearr_19979_20050 = state_19940__$1;
(statearr_19979_20050[(2)] = null);

(statearr_19979_20050[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (29))){
var inst_19924 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_19980_20051 = state_19940__$1;
(statearr_19980_20051[(2)] = inst_19924);

(statearr_19980_20051[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (44))){
var inst_19933 = (state_19940[(2)]);
var state_19940__$1 = (function (){var statearr_19981 = state_19940;
(statearr_19981[(28)] = inst_19933);

return statearr_19981;
})();
var statearr_19982_20052 = state_19940__$1;
(statearr_19982_20052[(2)] = null);

(statearr_19982_20052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (6))){
var inst_19872 = (state_19940[(29)]);
var inst_19871 = cljs.core.deref.call(null,cs);
var inst_19872__$1 = cljs.core.keys.call(null,inst_19871);
var inst_19873 = cljs.core.count.call(null,inst_19872__$1);
var inst_19874 = cljs.core.reset_BANG_.call(null,dctr,inst_19873);
var inst_19879 = cljs.core.seq.call(null,inst_19872__$1);
var inst_19880 = inst_19879;
var inst_19881 = null;
var inst_19882 = (0);
var inst_19883 = (0);
var state_19940__$1 = (function (){var statearr_19983 = state_19940;
(statearr_19983[(9)] = inst_19883);

(statearr_19983[(10)] = inst_19881);

(statearr_19983[(20)] = inst_19880);

(statearr_19983[(21)] = inst_19882);

(statearr_19983[(30)] = inst_19874);

(statearr_19983[(29)] = inst_19872__$1);

return statearr_19983;
})();
var statearr_19984_20053 = state_19940__$1;
(statearr_19984_20053[(2)] = null);

(statearr_19984_20053[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (28))){
var inst_19880 = (state_19940[(20)]);
var inst_19899 = (state_19940[(25)]);
var inst_19899__$1 = cljs.core.seq.call(null,inst_19880);
var state_19940__$1 = (function (){var statearr_19985 = state_19940;
(statearr_19985[(25)] = inst_19899__$1);

return statearr_19985;
})();
if(inst_19899__$1){
var statearr_19986_20054 = state_19940__$1;
(statearr_19986_20054[(1)] = (33));

} else {
var statearr_19987_20055 = state_19940__$1;
(statearr_19987_20055[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (25))){
var inst_19883 = (state_19940[(9)]);
var inst_19882 = (state_19940[(21)]);
var inst_19885 = (inst_19883 < inst_19882);
var inst_19886 = inst_19885;
var state_19940__$1 = state_19940;
if(cljs.core.truth_(inst_19886)){
var statearr_19988_20056 = state_19940__$1;
(statearr_19988_20056[(1)] = (27));

} else {
var statearr_19989_20057 = state_19940__$1;
(statearr_19989_20057[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (34))){
var state_19940__$1 = state_19940;
var statearr_19990_20058 = state_19940__$1;
(statearr_19990_20058[(2)] = null);

(statearr_19990_20058[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (17))){
var state_19940__$1 = state_19940;
var statearr_19991_20059 = state_19940__$1;
(statearr_19991_20059[(2)] = null);

(statearr_19991_20059[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (3))){
var inst_19938 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19940__$1,inst_19938);
} else {
if((state_val_19941 === (12))){
var inst_19867 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_19992_20060 = state_19940__$1;
(statearr_19992_20060[(2)] = inst_19867);

(statearr_19992_20060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (2))){
var state_19940__$1 = state_19940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19940__$1,(4),ch);
} else {
if((state_val_19941 === (23))){
var state_19940__$1 = state_19940;
var statearr_19993_20061 = state_19940__$1;
(statearr_19993_20061[(2)] = null);

(statearr_19993_20061[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (35))){
var inst_19922 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_19994_20062 = state_19940__$1;
(statearr_19994_20062[(2)] = inst_19922);

(statearr_19994_20062[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (19))){
var inst_19839 = (state_19940[(7)]);
var inst_19843 = cljs.core.chunk_first.call(null,inst_19839);
var inst_19844 = cljs.core.chunk_rest.call(null,inst_19839);
var inst_19845 = cljs.core.count.call(null,inst_19843);
var inst_19817 = inst_19844;
var inst_19818 = inst_19843;
var inst_19819 = inst_19845;
var inst_19820 = (0);
var state_19940__$1 = (function (){var statearr_19995 = state_19940;
(statearr_19995[(13)] = inst_19818);

(statearr_19995[(14)] = inst_19820);

(statearr_19995[(16)] = inst_19819);

(statearr_19995[(17)] = inst_19817);

return statearr_19995;
})();
var statearr_19996_20063 = state_19940__$1;
(statearr_19996_20063[(2)] = null);

(statearr_19996_20063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (11))){
var inst_19839 = (state_19940[(7)]);
var inst_19817 = (state_19940[(17)]);
var inst_19839__$1 = cljs.core.seq.call(null,inst_19817);
var state_19940__$1 = (function (){var statearr_19997 = state_19940;
(statearr_19997[(7)] = inst_19839__$1);

return statearr_19997;
})();
if(inst_19839__$1){
var statearr_19998_20064 = state_19940__$1;
(statearr_19998_20064[(1)] = (16));

} else {
var statearr_19999_20065 = state_19940__$1;
(statearr_19999_20065[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (9))){
var inst_19869 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_20000_20066 = state_19940__$1;
(statearr_20000_20066[(2)] = inst_19869);

(statearr_20000_20066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (5))){
var inst_19815 = cljs.core.deref.call(null,cs);
var inst_19816 = cljs.core.seq.call(null,inst_19815);
var inst_19817 = inst_19816;
var inst_19818 = null;
var inst_19819 = (0);
var inst_19820 = (0);
var state_19940__$1 = (function (){var statearr_20001 = state_19940;
(statearr_20001[(13)] = inst_19818);

(statearr_20001[(14)] = inst_19820);

(statearr_20001[(16)] = inst_19819);

(statearr_20001[(17)] = inst_19817);

return statearr_20001;
})();
var statearr_20002_20067 = state_19940__$1;
(statearr_20002_20067[(2)] = null);

(statearr_20002_20067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (14))){
var state_19940__$1 = state_19940;
var statearr_20003_20068 = state_19940__$1;
(statearr_20003_20068[(2)] = null);

(statearr_20003_20068[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (45))){
var inst_19930 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_20004_20069 = state_19940__$1;
(statearr_20004_20069[(2)] = inst_19930);

(statearr_20004_20069[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (26))){
var inst_19872 = (state_19940[(29)]);
var inst_19926 = (state_19940[(2)]);
var inst_19927 = cljs.core.seq.call(null,inst_19872);
var state_19940__$1 = (function (){var statearr_20005 = state_19940;
(statearr_20005[(31)] = inst_19926);

return statearr_20005;
})();
if(inst_19927){
var statearr_20006_20070 = state_19940__$1;
(statearr_20006_20070[(1)] = (42));

} else {
var statearr_20007_20071 = state_19940__$1;
(statearr_20007_20071[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (16))){
var inst_19839 = (state_19940[(7)]);
var inst_19841 = cljs.core.chunked_seq_QMARK_.call(null,inst_19839);
var state_19940__$1 = state_19940;
if(inst_19841){
var statearr_20008_20072 = state_19940__$1;
(statearr_20008_20072[(1)] = (19));

} else {
var statearr_20009_20073 = state_19940__$1;
(statearr_20009_20073[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (38))){
var inst_19919 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_20010_20074 = state_19940__$1;
(statearr_20010_20074[(2)] = inst_19919);

(statearr_20010_20074[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (30))){
var state_19940__$1 = state_19940;
var statearr_20011_20075 = state_19940__$1;
(statearr_20011_20075[(2)] = null);

(statearr_20011_20075[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (10))){
var inst_19818 = (state_19940[(13)]);
var inst_19820 = (state_19940[(14)]);
var inst_19828 = cljs.core._nth.call(null,inst_19818,inst_19820);
var inst_19829 = cljs.core.nth.call(null,inst_19828,(0),null);
var inst_19830 = cljs.core.nth.call(null,inst_19828,(1),null);
var state_19940__$1 = (function (){var statearr_20012 = state_19940;
(statearr_20012[(26)] = inst_19829);

return statearr_20012;
})();
if(cljs.core.truth_(inst_19830)){
var statearr_20013_20076 = state_19940__$1;
(statearr_20013_20076[(1)] = (13));

} else {
var statearr_20014_20077 = state_19940__$1;
(statearr_20014_20077[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (18))){
var inst_19865 = (state_19940[(2)]);
var state_19940__$1 = state_19940;
var statearr_20015_20078 = state_19940__$1;
(statearr_20015_20078[(2)] = inst_19865);

(statearr_20015_20078[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (42))){
var state_19940__$1 = state_19940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19940__$1,(45),dchan);
} else {
if((state_val_19941 === (37))){
var inst_19908 = (state_19940[(23)]);
var inst_19808 = (state_19940[(12)]);
var inst_19899 = (state_19940[(25)]);
var inst_19908__$1 = cljs.core.first.call(null,inst_19899);
var inst_19909 = cljs.core.async.put_BANG_.call(null,inst_19908__$1,inst_19808,done);
var state_19940__$1 = (function (){var statearr_20016 = state_19940;
(statearr_20016[(23)] = inst_19908__$1);

return statearr_20016;
})();
if(cljs.core.truth_(inst_19909)){
var statearr_20017_20079 = state_19940__$1;
(statearr_20017_20079[(1)] = (39));

} else {
var statearr_20018_20080 = state_19940__$1;
(statearr_20018_20080[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19941 === (8))){
var inst_19820 = (state_19940[(14)]);
var inst_19819 = (state_19940[(16)]);
var inst_19822 = (inst_19820 < inst_19819);
var inst_19823 = inst_19822;
var state_19940__$1 = state_19940;
if(cljs.core.truth_(inst_19823)){
var statearr_20019_20081 = state_19940__$1;
(statearr_20019_20081[(1)] = (10));

} else {
var statearr_20020_20082 = state_19940__$1;
(statearr_20020_20082[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___20028,cs,m,dchan,dctr,done))
;
return ((function (switch__18593__auto__,c__18705__auto___20028,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__18594__auto__ = null;
var cljs$core$async$mult_$_state_machine__18594__auto____0 = (function (){
var statearr_20024 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20024[(0)] = cljs$core$async$mult_$_state_machine__18594__auto__);

(statearr_20024[(1)] = (1));

return statearr_20024;
});
var cljs$core$async$mult_$_state_machine__18594__auto____1 = (function (state_19940){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_19940);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e20025){if((e20025 instanceof Object)){
var ex__18597__auto__ = e20025;
var statearr_20026_20083 = state_19940;
(statearr_20026_20083[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19940);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20025;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20084 = state_19940;
state_19940 = G__20084;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__18594__auto__ = function(state_19940){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__18594__auto____1.call(this,state_19940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__18594__auto____0;
cljs$core$async$mult_$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__18594__auto____1;
return cljs$core$async$mult_$_state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___20028,cs,m,dchan,dctr,done))
})();
var state__18707__auto__ = (function (){var statearr_20027 = f__18706__auto__.call(null);
(statearr_20027[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___20028);

return statearr_20027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___20028,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20085 = [];
var len__7651__auto___20088 = arguments.length;
var i__7652__auto___20089 = (0);
while(true){
if((i__7652__auto___20089 < len__7651__auto___20088)){
args20085.push((arguments[i__7652__auto___20089]));

var G__20090 = (i__7652__auto___20089 + (1));
i__7652__auto___20089 = G__20090;
continue;
} else {
}
break;
}

var G__20087 = args20085.length;
switch (G__20087) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20085.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,ch);
} else {
var m__7207__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,ch);
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m);
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,state_map);
} else {
var m__7207__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,m,mode);
} else {
var m__7207__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___20102 = arguments.length;
var i__7652__auto___20103 = (0);
while(true){
if((i__7652__auto___20103 < len__7651__auto___20102)){
args__7658__auto__.push((arguments[i__7652__auto___20103]));

var G__20104 = (i__7652__auto___20103 + (1));
i__7652__auto___20103 = G__20104;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20096){
var map__20097 = p__20096;
var map__20097__$1 = ((((!((map__20097 == null)))?((((map__20097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20097.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20097):map__20097);
var opts = map__20097__$1;
var statearr_20099_20105 = state;
(statearr_20099_20105[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__20097,map__20097__$1,opts){
return (function (val){
var statearr_20100_20106 = state;
(statearr_20100_20106[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20097,map__20097__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_20101_20107 = state;
(statearr_20101_20107[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20092){
var G__20093 = cljs.core.first.call(null,seq20092);
var seq20092__$1 = cljs.core.next.call(null,seq20092);
var G__20094 = cljs.core.first.call(null,seq20092__$1);
var seq20092__$2 = cljs.core.next.call(null,seq20092__$1);
var G__20095 = cljs.core.first.call(null,seq20092__$2);
var seq20092__$3 = cljs.core.next.call(null,seq20092__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20093,G__20094,G__20095,seq20092__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20275 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20275 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta20276){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta20276 = meta20276;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20277,meta20276__$1){
var self__ = this;
var _20277__$1 = this;
return (new cljs.core.async.t_cljs$core$async20275(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta20276__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20277){
var self__ = this;
var _20277__$1 = this;
return self__.meta20276;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta20276","meta20276",-26635364,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20275.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20275.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20275";

cljs.core.async.t_cljs$core$async20275.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20275");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20275 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20275(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta20276){
return (new cljs.core.async.t_cljs$core$async20275(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta20276));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20275(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18705__auto___20442 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___20442,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___20442,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20379){
var state_val_20380 = (state_20379[(1)]);
if((state_val_20380 === (7))){
var inst_20294 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
var statearr_20381_20443 = state_20379__$1;
(statearr_20381_20443[(2)] = inst_20294);

(statearr_20381_20443[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (20))){
var inst_20306 = (state_20379[(7)]);
var state_20379__$1 = state_20379;
var statearr_20382_20444 = state_20379__$1;
(statearr_20382_20444[(2)] = inst_20306);

(statearr_20382_20444[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (27))){
var state_20379__$1 = state_20379;
var statearr_20383_20445 = state_20379__$1;
(statearr_20383_20445[(2)] = null);

(statearr_20383_20445[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (1))){
var inst_20281 = (state_20379[(8)]);
var inst_20281__$1 = calc_state.call(null);
var inst_20283 = (inst_20281__$1 == null);
var inst_20284 = cljs.core.not.call(null,inst_20283);
var state_20379__$1 = (function (){var statearr_20384 = state_20379;
(statearr_20384[(8)] = inst_20281__$1);

return statearr_20384;
})();
if(inst_20284){
var statearr_20385_20446 = state_20379__$1;
(statearr_20385_20446[(1)] = (2));

} else {
var statearr_20386_20447 = state_20379__$1;
(statearr_20386_20447[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (24))){
var inst_20339 = (state_20379[(9)]);
var inst_20330 = (state_20379[(10)]);
var inst_20353 = (state_20379[(11)]);
var inst_20353__$1 = inst_20330.call(null,inst_20339);
var state_20379__$1 = (function (){var statearr_20387 = state_20379;
(statearr_20387[(11)] = inst_20353__$1);

return statearr_20387;
})();
if(cljs.core.truth_(inst_20353__$1)){
var statearr_20388_20448 = state_20379__$1;
(statearr_20388_20448[(1)] = (29));

} else {
var statearr_20389_20449 = state_20379__$1;
(statearr_20389_20449[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (4))){
var inst_20297 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
if(cljs.core.truth_(inst_20297)){
var statearr_20390_20450 = state_20379__$1;
(statearr_20390_20450[(1)] = (8));

} else {
var statearr_20391_20451 = state_20379__$1;
(statearr_20391_20451[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (15))){
var inst_20324 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
if(cljs.core.truth_(inst_20324)){
var statearr_20392_20452 = state_20379__$1;
(statearr_20392_20452[(1)] = (19));

} else {
var statearr_20393_20453 = state_20379__$1;
(statearr_20393_20453[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (21))){
var inst_20329 = (state_20379[(12)]);
var inst_20329__$1 = (state_20379[(2)]);
var inst_20330 = cljs.core.get.call(null,inst_20329__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20331 = cljs.core.get.call(null,inst_20329__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20332 = cljs.core.get.call(null,inst_20329__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20379__$1 = (function (){var statearr_20394 = state_20379;
(statearr_20394[(13)] = inst_20331);

(statearr_20394[(12)] = inst_20329__$1);

(statearr_20394[(10)] = inst_20330);

return statearr_20394;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20379__$1,(22),inst_20332);
} else {
if((state_val_20380 === (31))){
var inst_20361 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
if(cljs.core.truth_(inst_20361)){
var statearr_20395_20454 = state_20379__$1;
(statearr_20395_20454[(1)] = (32));

} else {
var statearr_20396_20455 = state_20379__$1;
(statearr_20396_20455[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (32))){
var inst_20338 = (state_20379[(14)]);
var state_20379__$1 = state_20379;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20379__$1,(35),out,inst_20338);
} else {
if((state_val_20380 === (33))){
var inst_20329 = (state_20379[(12)]);
var inst_20306 = inst_20329;
var state_20379__$1 = (function (){var statearr_20397 = state_20379;
(statearr_20397[(7)] = inst_20306);

return statearr_20397;
})();
var statearr_20398_20456 = state_20379__$1;
(statearr_20398_20456[(2)] = null);

(statearr_20398_20456[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (13))){
var inst_20306 = (state_20379[(7)]);
var inst_20313 = inst_20306.cljs$lang$protocol_mask$partition0$;
var inst_20314 = (inst_20313 & (64));
var inst_20315 = inst_20306.cljs$core$ISeq$;
var inst_20316 = (cljs.core.PROTOCOL_SENTINEL === inst_20315);
var inst_20317 = (inst_20314) || (inst_20316);
var state_20379__$1 = state_20379;
if(cljs.core.truth_(inst_20317)){
var statearr_20399_20457 = state_20379__$1;
(statearr_20399_20457[(1)] = (16));

} else {
var statearr_20400_20458 = state_20379__$1;
(statearr_20400_20458[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (22))){
var inst_20338 = (state_20379[(14)]);
var inst_20339 = (state_20379[(9)]);
var inst_20337 = (state_20379[(2)]);
var inst_20338__$1 = cljs.core.nth.call(null,inst_20337,(0),null);
var inst_20339__$1 = cljs.core.nth.call(null,inst_20337,(1),null);
var inst_20340 = (inst_20338__$1 == null);
var inst_20341 = cljs.core._EQ_.call(null,inst_20339__$1,change);
var inst_20342 = (inst_20340) || (inst_20341);
var state_20379__$1 = (function (){var statearr_20401 = state_20379;
(statearr_20401[(14)] = inst_20338__$1);

(statearr_20401[(9)] = inst_20339__$1);

return statearr_20401;
})();
if(cljs.core.truth_(inst_20342)){
var statearr_20402_20459 = state_20379__$1;
(statearr_20402_20459[(1)] = (23));

} else {
var statearr_20403_20460 = state_20379__$1;
(statearr_20403_20460[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (36))){
var inst_20329 = (state_20379[(12)]);
var inst_20306 = inst_20329;
var state_20379__$1 = (function (){var statearr_20404 = state_20379;
(statearr_20404[(7)] = inst_20306);

return statearr_20404;
})();
var statearr_20405_20461 = state_20379__$1;
(statearr_20405_20461[(2)] = null);

(statearr_20405_20461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (29))){
var inst_20353 = (state_20379[(11)]);
var state_20379__$1 = state_20379;
var statearr_20406_20462 = state_20379__$1;
(statearr_20406_20462[(2)] = inst_20353);

(statearr_20406_20462[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (6))){
var state_20379__$1 = state_20379;
var statearr_20407_20463 = state_20379__$1;
(statearr_20407_20463[(2)] = false);

(statearr_20407_20463[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (28))){
var inst_20349 = (state_20379[(2)]);
var inst_20350 = calc_state.call(null);
var inst_20306 = inst_20350;
var state_20379__$1 = (function (){var statearr_20408 = state_20379;
(statearr_20408[(15)] = inst_20349);

(statearr_20408[(7)] = inst_20306);

return statearr_20408;
})();
var statearr_20409_20464 = state_20379__$1;
(statearr_20409_20464[(2)] = null);

(statearr_20409_20464[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (25))){
var inst_20375 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
var statearr_20410_20465 = state_20379__$1;
(statearr_20410_20465[(2)] = inst_20375);

(statearr_20410_20465[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (34))){
var inst_20373 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
var statearr_20411_20466 = state_20379__$1;
(statearr_20411_20466[(2)] = inst_20373);

(statearr_20411_20466[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (17))){
var state_20379__$1 = state_20379;
var statearr_20412_20467 = state_20379__$1;
(statearr_20412_20467[(2)] = false);

(statearr_20412_20467[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (3))){
var state_20379__$1 = state_20379;
var statearr_20413_20468 = state_20379__$1;
(statearr_20413_20468[(2)] = false);

(statearr_20413_20468[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (12))){
var inst_20377 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20379__$1,inst_20377);
} else {
if((state_val_20380 === (2))){
var inst_20281 = (state_20379[(8)]);
var inst_20286 = inst_20281.cljs$lang$protocol_mask$partition0$;
var inst_20287 = (inst_20286 & (64));
var inst_20288 = inst_20281.cljs$core$ISeq$;
var inst_20289 = (cljs.core.PROTOCOL_SENTINEL === inst_20288);
var inst_20290 = (inst_20287) || (inst_20289);
var state_20379__$1 = state_20379;
if(cljs.core.truth_(inst_20290)){
var statearr_20414_20469 = state_20379__$1;
(statearr_20414_20469[(1)] = (5));

} else {
var statearr_20415_20470 = state_20379__$1;
(statearr_20415_20470[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (23))){
var inst_20338 = (state_20379[(14)]);
var inst_20344 = (inst_20338 == null);
var state_20379__$1 = state_20379;
if(cljs.core.truth_(inst_20344)){
var statearr_20416_20471 = state_20379__$1;
(statearr_20416_20471[(1)] = (26));

} else {
var statearr_20417_20472 = state_20379__$1;
(statearr_20417_20472[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (35))){
var inst_20364 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
if(cljs.core.truth_(inst_20364)){
var statearr_20418_20473 = state_20379__$1;
(statearr_20418_20473[(1)] = (36));

} else {
var statearr_20419_20474 = state_20379__$1;
(statearr_20419_20474[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (19))){
var inst_20306 = (state_20379[(7)]);
var inst_20326 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20306);
var state_20379__$1 = state_20379;
var statearr_20420_20475 = state_20379__$1;
(statearr_20420_20475[(2)] = inst_20326);

(statearr_20420_20475[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (11))){
var inst_20306 = (state_20379[(7)]);
var inst_20310 = (inst_20306 == null);
var inst_20311 = cljs.core.not.call(null,inst_20310);
var state_20379__$1 = state_20379;
if(inst_20311){
var statearr_20421_20476 = state_20379__$1;
(statearr_20421_20476[(1)] = (13));

} else {
var statearr_20422_20477 = state_20379__$1;
(statearr_20422_20477[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (9))){
var inst_20281 = (state_20379[(8)]);
var state_20379__$1 = state_20379;
var statearr_20423_20478 = state_20379__$1;
(statearr_20423_20478[(2)] = inst_20281);

(statearr_20423_20478[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (5))){
var state_20379__$1 = state_20379;
var statearr_20424_20479 = state_20379__$1;
(statearr_20424_20479[(2)] = true);

(statearr_20424_20479[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (14))){
var state_20379__$1 = state_20379;
var statearr_20425_20480 = state_20379__$1;
(statearr_20425_20480[(2)] = false);

(statearr_20425_20480[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (26))){
var inst_20339 = (state_20379[(9)]);
var inst_20346 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20339);
var state_20379__$1 = state_20379;
var statearr_20426_20481 = state_20379__$1;
(statearr_20426_20481[(2)] = inst_20346);

(statearr_20426_20481[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (16))){
var state_20379__$1 = state_20379;
var statearr_20427_20482 = state_20379__$1;
(statearr_20427_20482[(2)] = true);

(statearr_20427_20482[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (38))){
var inst_20369 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
var statearr_20428_20483 = state_20379__$1;
(statearr_20428_20483[(2)] = inst_20369);

(statearr_20428_20483[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (30))){
var inst_20331 = (state_20379[(13)]);
var inst_20339 = (state_20379[(9)]);
var inst_20330 = (state_20379[(10)]);
var inst_20356 = cljs.core.empty_QMARK_.call(null,inst_20330);
var inst_20357 = inst_20331.call(null,inst_20339);
var inst_20358 = cljs.core.not.call(null,inst_20357);
var inst_20359 = (inst_20356) && (inst_20358);
var state_20379__$1 = state_20379;
var statearr_20429_20484 = state_20379__$1;
(statearr_20429_20484[(2)] = inst_20359);

(statearr_20429_20484[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (10))){
var inst_20281 = (state_20379[(8)]);
var inst_20302 = (state_20379[(2)]);
var inst_20303 = cljs.core.get.call(null,inst_20302,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20304 = cljs.core.get.call(null,inst_20302,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20305 = cljs.core.get.call(null,inst_20302,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20306 = inst_20281;
var state_20379__$1 = (function (){var statearr_20430 = state_20379;
(statearr_20430[(16)] = inst_20305);

(statearr_20430[(7)] = inst_20306);

(statearr_20430[(17)] = inst_20303);

(statearr_20430[(18)] = inst_20304);

return statearr_20430;
})();
var statearr_20431_20485 = state_20379__$1;
(statearr_20431_20485[(2)] = null);

(statearr_20431_20485[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (18))){
var inst_20321 = (state_20379[(2)]);
var state_20379__$1 = state_20379;
var statearr_20432_20486 = state_20379__$1;
(statearr_20432_20486[(2)] = inst_20321);

(statearr_20432_20486[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (37))){
var state_20379__$1 = state_20379;
var statearr_20433_20487 = state_20379__$1;
(statearr_20433_20487[(2)] = null);

(statearr_20433_20487[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20380 === (8))){
var inst_20281 = (state_20379[(8)]);
var inst_20299 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20281);
var state_20379__$1 = state_20379;
var statearr_20434_20488 = state_20379__$1;
(statearr_20434_20488[(2)] = inst_20299);

(statearr_20434_20488[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___20442,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__18593__auto__,c__18705__auto___20442,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__18594__auto__ = null;
var cljs$core$async$mix_$_state_machine__18594__auto____0 = (function (){
var statearr_20438 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20438[(0)] = cljs$core$async$mix_$_state_machine__18594__auto__);

(statearr_20438[(1)] = (1));

return statearr_20438;
});
var cljs$core$async$mix_$_state_machine__18594__auto____1 = (function (state_20379){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_20379);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e20439){if((e20439 instanceof Object)){
var ex__18597__auto__ = e20439;
var statearr_20440_20489 = state_20379;
(statearr_20440_20489[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20379);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20439;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20490 = state_20379;
state_20379 = G__20490;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__18594__auto__ = function(state_20379){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__18594__auto____1.call(this,state_20379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__18594__auto____0;
cljs$core$async$mix_$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__18594__auto____1;
return cljs$core$async$mix_$_state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___20442,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__18707__auto__ = (function (){var statearr_20441 = f__18706__auto__.call(null);
(statearr_20441[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___20442);

return statearr_20441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___20442,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7207__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,p,v,ch);
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20491 = [];
var len__7651__auto___20494 = arguments.length;
var i__7652__auto___20495 = (0);
while(true){
if((i__7652__auto___20495 < len__7651__auto___20494)){
args20491.push((arguments[i__7652__auto___20495]));

var G__20496 = (i__7652__auto___20495 + (1));
i__7652__auto___20495 = G__20496;
continue;
} else {
}
break;
}

var G__20493 = args20491.length;
switch (G__20493) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20491.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,p);
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return m__7207__auto__.call(null,p,v);
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return m__7207__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20499 = [];
var len__7651__auto___20624 = arguments.length;
var i__7652__auto___20625 = (0);
while(true){
if((i__7652__auto___20625 < len__7651__auto___20624)){
args20499.push((arguments[i__7652__auto___20625]));

var G__20626 = (i__7652__auto___20625 + (1));
i__7652__auto___20625 = G__20626;
continue;
} else {
}
break;
}

var G__20501 = args20499.length;
switch (G__20501) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20499.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6543__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6543__auto__,mults){
return (function (p1__20498_SHARP_){
if(cljs.core.truth_(p1__20498_SHARP_.call(null,topic))){
return p1__20498_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20498_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6543__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20502 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20502 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20503){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20503 = meta20503;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20504,meta20503__$1){
var self__ = this;
var _20504__$1 = this;
return (new cljs.core.async.t_cljs$core$async20502(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20503__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20504){
var self__ = this;
var _20504__$1 = this;
return self__.meta20503;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20502.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20502.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20503","meta20503",-769744477,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20502.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20502.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20502";

cljs.core.async.t_cljs$core$async20502.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20502");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20502 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20502(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20503){
return (new cljs.core.async.t_cljs$core$async20502(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20503));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20502(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18705__auto___20628 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___20628,mults,ensure_mult,p){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___20628,mults,ensure_mult,p){
return (function (state_20576){
var state_val_20577 = (state_20576[(1)]);
if((state_val_20577 === (7))){
var inst_20572 = (state_20576[(2)]);
var state_20576__$1 = state_20576;
var statearr_20578_20629 = state_20576__$1;
(statearr_20578_20629[(2)] = inst_20572);

(statearr_20578_20629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (20))){
var state_20576__$1 = state_20576;
var statearr_20579_20630 = state_20576__$1;
(statearr_20579_20630[(2)] = null);

(statearr_20579_20630[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (1))){
var state_20576__$1 = state_20576;
var statearr_20580_20631 = state_20576__$1;
(statearr_20580_20631[(2)] = null);

(statearr_20580_20631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (24))){
var inst_20555 = (state_20576[(7)]);
var inst_20564 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20555);
var state_20576__$1 = state_20576;
var statearr_20581_20632 = state_20576__$1;
(statearr_20581_20632[(2)] = inst_20564);

(statearr_20581_20632[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (4))){
var inst_20507 = (state_20576[(8)]);
var inst_20507__$1 = (state_20576[(2)]);
var inst_20508 = (inst_20507__$1 == null);
var state_20576__$1 = (function (){var statearr_20582 = state_20576;
(statearr_20582[(8)] = inst_20507__$1);

return statearr_20582;
})();
if(cljs.core.truth_(inst_20508)){
var statearr_20583_20633 = state_20576__$1;
(statearr_20583_20633[(1)] = (5));

} else {
var statearr_20584_20634 = state_20576__$1;
(statearr_20584_20634[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (15))){
var inst_20549 = (state_20576[(2)]);
var state_20576__$1 = state_20576;
var statearr_20585_20635 = state_20576__$1;
(statearr_20585_20635[(2)] = inst_20549);

(statearr_20585_20635[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (21))){
var inst_20569 = (state_20576[(2)]);
var state_20576__$1 = (function (){var statearr_20586 = state_20576;
(statearr_20586[(9)] = inst_20569);

return statearr_20586;
})();
var statearr_20587_20636 = state_20576__$1;
(statearr_20587_20636[(2)] = null);

(statearr_20587_20636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (13))){
var inst_20531 = (state_20576[(10)]);
var inst_20533 = cljs.core.chunked_seq_QMARK_.call(null,inst_20531);
var state_20576__$1 = state_20576;
if(inst_20533){
var statearr_20588_20637 = state_20576__$1;
(statearr_20588_20637[(1)] = (16));

} else {
var statearr_20589_20638 = state_20576__$1;
(statearr_20589_20638[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (22))){
var inst_20561 = (state_20576[(2)]);
var state_20576__$1 = state_20576;
if(cljs.core.truth_(inst_20561)){
var statearr_20590_20639 = state_20576__$1;
(statearr_20590_20639[(1)] = (23));

} else {
var statearr_20591_20640 = state_20576__$1;
(statearr_20591_20640[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (6))){
var inst_20557 = (state_20576[(11)]);
var inst_20507 = (state_20576[(8)]);
var inst_20555 = (state_20576[(7)]);
var inst_20555__$1 = topic_fn.call(null,inst_20507);
var inst_20556 = cljs.core.deref.call(null,mults);
var inst_20557__$1 = cljs.core.get.call(null,inst_20556,inst_20555__$1);
var state_20576__$1 = (function (){var statearr_20592 = state_20576;
(statearr_20592[(11)] = inst_20557__$1);

(statearr_20592[(7)] = inst_20555__$1);

return statearr_20592;
})();
if(cljs.core.truth_(inst_20557__$1)){
var statearr_20593_20641 = state_20576__$1;
(statearr_20593_20641[(1)] = (19));

} else {
var statearr_20594_20642 = state_20576__$1;
(statearr_20594_20642[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (25))){
var inst_20566 = (state_20576[(2)]);
var state_20576__$1 = state_20576;
var statearr_20595_20643 = state_20576__$1;
(statearr_20595_20643[(2)] = inst_20566);

(statearr_20595_20643[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (17))){
var inst_20531 = (state_20576[(10)]);
var inst_20540 = cljs.core.first.call(null,inst_20531);
var inst_20541 = cljs.core.async.muxch_STAR_.call(null,inst_20540);
var inst_20542 = cljs.core.async.close_BANG_.call(null,inst_20541);
var inst_20543 = cljs.core.next.call(null,inst_20531);
var inst_20517 = inst_20543;
var inst_20518 = null;
var inst_20519 = (0);
var inst_20520 = (0);
var state_20576__$1 = (function (){var statearr_20596 = state_20576;
(statearr_20596[(12)] = inst_20518);

(statearr_20596[(13)] = inst_20542);

(statearr_20596[(14)] = inst_20520);

(statearr_20596[(15)] = inst_20517);

(statearr_20596[(16)] = inst_20519);

return statearr_20596;
})();
var statearr_20597_20644 = state_20576__$1;
(statearr_20597_20644[(2)] = null);

(statearr_20597_20644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (3))){
var inst_20574 = (state_20576[(2)]);
var state_20576__$1 = state_20576;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20576__$1,inst_20574);
} else {
if((state_val_20577 === (12))){
var inst_20551 = (state_20576[(2)]);
var state_20576__$1 = state_20576;
var statearr_20598_20645 = state_20576__$1;
(statearr_20598_20645[(2)] = inst_20551);

(statearr_20598_20645[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (2))){
var state_20576__$1 = state_20576;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20576__$1,(4),ch);
} else {
if((state_val_20577 === (23))){
var state_20576__$1 = state_20576;
var statearr_20599_20646 = state_20576__$1;
(statearr_20599_20646[(2)] = null);

(statearr_20599_20646[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (19))){
var inst_20557 = (state_20576[(11)]);
var inst_20507 = (state_20576[(8)]);
var inst_20559 = cljs.core.async.muxch_STAR_.call(null,inst_20557);
var state_20576__$1 = state_20576;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20576__$1,(22),inst_20559,inst_20507);
} else {
if((state_val_20577 === (11))){
var inst_20531 = (state_20576[(10)]);
var inst_20517 = (state_20576[(15)]);
var inst_20531__$1 = cljs.core.seq.call(null,inst_20517);
var state_20576__$1 = (function (){var statearr_20600 = state_20576;
(statearr_20600[(10)] = inst_20531__$1);

return statearr_20600;
})();
if(inst_20531__$1){
var statearr_20601_20647 = state_20576__$1;
(statearr_20601_20647[(1)] = (13));

} else {
var statearr_20602_20648 = state_20576__$1;
(statearr_20602_20648[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (9))){
var inst_20553 = (state_20576[(2)]);
var state_20576__$1 = state_20576;
var statearr_20603_20649 = state_20576__$1;
(statearr_20603_20649[(2)] = inst_20553);

(statearr_20603_20649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (5))){
var inst_20514 = cljs.core.deref.call(null,mults);
var inst_20515 = cljs.core.vals.call(null,inst_20514);
var inst_20516 = cljs.core.seq.call(null,inst_20515);
var inst_20517 = inst_20516;
var inst_20518 = null;
var inst_20519 = (0);
var inst_20520 = (0);
var state_20576__$1 = (function (){var statearr_20604 = state_20576;
(statearr_20604[(12)] = inst_20518);

(statearr_20604[(14)] = inst_20520);

(statearr_20604[(15)] = inst_20517);

(statearr_20604[(16)] = inst_20519);

return statearr_20604;
})();
var statearr_20605_20650 = state_20576__$1;
(statearr_20605_20650[(2)] = null);

(statearr_20605_20650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (14))){
var state_20576__$1 = state_20576;
var statearr_20609_20651 = state_20576__$1;
(statearr_20609_20651[(2)] = null);

(statearr_20609_20651[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (16))){
var inst_20531 = (state_20576[(10)]);
var inst_20535 = cljs.core.chunk_first.call(null,inst_20531);
var inst_20536 = cljs.core.chunk_rest.call(null,inst_20531);
var inst_20537 = cljs.core.count.call(null,inst_20535);
var inst_20517 = inst_20536;
var inst_20518 = inst_20535;
var inst_20519 = inst_20537;
var inst_20520 = (0);
var state_20576__$1 = (function (){var statearr_20610 = state_20576;
(statearr_20610[(12)] = inst_20518);

(statearr_20610[(14)] = inst_20520);

(statearr_20610[(15)] = inst_20517);

(statearr_20610[(16)] = inst_20519);

return statearr_20610;
})();
var statearr_20611_20652 = state_20576__$1;
(statearr_20611_20652[(2)] = null);

(statearr_20611_20652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (10))){
var inst_20518 = (state_20576[(12)]);
var inst_20520 = (state_20576[(14)]);
var inst_20517 = (state_20576[(15)]);
var inst_20519 = (state_20576[(16)]);
var inst_20525 = cljs.core._nth.call(null,inst_20518,inst_20520);
var inst_20526 = cljs.core.async.muxch_STAR_.call(null,inst_20525);
var inst_20527 = cljs.core.async.close_BANG_.call(null,inst_20526);
var inst_20528 = (inst_20520 + (1));
var tmp20606 = inst_20518;
var tmp20607 = inst_20517;
var tmp20608 = inst_20519;
var inst_20517__$1 = tmp20607;
var inst_20518__$1 = tmp20606;
var inst_20519__$1 = tmp20608;
var inst_20520__$1 = inst_20528;
var state_20576__$1 = (function (){var statearr_20612 = state_20576;
(statearr_20612[(12)] = inst_20518__$1);

(statearr_20612[(14)] = inst_20520__$1);

(statearr_20612[(15)] = inst_20517__$1);

(statearr_20612[(16)] = inst_20519__$1);

(statearr_20612[(17)] = inst_20527);

return statearr_20612;
})();
var statearr_20613_20653 = state_20576__$1;
(statearr_20613_20653[(2)] = null);

(statearr_20613_20653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (18))){
var inst_20546 = (state_20576[(2)]);
var state_20576__$1 = state_20576;
var statearr_20614_20654 = state_20576__$1;
(statearr_20614_20654[(2)] = inst_20546);

(statearr_20614_20654[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20577 === (8))){
var inst_20520 = (state_20576[(14)]);
var inst_20519 = (state_20576[(16)]);
var inst_20522 = (inst_20520 < inst_20519);
var inst_20523 = inst_20522;
var state_20576__$1 = state_20576;
if(cljs.core.truth_(inst_20523)){
var statearr_20615_20655 = state_20576__$1;
(statearr_20615_20655[(1)] = (10));

} else {
var statearr_20616_20656 = state_20576__$1;
(statearr_20616_20656[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___20628,mults,ensure_mult,p))
;
return ((function (switch__18593__auto__,c__18705__auto___20628,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_20620 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20620[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_20620[(1)] = (1));

return statearr_20620;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_20576){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_20576);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e20621){if((e20621 instanceof Object)){
var ex__18597__auto__ = e20621;
var statearr_20622_20657 = state_20576;
(statearr_20622_20657[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20576);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20621;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20658 = state_20576;
state_20576 = G__20658;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_20576){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_20576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___20628,mults,ensure_mult,p))
})();
var state__18707__auto__ = (function (){var statearr_20623 = f__18706__auto__.call(null);
(statearr_20623[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___20628);

return statearr_20623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___20628,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20659 = [];
var len__7651__auto___20662 = arguments.length;
var i__7652__auto___20663 = (0);
while(true){
if((i__7652__auto___20663 < len__7651__auto___20662)){
args20659.push((arguments[i__7652__auto___20663]));

var G__20664 = (i__7652__auto___20663 + (1));
i__7652__auto___20663 = G__20664;
continue;
} else {
}
break;
}

var G__20661 = args20659.length;
switch (G__20661) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20659.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20666 = [];
var len__7651__auto___20669 = arguments.length;
var i__7652__auto___20670 = (0);
while(true){
if((i__7652__auto___20670 < len__7651__auto___20669)){
args20666.push((arguments[i__7652__auto___20670]));

var G__20671 = (i__7652__auto___20670 + (1));
i__7652__auto___20670 = G__20671;
continue;
} else {
}
break;
}

var G__20668 = args20666.length;
switch (G__20668) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20666.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20673 = [];
var len__7651__auto___20744 = arguments.length;
var i__7652__auto___20745 = (0);
while(true){
if((i__7652__auto___20745 < len__7651__auto___20744)){
args20673.push((arguments[i__7652__auto___20745]));

var G__20746 = (i__7652__auto___20745 + (1));
i__7652__auto___20745 = G__20746;
continue;
} else {
}
break;
}

var G__20675 = args20673.length;
switch (G__20675) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20673.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__18705__auto___20748 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___20748,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___20748,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20714){
var state_val_20715 = (state_20714[(1)]);
if((state_val_20715 === (7))){
var state_20714__$1 = state_20714;
var statearr_20716_20749 = state_20714__$1;
(statearr_20716_20749[(2)] = null);

(statearr_20716_20749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (1))){
var state_20714__$1 = state_20714;
var statearr_20717_20750 = state_20714__$1;
(statearr_20717_20750[(2)] = null);

(statearr_20717_20750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (4))){
var inst_20678 = (state_20714[(7)]);
var inst_20680 = (inst_20678 < cnt);
var state_20714__$1 = state_20714;
if(cljs.core.truth_(inst_20680)){
var statearr_20718_20751 = state_20714__$1;
(statearr_20718_20751[(1)] = (6));

} else {
var statearr_20719_20752 = state_20714__$1;
(statearr_20719_20752[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (15))){
var inst_20710 = (state_20714[(2)]);
var state_20714__$1 = state_20714;
var statearr_20720_20753 = state_20714__$1;
(statearr_20720_20753[(2)] = inst_20710);

(statearr_20720_20753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (13))){
var inst_20703 = cljs.core.async.close_BANG_.call(null,out);
var state_20714__$1 = state_20714;
var statearr_20721_20754 = state_20714__$1;
(statearr_20721_20754[(2)] = inst_20703);

(statearr_20721_20754[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (6))){
var state_20714__$1 = state_20714;
var statearr_20722_20755 = state_20714__$1;
(statearr_20722_20755[(2)] = null);

(statearr_20722_20755[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (3))){
var inst_20712 = (state_20714[(2)]);
var state_20714__$1 = state_20714;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20714__$1,inst_20712);
} else {
if((state_val_20715 === (12))){
var inst_20700 = (state_20714[(8)]);
var inst_20700__$1 = (state_20714[(2)]);
var inst_20701 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20700__$1);
var state_20714__$1 = (function (){var statearr_20723 = state_20714;
(statearr_20723[(8)] = inst_20700__$1);

return statearr_20723;
})();
if(cljs.core.truth_(inst_20701)){
var statearr_20724_20756 = state_20714__$1;
(statearr_20724_20756[(1)] = (13));

} else {
var statearr_20725_20757 = state_20714__$1;
(statearr_20725_20757[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (2))){
var inst_20677 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20678 = (0);
var state_20714__$1 = (function (){var statearr_20726 = state_20714;
(statearr_20726[(9)] = inst_20677);

(statearr_20726[(7)] = inst_20678);

return statearr_20726;
})();
var statearr_20727_20758 = state_20714__$1;
(statearr_20727_20758[(2)] = null);

(statearr_20727_20758[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (11))){
var inst_20678 = (state_20714[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20714,(10),Object,null,(9));
var inst_20687 = chs__$1.call(null,inst_20678);
var inst_20688 = done.call(null,inst_20678);
var inst_20689 = cljs.core.async.take_BANG_.call(null,inst_20687,inst_20688);
var state_20714__$1 = state_20714;
var statearr_20728_20759 = state_20714__$1;
(statearr_20728_20759[(2)] = inst_20689);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20714__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (9))){
var inst_20678 = (state_20714[(7)]);
var inst_20691 = (state_20714[(2)]);
var inst_20692 = (inst_20678 + (1));
var inst_20678__$1 = inst_20692;
var state_20714__$1 = (function (){var statearr_20729 = state_20714;
(statearr_20729[(7)] = inst_20678__$1);

(statearr_20729[(10)] = inst_20691);

return statearr_20729;
})();
var statearr_20730_20760 = state_20714__$1;
(statearr_20730_20760[(2)] = null);

(statearr_20730_20760[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (5))){
var inst_20698 = (state_20714[(2)]);
var state_20714__$1 = (function (){var statearr_20731 = state_20714;
(statearr_20731[(11)] = inst_20698);

return statearr_20731;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20714__$1,(12),dchan);
} else {
if((state_val_20715 === (14))){
var inst_20700 = (state_20714[(8)]);
var inst_20705 = cljs.core.apply.call(null,f,inst_20700);
var state_20714__$1 = state_20714;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20714__$1,(16),out,inst_20705);
} else {
if((state_val_20715 === (16))){
var inst_20707 = (state_20714[(2)]);
var state_20714__$1 = (function (){var statearr_20732 = state_20714;
(statearr_20732[(12)] = inst_20707);

return statearr_20732;
})();
var statearr_20733_20761 = state_20714__$1;
(statearr_20733_20761[(2)] = null);

(statearr_20733_20761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (10))){
var inst_20682 = (state_20714[(2)]);
var inst_20683 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20714__$1 = (function (){var statearr_20734 = state_20714;
(statearr_20734[(13)] = inst_20682);

return statearr_20734;
})();
var statearr_20735_20762 = state_20714__$1;
(statearr_20735_20762[(2)] = inst_20683);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20714__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20715 === (8))){
var inst_20696 = (state_20714[(2)]);
var state_20714__$1 = state_20714;
var statearr_20736_20763 = state_20714__$1;
(statearr_20736_20763[(2)] = inst_20696);

(statearr_20736_20763[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___20748,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__18593__auto__,c__18705__auto___20748,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_20740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20740[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_20740[(1)] = (1));

return statearr_20740;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_20714){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_20714);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e20741){if((e20741 instanceof Object)){
var ex__18597__auto__ = e20741;
var statearr_20742_20764 = state_20714;
(statearr_20742_20764[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20714);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20741;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20765 = state_20714;
state_20714 = G__20765;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_20714){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_20714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___20748,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__18707__auto__ = (function (){var statearr_20743 = f__18706__auto__.call(null);
(statearr_20743[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___20748);

return statearr_20743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___20748,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20767 = [];
var len__7651__auto___20825 = arguments.length;
var i__7652__auto___20826 = (0);
while(true){
if((i__7652__auto___20826 < len__7651__auto___20825)){
args20767.push((arguments[i__7652__auto___20826]));

var G__20827 = (i__7652__auto___20826 + (1));
i__7652__auto___20826 = G__20827;
continue;
} else {
}
break;
}

var G__20769 = args20767.length;
switch (G__20769) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20767.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18705__auto___20829 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___20829,out){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___20829,out){
return (function (state_20801){
var state_val_20802 = (state_20801[(1)]);
if((state_val_20802 === (7))){
var inst_20781 = (state_20801[(7)]);
var inst_20780 = (state_20801[(8)]);
var inst_20780__$1 = (state_20801[(2)]);
var inst_20781__$1 = cljs.core.nth.call(null,inst_20780__$1,(0),null);
var inst_20782 = cljs.core.nth.call(null,inst_20780__$1,(1),null);
var inst_20783 = (inst_20781__$1 == null);
var state_20801__$1 = (function (){var statearr_20803 = state_20801;
(statearr_20803[(7)] = inst_20781__$1);

(statearr_20803[(9)] = inst_20782);

(statearr_20803[(8)] = inst_20780__$1);

return statearr_20803;
})();
if(cljs.core.truth_(inst_20783)){
var statearr_20804_20830 = state_20801__$1;
(statearr_20804_20830[(1)] = (8));

} else {
var statearr_20805_20831 = state_20801__$1;
(statearr_20805_20831[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20802 === (1))){
var inst_20770 = cljs.core.vec.call(null,chs);
var inst_20771 = inst_20770;
var state_20801__$1 = (function (){var statearr_20806 = state_20801;
(statearr_20806[(10)] = inst_20771);

return statearr_20806;
})();
var statearr_20807_20832 = state_20801__$1;
(statearr_20807_20832[(2)] = null);

(statearr_20807_20832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20802 === (4))){
var inst_20771 = (state_20801[(10)]);
var state_20801__$1 = state_20801;
return cljs.core.async.ioc_alts_BANG_.call(null,state_20801__$1,(7),inst_20771);
} else {
if((state_val_20802 === (6))){
var inst_20797 = (state_20801[(2)]);
var state_20801__$1 = state_20801;
var statearr_20808_20833 = state_20801__$1;
(statearr_20808_20833[(2)] = inst_20797);

(statearr_20808_20833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20802 === (3))){
var inst_20799 = (state_20801[(2)]);
var state_20801__$1 = state_20801;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20801__$1,inst_20799);
} else {
if((state_val_20802 === (2))){
var inst_20771 = (state_20801[(10)]);
var inst_20773 = cljs.core.count.call(null,inst_20771);
var inst_20774 = (inst_20773 > (0));
var state_20801__$1 = state_20801;
if(cljs.core.truth_(inst_20774)){
var statearr_20810_20834 = state_20801__$1;
(statearr_20810_20834[(1)] = (4));

} else {
var statearr_20811_20835 = state_20801__$1;
(statearr_20811_20835[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20802 === (11))){
var inst_20771 = (state_20801[(10)]);
var inst_20790 = (state_20801[(2)]);
var tmp20809 = inst_20771;
var inst_20771__$1 = tmp20809;
var state_20801__$1 = (function (){var statearr_20812 = state_20801;
(statearr_20812[(10)] = inst_20771__$1);

(statearr_20812[(11)] = inst_20790);

return statearr_20812;
})();
var statearr_20813_20836 = state_20801__$1;
(statearr_20813_20836[(2)] = null);

(statearr_20813_20836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20802 === (9))){
var inst_20781 = (state_20801[(7)]);
var state_20801__$1 = state_20801;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20801__$1,(11),out,inst_20781);
} else {
if((state_val_20802 === (5))){
var inst_20795 = cljs.core.async.close_BANG_.call(null,out);
var state_20801__$1 = state_20801;
var statearr_20814_20837 = state_20801__$1;
(statearr_20814_20837[(2)] = inst_20795);

(statearr_20814_20837[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20802 === (10))){
var inst_20793 = (state_20801[(2)]);
var state_20801__$1 = state_20801;
var statearr_20815_20838 = state_20801__$1;
(statearr_20815_20838[(2)] = inst_20793);

(statearr_20815_20838[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20802 === (8))){
var inst_20781 = (state_20801[(7)]);
var inst_20771 = (state_20801[(10)]);
var inst_20782 = (state_20801[(9)]);
var inst_20780 = (state_20801[(8)]);
var inst_20785 = (function (){var cs = inst_20771;
var vec__20776 = inst_20780;
var v = inst_20781;
var c = inst_20782;
return ((function (cs,vec__20776,v,c,inst_20781,inst_20771,inst_20782,inst_20780,state_val_20802,c__18705__auto___20829,out){
return (function (p1__20766_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20766_SHARP_);
});
;})(cs,vec__20776,v,c,inst_20781,inst_20771,inst_20782,inst_20780,state_val_20802,c__18705__auto___20829,out))
})();
var inst_20786 = cljs.core.filterv.call(null,inst_20785,inst_20771);
var inst_20771__$1 = inst_20786;
var state_20801__$1 = (function (){var statearr_20816 = state_20801;
(statearr_20816[(10)] = inst_20771__$1);

return statearr_20816;
})();
var statearr_20817_20839 = state_20801__$1;
(statearr_20817_20839[(2)] = null);

(statearr_20817_20839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___20829,out))
;
return ((function (switch__18593__auto__,c__18705__auto___20829,out){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_20821 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20821[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_20821[(1)] = (1));

return statearr_20821;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_20801){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_20801);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e20822){if((e20822 instanceof Object)){
var ex__18597__auto__ = e20822;
var statearr_20823_20840 = state_20801;
(statearr_20823_20840[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20801);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20841 = state_20801;
state_20801 = G__20841;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_20801){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_20801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___20829,out))
})();
var state__18707__auto__ = (function (){var statearr_20824 = f__18706__auto__.call(null);
(statearr_20824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___20829);

return statearr_20824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___20829,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args20842 = [];
var len__7651__auto___20891 = arguments.length;
var i__7652__auto___20892 = (0);
while(true){
if((i__7652__auto___20892 < len__7651__auto___20891)){
args20842.push((arguments[i__7652__auto___20892]));

var G__20893 = (i__7652__auto___20892 + (1));
i__7652__auto___20892 = G__20893;
continue;
} else {
}
break;
}

var G__20844 = args20842.length;
switch (G__20844) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20842.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18705__auto___20895 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___20895,out){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___20895,out){
return (function (state_20868){
var state_val_20869 = (state_20868[(1)]);
if((state_val_20869 === (7))){
var inst_20850 = (state_20868[(7)]);
var inst_20850__$1 = (state_20868[(2)]);
var inst_20851 = (inst_20850__$1 == null);
var inst_20852 = cljs.core.not.call(null,inst_20851);
var state_20868__$1 = (function (){var statearr_20870 = state_20868;
(statearr_20870[(7)] = inst_20850__$1);

return statearr_20870;
})();
if(inst_20852){
var statearr_20871_20896 = state_20868__$1;
(statearr_20871_20896[(1)] = (8));

} else {
var statearr_20872_20897 = state_20868__$1;
(statearr_20872_20897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20869 === (1))){
var inst_20845 = (0);
var state_20868__$1 = (function (){var statearr_20873 = state_20868;
(statearr_20873[(8)] = inst_20845);

return statearr_20873;
})();
var statearr_20874_20898 = state_20868__$1;
(statearr_20874_20898[(2)] = null);

(statearr_20874_20898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20869 === (4))){
var state_20868__$1 = state_20868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20868__$1,(7),ch);
} else {
if((state_val_20869 === (6))){
var inst_20863 = (state_20868[(2)]);
var state_20868__$1 = state_20868;
var statearr_20875_20899 = state_20868__$1;
(statearr_20875_20899[(2)] = inst_20863);

(statearr_20875_20899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20869 === (3))){
var inst_20865 = (state_20868[(2)]);
var inst_20866 = cljs.core.async.close_BANG_.call(null,out);
var state_20868__$1 = (function (){var statearr_20876 = state_20868;
(statearr_20876[(9)] = inst_20865);

return statearr_20876;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20868__$1,inst_20866);
} else {
if((state_val_20869 === (2))){
var inst_20845 = (state_20868[(8)]);
var inst_20847 = (inst_20845 < n);
var state_20868__$1 = state_20868;
if(cljs.core.truth_(inst_20847)){
var statearr_20877_20900 = state_20868__$1;
(statearr_20877_20900[(1)] = (4));

} else {
var statearr_20878_20901 = state_20868__$1;
(statearr_20878_20901[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20869 === (11))){
var inst_20845 = (state_20868[(8)]);
var inst_20855 = (state_20868[(2)]);
var inst_20856 = (inst_20845 + (1));
var inst_20845__$1 = inst_20856;
var state_20868__$1 = (function (){var statearr_20879 = state_20868;
(statearr_20879[(10)] = inst_20855);

(statearr_20879[(8)] = inst_20845__$1);

return statearr_20879;
})();
var statearr_20880_20902 = state_20868__$1;
(statearr_20880_20902[(2)] = null);

(statearr_20880_20902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20869 === (9))){
var state_20868__$1 = state_20868;
var statearr_20881_20903 = state_20868__$1;
(statearr_20881_20903[(2)] = null);

(statearr_20881_20903[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20869 === (5))){
var state_20868__$1 = state_20868;
var statearr_20882_20904 = state_20868__$1;
(statearr_20882_20904[(2)] = null);

(statearr_20882_20904[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20869 === (10))){
var inst_20860 = (state_20868[(2)]);
var state_20868__$1 = state_20868;
var statearr_20883_20905 = state_20868__$1;
(statearr_20883_20905[(2)] = inst_20860);

(statearr_20883_20905[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20869 === (8))){
var inst_20850 = (state_20868[(7)]);
var state_20868__$1 = state_20868;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20868__$1,(11),out,inst_20850);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___20895,out))
;
return ((function (switch__18593__auto__,c__18705__auto___20895,out){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_20887 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20887[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_20887[(1)] = (1));

return statearr_20887;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_20868){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_20868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e20888){if((e20888 instanceof Object)){
var ex__18597__auto__ = e20888;
var statearr_20889_20906 = state_20868;
(statearr_20889_20906[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20868);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20888;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20907 = state_20868;
state_20868 = G__20907;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_20868){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_20868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___20895,out))
})();
var state__18707__auto__ = (function (){var statearr_20890 = f__18706__auto__.call(null);
(statearr_20890[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___20895);

return statearr_20890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___20895,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20915 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20915 = (function (f,ch,meta20916){
this.f = f;
this.ch = ch;
this.meta20916 = meta20916;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20917,meta20916__$1){
var self__ = this;
var _20917__$1 = this;
return (new cljs.core.async.t_cljs$core$async20915(self__.f,self__.ch,meta20916__$1));
});

cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20917){
var self__ = this;
var _20917__$1 = this;
return self__.meta20916;
});

cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async20918 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20918 = (function (f,ch,meta20916,_,fn1,meta20919){
this.f = f;
this.ch = ch;
this.meta20916 = meta20916;
this._ = _;
this.fn1 = fn1;
this.meta20919 = meta20919;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20918.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_20920,meta20919__$1){
var self__ = this;
var _20920__$1 = this;
return (new cljs.core.async.t_cljs$core$async20918(self__.f,self__.ch,self__.meta20916,self__._,self__.fn1,meta20919__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async20918.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_20920){
var self__ = this;
var _20920__$1 = this;
return self__.meta20919;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20918.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20918.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20918.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20918.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__20908_SHARP_){
return f1.call(null,(((p1__20908_SHARP_ == null))?null:self__.f.call(null,p1__20908_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async20918.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20916","meta20916",-1989608474,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async20915","cljs.core.async/t_cljs$core$async20915",-214073980,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta20919","meta20919",991822801,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20918.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20918.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20918";

cljs.core.async.t_cljs$core$async20918.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20918");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async20918 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20918(f__$1,ch__$1,meta20916__$1,___$2,fn1__$1,meta20919){
return (new cljs.core.async.t_cljs$core$async20918(f__$1,ch__$1,meta20916__$1,___$2,fn1__$1,meta20919));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async20918(self__.f,self__.ch,self__.meta20916,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6531__auto__ = ret;
if(cljs.core.truth_(and__6531__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20915.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async20915.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20916","meta20916",-1989608474,null)], null);
});

cljs.core.async.t_cljs$core$async20915.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20915.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20915";

cljs.core.async.t_cljs$core$async20915.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20915");
});

cljs.core.async.__GT_t_cljs$core$async20915 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20915(f__$1,ch__$1,meta20916){
return (new cljs.core.async.t_cljs$core$async20915(f__$1,ch__$1,meta20916));
});

}

return (new cljs.core.async.t_cljs$core$async20915(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20924 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20924 = (function (f,ch,meta20925){
this.f = f;
this.ch = ch;
this.meta20925 = meta20925;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20924.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20926,meta20925__$1){
var self__ = this;
var _20926__$1 = this;
return (new cljs.core.async.t_cljs$core$async20924(self__.f,self__.ch,meta20925__$1));
});

cljs.core.async.t_cljs$core$async20924.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20926){
var self__ = this;
var _20926__$1 = this;
return self__.meta20925;
});

cljs.core.async.t_cljs$core$async20924.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20924.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20924.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20924.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20924.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20924.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async20924.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20925","meta20925",-1879784499,null)], null);
});

cljs.core.async.t_cljs$core$async20924.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20924.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20924";

cljs.core.async.t_cljs$core$async20924.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20924");
});

cljs.core.async.__GT_t_cljs$core$async20924 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async20924(f__$1,ch__$1,meta20925){
return (new cljs.core.async.t_cljs$core$async20924(f__$1,ch__$1,meta20925));
});

}

return (new cljs.core.async.t_cljs$core$async20924(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async20930 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20930 = (function (p,ch,meta20931){
this.p = p;
this.ch = ch;
this.meta20931 = meta20931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20932,meta20931__$1){
var self__ = this;
var _20932__$1 = this;
return (new cljs.core.async.t_cljs$core$async20930(self__.p,self__.ch,meta20931__$1));
});

cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20932){
var self__ = this;
var _20932__$1 = this;
return self__.meta20931;
});

cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20930.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async20930.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20931","meta20931",602024744,null)], null);
});

cljs.core.async.t_cljs$core$async20930.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20930.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20930";

cljs.core.async.t_cljs$core$async20930.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"cljs.core.async/t_cljs$core$async20930");
});

cljs.core.async.__GT_t_cljs$core$async20930 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async20930(p__$1,ch__$1,meta20931){
return (new cljs.core.async.t_cljs$core$async20930(p__$1,ch__$1,meta20931));
});

}

return (new cljs.core.async.t_cljs$core$async20930(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args20933 = [];
var len__7651__auto___20977 = arguments.length;
var i__7652__auto___20978 = (0);
while(true){
if((i__7652__auto___20978 < len__7651__auto___20977)){
args20933.push((arguments[i__7652__auto___20978]));

var G__20979 = (i__7652__auto___20978 + (1));
i__7652__auto___20978 = G__20979;
continue;
} else {
}
break;
}

var G__20935 = args20933.length;
switch (G__20935) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20933.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18705__auto___20981 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___20981,out){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___20981,out){
return (function (state_20956){
var state_val_20957 = (state_20956[(1)]);
if((state_val_20957 === (7))){
var inst_20952 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
var statearr_20958_20982 = state_20956__$1;
(statearr_20958_20982[(2)] = inst_20952);

(statearr_20958_20982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (1))){
var state_20956__$1 = state_20956;
var statearr_20959_20983 = state_20956__$1;
(statearr_20959_20983[(2)] = null);

(statearr_20959_20983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (4))){
var inst_20938 = (state_20956[(7)]);
var inst_20938__$1 = (state_20956[(2)]);
var inst_20939 = (inst_20938__$1 == null);
var state_20956__$1 = (function (){var statearr_20960 = state_20956;
(statearr_20960[(7)] = inst_20938__$1);

return statearr_20960;
})();
if(cljs.core.truth_(inst_20939)){
var statearr_20961_20984 = state_20956__$1;
(statearr_20961_20984[(1)] = (5));

} else {
var statearr_20962_20985 = state_20956__$1;
(statearr_20962_20985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (6))){
var inst_20938 = (state_20956[(7)]);
var inst_20943 = p.call(null,inst_20938);
var state_20956__$1 = state_20956;
if(cljs.core.truth_(inst_20943)){
var statearr_20963_20986 = state_20956__$1;
(statearr_20963_20986[(1)] = (8));

} else {
var statearr_20964_20987 = state_20956__$1;
(statearr_20964_20987[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (3))){
var inst_20954 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20956__$1,inst_20954);
} else {
if((state_val_20957 === (2))){
var state_20956__$1 = state_20956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20956__$1,(4),ch);
} else {
if((state_val_20957 === (11))){
var inst_20946 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
var statearr_20965_20988 = state_20956__$1;
(statearr_20965_20988[(2)] = inst_20946);

(statearr_20965_20988[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (9))){
var state_20956__$1 = state_20956;
var statearr_20966_20989 = state_20956__$1;
(statearr_20966_20989[(2)] = null);

(statearr_20966_20989[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (5))){
var inst_20941 = cljs.core.async.close_BANG_.call(null,out);
var state_20956__$1 = state_20956;
var statearr_20967_20990 = state_20956__$1;
(statearr_20967_20990[(2)] = inst_20941);

(statearr_20967_20990[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (10))){
var inst_20949 = (state_20956[(2)]);
var state_20956__$1 = (function (){var statearr_20968 = state_20956;
(statearr_20968[(8)] = inst_20949);

return statearr_20968;
})();
var statearr_20969_20991 = state_20956__$1;
(statearr_20969_20991[(2)] = null);

(statearr_20969_20991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (8))){
var inst_20938 = (state_20956[(7)]);
var state_20956__$1 = state_20956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20956__$1,(11),out,inst_20938);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___20981,out))
;
return ((function (switch__18593__auto__,c__18705__auto___20981,out){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_20973 = [null,null,null,null,null,null,null,null,null];
(statearr_20973[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_20973[(1)] = (1));

return statearr_20973;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_20956){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_20956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e20974){if((e20974 instanceof Object)){
var ex__18597__auto__ = e20974;
var statearr_20975_20992 = state_20956;
(statearr_20975_20992[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20974;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20993 = state_20956;
state_20956 = G__20993;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_20956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_20956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___20981,out))
})();
var state__18707__auto__ = (function (){var statearr_20976 = f__18706__auto__.call(null);
(statearr_20976[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___20981);

return statearr_20976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___20981,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args20994 = [];
var len__7651__auto___20997 = arguments.length;
var i__7652__auto___20998 = (0);
while(true){
if((i__7652__auto___20998 < len__7651__auto___20997)){
args20994.push((arguments[i__7652__auto___20998]));

var G__20999 = (i__7652__auto___20998 + (1));
i__7652__auto___20998 = G__20999;
continue;
} else {
}
break;
}

var G__20996 = args20994.length;
switch (G__20996) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20994.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__18705__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto__){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto__){
return (function (state_21166){
var state_val_21167 = (state_21166[(1)]);
if((state_val_21167 === (7))){
var inst_21162 = (state_21166[(2)]);
var state_21166__$1 = state_21166;
var statearr_21168_21209 = state_21166__$1;
(statearr_21168_21209[(2)] = inst_21162);

(statearr_21168_21209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (20))){
var inst_21132 = (state_21166[(7)]);
var inst_21143 = (state_21166[(2)]);
var inst_21144 = cljs.core.next.call(null,inst_21132);
var inst_21118 = inst_21144;
var inst_21119 = null;
var inst_21120 = (0);
var inst_21121 = (0);
var state_21166__$1 = (function (){var statearr_21169 = state_21166;
(statearr_21169[(8)] = inst_21120);

(statearr_21169[(9)] = inst_21118);

(statearr_21169[(10)] = inst_21143);

(statearr_21169[(11)] = inst_21121);

(statearr_21169[(12)] = inst_21119);

return statearr_21169;
})();
var statearr_21170_21210 = state_21166__$1;
(statearr_21170_21210[(2)] = null);

(statearr_21170_21210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (1))){
var state_21166__$1 = state_21166;
var statearr_21171_21211 = state_21166__$1;
(statearr_21171_21211[(2)] = null);

(statearr_21171_21211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (4))){
var inst_21107 = (state_21166[(13)]);
var inst_21107__$1 = (state_21166[(2)]);
var inst_21108 = (inst_21107__$1 == null);
var state_21166__$1 = (function (){var statearr_21172 = state_21166;
(statearr_21172[(13)] = inst_21107__$1);

return statearr_21172;
})();
if(cljs.core.truth_(inst_21108)){
var statearr_21173_21212 = state_21166__$1;
(statearr_21173_21212[(1)] = (5));

} else {
var statearr_21174_21213 = state_21166__$1;
(statearr_21174_21213[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (15))){
var state_21166__$1 = state_21166;
var statearr_21178_21214 = state_21166__$1;
(statearr_21178_21214[(2)] = null);

(statearr_21178_21214[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (21))){
var state_21166__$1 = state_21166;
var statearr_21179_21215 = state_21166__$1;
(statearr_21179_21215[(2)] = null);

(statearr_21179_21215[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (13))){
var inst_21120 = (state_21166[(8)]);
var inst_21118 = (state_21166[(9)]);
var inst_21121 = (state_21166[(11)]);
var inst_21119 = (state_21166[(12)]);
var inst_21128 = (state_21166[(2)]);
var inst_21129 = (inst_21121 + (1));
var tmp21175 = inst_21120;
var tmp21176 = inst_21118;
var tmp21177 = inst_21119;
var inst_21118__$1 = tmp21176;
var inst_21119__$1 = tmp21177;
var inst_21120__$1 = tmp21175;
var inst_21121__$1 = inst_21129;
var state_21166__$1 = (function (){var statearr_21180 = state_21166;
(statearr_21180[(8)] = inst_21120__$1);

(statearr_21180[(9)] = inst_21118__$1);

(statearr_21180[(11)] = inst_21121__$1);

(statearr_21180[(12)] = inst_21119__$1);

(statearr_21180[(14)] = inst_21128);

return statearr_21180;
})();
var statearr_21181_21216 = state_21166__$1;
(statearr_21181_21216[(2)] = null);

(statearr_21181_21216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (22))){
var state_21166__$1 = state_21166;
var statearr_21182_21217 = state_21166__$1;
(statearr_21182_21217[(2)] = null);

(statearr_21182_21217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (6))){
var inst_21107 = (state_21166[(13)]);
var inst_21116 = f.call(null,inst_21107);
var inst_21117 = cljs.core.seq.call(null,inst_21116);
var inst_21118 = inst_21117;
var inst_21119 = null;
var inst_21120 = (0);
var inst_21121 = (0);
var state_21166__$1 = (function (){var statearr_21183 = state_21166;
(statearr_21183[(8)] = inst_21120);

(statearr_21183[(9)] = inst_21118);

(statearr_21183[(11)] = inst_21121);

(statearr_21183[(12)] = inst_21119);

return statearr_21183;
})();
var statearr_21184_21218 = state_21166__$1;
(statearr_21184_21218[(2)] = null);

(statearr_21184_21218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (17))){
var inst_21132 = (state_21166[(7)]);
var inst_21136 = cljs.core.chunk_first.call(null,inst_21132);
var inst_21137 = cljs.core.chunk_rest.call(null,inst_21132);
var inst_21138 = cljs.core.count.call(null,inst_21136);
var inst_21118 = inst_21137;
var inst_21119 = inst_21136;
var inst_21120 = inst_21138;
var inst_21121 = (0);
var state_21166__$1 = (function (){var statearr_21185 = state_21166;
(statearr_21185[(8)] = inst_21120);

(statearr_21185[(9)] = inst_21118);

(statearr_21185[(11)] = inst_21121);

(statearr_21185[(12)] = inst_21119);

return statearr_21185;
})();
var statearr_21186_21219 = state_21166__$1;
(statearr_21186_21219[(2)] = null);

(statearr_21186_21219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (3))){
var inst_21164 = (state_21166[(2)]);
var state_21166__$1 = state_21166;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21166__$1,inst_21164);
} else {
if((state_val_21167 === (12))){
var inst_21152 = (state_21166[(2)]);
var state_21166__$1 = state_21166;
var statearr_21187_21220 = state_21166__$1;
(statearr_21187_21220[(2)] = inst_21152);

(statearr_21187_21220[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (2))){
var state_21166__$1 = state_21166;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21166__$1,(4),in$);
} else {
if((state_val_21167 === (23))){
var inst_21160 = (state_21166[(2)]);
var state_21166__$1 = state_21166;
var statearr_21188_21221 = state_21166__$1;
(statearr_21188_21221[(2)] = inst_21160);

(statearr_21188_21221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (19))){
var inst_21147 = (state_21166[(2)]);
var state_21166__$1 = state_21166;
var statearr_21189_21222 = state_21166__$1;
(statearr_21189_21222[(2)] = inst_21147);

(statearr_21189_21222[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (11))){
var inst_21132 = (state_21166[(7)]);
var inst_21118 = (state_21166[(9)]);
var inst_21132__$1 = cljs.core.seq.call(null,inst_21118);
var state_21166__$1 = (function (){var statearr_21190 = state_21166;
(statearr_21190[(7)] = inst_21132__$1);

return statearr_21190;
})();
if(inst_21132__$1){
var statearr_21191_21223 = state_21166__$1;
(statearr_21191_21223[(1)] = (14));

} else {
var statearr_21192_21224 = state_21166__$1;
(statearr_21192_21224[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (9))){
var inst_21154 = (state_21166[(2)]);
var inst_21155 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21166__$1 = (function (){var statearr_21193 = state_21166;
(statearr_21193[(15)] = inst_21154);

return statearr_21193;
})();
if(cljs.core.truth_(inst_21155)){
var statearr_21194_21225 = state_21166__$1;
(statearr_21194_21225[(1)] = (21));

} else {
var statearr_21195_21226 = state_21166__$1;
(statearr_21195_21226[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (5))){
var inst_21110 = cljs.core.async.close_BANG_.call(null,out);
var state_21166__$1 = state_21166;
var statearr_21196_21227 = state_21166__$1;
(statearr_21196_21227[(2)] = inst_21110);

(statearr_21196_21227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (14))){
var inst_21132 = (state_21166[(7)]);
var inst_21134 = cljs.core.chunked_seq_QMARK_.call(null,inst_21132);
var state_21166__$1 = state_21166;
if(inst_21134){
var statearr_21197_21228 = state_21166__$1;
(statearr_21197_21228[(1)] = (17));

} else {
var statearr_21198_21229 = state_21166__$1;
(statearr_21198_21229[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (16))){
var inst_21150 = (state_21166[(2)]);
var state_21166__$1 = state_21166;
var statearr_21199_21230 = state_21166__$1;
(statearr_21199_21230[(2)] = inst_21150);

(statearr_21199_21230[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21167 === (10))){
var inst_21121 = (state_21166[(11)]);
var inst_21119 = (state_21166[(12)]);
var inst_21126 = cljs.core._nth.call(null,inst_21119,inst_21121);
var state_21166__$1 = state_21166;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21166__$1,(13),out,inst_21126);
} else {
if((state_val_21167 === (18))){
var inst_21132 = (state_21166[(7)]);
var inst_21141 = cljs.core.first.call(null,inst_21132);
var state_21166__$1 = state_21166;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21166__$1,(20),out,inst_21141);
} else {
if((state_val_21167 === (8))){
var inst_21120 = (state_21166[(8)]);
var inst_21121 = (state_21166[(11)]);
var inst_21123 = (inst_21121 < inst_21120);
var inst_21124 = inst_21123;
var state_21166__$1 = state_21166;
if(cljs.core.truth_(inst_21124)){
var statearr_21200_21231 = state_21166__$1;
(statearr_21200_21231[(1)] = (10));

} else {
var statearr_21201_21232 = state_21166__$1;
(statearr_21201_21232[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto__))
;
return ((function (switch__18593__auto__,c__18705__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__18594__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__18594__auto____0 = (function (){
var statearr_21205 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21205[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__18594__auto__);

(statearr_21205[(1)] = (1));

return statearr_21205;
});
var cljs$core$async$mapcat_STAR__$_state_machine__18594__auto____1 = (function (state_21166){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_21166);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e21206){if((e21206 instanceof Object)){
var ex__18597__auto__ = e21206;
var statearr_21207_21233 = state_21166;
(statearr_21207_21233[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21166);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21206;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21234 = state_21166;
state_21166 = G__21234;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__18594__auto__ = function(state_21166){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__18594__auto____1.call(this,state_21166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__18594__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__18594__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto__))
})();
var state__18707__auto__ = (function (){var statearr_21208 = f__18706__auto__.call(null);
(statearr_21208[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto__);

return statearr_21208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto__))
);

return c__18705__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21235 = [];
var len__7651__auto___21238 = arguments.length;
var i__7652__auto___21239 = (0);
while(true){
if((i__7652__auto___21239 < len__7651__auto___21238)){
args21235.push((arguments[i__7652__auto___21239]));

var G__21240 = (i__7652__auto___21239 + (1));
i__7652__auto___21239 = G__21240;
continue;
} else {
}
break;
}

var G__21237 = args21235.length;
switch (G__21237) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21235.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21242 = [];
var len__7651__auto___21245 = arguments.length;
var i__7652__auto___21246 = (0);
while(true){
if((i__7652__auto___21246 < len__7651__auto___21245)){
args21242.push((arguments[i__7652__auto___21246]));

var G__21247 = (i__7652__auto___21246 + (1));
i__7652__auto___21246 = G__21247;
continue;
} else {
}
break;
}

var G__21244 = args21242.length;
switch (G__21244) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21242.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21249 = [];
var len__7651__auto___21300 = arguments.length;
var i__7652__auto___21301 = (0);
while(true){
if((i__7652__auto___21301 < len__7651__auto___21300)){
args21249.push((arguments[i__7652__auto___21301]));

var G__21302 = (i__7652__auto___21301 + (1));
i__7652__auto___21301 = G__21302;
continue;
} else {
}
break;
}

var G__21251 = args21249.length;
switch (G__21251) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21249.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18705__auto___21304 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___21304,out){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___21304,out){
return (function (state_21275){
var state_val_21276 = (state_21275[(1)]);
if((state_val_21276 === (7))){
var inst_21270 = (state_21275[(2)]);
var state_21275__$1 = state_21275;
var statearr_21277_21305 = state_21275__$1;
(statearr_21277_21305[(2)] = inst_21270);

(statearr_21277_21305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21276 === (1))){
var inst_21252 = null;
var state_21275__$1 = (function (){var statearr_21278 = state_21275;
(statearr_21278[(7)] = inst_21252);

return statearr_21278;
})();
var statearr_21279_21306 = state_21275__$1;
(statearr_21279_21306[(2)] = null);

(statearr_21279_21306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21276 === (4))){
var inst_21255 = (state_21275[(8)]);
var inst_21255__$1 = (state_21275[(2)]);
var inst_21256 = (inst_21255__$1 == null);
var inst_21257 = cljs.core.not.call(null,inst_21256);
var state_21275__$1 = (function (){var statearr_21280 = state_21275;
(statearr_21280[(8)] = inst_21255__$1);

return statearr_21280;
})();
if(inst_21257){
var statearr_21281_21307 = state_21275__$1;
(statearr_21281_21307[(1)] = (5));

} else {
var statearr_21282_21308 = state_21275__$1;
(statearr_21282_21308[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21276 === (6))){
var state_21275__$1 = state_21275;
var statearr_21283_21309 = state_21275__$1;
(statearr_21283_21309[(2)] = null);

(statearr_21283_21309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21276 === (3))){
var inst_21272 = (state_21275[(2)]);
var inst_21273 = cljs.core.async.close_BANG_.call(null,out);
var state_21275__$1 = (function (){var statearr_21284 = state_21275;
(statearr_21284[(9)] = inst_21272);

return statearr_21284;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21275__$1,inst_21273);
} else {
if((state_val_21276 === (2))){
var state_21275__$1 = state_21275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21275__$1,(4),ch);
} else {
if((state_val_21276 === (11))){
var inst_21255 = (state_21275[(8)]);
var inst_21264 = (state_21275[(2)]);
var inst_21252 = inst_21255;
var state_21275__$1 = (function (){var statearr_21285 = state_21275;
(statearr_21285[(7)] = inst_21252);

(statearr_21285[(10)] = inst_21264);

return statearr_21285;
})();
var statearr_21286_21310 = state_21275__$1;
(statearr_21286_21310[(2)] = null);

(statearr_21286_21310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21276 === (9))){
var inst_21255 = (state_21275[(8)]);
var state_21275__$1 = state_21275;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21275__$1,(11),out,inst_21255);
} else {
if((state_val_21276 === (5))){
var inst_21252 = (state_21275[(7)]);
var inst_21255 = (state_21275[(8)]);
var inst_21259 = cljs.core._EQ_.call(null,inst_21255,inst_21252);
var state_21275__$1 = state_21275;
if(inst_21259){
var statearr_21288_21311 = state_21275__$1;
(statearr_21288_21311[(1)] = (8));

} else {
var statearr_21289_21312 = state_21275__$1;
(statearr_21289_21312[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21276 === (10))){
var inst_21267 = (state_21275[(2)]);
var state_21275__$1 = state_21275;
var statearr_21290_21313 = state_21275__$1;
(statearr_21290_21313[(2)] = inst_21267);

(statearr_21290_21313[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21276 === (8))){
var inst_21252 = (state_21275[(7)]);
var tmp21287 = inst_21252;
var inst_21252__$1 = tmp21287;
var state_21275__$1 = (function (){var statearr_21291 = state_21275;
(statearr_21291[(7)] = inst_21252__$1);

return statearr_21291;
})();
var statearr_21292_21314 = state_21275__$1;
(statearr_21292_21314[(2)] = null);

(statearr_21292_21314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___21304,out))
;
return ((function (switch__18593__auto__,c__18705__auto___21304,out){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_21296 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21296[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_21296[(1)] = (1));

return statearr_21296;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_21275){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_21275);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e21297){if((e21297 instanceof Object)){
var ex__18597__auto__ = e21297;
var statearr_21298_21315 = state_21275;
(statearr_21298_21315[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21275);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21297;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21316 = state_21275;
state_21275 = G__21316;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_21275){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_21275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___21304,out))
})();
var state__18707__auto__ = (function (){var statearr_21299 = f__18706__auto__.call(null);
(statearr_21299[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___21304);

return statearr_21299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___21304,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21317 = [];
var len__7651__auto___21387 = arguments.length;
var i__7652__auto___21388 = (0);
while(true){
if((i__7652__auto___21388 < len__7651__auto___21387)){
args21317.push((arguments[i__7652__auto___21388]));

var G__21389 = (i__7652__auto___21388 + (1));
i__7652__auto___21388 = G__21389;
continue;
} else {
}
break;
}

var G__21319 = args21317.length;
switch (G__21319) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21317.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18705__auto___21391 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___21391,out){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___21391,out){
return (function (state_21357){
var state_val_21358 = (state_21357[(1)]);
if((state_val_21358 === (7))){
var inst_21353 = (state_21357[(2)]);
var state_21357__$1 = state_21357;
var statearr_21359_21392 = state_21357__$1;
(statearr_21359_21392[(2)] = inst_21353);

(statearr_21359_21392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (1))){
var inst_21320 = (new Array(n));
var inst_21321 = inst_21320;
var inst_21322 = (0);
var state_21357__$1 = (function (){var statearr_21360 = state_21357;
(statearr_21360[(7)] = inst_21321);

(statearr_21360[(8)] = inst_21322);

return statearr_21360;
})();
var statearr_21361_21393 = state_21357__$1;
(statearr_21361_21393[(2)] = null);

(statearr_21361_21393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (4))){
var inst_21325 = (state_21357[(9)]);
var inst_21325__$1 = (state_21357[(2)]);
var inst_21326 = (inst_21325__$1 == null);
var inst_21327 = cljs.core.not.call(null,inst_21326);
var state_21357__$1 = (function (){var statearr_21362 = state_21357;
(statearr_21362[(9)] = inst_21325__$1);

return statearr_21362;
})();
if(inst_21327){
var statearr_21363_21394 = state_21357__$1;
(statearr_21363_21394[(1)] = (5));

} else {
var statearr_21364_21395 = state_21357__$1;
(statearr_21364_21395[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (15))){
var inst_21347 = (state_21357[(2)]);
var state_21357__$1 = state_21357;
var statearr_21365_21396 = state_21357__$1;
(statearr_21365_21396[(2)] = inst_21347);

(statearr_21365_21396[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (13))){
var state_21357__$1 = state_21357;
var statearr_21366_21397 = state_21357__$1;
(statearr_21366_21397[(2)] = null);

(statearr_21366_21397[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (6))){
var inst_21322 = (state_21357[(8)]);
var inst_21343 = (inst_21322 > (0));
var state_21357__$1 = state_21357;
if(cljs.core.truth_(inst_21343)){
var statearr_21367_21398 = state_21357__$1;
(statearr_21367_21398[(1)] = (12));

} else {
var statearr_21368_21399 = state_21357__$1;
(statearr_21368_21399[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (3))){
var inst_21355 = (state_21357[(2)]);
var state_21357__$1 = state_21357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21357__$1,inst_21355);
} else {
if((state_val_21358 === (12))){
var inst_21321 = (state_21357[(7)]);
var inst_21345 = cljs.core.vec.call(null,inst_21321);
var state_21357__$1 = state_21357;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21357__$1,(15),out,inst_21345);
} else {
if((state_val_21358 === (2))){
var state_21357__$1 = state_21357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21357__$1,(4),ch);
} else {
if((state_val_21358 === (11))){
var inst_21337 = (state_21357[(2)]);
var inst_21338 = (new Array(n));
var inst_21321 = inst_21338;
var inst_21322 = (0);
var state_21357__$1 = (function (){var statearr_21369 = state_21357;
(statearr_21369[(7)] = inst_21321);

(statearr_21369[(8)] = inst_21322);

(statearr_21369[(10)] = inst_21337);

return statearr_21369;
})();
var statearr_21370_21400 = state_21357__$1;
(statearr_21370_21400[(2)] = null);

(statearr_21370_21400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (9))){
var inst_21321 = (state_21357[(7)]);
var inst_21335 = cljs.core.vec.call(null,inst_21321);
var state_21357__$1 = state_21357;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21357__$1,(11),out,inst_21335);
} else {
if((state_val_21358 === (5))){
var inst_21321 = (state_21357[(7)]);
var inst_21322 = (state_21357[(8)]);
var inst_21325 = (state_21357[(9)]);
var inst_21330 = (state_21357[(11)]);
var inst_21329 = (inst_21321[inst_21322] = inst_21325);
var inst_21330__$1 = (inst_21322 + (1));
var inst_21331 = (inst_21330__$1 < n);
var state_21357__$1 = (function (){var statearr_21371 = state_21357;
(statearr_21371[(12)] = inst_21329);

(statearr_21371[(11)] = inst_21330__$1);

return statearr_21371;
})();
if(cljs.core.truth_(inst_21331)){
var statearr_21372_21401 = state_21357__$1;
(statearr_21372_21401[(1)] = (8));

} else {
var statearr_21373_21402 = state_21357__$1;
(statearr_21373_21402[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (14))){
var inst_21350 = (state_21357[(2)]);
var inst_21351 = cljs.core.async.close_BANG_.call(null,out);
var state_21357__$1 = (function (){var statearr_21375 = state_21357;
(statearr_21375[(13)] = inst_21350);

return statearr_21375;
})();
var statearr_21376_21403 = state_21357__$1;
(statearr_21376_21403[(2)] = inst_21351);

(statearr_21376_21403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (10))){
var inst_21341 = (state_21357[(2)]);
var state_21357__$1 = state_21357;
var statearr_21377_21404 = state_21357__$1;
(statearr_21377_21404[(2)] = inst_21341);

(statearr_21377_21404[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21358 === (8))){
var inst_21321 = (state_21357[(7)]);
var inst_21330 = (state_21357[(11)]);
var tmp21374 = inst_21321;
var inst_21321__$1 = tmp21374;
var inst_21322 = inst_21330;
var state_21357__$1 = (function (){var statearr_21378 = state_21357;
(statearr_21378[(7)] = inst_21321__$1);

(statearr_21378[(8)] = inst_21322);

return statearr_21378;
})();
var statearr_21379_21405 = state_21357__$1;
(statearr_21379_21405[(2)] = null);

(statearr_21379_21405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___21391,out))
;
return ((function (switch__18593__auto__,c__18705__auto___21391,out){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_21383 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21383[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_21383[(1)] = (1));

return statearr_21383;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_21357){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_21357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e21384){if((e21384 instanceof Object)){
var ex__18597__auto__ = e21384;
var statearr_21385_21406 = state_21357;
(statearr_21385_21406[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21357);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21384;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21407 = state_21357;
state_21357 = G__21407;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_21357){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_21357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___21391,out))
})();
var state__18707__auto__ = (function (){var statearr_21386 = f__18706__auto__.call(null);
(statearr_21386[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___21391);

return statearr_21386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___21391,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21408 = [];
var len__7651__auto___21482 = arguments.length;
var i__7652__auto___21483 = (0);
while(true){
if((i__7652__auto___21483 < len__7651__auto___21482)){
args21408.push((arguments[i__7652__auto___21483]));

var G__21484 = (i__7652__auto___21483 + (1));
i__7652__auto___21483 = G__21484;
continue;
} else {
}
break;
}

var G__21410 = args21408.length;
switch (G__21410) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21408.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18705__auto___21486 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18705__auto___21486,out){
return (function (){
var f__18706__auto__ = (function (){var switch__18593__auto__ = ((function (c__18705__auto___21486,out){
return (function (state_21452){
var state_val_21453 = (state_21452[(1)]);
if((state_val_21453 === (7))){
var inst_21448 = (state_21452[(2)]);
var state_21452__$1 = state_21452;
var statearr_21454_21487 = state_21452__$1;
(statearr_21454_21487[(2)] = inst_21448);

(statearr_21454_21487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (1))){
var inst_21411 = [];
var inst_21412 = inst_21411;
var inst_21413 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21452__$1 = (function (){var statearr_21455 = state_21452;
(statearr_21455[(7)] = inst_21412);

(statearr_21455[(8)] = inst_21413);

return statearr_21455;
})();
var statearr_21456_21488 = state_21452__$1;
(statearr_21456_21488[(2)] = null);

(statearr_21456_21488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (4))){
var inst_21416 = (state_21452[(9)]);
var inst_21416__$1 = (state_21452[(2)]);
var inst_21417 = (inst_21416__$1 == null);
var inst_21418 = cljs.core.not.call(null,inst_21417);
var state_21452__$1 = (function (){var statearr_21457 = state_21452;
(statearr_21457[(9)] = inst_21416__$1);

return statearr_21457;
})();
if(inst_21418){
var statearr_21458_21489 = state_21452__$1;
(statearr_21458_21489[(1)] = (5));

} else {
var statearr_21459_21490 = state_21452__$1;
(statearr_21459_21490[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (15))){
var inst_21442 = (state_21452[(2)]);
var state_21452__$1 = state_21452;
var statearr_21460_21491 = state_21452__$1;
(statearr_21460_21491[(2)] = inst_21442);

(statearr_21460_21491[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (13))){
var state_21452__$1 = state_21452;
var statearr_21461_21492 = state_21452__$1;
(statearr_21461_21492[(2)] = null);

(statearr_21461_21492[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (6))){
var inst_21412 = (state_21452[(7)]);
var inst_21437 = inst_21412.length;
var inst_21438 = (inst_21437 > (0));
var state_21452__$1 = state_21452;
if(cljs.core.truth_(inst_21438)){
var statearr_21462_21493 = state_21452__$1;
(statearr_21462_21493[(1)] = (12));

} else {
var statearr_21463_21494 = state_21452__$1;
(statearr_21463_21494[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (3))){
var inst_21450 = (state_21452[(2)]);
var state_21452__$1 = state_21452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21452__$1,inst_21450);
} else {
if((state_val_21453 === (12))){
var inst_21412 = (state_21452[(7)]);
var inst_21440 = cljs.core.vec.call(null,inst_21412);
var state_21452__$1 = state_21452;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21452__$1,(15),out,inst_21440);
} else {
if((state_val_21453 === (2))){
var state_21452__$1 = state_21452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21452__$1,(4),ch);
} else {
if((state_val_21453 === (11))){
var inst_21420 = (state_21452[(10)]);
var inst_21416 = (state_21452[(9)]);
var inst_21430 = (state_21452[(2)]);
var inst_21431 = [];
var inst_21432 = inst_21431.push(inst_21416);
var inst_21412 = inst_21431;
var inst_21413 = inst_21420;
var state_21452__$1 = (function (){var statearr_21464 = state_21452;
(statearr_21464[(7)] = inst_21412);

(statearr_21464[(11)] = inst_21432);

(statearr_21464[(12)] = inst_21430);

(statearr_21464[(8)] = inst_21413);

return statearr_21464;
})();
var statearr_21465_21495 = state_21452__$1;
(statearr_21465_21495[(2)] = null);

(statearr_21465_21495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (9))){
var inst_21412 = (state_21452[(7)]);
var inst_21428 = cljs.core.vec.call(null,inst_21412);
var state_21452__$1 = state_21452;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21452__$1,(11),out,inst_21428);
} else {
if((state_val_21453 === (5))){
var inst_21420 = (state_21452[(10)]);
var inst_21416 = (state_21452[(9)]);
var inst_21413 = (state_21452[(8)]);
var inst_21420__$1 = f.call(null,inst_21416);
var inst_21421 = cljs.core._EQ_.call(null,inst_21420__$1,inst_21413);
var inst_21422 = cljs.core.keyword_identical_QMARK_.call(null,inst_21413,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21423 = (inst_21421) || (inst_21422);
var state_21452__$1 = (function (){var statearr_21466 = state_21452;
(statearr_21466[(10)] = inst_21420__$1);

return statearr_21466;
})();
if(cljs.core.truth_(inst_21423)){
var statearr_21467_21496 = state_21452__$1;
(statearr_21467_21496[(1)] = (8));

} else {
var statearr_21468_21497 = state_21452__$1;
(statearr_21468_21497[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (14))){
var inst_21445 = (state_21452[(2)]);
var inst_21446 = cljs.core.async.close_BANG_.call(null,out);
var state_21452__$1 = (function (){var statearr_21470 = state_21452;
(statearr_21470[(13)] = inst_21445);

return statearr_21470;
})();
var statearr_21471_21498 = state_21452__$1;
(statearr_21471_21498[(2)] = inst_21446);

(statearr_21471_21498[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (10))){
var inst_21435 = (state_21452[(2)]);
var state_21452__$1 = state_21452;
var statearr_21472_21499 = state_21452__$1;
(statearr_21472_21499[(2)] = inst_21435);

(statearr_21472_21499[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21453 === (8))){
var inst_21420 = (state_21452[(10)]);
var inst_21412 = (state_21452[(7)]);
var inst_21416 = (state_21452[(9)]);
var inst_21425 = inst_21412.push(inst_21416);
var tmp21469 = inst_21412;
var inst_21412__$1 = tmp21469;
var inst_21413 = inst_21420;
var state_21452__$1 = (function (){var statearr_21473 = state_21452;
(statearr_21473[(7)] = inst_21412__$1);

(statearr_21473[(14)] = inst_21425);

(statearr_21473[(8)] = inst_21413);

return statearr_21473;
})();
var statearr_21474_21500 = state_21452__$1;
(statearr_21474_21500[(2)] = null);

(statearr_21474_21500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18705__auto___21486,out))
;
return ((function (switch__18593__auto__,c__18705__auto___21486,out){
return (function() {
var cljs$core$async$state_machine__18594__auto__ = null;
var cljs$core$async$state_machine__18594__auto____0 = (function (){
var statearr_21478 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21478[(0)] = cljs$core$async$state_machine__18594__auto__);

(statearr_21478[(1)] = (1));

return statearr_21478;
});
var cljs$core$async$state_machine__18594__auto____1 = (function (state_21452){
while(true){
var ret_value__18595__auto__ = (function (){try{while(true){
var result__18596__auto__ = switch__18593__auto__.call(null,state_21452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18596__auto__;
}
break;
}
}catch (e21479){if((e21479 instanceof Object)){
var ex__18597__auto__ = e21479;
var statearr_21480_21501 = state_21452;
(statearr_21480_21501[(5)] = ex__18597__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21452);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21479;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18595__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21502 = state_21452;
state_21452 = G__21502;
continue;
} else {
return ret_value__18595__auto__;
}
break;
}
});
cljs$core$async$state_machine__18594__auto__ = function(state_21452){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18594__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18594__auto____1.call(this,state_21452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18594__auto____0;
cljs$core$async$state_machine__18594__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18594__auto____1;
return cljs$core$async$state_machine__18594__auto__;
})()
;})(switch__18593__auto__,c__18705__auto___21486,out))
})();
var state__18707__auto__ = (function (){var statearr_21481 = f__18706__auto__.call(null);
(statearr_21481[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18705__auto___21486);

return statearr_21481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18707__auto__);
});})(c__18705__auto___21486,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

