// Compiled by ClojureScript 1.9.293 {}
goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16766 = arguments.length;
var i__7652__auto___16767 = (0);
while(true){
if((i__7652__auto___16767 < len__7651__auto___16766)){
args__7658__auto__.push((arguments[i__7652__auto___16767]));

var G__16768 = (i__7652__auto___16767 + (1));
i__7652__auto___16767 = G__16768;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,cljs.core.vec.call(null,apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq16765){
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16765));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
return com.rpl.specter.compiled_select.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
return com.rpl.specter.compiled_select_one.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
return com.rpl.specter.compiled_select_one_BANG_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
return com.rpl.specter.compiled_select_first.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
return com.rpl.specter.compiled_select_any.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
return com.rpl.specter.compiled_selected_any_QMARK_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
return com.rpl.specter.compiled_traverse.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath),structure);
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
return com.rpl.specter.compiled_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure);
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal`. Error is thrown if navigation finishes
 * at a non-`terminal` navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
return com.rpl.specter.compiled_multi_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
return com.rpl.specter.compiled_setval.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),val,structure);
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16776 = arguments.length;
var i__7652__auto___16777 = (0);
while(true){
if((i__7652__auto___16777 < len__7651__auto___16776)){
args__7658__auto__.push((arguments[i__7652__auto___16777]));

var G__16778 = (i__7652__auto___16777 + (1));
i__7652__auto___16777 = G__16778;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__16773){
var map__16774 = p__16773;
var map__16774__$1 = ((((!((map__16774 == null)))?((((map__16774.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16774.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16774):map__16774);
var merge_fn = cljs.core.get.call(null,map__16774__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
return com.rpl.specter.compiled_replace_in.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),merge_fn);
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq16769){
var G__16770 = cljs.core.first.call(null,seq16769);
var seq16769__$1 = cljs.core.next.call(null,seq16769);
var G__16771 = cljs.core.first.call(null,seq16769__$1);
var seq16769__$2 = cljs.core.next.call(null,seq16769__$1);
var G__16772 = cljs.core.first.call(null,seq16769__$2);
var seq16769__$3 = cljs.core.next.call(null,seq16769__$2);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__16770,G__16771,G__16772,seq16769__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.call(null,(function (navfn){
var latenavfn = com.rpl.specter.late_resolved_fn.call(null,navfn);
return cljs.core.vary_meta.call(null,((function (latenavfn){
return (function() { 
var G__16779__delegate = function (args){
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,args))){
return latenavfn.call(null,cljs.core.first.call(null,args));
} else {
return cljs.core.map.call(null,latenavfn,args);
}
};
var G__16779 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16780__i = 0, G__16780__a = new Array(arguments.length -  0);
while (G__16780__i < G__16780__a.length) {G__16780__a[G__16780__i] = arguments[G__16780__i + 0]; ++G__16780__i;}
  args = new cljs.core.IndexedSeq(G__16780__a,0);
} 
return G__16779__delegate.call(this,args);};
G__16779.cljs$lang$maxFixedArity = 0;
G__16779.cljs$lang$applyTo = (function (arglist__16781){
var args = cljs.core.seq(arglist__16781);
return G__16779__delegate(args);
});
G__16779.cljs$core$IFn$_invoke$arity$variadic = G__16779__delegate;
return G__16779;
})()
;})(latenavfn))
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16782 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16782 = (function (meta16783){
this.meta16783 = meta16783;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16782.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16784,meta16783__$1){
var self__ = this;
var _16784__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16782(meta16783__$1));
});

com.rpl.specter.t_com$rpl$specter16782.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16784){
var self__ = this;
var _16784__$1 = this;
return self__.meta16783;
});

com.rpl.specter.t_com$rpl$specter16782.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16782.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.NONE;
});

com.rpl.specter.t_com$rpl$specter16782.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter16782.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16783","meta16783",953472529,null)], null);
});

com.rpl.specter.t_com$rpl$specter16782.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16782.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16782";

com.rpl.specter.t_com$rpl$specter16782.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16782");
});

com.rpl.specter.__GT_t_com$rpl$specter16782 = (function com$rpl$specter$__GT_t_com$rpl$specter16782(meta16783){
return (new com.rpl.specter.t_com$rpl$specter16782(meta16783));
});

}

return (new com.rpl.specter.t_com$rpl$specter16782(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * For usage with `multi-transform`, defines an endpoint in the navigation
 *        that will have the parameterized transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter16785 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16785 = (function (afn,meta16786){
this.afn = afn;
this.meta16786 = meta16786;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16785.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16787,meta16786__$1){
var self__ = this;
var _16787__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16785(self__.afn,meta16786__$1));
});

com.rpl.specter.t_com$rpl$specter16785.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16787){
var self__ = this;
var _16787__$1 = this;
return self__.meta16786;
});

com.rpl.specter.t_com$rpl$specter16785.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16785.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"'terminal' should only be used in multi-transform")));
});

com.rpl.specter.t_com$rpl$specter16785.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_.call(null,self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter16785.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta16786","meta16786",-1570426646,null)], null);
});

com.rpl.specter.t_com$rpl$specter16785.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16785.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16785";

com.rpl.specter.t_com$rpl$specter16785.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16785");
});

com.rpl.specter.__GT_t_com$rpl$specter16785 = (function com$rpl$specter$__GT_t_com$rpl$specter16785(afn__$1,meta16786){
return (new com.rpl.specter.t_com$rpl$specter16785(afn__$1,meta16786));
});

}

return (new com.rpl.specter.t_com$rpl$specter16785(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
return com.rpl.specter.terminal.call(null,com.rpl.specter.impl.fast_constantly.call(null,v));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16788 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16788 = (function (meta16789){
this.meta16789 = meta16789;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16788.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16790,meta16789__$1){
var self__ = this;
var _16790__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16788(meta16789__$1));
});

com.rpl.specter.t_com$rpl$specter16788.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16790){
var self__ = this;
var _16790__$1 = this;
return self__.meta16789;
});

com.rpl.specter.t_com$rpl$specter16788.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16788.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter16788.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter16788.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16789","meta16789",791146087,null)], null);
});

com.rpl.specter.t_com$rpl$specter16788.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16788.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16788";

com.rpl.specter.t_com$rpl$specter16788.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16788");
});

com.rpl.specter.__GT_t_com$rpl$specter16788 = (function com$rpl$specter$__GT_t_com$rpl$specter16788(meta16789){
return (new com.rpl.specter.t_com$rpl$specter16788(meta16789));
});

}

return (new com.rpl.specter.t_com$rpl$specter16788(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__13765__auto__,v){
var ret__13766__auto__ = next_fn.call(null,v);
if((ret__13766__auto__ === com.rpl.specter.NONE)){
return curr__13765__auto__;
} else {
return ret__13766__auto__;
}
}),com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16791 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16791 = (function (meta16792){
this.meta16792 = meta16792;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16791.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16793,meta16792__$1){
var self__ = this;
var _16793__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16791(meta16792__$1));
});

com.rpl.specter.t_com$rpl$specter16791.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16793){
var self__ = this;
var _16793__$1 = this;
return self__.meta16792;
});

com.rpl.specter.t_com$rpl$specter16791.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16791.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__15513__auto____$1){
return (function (curr__13765__auto__,v){
var ret__13766__auto__ = next_fn.call(null,v);
if((ret__13766__auto__ === com.rpl.specter.NONE)){
return curr__13765__auto__;
} else {
return ret__13766__auto__;
}
});})(next_fn,this__15513__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16791.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter16791.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16792","meta16792",-1370054326,null)], null);
});

com.rpl.specter.t_com$rpl$specter16791.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16791.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16791";

com.rpl.specter.t_com$rpl$specter16791.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16791");
});

com.rpl.specter.__GT_t_com$rpl$specter16791 = (function com$rpl$specter$__GT_t_com$rpl$specter16791(meta16792){
return (new com.rpl.specter.t_com$rpl$specter16791(meta16792));
});

}

return (new com.rpl.specter.t_com$rpl$specter16791(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16794 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16794 = (function (meta16795){
this.meta16795 = meta16795;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16794.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16796,meta16795__$1){
var self__ = this;
var _16796__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16794(meta16795__$1));
});

com.rpl.specter.t_com$rpl$specter16794.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16796){
var self__ = this;
var _16796__$1 = this;
return self__.meta16795;
});

com.rpl.specter.t_com$rpl$specter16794.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16794.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16148__auto__,vals__16149__auto__,structure,next_fn__16150__auto__){
var self__ = this;
var this__16148__auto____$1 = this;
return next_fn__16150__auto__.call(null,cljs.core.conj.call(null,vals__16149__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter16794.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16148__auto__,vals__16149__auto__,structure,next_fn__16150__auto__){
var self__ = this;
var this__16148__auto____$1 = this;
return next_fn__16150__auto__.call(null,cljs.core.conj.call(null,vals__16149__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter16794.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16795","meta16795",1684340449,null)], null);
});

com.rpl.specter.t_com$rpl$specter16794.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16794.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16794";

com.rpl.specter.t_com$rpl$specter16794.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16794");
});

com.rpl.specter.__GT_t_com$rpl$specter16794 = (function com$rpl$specter$__GT_t_com$rpl$specter16794(meta16795){
return (new com.rpl.specter.t_com$rpl$specter16794(meta16795));
});

}

return (new com.rpl.specter.t_com$rpl$specter16794(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last);
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first);


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_fn,end_fn,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start_fn.call(null,structure),end_fn.call(null,structure),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_fn,end_fn,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start_fn.call(null,structure),end_fn.call(null,structure),next_fn);
});

/**
 * Uses start-fn and end-fn to determine the bounds of the subsequence
 *        to select when navigating. Each function takes in the structure as input.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start_fn,end_fn){
if(typeof com.rpl.specter.t_com$rpl$specter16797 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16797 = (function (start_fn,end_fn,meta16798){
this.start_fn = start_fn;
this.end_fn = end_fn;
this.meta16798 = meta16798;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16797.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16799,meta16798__$1){
var self__ = this;
var _16799__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16797(self__.start_fn,self__.end_fn,meta16798__$1));
});

com.rpl.specter.t_com$rpl$specter16797.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16799){
var self__ = this;
var _16799__$1 = this;
return self__.meta16798;
});

com.rpl.specter.t_com$rpl$specter16797.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16797.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start_fn.call(null,structure),self__.end_fn.call(null,structure),next_fn);
});

com.rpl.specter.t_com$rpl$specter16797.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start_fn.call(null,structure),self__.end_fn.call(null,structure),next_fn);
});

com.rpl.specter.t_com$rpl$specter16797.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-fn","start-fn",-1617360859,null),new cljs.core.Symbol(null,"end-fn","end-fn",1694587211,null),new cljs.core.Symbol(null,"meta16798","meta16798",-103275704,null)], null);
});

com.rpl.specter.t_com$rpl$specter16797.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16797.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16797";

com.rpl.specter.t_com$rpl$specter16797.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16797");
});

com.rpl.specter.__GT_t_com$rpl$specter16797 = (function com$rpl$specter$__GT_t_com$rpl$specter16797(start_fn__$1,end_fn__$1,meta16798){
return (new com.rpl.specter.t_com$rpl$specter16797(start_fn__$1,end_fn__$1,meta16798));
});

}

return (new com.rpl.specter.t_com$rpl$specter16797(start_fn,end_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn);
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter16800 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16800 = (function (start,end,meta16801){
this.start = start;
this.end = end;
this.meta16801 = meta16801;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16800.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16802,meta16801__$1){
var self__ = this;
var _16802__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16800(self__.start,self__.end,meta16801__$1));
});

com.rpl.specter.t_com$rpl$specter16800.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16802){
var self__ = this;
var _16802__$1 = this;
return self__.meta16801;
});

com.rpl.specter.t_com$rpl$specter16800.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16800.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter16800.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter16800.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta16801","meta16801",-157902135,null)], null);
});

com.rpl.specter.t_com$rpl$specter16800.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16800.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16800";

com.rpl.specter.t_com$rpl$specter16800.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16800");
});

com.rpl.specter.__GT_t_com$rpl$specter16800 = (function com$rpl$specter$__GT_t_com$rpl$specter16800(start__$1,end__$1,meta16801){
return (new com.rpl.specter.t_com$rpl$specter16800(start__$1,end__$1,meta16801));
});

}

return (new com.rpl.specter.t_com$rpl$specter16800(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__13765__auto__,p__16807){
var vec__16808 = p__16807;
var s = cljs.core.nth.call(null,vec__16808,(0),null);
var e = cljs.core.nth.call(null,vec__16808,(1),null);
var ret__13766__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__13766__auto__ === com.rpl.specter.NONE)){
return curr__13765__auto__;
} else {
return ret__13766__auto__;
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj.call(null,(function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter16811 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16811 = (function (pred,meta16812){
this.pred = pred;
this.meta16812 = meta16812;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16811.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16813,meta16812__$1){
var self__ = this;
var _16813__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16811(self__.pred,meta16812__$1));
});

com.rpl.specter.t_com$rpl$specter16811.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16813){
var self__ = this;
var _16813__$1 = this;
return self__.meta16812;
});

com.rpl.specter.t_com$rpl$specter16811.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16811.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__15513__auto____$1){
return (function (curr__13765__auto__,p__16814){
var vec__16815 = p__16814;
var s = cljs.core.nth.call(null,vec__16815,(0),null);
var e = cljs.core.nth.call(null,vec__16815,(1),null);
var ret__13766__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__13766__auto__ === com.rpl.specter.NONE)){
return curr__13765__auto__;
} else {
return ret__13766__auto__;
}
});})(next_fn,this__15513__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,self__.pred));
});

com.rpl.specter.t_com$rpl$specter16811.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter16811.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta16812","meta16812",2013171126,null)], null);
});

com.rpl.specter.t_com$rpl$specter16811.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16811.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16811";

com.rpl.specter.t_com$rpl$specter16811.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16811");
});

com.rpl.specter.__GT_t_com$rpl$specter16811 = (function com$rpl$specter$__GT_t_com$rpl$specter16811(pred__$1,meta16812){
return (new com.rpl.specter.t_com$rpl$specter16811(pred__$1,meta16812));
});

}

return (new com.rpl.specter.t_com$rpl$specter16811(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16818 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16818 = (function (meta16819){
this.meta16819 = meta16819;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16818.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16820,meta16819__$1){
var self__ = this;
var _16820__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16818(meta16819__$1));
});

com.rpl.specter.t_com$rpl$specter16818.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16820){
var self__ = this;
var _16820__$1 = this;
return self__.meta16819;
});

com.rpl.specter.t_com$rpl$specter16818.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16818.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.t_com$rpl$specter16818.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
});

com.rpl.specter.t_com$rpl$specter16818.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16819","meta16819",782014449,null)], null);
});

com.rpl.specter.t_com$rpl$specter16818.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16818.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16818";

com.rpl.specter.t_com$rpl$specter16818.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16818");
});

com.rpl.specter.__GT_t_com$rpl$specter16818 = (function com$rpl$specter$__GT_t_com$rpl$specter16818(meta16819){
return (new com.rpl.specter.t_com$rpl$specter16818(meta16819));
});

}

return (new com.rpl.specter.t_com$rpl$specter16818(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16821 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16821 = (function (meta16822){
this.meta16822 = meta16822;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16821.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16823,meta16822__$1){
var self__ = this;
var _16823__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16821(meta16822__$1));
});

com.rpl.specter.t_com$rpl$specter16821.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16823){
var self__ = this;
var _16823__$1 = this;
return self__.meta16822;
});

com.rpl.specter.t_com$rpl$specter16821.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16821.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.t_com$rpl$specter16821.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
});

com.rpl.specter.t_com$rpl$specter16821.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16822","meta16822",166971423,null)], null);
});

com.rpl.specter.t_com$rpl$specter16821.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16821.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16821";

com.rpl.specter.t_com$rpl$specter16821.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16821");
});

com.rpl.specter.__GT_t_com$rpl$specter16821 = (function com$rpl$specter$__GT_t_com$rpl$specter16821(meta16822){
return (new com.rpl.specter.t_com$rpl$specter16821(meta16822));
});

}

return (new com.rpl.specter.t_com$rpl$specter16821(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
return next_fn.call(null,clojure.set.intersection.call(null,structure,aset));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.call(null,structure,aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj.call(null,(function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter16824 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16824 = (function (aset,meta16825){
this.aset = aset;
this.meta16825 = meta16825;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16824.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16826,meta16825__$1){
var self__ = this;
var _16826__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16824(self__.aset,meta16825__$1));
});

com.rpl.specter.t_com$rpl$specter16824.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16826){
var self__ = this;
var _16826__$1 = this;
return self__.meta16825;
});

com.rpl.specter.t_com$rpl$specter16824.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16824.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,clojure.set.intersection.call(null,structure,self__.aset));
});

com.rpl.specter.t_com$rpl$specter16824.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
var subset = clojure.set.intersection.call(null,structure,self__.aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter16824.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta16825","meta16825",673346867,null)], null);
});

com.rpl.specter.t_com$rpl$specter16824.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16824.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16824";

com.rpl.specter.t_com$rpl$specter16824.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16824");
});

com.rpl.specter.__GT_t_com$rpl$specter16824 = (function com$rpl$specter$__GT_t_com$rpl$specter16824(aset__$1,meta16825){
return (new com.rpl.specter.t_com$rpl$specter16824(aset__$1,meta16825));
});

}

return (new com.rpl.specter.t_com$rpl$specter16824(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
return next_fn.call(null,cljs.core.select_keys.call(null,structure,m_keys));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys.call(null,structure,m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,m_keys),newmap);
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj.call(null,(function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter16827 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16827 = (function (m_keys,meta16828){
this.m_keys = m_keys;
this.meta16828 = meta16828;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16827.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16829,meta16828__$1){
var self__ = this;
var _16829__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16827(self__.m_keys,meta16828__$1));
});

com.rpl.specter.t_com$rpl$specter16827.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16829){
var self__ = this;
var _16829__$1 = this;
return self__.meta16828;
});

com.rpl.specter.t_com$rpl$specter16827.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16827.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,cljs.core.select_keys.call(null,structure,self__.m_keys));
});

com.rpl.specter.t_com$rpl$specter16827.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
var submap = cljs.core.select_keys.call(null,structure,self__.m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,self__.m_keys),newmap);
});

com.rpl.specter.t_com$rpl$specter16827.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta16828","meta16828",1845338344,null)], null);
});

com.rpl.specter.t_com$rpl$specter16827.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16827.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16827";

com.rpl.specter.t_com$rpl$specter16827.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16827");
});

com.rpl.specter.__GT_t_com$rpl$specter16827 = (function com$rpl$specter$__GT_t_com$rpl$specter16827(m_keys__$1,meta16828){
return (new com.rpl.specter.t_com$rpl$specter16827(m_keys__$1,meta16828));
});

}

return (new com.rpl.specter.t_com$rpl$specter16827(m_keys,null));
}));


com.rpl.specter.walker_select_STAR_ = (function com$rpl$specter$walker_select_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_select.call(null,afn,next_fn,structure);
});

com.rpl.specter.walker_transform_STAR_ = (function com$rpl$specter$walker_transform_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_until.call(null,afn,next_fn,structure);
});

/**
 * Using clojure.walk, navigate the data structure until reaching
 *        a value for which `afn` returns truthy.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter16830 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16830 = (function (afn,meta16831){
this.afn = afn;
this.meta16831 = meta16831;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16830.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16832,meta16831__$1){
var self__ = this;
var _16832__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16830(self__.afn,meta16831__$1));
});

com.rpl.specter.t_com$rpl$specter16830.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16832){
var self__ = this;
var _16832__$1 = this;
return self__.meta16831;
});

com.rpl.specter.t_com$rpl$specter16830.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16830.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.walk_select.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter16830.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.walk_until.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter16830.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta16831","meta16831",1751876361,null)], null);
});

com.rpl.specter.t_com$rpl$specter16830.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16830.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16830";

com.rpl.specter.t_com$rpl$specter16830.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16830");
});

com.rpl.specter.__GT_t_com$rpl$specter16830 = (function com$rpl$specter$__GT_t_com$rpl$specter16830(afn__$1,meta16831){
return (new com.rpl.specter.t_com$rpl$specter16830(afn__$1,meta16831));
});

}

return (new com.rpl.specter.t_com$rpl$specter16830(afn,null));
}));


com.rpl.specter.codewalker_select_STAR_ = (function com$rpl$specter$codewalker_select_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_select.call(null,afn,next_fn,structure);
});

com.rpl.specter.codewalker_transform_STAR_ = (function com$rpl$specter$codewalker_transform_STAR_(afn,structure,next_fn){
return com.rpl.specter.impl.codewalk_until.call(null,afn,next_fn,structure);
});

/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter16833 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16833 = (function (afn,meta16834){
this.afn = afn;
this.meta16834 = meta16834;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16833.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16835,meta16834__$1){
var self__ = this;
var _16835__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16833(self__.afn,meta16834__$1));
});

com.rpl.specter.t_com$rpl$specter16833.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16835){
var self__ = this;
var _16835__$1 = this;
return self__.meta16834;
});

com.rpl.specter.t_com$rpl$specter16833.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16833.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.navs.walk_select.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter16833.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return com.rpl.specter.impl.codewalk_until.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter16833.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta16834","meta16834",1763288492,null)], null);
});

com.rpl.specter.t_com$rpl$specter16833.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16833.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16833";

com.rpl.specter.t_com$rpl$specter16833.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16833");
});

com.rpl.specter.__GT_t_com$rpl$specter16833 = (function com$rpl$specter$__GT_t_com$rpl$specter16833(afn__$1,meta16834){
return (new com.rpl.specter.t_com$rpl$specter16833(afn__$1,meta16834));
});

}

return (new com.rpl.specter.t_com$rpl$specter16833(afn,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 */
com.rpl.specter.subselect = cljs.core.vary_meta.call(null,(function() { 
var G__16839__delegate = function (path){
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16836 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16836 = (function (path,late,meta16837){
this.path = path;
this.late = late;
this.meta16837 = meta16837;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16836.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16838,meta16837__$1){
var self__ = this;
var _16838__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16836(self__.path,self__.late,meta16837__$1));
});

com.rpl.specter.t_com$rpl$specter16836.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16838){
var self__ = this;
var _16838__$1 = this;
return self__.meta16837;
});

com.rpl.specter.t_com$rpl$specter16836.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16836.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_select.call(null,self__.late,structure));
});

com.rpl.specter.t_com$rpl$specter16836.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
var select_result = com.rpl.specter.compiled_select.call(null,self__.late,structure);
var transformed = next_fn.call(null,select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.call(null,transformed);
return com.rpl.specter.compiled_transform.call(null,self__.late,((function (select_result,transformed,values_to_insert,next_fn,this__15513__auto____$1){
return (function (_){
var next_val = cljs.core.first.call(null,com.rpl.specter.impl.get_cell.call(null,values_to_insert));
com.rpl.specter.impl.update_cell_BANG_.call(null,values_to_insert,cljs.core.rest);

return next_val;
});})(select_result,transformed,values_to_insert,next_fn,this__15513__auto____$1))
,structure);
});

com.rpl.specter.t_com$rpl$specter16836.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16837","meta16837",765425094,null)], null);
});

com.rpl.specter.t_com$rpl$specter16836.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16836.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16836";

com.rpl.specter.t_com$rpl$specter16836.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16836");
});

com.rpl.specter.__GT_t_com$rpl$specter16836 = (function com$rpl$specter$__GT_t_com$rpl$specter16836(path__$1,late__$1,meta16837){
return (new com.rpl.specter.t_com$rpl$specter16836(path__$1,late__$1,meta16837));
});

}

return (new com.rpl.specter.t_com$rpl$specter16836(path,late,null));
}));
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
};
var G__16839 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16840__i = 0, G__16840__a = new Array(arguments.length -  0);
while (G__16840__i < G__16840__a.length) {G__16840__a[G__16840__i] = arguments[G__16840__i + 0]; ++G__16840__i;}
  path = new cljs.core.IndexedSeq(G__16840__a,0);
} 
return G__16839__delegate.call(this,path);};
G__16839.cljs$lang$maxFixedArity = 0;
G__16839.cljs$lang$applyTo = (function (arglist__16841){
var path = cljs.core.seq(arglist__16841);
return G__16839__delegate(path);
});
G__16839.cljs$core$IFn$_invoke$arity$variadic = G__16839__delegate;
return G__16839;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.keypath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_);
com.rpl.specter.must = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_);
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter16842 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16842 = (function (afn,meta16843){
this.afn = afn;
this.meta16843 = meta16843;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16842.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16844,meta16843__$1){
var self__ = this;
var _16844__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16842(self__.afn,meta16843__$1));
});

com.rpl.specter.t_com$rpl$specter16842.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16844){
var self__ = this;
var _16844__$1 = this;
return self__.meta16843;
});

com.rpl.specter.t_com$rpl$specter16842.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16842.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16842.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16842.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta16843","meta16843",850643808,null)], null);
});

com.rpl.specter.t_com$rpl$specter16842.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16842.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16842";

com.rpl.specter.t_com$rpl$specter16842.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16842");
});

com.rpl.specter.__GT_t_com$rpl$specter16842 = (function com$rpl$specter$__GT_t_com$rpl$specter16842(afn__$1,meta16843){
return (new com.rpl.specter.t_com$rpl$specter16842(afn__$1,meta16843));
});

}

return (new com.rpl.specter.t_com$rpl$specter16842(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
return next_fn.call(null,parse_fn.call(null,structure));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
return unparse_fn.call(null,next_fn.call(null,parse_fn.call(null,structure)));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj.call(null,(function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter16845 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16845 = (function (parse_fn,unparse_fn,meta16846){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta16846 = meta16846;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16845.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16847,meta16846__$1){
var self__ = this;
var _16847__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16845(self__.parse_fn,self__.unparse_fn,meta16846__$1));
});

com.rpl.specter.t_com$rpl$specter16845.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16847){
var self__ = this;
var _16847__$1 = this;
return self__.meta16846;
});

com.rpl.specter.t_com$rpl$specter16845.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16845.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,self__.parse_fn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16845.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return self__.unparse_fn.call(null,next_fn.call(null,self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter16845.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta16846","meta16846",1705628564,null)], null);
});

com.rpl.specter.t_com$rpl$specter16845.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16845.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16845";

com.rpl.specter.t_com$rpl$specter16845.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16845");
});

com.rpl.specter.__GT_t_com$rpl$specter16845 = (function com$rpl$specter$__GT_t_com$rpl$specter16845(parse_fn__$1,unparse_fn__$1,meta16846){
return (new com.rpl.specter.t_com$rpl$specter16845(parse_fn__$1,unparse_fn__$1,meta16846));
});

}

return (new com.rpl.specter.t_com$rpl$specter16845(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16848 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16848 = (function (meta16849){
this.meta16849 = meta16849;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16848.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16850,meta16849__$1){
var self__ = this;
var _16850__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16848(meta16849__$1));
});

com.rpl.specter.t_com$rpl$specter16848.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16850){
var self__ = this;
var _16850__$1 = this;
return self__.meta16849;
});

com.rpl.specter.t_com$rpl$specter16848.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16848.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16848.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter16848.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16849","meta16849",-1004832789,null)], null);
});

com.rpl.specter.t_com$rpl$specter16848.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16848.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16848";

com.rpl.specter.t_com$rpl$specter16848.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16848");
});

com.rpl.specter.__GT_t_com$rpl$specter16848 = (function com$rpl$specter$__GT_t_com$rpl$specter16848(meta16849){
return (new com.rpl.specter.t_com$rpl$specter16848(meta16849));
});

}

return (new com.rpl.specter.t_com$rpl$specter16848(null));
})()
;
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.call(null,(function() { 
var G__16856__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return afn;
} else {
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16853 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16853 = (function (path,temp__4655__auto__,late,meta16854){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta16854 = meta16854;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16853.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_16855,meta16854__$1){
var self__ = this;
var _16855__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16853(self__.path,self__.temp__4655__auto__,self__.late,meta16854__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16853.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_16855){
var self__ = this;
var _16855__$1 = this;
return self__.meta16854;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16853.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16853.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1,temp__4655__auto__){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_select.call(null,((function (next_fn,this__15513__auto____$1,temp__4655__auto__){
return (function (p1__16851_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,p1__16851_SHARP_);
});})(next_fn,this__15513__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16853.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1,temp__4655__auto__){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_transform.call(null,((function (next_fn,this__15513__auto____$1,temp__4655__auto__){
return (function (p1__16852_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,p1__16852_SHARP_);
});})(next_fn,this__15513__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16853.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16854","meta16854",2041841219,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16853.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16853.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16853";

com.rpl.specter.t_com$rpl$specter16853.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16853");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter16853 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter16853(path__$1,temp__4655__auto____$1,late__$1,meta16854){
return (new com.rpl.specter.t_com$rpl$specter16853(path__$1,temp__4655__auto____$1,late__$1,meta16854));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter16853(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
}
};
var G__16856 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16857__i = 0, G__16857__a = new Array(arguments.length -  0);
while (G__16857__i < G__16857__a.length) {G__16857__a[G__16857__i] = arguments[G__16857__i + 0]; ++G__16857__i;}
  path = new cljs.core.IndexedSeq(G__16857__a,0);
} 
return G__16856__delegate.call(this,path);};
G__16856.cljs$lang$maxFixedArity = 0;
G__16856.cljs$lang$applyTo = (function (arglist__16858){
var path = cljs.core.seq(arglist__16858);
return G__16856__delegate(path);
});
G__16856.cljs$core$IFn$_invoke$arity$variadic = G__16856__delegate;
return G__16856;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.call(null,(function() { 
var G__16864__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return ((function (afn,temp__4655__auto__){
return (function (s){
return cljs.core.not.call(null,afn.call(null,s));
});
;})(afn,temp__4655__auto__))
} else {
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16861 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16861 = (function (path,temp__4655__auto__,late,meta16862){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta16862 = meta16862;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16861.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_16863,meta16862__$1){
var self__ = this;
var _16863__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16861(self__.path,self__.temp__4655__auto__,self__.late,meta16862__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16861.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_16863){
var self__ = this;
var _16863__$1 = this;
return self__.meta16862;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16861.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16861.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1,temp__4655__auto__){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_select.call(null,((function (next_fn,this__15513__auto____$1,temp__4655__auto__){
return (function (p1__16859_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,p1__16859_SHARP_);
});})(next_fn,this__15513__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16861.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1,temp__4655__auto__){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_transform.call(null,((function (next_fn,this__15513__auto____$1,temp__4655__auto__){
return (function (p1__16860_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,p1__16860_SHARP_);
});})(next_fn,this__15513__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16861.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16862","meta16862",-577979107,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16861.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16861.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16861";

com.rpl.specter.t_com$rpl$specter16861.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16861");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter16861 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter16861(path__$1,temp__4655__auto____$1,late__$1,meta16862){
return (new com.rpl.specter.t_com$rpl$specter16861(path__$1,temp__4655__auto____$1,late__$1,meta16862));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter16861(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
}
};
var G__16864 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16865__i = 0, G__16865__a = new Array(arguments.length -  0);
while (G__16865__i < G__16865__a.length) {G__16865__a[G__16865__i] = arguments[G__16865__i + 0]; ++G__16865__i;}
  path = new cljs.core.IndexedSeq(G__16865__a,0);
} 
return G__16864__delegate.call(this,path);};
G__16864.cljs$lang$maxFixedArity = 0;
G__16864.cljs$lang$applyTo = (function (arglist__16866){
var path = cljs.core.seq(arglist__16866);
return G__16864__delegate(path);
});
G__16864.cljs$core$IFn$_invoke$arity$variadic = G__16864__delegate;
return G__16864;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.call(null,(function() { 
var G__16867__delegate = function (path){
return com.rpl.specter.subselect.call(null,com.rpl.specter.ALL,com.rpl.specter.selected_QMARK_.call(null,path));
};
var G__16867 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16868__i = 0, G__16868__a = new Array(arguments.length -  0);
while (G__16868__i < G__16868__a.length) {G__16868__a[G__16868__i] = arguments[G__16868__i + 0]; ++G__16868__i;}
  path = new cljs.core.IndexedSeq(G__16868__a,0);
} 
return G__16867__delegate.call(this,path);};
G__16867.cljs$lang$maxFixedArity = 0;
G__16867.cljs$lang$applyTo = (function (arglist__16869){
var path = cljs.core.seq(arglist__16869);
return G__16867__delegate(path);
});
G__16867.cljs$core$IFn$_invoke$arity$variadic = G__16867__delegate;
return G__16867;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.call(null,(function (path,update_fn){
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter16870 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16870 = (function (path,update_fn,late,late_fn,meta16871){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta16871 = meta16871;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16870.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16872,meta16871__$1){
var self__ = this;
var _16872__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16870(self__.path,self__.update_fn,self__.late,self__.late_fn,meta16871__$1));
});

com.rpl.specter.t_com$rpl$specter16870.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16872){
var self__ = this;
var _16872__$1 = this;
return self__.meta16871;
});

com.rpl.specter.t_com$rpl$specter16870.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16870.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter16870.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter16870.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta16871","meta16871",-1109999131,null)], null);
});

com.rpl.specter.t_com$rpl$specter16870.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16870.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16870";

com.rpl.specter.t_com$rpl$specter16870.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16870");
});

com.rpl.specter.__GT_t_com$rpl$specter16870 = (function com$rpl$specter$__GT_t_com$rpl$specter16870(path__$1,update_fn__$1,late__$1,late_fn__$1,meta16871){
return (new com.rpl.specter.t_com$rpl$specter16870(path__$1,update_fn__$1,late__$1,late_fn__$1,meta16871));
});

}

return (new com.rpl.specter.t_com$rpl$specter16870(path,update_fn,late,late_fn,null));
}));
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),update_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.call(null,(function (path,reduce_fn){
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter16873 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16873 = (function (path,reduce_fn,late,late_fn,meta16874){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta16874 = meta16874;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16873.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16875,meta16874__$1){
var self__ = this;
var _16875__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16873(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta16874__$1));
});

com.rpl.specter.t_com$rpl$specter16873.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16875){
var self__ = this;
var _16875__$1 = this;
return self__.meta16874;
});

com.rpl.specter.t_com$rpl$specter16873.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16873.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter16873.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter16873.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta16874","meta16874",-1173811132,null)], null);
});

com.rpl.specter.t_com$rpl$specter16873.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16873.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16873";

com.rpl.specter.t_com$rpl$specter16873.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16873");
});

com.rpl.specter.__GT_t_com$rpl$specter16873 = (function com$rpl$specter$__GT_t_com$rpl$specter16873(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta16874){
return (new com.rpl.specter.t_com$rpl$specter16873(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta16874));
});

}

return (new com.rpl.specter.t_com$rpl$specter16873(path,reduce_fn,late,late_fn,null));
}));
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),reduce_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. This is the
 *        late-bound parameterized version of using a function directly in a path.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
(com.rpl.specter.protocols.ImplicitNav["null"] = true);

(com.rpl.specter.protocols.implicit_nav["null"] = (function (this$){
return com.rpl.specter.STAY;
}));
cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1);
});
(com.rpl.specter.protocols.ImplicitNav["function"] = true);

(com.rpl.specter.protocols.implicit_nav["function"] = (function (this$){
return com.rpl.specter.pred.call(null,this$);
}));
cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.pred.call(null,this$__$1);
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj.call(null,(function (v){
if(typeof com.rpl.specter.t_com$rpl$specter16876 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16876 = (function (v,meta16877){
this.v = v;
this.meta16877 = meta16877;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16876.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16878,meta16877__$1){
var self__ = this;
var _16878__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16876(self__.v,meta16877__$1));
});

com.rpl.specter.t_com$rpl$specter16876.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16878){
var self__ = this;
var _16878__$1 = this;
return self__.meta16877;
});

com.rpl.specter.t_com$rpl$specter16876.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16876.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter16876.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter16876.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta16877","meta16877",-442891139,null)], null);
});

com.rpl.specter.t_com$rpl$specter16876.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16876.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16876";

com.rpl.specter.t_com$rpl$specter16876.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16876");
});

com.rpl.specter.__GT_t_com$rpl$specter16876 = (function com$rpl$specter$__GT_t_com$rpl$specter16876(v__$1,meta16877){
return (new com.rpl.specter.t_com$rpl$specter16876(v__$1,meta16877));
});

}

return (new com.rpl.specter.t_com$rpl$specter16876(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentHashSet.EMPTY);
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = com.rpl.specter.nil__GT_val.call(null,cljs.core.List.EMPTY);
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentVector.EMPTY);


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16879 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16879 = (function (meta16880){
this.meta16880 = meta16880;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16879.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16881,meta16880__$1){
var self__ = this;
var _16881__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16879(meta16880__$1));
});

com.rpl.specter.t_com$rpl$specter16879.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16881){
var self__ = this;
var _16881__$1 = this;
return self__.meta16880;
});

com.rpl.specter.t_com$rpl$specter16879.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16879.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter16879.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__15513__auto__,vals__15514__auto__,structure,next_fn__15515__auto__){
var self__ = this;
var this__15513__auto____$1 = this;
var next_fn = ((function (this__15513__auto____$1){
return (function (s__15516__auto__){
return next_fn__15515__auto__.call(null,vals__15514__auto__,s__15516__auto__);
});})(this__15513__auto____$1))
;
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter16879.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16880","meta16880",-132040635,null)], null);
});

com.rpl.specter.t_com$rpl$specter16879.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16879.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16879";

com.rpl.specter.t_com$rpl$specter16879.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16879");
});

com.rpl.specter.__GT_t_com$rpl$specter16879 = (function com$rpl$specter$__GT_t_com$rpl$specter16879(meta16880){
return (new com.rpl.specter.t_com$rpl$specter16879(meta16880));
});

}

return (new com.rpl.specter.t_com$rpl$specter16879(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.call(null,(function() { 
var G__16885__delegate = function (path){
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16882 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16882 = (function (path,late,meta16883){
this.path = path;
this.late = late;
this.meta16883 = meta16883;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16884,meta16883__$1){
var self__ = this;
var _16884__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16882(self__.path,self__.late,meta16883__$1));
});

com.rpl.specter.t_com$rpl$specter16882.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16884){
var self__ = this;
var _16884__$1 = this;
return self__.meta16883;
});

com.rpl.specter.t_com$rpl$specter16882.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16882.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16148__auto__,vals__16149__auto__,structure,next_fn__16150__auto__){
var self__ = this;
var this__16148__auto____$1 = this;
return next_fn__16150__auto__.call(null,cljs.core.conj.call(null,vals__16149__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter16882.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16148__auto__,vals__16149__auto__,structure,next_fn__16150__auto__){
var self__ = this;
var this__16148__auto____$1 = this;
return next_fn__16150__auto__.call(null,cljs.core.conj.call(null,vals__16149__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter16882.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16883","meta16883",534942695,null)], null);
});

com.rpl.specter.t_com$rpl$specter16882.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16882.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16882";

com.rpl.specter.t_com$rpl$specter16882.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16882");
});

com.rpl.specter.__GT_t_com$rpl$specter16882 = (function com$rpl$specter$__GT_t_com$rpl$specter16882(path__$1,late__$1,meta16883){
return (new com.rpl.specter.t_com$rpl$specter16882(path__$1,late__$1,meta16883));
});

}

return (new com.rpl.specter.t_com$rpl$specter16882(path,late,null));
}));
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
};
var G__16885 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16886__i = 0, G__16886__a = new Array(arguments.length -  0);
while (G__16886__i < G__16886__a.length) {G__16886__a[G__16886__i] = arguments[G__16886__i + 0]; ++G__16886__i;}
  path = new cljs.core.IndexedSeq(G__16886__a,0);
} 
return G__16885__delegate.call(this,path);};
G__16885.cljs$lang$maxFixedArity = 0;
G__16885.cljs$lang$applyTo = (function (arglist__16887){
var path = cljs.core.seq(arglist__16887);
return G__16885__delegate(path);
});
G__16885.cljs$core$IFn$_invoke$arity$variadic = G__16885__delegate;
return G__16885;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.call(null,(function() { 
var G__16891__delegate = function (path){
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter16888 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16888 = (function (path,late,meta16889){
this.path = path;
this.late = late;
this.meta16889 = meta16889;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16888.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16890,meta16889__$1){
var self__ = this;
var _16890__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16888(self__.path,self__.late,meta16889__$1));
});

com.rpl.specter.t_com$rpl$specter16888.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16890){
var self__ = this;
var _16890__$1 = this;
return self__.meta16889;
});

com.rpl.specter.t_com$rpl$specter16888.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16888.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16148__auto__,vals__16149__auto__,structure,next_fn__16150__auto__){
var self__ = this;
var this__16148__auto____$1 = this;
return next_fn__16150__auto__.call(null,cljs.core.conj.call(null,vals__16149__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter16888.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16148__auto__,vals__16149__auto__,structure,next_fn__16150__auto__){
var self__ = this;
var this__16148__auto____$1 = this;
return next_fn__16150__auto__.call(null,cljs.core.conj.call(null,vals__16149__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter16888.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta16889","meta16889",-295120901,null)], null);
});

com.rpl.specter.t_com$rpl$specter16888.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16888.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16888";

com.rpl.specter.t_com$rpl$specter16888.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16888");
});

com.rpl.specter.__GT_t_com$rpl$specter16888 = (function com$rpl$specter$__GT_t_com$rpl$specter16888(path__$1,late__$1,meta16889){
return (new com.rpl.specter.t_com$rpl$specter16888(path__$1,late__$1,meta16889));
});

}

return (new com.rpl.specter.t_com$rpl$specter16888(path,late,null));
}));
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
};
var G__16891 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16892__i = 0, G__16892__a = new Array(arguments.length -  0);
while (G__16892__i < G__16892__a.length) {G__16892__a[G__16892__i] = arguments[G__16892__i + 0]; ++G__16892__i;}
  path = new cljs.core.IndexedSeq(G__16892__a,0);
} 
return G__16891__delegate.call(this,path);};
G__16891.cljs$lang$maxFixedArity = 0;
G__16891.cljs$lang$applyTo = (function (arglist__16893){
var path = cljs.core.seq(arglist__16893);
return G__16891__delegate(path);
});
G__16891.cljs$core$IFn$_invoke$arity$variadic = G__16891__delegate;
return G__16891;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj.call(null,(function (val){
if(typeof com.rpl.specter.t_com$rpl$specter16894 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16894 = (function (val,meta16895){
this.val = val;
this.meta16895 = meta16895;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16894.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16896,meta16895__$1){
var self__ = this;
var _16896__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16894(self__.val,meta16895__$1));
});

com.rpl.specter.t_com$rpl$specter16894.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16896){
var self__ = this;
var _16896__$1 = this;
return self__.meta16895;
});

com.rpl.specter.t_com$rpl$specter16894.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16894.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16148__auto__,vals__16149__auto__,structure,next_fn__16150__auto__){
var self__ = this;
var this__16148__auto____$1 = this;
return next_fn__16150__auto__.call(null,cljs.core.conj.call(null,vals__16149__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter16894.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16148__auto__,vals__16149__auto__,structure,next_fn__16150__auto__){
var self__ = this;
var this__16148__auto____$1 = this;
return next_fn__16150__auto__.call(null,cljs.core.conj.call(null,vals__16149__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter16894.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta16895","meta16895",606498846,null)], null);
});

com.rpl.specter.t_com$rpl$specter16894.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16894.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16894";

com.rpl.specter.t_com$rpl$specter16894.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16894");
});

com.rpl.specter.__GT_t_com$rpl$specter16894 = (function com$rpl$specter$__GT_t_com$rpl$specter16894(val__$1,meta16895){
return (new com.rpl.specter.t_com$rpl$specter16894(val__$1,meta16895));
});

}

return (new com.rpl.specter.t_com$rpl$specter16894(val,null));
}));
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter16897 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16897 = (function (meta16898){
this.meta16898 = meta16898;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16897.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16899,meta16898__$1){
var self__ = this;
var _16899__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16897(meta16898__$1));
});

com.rpl.specter.t_com$rpl$specter16897.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16899){
var self__ = this;
var _16899__$1 = this;
return self__.meta16898;
});

com.rpl.specter.t_com$rpl$specter16897.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16897.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter16897.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter16897.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta16898","meta16898",268349135,null)], null);
});

com.rpl.specter.t_com$rpl$specter16897.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16897.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16897";

com.rpl.specter.t_com$rpl$specter16897.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16897");
});

com.rpl.specter.__GT_t_com$rpl$specter16897 = (function com$rpl$specter$__GT_t_com$rpl$specter16897(meta16898){
return (new com.rpl.specter.t_com$rpl$specter16897(meta16898));
});

}

return (new com.rpl.specter.t_com$rpl$specter16897(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.call(null,(function() {
var G__16908 = null;
var G__16908__2 = (function (cond_p,then_path){
return com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP);
});
var G__16908__3 = (function (cond_p,then_path,else_path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,cond_p);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (afn,temp__4655__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter16902 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16902 = (function (cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,meta16903){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta16903 = meta16903;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16902.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__4655__auto__){
return (function (_16904,meta16903__$1){
var self__ = this;
var _16904__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16902(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.afn,self__.late_then,self__.late_else,meta16903__$1));
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16902.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__4655__auto__){
return (function (_16904){
var self__ = this;
var _16904__$1 = this;
return self__.meta16903;
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16902.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16902.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16902.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16902.getBasis = ((function (afn,temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta16903","meta16903",414465872,null)], null);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16902.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16902.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16902";

com.rpl.specter.t_com$rpl$specter16902.cljs$lang$ctorPrWriter = ((function (afn,temp__4655__auto__){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16902");
});})(afn,temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter16902 = ((function (afn,temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter16902(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta16903){
return (new com.rpl.specter.t_com$rpl$specter16902(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta16903));
});})(afn,temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter16902(cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,null));
});})(afn,temp__4655__auto__))
);
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
} else {
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter16905 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16905 = (function (cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,meta16906){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta16906 = meta16906;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16905.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_16907,meta16906__$1){
var self__ = this;
var _16907__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16905(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.late_cond,self__.late_then,self__.late_else,meta16906__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16905.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_16907){
var self__ = this;
var _16907__$1 = this;
return self__.meta16906;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16905.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16905.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__16900_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,p1__16900_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16905.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__16901_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,p1__16901_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16905.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta16906","meta16906",2021605525,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter16905.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16905.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16905";

com.rpl.specter.t_com$rpl$specter16905.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16905");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter16905 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter16905(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta16906){
return (new com.rpl.specter.t_com$rpl$specter16905(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta16906));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter16905(cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,null));
});})(temp__4655__auto__))
);
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,cond_p),com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
}
});
G__16908 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__16908__2.call(this,cond_p,then_path);
case 3:
return G__16908__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16908.cljs$core$IFn$_invoke$arity$2 = G__16908__2;
G__16908.cljs$core$IFn$_invoke$arity$3 = G__16908__3;
return G__16908;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 * 
 * The input paths may be parameterized, in which case the result of cond-path
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.call(null,(function() { 
var G__16913__delegate = function (conds){
var pairs = cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),conds));
return cljs.core.reduce.call(null,((function (pairs){
return (function (p,p__16909){
var vec__16910 = p__16909;
var tester = cljs.core.nth.call(null,vec__16910,(0),null);
var apath = cljs.core.nth.call(null,vec__16910,(1),null);
return com.rpl.specter.if_path.call(null,tester,apath,p);
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__16913 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__16914__i = 0, G__16914__a = new Array(arguments.length -  0);
while (G__16914__i < G__16914__a.length) {G__16914__a[G__16914__i] = arguments[G__16914__i + 0]; ++G__16914__i;}
  conds = new cljs.core.IndexedSeq(G__16914__a,0);
} 
return G__16913__delegate.call(this,conds);};
G__16913.cljs$lang$maxFixedArity = 0;
G__16913.cljs$lang$applyTo = (function (arglist__16915){
var conds = cljs.core.seq(arglist__16915);
return G__16913__delegate(conds);
});
G__16913.cljs$core$IFn$_invoke$arity$variadic = G__16913__delegate;
return G__16913;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.call(null,(function() {
var G__16923 = null;
var G__16923__0 = (function (){
return com.rpl.specter.STAY;
});
var G__16923__1 = (function (path){
return path;
});
var G__16923__2 = (function (path1,path2){
var builder__16151__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter16916 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter16916 = (function (path1,path2,late1,late2,meta16917){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta16917 = meta16917;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter16916.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16918,meta16917__$1){
var self__ = this;
var _16918__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter16916(self__.path1,self__.path2,self__.late1,self__.late2,meta16917__$1));
});

com.rpl.specter.t_com$rpl$specter16916.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16918){
var self__ = this;
var _16918__$1 = this;
return self__.meta16917;
});

com.rpl.specter.t_com$rpl$specter16916.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter16916.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late1,vals,structure,next_fn);
var res2 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res2)){
return res1;
} else {
return res2;
}
});

com.rpl.specter.t_com$rpl$specter16916.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_.call(null,self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late2,vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter16916.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta16917","meta16917",1987833735,null)], null);
});

com.rpl.specter.t_com$rpl$specter16916.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter16916.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter16916";

com.rpl.specter.t_com$rpl$specter16916.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write.call(null,writer__7150__auto__,"com.rpl.specter/t_com$rpl$specter16916");
});

com.rpl.specter.__GT_t_com$rpl$specter16916 = (function com$rpl$specter$__GT_t_com$rpl$specter16916(path1__$1,path2__$1,late1__$1,late2__$1,meta16917){
return (new com.rpl.specter.t_com$rpl$specter16916(path1__$1,path2__$1,late1__$1,late2__$1,meta16917));
});

}

return (new com.rpl.specter.t_com$rpl$specter16916(path1,path2,late1,late2,null));
}));
var curr_params__16152__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path1),com.rpl.specter.late_path.call(null,path2)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16152__auto__)){
return cljs.core.apply.call(null,builder__16151__auto__,curr_params__16152__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16151__auto__,curr_params__16152__auto__);
}
});
var G__16923__3 = (function() { 
var G__16924__delegate = function (path1,path2,paths){
return cljs.core.reduce.call(null,com.rpl.specter.multi_path,com.rpl.specter.multi_path.call(null,path1,path2),paths);
};
var G__16924 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__16925__i = 0, G__16925__a = new Array(arguments.length -  2);
while (G__16925__i < G__16925__a.length) {G__16925__a[G__16925__i] = arguments[G__16925__i + 2]; ++G__16925__i;}
  paths = new cljs.core.IndexedSeq(G__16925__a,0);
} 
return G__16924__delegate.call(this,path1,path2,paths);};
G__16924.cljs$lang$maxFixedArity = 2;
G__16924.cljs$lang$applyTo = (function (arglist__16926){
var path1 = cljs.core.first(arglist__16926);
arglist__16926 = cljs.core.next(arglist__16926);
var path2 = cljs.core.first(arglist__16926);
var paths = cljs.core.rest(arglist__16926);
return G__16924__delegate(path1,path2,paths);
});
G__16924.cljs$core$IFn$_invoke$arity$variadic = G__16924__delegate;
return G__16924;
})()
;
G__16923 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__16923__0.call(this);
case 1:
return G__16923__1.call(this,path1);
case 2:
return G__16923__2.call(this,path1,path2);
default:
var G__16927 = null;
if (arguments.length > 2) {
var G__16928__i = 0, G__16928__a = new Array(arguments.length -  2);
while (G__16928__i < G__16928__a.length) {G__16928__a[G__16928__i] = arguments[G__16928__i + 2]; ++G__16928__i;}
G__16927 = new cljs.core.IndexedSeq(G__16928__a,0);
}
return G__16923__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__16927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16923.cljs$lang$maxFixedArity = 2;
G__16923.cljs$lang$applyTo = G__16923__3.cljs$lang$applyTo;
G__16923.cljs$core$IFn$_invoke$arity$0 = G__16923__0;
G__16923.cljs$core$IFn$_invoke$arity$1 = G__16923__1;
G__16923.cljs$core$IFn$_invoke$arity$2 = G__16923__2;
G__16923.cljs$core$IFn$_invoke$arity$variadic = G__16923__3.cljs$core$IFn$_invoke$arity$variadic;
return G__16923;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.call(null,(function() { 
var G__16929__delegate = function (path){
return com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path);
};
var G__16929 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16930__i = 0, G__16930__a = new Array(arguments.length -  0);
while (G__16930__i < G__16930__a.length) {G__16930__a[G__16930__i] = arguments[G__16930__i + 0]; ++G__16930__i;}
  path = new cljs.core.IndexedSeq(G__16930__a,0);
} 
return G__16929__delegate.call(this,path);};
G__16929.cljs$lang$maxFixedArity = 0;
G__16929.cljs$lang$applyTo = (function (arglist__16931){
var path = cljs.core.seq(arglist__16931);
return G__16929__delegate(path);
});
G__16929.cljs$core$IFn$_invoke$arity$variadic = G__16929__delegate;
return G__16929;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.call(null,(function() { 
var G__16932__delegate = function (path){
return com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY);
};
var G__16932 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__16933__i = 0, G__16933__a = new Array(arguments.length -  0);
while (G__16933__i < G__16933__a.length) {G__16933__a[G__16933__i] = arguments[G__16933__i + 0]; ++G__16933__i;}
  path = new cljs.core.IndexedSeq(G__16933__a,0);
} 
return G__16932__delegate.call(this,path);};
G__16932.cljs$lang$maxFixedArity = 0;
G__16932.cljs$lang$applyTo = (function (arglist__16934){
var path = cljs.core.seq(arglist__16934);
return G__16932__delegate(path);
});
G__16932.cljs$core$IFn$_invoke$arity$variadic = G__16932__delegate;
return G__16932;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
