/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.IndexedSeq;
import clojure.lang.MapEntry;
import clojure.lang.Murmur3;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public abstract class APersistentVector
extends AFn
implements IPersistentVector,
Iterable,
List,
RandomAccess,
Comparable,
Serializable,
IHashEq {
    int _hash = -1;
    int _hasheq = -1;

    public String toString() {
        return RT.printString(this);
    }

    @Override
    public ISeq seq() {
        if (this.count() > 0) {
            return new Seq(this, 0);
        }
        return null;
    }

    @Override
    public ISeq rseq() {
        if (this.count() > 0) {
            return new RSeq(this, this.count() - 1);
        }
        return null;
    }

    static boolean doEquals(IPersistentVector v, Object obj) {
        if (v == obj) {
            return true;
        }
        if (obj instanceof List || obj instanceof IPersistentVector) {
            Collection ma = (Collection)obj;
            if (ma.size() != v.count() || ma.hashCode() != v.hashCode()) {
                return false;
            }
            Iterator i1 = ((List)((Object)v)).iterator();
            Iterator i2 = ma.iterator();
            while (i1.hasNext()) {
                if (Util.equals(i1.next(), i2.next())) continue;
                return false;
            }
            return true;
        }
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        int i = 0;
        while (i < v.count()) {
            if (ms == null || !Util.equals(v.nth(i), ms.first())) {
                return false;
            }
            ++i;
            ms = ms.next();
        }
        return ms == null;
    }

    static boolean doEquiv(IPersistentVector v, Object obj) {
        if (obj instanceof List || obj instanceof IPersistentVector) {
            Collection ma = (Collection)obj;
            if (ma.size() != v.count()) {
                return false;
            }
            Iterator i1 = ((List)((Object)v)).iterator();
            Iterator i2 = ma.iterator();
            while (i1.hasNext()) {
                if (Util.equiv(i1.next(), i2.next())) continue;
                return false;
            }
            return true;
        }
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        int i = 0;
        while (i < v.count()) {
            if (ms == null || !Util.equiv(v.nth(i), ms.first())) {
                return false;
            }
            ++i;
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public boolean equals(Object obj) {
        return APersistentVector.doEquals(this, obj);
    }

    @Override
    public boolean equiv(Object obj) {
        return APersistentVector.doEquiv(this, obj);
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash2 = 1;
            for (Object obj : this) {
                hash2 = 31 * hash2 + (obj == null ? 0 : obj.hashCode());
            }
            this._hash = hash2;
        }
        return this._hash;
    }

    @Override
    public int hasheq() {
        if (this._hasheq == -1) {
            this._hasheq = Murmur3.hashOrdered(this);
        }
        return this._hasheq;
    }

    public Object get(int index) {
        return this.nth(index);
    }

    @Override
    public Object nth(int i, Object notFound) {
        if (i >= 0 && i < this.count()) {
            return this.nth(i);
        }
        return notFound;
    }

    public Object remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.count(); ++i) {
            if (!Util.equiv(this.nth(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.count() - 1; i >= 0; --i) {
            if (!Util.equiv(this.nth(i), o)) continue;
            return i;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            int nexti;
            {
                this.nexti = index;
            }

            @Override
            public boolean hasNext() {
                return this.nexti < APersistentVector.this.count();
            }

            @Override
            public Object next() {
                return APersistentVector.this.nth(this.nexti++);
            }

            @Override
            public boolean hasPrevious() {
                return this.nexti > 0;
            }

            public Object previous() {
                return APersistentVector.this.nth(--this.nexti);
            }

            @Override
            public int nextIndex() {
                return this.nexti;
            }

            @Override
            public int previousIndex() {
                return this.nexti - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    Iterator rangedIterator(final int start, final int end) {
        return new Iterator(){
            int i;
            {
                this.i = start;
            }

            @Override
            public boolean hasNext() {
                return this.i < end;
            }

            public Object next() {
                return APersistentVector.this.nth(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        return (List)((Object)RT.subvec(this, fromIndex, toIndex));
    }

    public Object set(int i, Object o) {
        throw new UnsupportedOperationException();
    }

    public void add(int i, Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int i, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invoke(Object arg1) {
        if (Util.isInteger(arg1)) {
            return this.nth(((Number)arg1).intValue());
        }
        throw new IllegalArgumentException("Key must be integer");
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < APersistentVector.this.count();
            }

            public Object next() {
                return APersistentVector.this.nth(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object peek() {
        if (this.count() > 0) {
            return this.nth(this.count() - 1);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key2) {
        if (!Util.isInteger(key2)) {
            return false;
        }
        int i = ((Number)key2).intValue();
        return i >= 0 && i < this.count();
    }

    @Override
    public IMapEntry entryAt(Object key2) {
        int i;
        if (Util.isInteger(key2) && (i = ((Number)key2).intValue()) >= 0 && i < this.count()) {
            return new MapEntry(key2, this.nth(i));
        }
        return null;
    }

    @Override
    public IPersistentVector assoc(Object key2, Object val2) {
        if (Util.isInteger(key2)) {
            int i = ((Number)key2).intValue();
            return this.assocN(i, val2);
        }
        throw new IllegalArgumentException("Key must be integer");
    }

    @Override
    public Object valAt(Object key2, Object notFound) {
        int i;
        if (Util.isInteger(key2) && (i = ((Number)key2).intValue()) >= 0 && i < this.count()) {
            return this.nth(i);
        }
        return notFound;
    }

    @Override
    public Object valAt(Object key2) {
        return this.valAt(key2, null);
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int length() {
        return this.count();
    }

    public int compareTo(Object o) {
        IPersistentVector v = (IPersistentVector)o;
        if (this.count() < v.count()) {
            return -1;
        }
        if (this.count() > v.count()) {
            return 1;
        }
        for (int i = 0; i < this.count(); ++i) {
            int c = Util.compare(this.nth(i), v.nth(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public static class SubVector
    extends APersistentVector
    implements IObj {
        public final IPersistentVector v;
        public final int start;
        public final int end;
        final IPersistentMap _meta;

        public SubVector(IPersistentMap meta, IPersistentVector v, int start, int end) {
            this._meta = meta;
            if (v instanceof SubVector) {
                SubVector sv = (SubVector)v;
                start += sv.start;
                end += sv.start;
                v = sv.v;
            }
            this.v = v;
            this.start = start;
            this.end = end;
        }

        @Override
        public Iterator iterator() {
            if (this.v instanceof APersistentVector) {
                return ((APersistentVector)this.v).rangedIterator(this.start, this.end);
            }
            return super.iterator();
        }

        @Override
        public Object nth(int i) {
            if (this.start + i >= this.end || i < 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.v.nth(this.start + i);
        }

        @Override
        public IPersistentVector assocN(int i, Object val2) {
            if (this.start + i > this.end) {
                throw new IndexOutOfBoundsException();
            }
            if (this.start + i == this.end) {
                return this.cons(val2);
            }
            return new SubVector(this._meta, this.v.assocN(this.start + i, val2), this.start, this.end);
        }

        @Override
        public int count() {
            return this.end - this.start;
        }

        @Override
        public IPersistentVector cons(Object o) {
            return new SubVector(this._meta, this.v.assocN(this.end, o), this.start, this.end + 1);
        }

        @Override
        public IPersistentCollection empty() {
            return PersistentVector.EMPTY.withMeta(this.meta());
        }

        @Override
        public IPersistentStack pop() {
            if (this.end - 1 == this.start) {
                return PersistentVector.EMPTY;
            }
            return new SubVector(this._meta, this.v, this.start, this.end - 1);
        }

        @Override
        public SubVector withMeta(IPersistentMap meta) {
            if (meta == this._meta) {
                return this;
            }
            return new SubVector(meta, this.v, this.start, this.end);
        }

        @Override
        public IPersistentMap meta() {
            return this._meta;
        }
    }

    public static class RSeq
    extends ASeq
    implements IndexedSeq,
    Counted {
        final IPersistentVector v;
        final int i;

        public RSeq(IPersistentVector vector2, int i) {
            this.v = vector2;
            this.i = i;
        }

        RSeq(IPersistentMap meta, IPersistentVector v, int i) {
            super(meta);
            this.v = v;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.v.nth(this.i);
        }

        @Override
        public ISeq next() {
            if (this.i > 0) {
                return new RSeq(this.v, this.i - 1);
            }
            return null;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public int count() {
            return this.i + 1;
        }

        @Override
        public RSeq withMeta(IPersistentMap meta) {
            return new RSeq(meta, this.v, this.i);
        }
    }

    static class Seq
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final IPersistentVector v;
        final int i;

        public Seq(IPersistentVector v, int i) {
            this.v = v;
            this.i = i;
        }

        Seq(IPersistentMap meta, IPersistentVector v, int i) {
            super(meta);
            this.v = v;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.v.nth(this.i);
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.v.count()) {
                return new Seq(this.v, this.i + 1);
            }
            return null;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public int count() {
            return this.v.count() - this.i;
        }

        @Override
        public Seq withMeta(IPersistentMap meta) {
            return new Seq(meta, this.v, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = this.v.nth(this.i);
            for (int x = this.i + 1; x < this.v.count(); ++x) {
                if (!RT.isReduced(ret = f.invoke(ret, this.v.nth(x)))) continue;
                return ((IDeref)ret).deref();
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, this.v.nth(this.i));
            for (int x = this.i + 1; x < this.v.count(); ++x) {
                if (RT.isReduced(ret)) {
                    return ((IDeref)ret).deref();
                }
                ret = f.invoke(ret, this.v.nth(x));
            }
            if (RT.isReduced(ret)) {
                return ((IDeref)ret).deref();
            }
            return ret;
        }
    }
}

