(ns dimporter.core
  (:require [clojure.data.csv :as csv]
            (dimporter
              [validations :as validate]
              [transformations :as transform]))
  (:use [clojure.java.io :only (reader)]))

(defn fields
  [& definitions]
  (let [headers       (filter keyword? (map #(if (vector? %) (first %) %) definitions))
        column_count  (count definitions)]
    (when (not= (count headers) column_count) (throw (Exception. "First definition must be a keyword")))
    {:headers       headers
     :column_count  column_count
     :mapping       definitions}))

(defn csv
  [file & {:keys [separator enclosure] :or {separator \, enclosure \"}}]
  (with-open [in-file (reader file)]
    (doall (csv/read-csv in-file :separator separator :quote enclosure))))

(defn datasource
  ([lines definitions]
   (datasource lines definitions true))
  ([lines definitions strict?]
   (let [main    (atom [])
         rejects (atom [])
         {:keys [headers column_count mapping]} definitions]
     (map #(zipmap headers %)
          (if strict?
            (filter #(= column_count (count %)) lines)
            lines)))))
