/*
 * Decompiled with CFR 0.152.
 */
package de.jetwick.snacktory;

import de.jetwick.snacktory.SHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;

public class Converter {
    private static final Logger logger = Logger.getLogger(Converter.class);
    public static final String UTF8 = "UTF-8";
    public static final String ISO = "ISO-8859-1";
    public static final int K2 = 2048;
    private int maxBytes = 500000;
    private String encoding;
    private String url;

    public Converter(String urlOnlyHint) {
        this.url = urlOnlyHint;
    }

    public Converter() {
    }

    public Converter setMaxBytes(int maxBytes) {
        this.maxBytes = maxBytes;
        return this;
    }

    public static String extractEncoding(String contentType) {
        String[] values = contentType != null ? contentType.split(";") : new String[]{};
        String charset = "";
        for (String value : values) {
            if (!(value = value.trim().toLowerCase()).startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        if (charset.length() == 0) {
            charset = ISO;
        }
        return charset;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            return "";
        }
        return this.encoding.toLowerCase();
    }

    public String streamToString(InputStream is) {
        return this.streamToString(is, this.maxBytes, this.encoding);
    }

    public String streamToString(InputStream is, String enc) {
        return this.streamToString(is, this.maxBytes, enc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String streamToString(InputStream is, int maxBytes, String enc) {
        this.encoding = enc;
        if (this.encoding == null || this.encoding.isEmpty()) {
            this.encoding = UTF8;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(is, 2048);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                in.mark(4096);
                String tmpEnc = this.detectCharset("charset=", output, in, this.encoding);
                if (tmpEnc != null) {
                    this.encoding = tmpEnc;
                } else {
                    logger.debug((Object)"no charset found in first stage");
                    tmpEnc = this.detectCharset("encoding=", output, in, this.encoding);
                    if (tmpEnc != null) {
                        this.encoding = tmpEnc;
                    } else {
                        logger.debug((Object)"no charset found in second stage");
                    }
                }
                if (!Charset.isSupported(this.encoding)) {
                    throw new UnsupportedEncodingException(this.encoding);
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.warn((Object)("Using default encoding:UTF-8 problem:" + e.getMessage() + " encoding:" + this.encoding + " " + this.url));
                this.encoding = UTF8;
            }
            int bytesRead = output.size();
            byte[] arr = new byte[2048];
            while (true) {
                if (bytesRead >= maxBytes) {
                    logger.warn((Object)("Maxbyte of " + maxBytes + " exceeded! Maybe html is now broken but try it nevertheless. Url: " + this.url));
                    break;
                }
                int n = in.read(arr);
                if (n < 0) break;
                bytesRead += n;
                output.write(arr, 0, n);
            }
            String string = output.toString(this.encoding);
            return string;
        }
        catch (SocketTimeoutException e) {
            logger.info((Object)(e.toString() + " url:" + this.url));
        }
        catch (IOException e) {
            logger.warn((Object)(e.toString() + " url:" + this.url));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return "";
    }

    protected String detectCharset(String key, ByteArrayOutputStream bos, BufferedInputStream in, String enc) throws IOException {
        int n;
        byte[] arr = new byte[2048];
        for (int nSum = 0; nSum < 2048 && (n = in.read(arr)) >= 0; nSum += n) {
            bos.write(arr, 0, n);
        }
        String str = bos.toString(enc);
        int encIndex = str.indexOf(key);
        int clength = key.length();
        if (encIndex > 0) {
            int lastEncIndex;
            char startChar = str.charAt(encIndex + clength);
            if (startChar == '\'') {
                lastEncIndex = str.indexOf("'", ++encIndex + clength);
            } else if (startChar == '\"') {
                lastEncIndex = str.indexOf("\"", ++encIndex + clength);
            } else {
                int sec;
                int first = str.indexOf("\"", encIndex + clength);
                if (first < 0) {
                    first = Integer.MAX_VALUE;
                }
                if ((sec = str.indexOf(" ", encIndex + clength)) < 0) {
                    sec = Integer.MAX_VALUE;
                }
                lastEncIndex = Math.min(first, sec);
                int third = str.indexOf("'", encIndex + clength);
                if (third > 0) {
                    lastEncIndex = Math.min(lastEncIndex, third);
                }
            }
            if (lastEncIndex > encIndex + clength && lastEncIndex < encIndex + clength + 40) {
                String tmpEnc = SHelper.encodingCleanup(str.substring(encIndex + clength, lastEncIndex));
                try {
                    in.reset();
                    bos.reset();
                    return tmpEnc;
                }
                catch (IOException ex) {
                    logger.warn((Object)("Couldn't reset stream to re-read with new encoding " + tmpEnc + " " + ex.toString()));
                }
            }
        }
        return null;
    }
}

