/*
 * Decompiled with CFR 0.152.
 */
package de.jetwick.snacktory;

import de.jetwick.snacktory.SHelper;
import java.util.Arrays;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputFormatter {
    private static final Logger logger = LoggerFactory.getLogger(OutputFormatter.class);
    public static final int MIN_PARAGRAPH_TEXT = 50;
    private static final List<String> NODES_TO_REPLACE = Arrays.asList("strong", "b", "i");
    protected final int minParagraphText;
    protected final List<String> nodesToReplace;

    public OutputFormatter() {
        this(50, NODES_TO_REPLACE);
    }

    public OutputFormatter(int minParagraphText) {
        this(minParagraphText, NODES_TO_REPLACE);
    }

    public OutputFormatter(int minParagraphText, List<String> nodesToReplace) {
        this.minParagraphText = minParagraphText;
        this.nodesToReplace = nodesToReplace;
    }

    public String getFormattedText(Element topNode) {
        this.removeNodesWithNegativeScores(topNode);
        StringBuilder sb = new StringBuilder();
        this.append(topNode, sb, "p");
        String str = SHelper.innerTrim(sb.toString());
        if (str.length() > 100) {
            return str;
        }
        if (str.isEmpty() || !topNode.text().isEmpty() && str.length() <= topNode.ownText().length()) {
            str = topNode.text();
        }
        return Jsoup.parse((String)str).text();
    }

    protected void removeNodesWithNegativeScores(Element topNode) {
        Elements gravityItems = topNode.select("*[gravityScore]");
        for (Element item : gravityItems) {
            int score = Integer.parseInt(item.attr("gravityScore"));
            if (score >= 0 && item.text().length() >= this.minParagraphText) continue;
            item.remove();
        }
    }

    protected void append(Element node, StringBuilder sb, String tagName) {
        for (Element e : node.getElementsByTag(tagName)) {
            String text;
            if (e.attr("class") != null && e.attr("class").contains("caption") || (text = e.text()).isEmpty() || text.length() < this.minParagraphText) continue;
            sb.append(text);
            sb.append("\n\n");
        }
    }
}

