/*
 * Decompiled with CFR 0.152.
 */
package lamina.stats.sample;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentVector;
import clojure.lang.IType;
import clojure.lang.Indexed;
import clojure.lang.Numbers;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import lamina.core.lock.ILock;
import lamina.stats.sample.IExponentiallyDecayingSampler;
import lamina.stats.utils.IUpdatable;
import potemkin.types.PotemkinType;

public final class ExponentiallyDecayingSampler
implements IExponentiallyDecayingSampler,
IUpdatable,
PotemkinType,
IDeref,
IType {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"+");
    public static final Var const__1 = RT.var((String)"lamina.time", (String)"now");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"long");
    public static final Var const__3 = RT.var((String)"lamina.stats.sample", (String)"rescale-interval");
    public static final Var const__4 = RT.var((String)"lamina.core.lock", (String)"acquire-exclusive");
    public static final Var const__5 = RT.var((String)"clojure.core", (String)"*");
    public static final Var const__6 = RT.var((String)"clojure.core", (String)"-");
    public static final Var const__7 = RT.var((String)"clojure.core", (String)"seq");
    public static final Var const__8 = RT.var((String)"clojure.core", (String)"keys");
    public static final Object const__9 = 0L;
    public static final Var const__10 = RT.var((String)"clojure.core", (String)"<");
    public static final Var const__11 = RT.var((String)"clojure.core", (String)"unchecked-inc");
    public static final Var const__12 = RT.var((String)"clojure.core", (String)"chunked-seq?");
    public static final Var const__13 = RT.var((String)"clojure.core", (String)"chunk-first");
    public static final Var const__14 = RT.var((String)"clojure.core", (String)"chunk-rest");
    public static final Var const__15 = RT.var((String)"clojure.core", (String)"int");
    public static final Var const__16 = RT.var((String)"clojure.core", (String)"count");
    public static final Var const__17 = RT.var((String)"clojure.core", (String)"first");
    public static final Var const__18 = RT.var((String)"clojure.core", (String)"next");
    public static final Var const__19 = RT.var((String)"lamina.core.lock", (String)"release-exclusive");
    public static final Var const__20 = RT.var((String)"clojure.core", (String)">=");
    public static final Var const__21 = RT.var((String)"lamina.stats.sample", (String)"rescale");
    public static final Var const__22 = RT.var((String)"lamina.stats.utils", (String)"update");
    public static final Var const__23 = RT.var((String)"lamina.stats.sample", (String)"priority");
    public static final Var const__24 = RT.var((String)"lamina.core.lock", (String)"acquire");
    public static final Var const__25 = RT.var((String)"lamina.core.lock", (String)"release");
    public static final Var const__26 = RT.var((String)"clojure.core", (String)"vals");
    public final Object samples;
    public final Object counter;
    public final Object next_rescale;
    volatile long start_time;
    public final double alpha;
    public final Object lock;
    public final Object task_queue;
    public final long sample_size;

    public ExponentiallyDecayingSampler(Object object2, Object object3, Object object4, long l, double d, Object object5, Object object6, long l2) {
        this.samples = object2;
        this.counter = object3;
        this.next_rescale = object4;
        this.start_time = l;
        this.alpha = d;
        this.lock = object5;
        this.task_queue = object6;
        this.sample_size = l2;
    }

    public static IPersistentVector getBasis() {
        return RT.vector((Object[])new Object[]{((IObj)Symbol.intern(null, (String)"samples")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"ConcurrentSkipListMap")})), ((IObj)Symbol.intern(null, (String)"counter")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"AtomicLong")})), ((IObj)Symbol.intern(null, (String)"next-rescale")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"AtomicLong")})), ((IObj)Symbol.intern(null, (String)"start-time")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long"), RT.keyword(null, (String)"volatile-mutable"), Boolean.TRUE})), ((IObj)Symbol.intern(null, (String)"alpha")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"double")})), Symbol.intern(null, (String)"lock"), Symbol.intern(null, (String)"task-queue"), ((IObj)Symbol.intern(null, (String)"sample-size")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long")}))});
    }

    public Object deref() {
        Object object2;
        Object lock__2112__auto__9087 = this.lock;
        ((ILock)lock__2112__auto__9087).acquire();
        try {
            object2 = ((IFn)const__26.getRawRoot()).invoke(this.samples);
        }
        finally {
            Object object3 = lock__2112__auto__9087;
            lock__2112__auto__9087 = null;
            ((ILock)object3).release();
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object update(Object val) {
        Object object2;
        Object object3;
        long now2 = ((IFn.OL)const__1.getRawRoot()).invokePrim(this.task_queue);
        if (now2 >= ((AtomicLong)this.next_rescale).get()) {
            ((IExponentiallyDecayingSampler)this).rescale(Numbers.num((long)((AtomicLong)this.next_rescale).get()));
            Object object4 = val;
            val = null;
            object3 = ((IUpdatable)this).update(object4);
            return object3;
        }
        long elapsed = now2 - this.start_time;
        Object pr = ((IFn)const__23.getRawRoot()).invoke((Object)this.alpha, (Object)Numbers.num((long)elapsed));
        Object lock__2112__auto__9088 = this.lock;
        ((ILock)lock__2112__auto__9088).acquire();
        try {
            Object object5;
            block8: {
                Object frst;
                block10: {
                    block9: {
                        block7: {
                            if (((AtomicLong)this.counter).incrementAndGet() >= this.sample_size) break block7;
                            Object object6 = pr;
                            pr = null;
                            Object object7 = val;
                            val = null;
                            object5 = ((ConcurrentSkipListMap)this.samples).put(object6, object7);
                            break block8;
                        }
                        frst = ((ConcurrentSkipListMap)this.samples).firstKey();
                        if (!Numbers.lt(frst, (Object)pr)) break block9;
                        Object object8 = pr;
                        pr = null;
                        Object object9 = val;
                        val = null;
                        Object object10 = ((ConcurrentSkipListMap)this.samples).putIfAbsent(object8, object9);
                        if (object10 == null || object10 == Boolean.FALSE) break block10;
                        object5 = null;
                        break block8;
                    }
                    object5 = null;
                    break block8;
                }
                Object k = frst;
                frst = null;
                Object frst2 = k;
                while (true) {
                    Object v = ((ConcurrentSkipListMap)this.samples).remove(frst2);
                    if (v != null && v != Boolean.FALSE) {
                        object5 = null;
                        break;
                    }
                    frst2 = ((ConcurrentSkipListMap)this.samples).firstKey();
                }
            }
            object2 = object5;
        }
        finally {
            Object object11 = lock__2112__auto__9088;
            lock__2112__auto__9088 = null;
            ((ILock)object11).release();
        }
        object3 = object2;
        return object3;
    }

    public Object rescale(Object next) {
        Object v13;
        Object object2 = next;
        next = null;
        if (((AtomicLong)this.next_rescale).compareAndSet(RT.uncheckedLongCast((Object)((Number)object2)), ((IFn.OL)const__1.getRawRoot()).invokePrim(this.task_queue) + RT.longCast((Object)const__3.getRawRoot()))) {
            Object var18_14;
            Object lock__2114__auto__9091 = this.lock;
            ((ILock)lock__2114__auto__9091).acquire_exclusive();
            try {
                long prev_start_time = this.start_time;
                this.start_time = ((IFn.OL)const__1.getRawRoot()).invokePrim(this.task_queue);
                Number _ = Numbers.num((long)this.start_time);
                double scale_factor = Math.exp(Numbers.unchecked_multiply((double)(-this.alpha), (long)(this.start_time - prev_start_time)));
                Object seq_9082 = ((IFn)const__7.getRawRoot()).invoke(((IFn)const__8.getRawRoot()).invoke(this.samples));
                Object chunk_9083 = null;
                long count_9084 = 0L;
                long i_9085 = 0L;
                while (true) {
                    Object temp__3974__auto__9090;
                    if (i_9085 < count_9084) {
                        Object k = ((Indexed)chunk_9083).nth(RT.uncheckedIntCast((long)i_9085));
                        Object val = ((ConcurrentSkipListMap)this.samples).remove(k);
                        Object object3 = k;
                        k = null;
                        Object v = val;
                        val = null;
                        ((ConcurrentSkipListMap)this.samples).put(Numbers.unchecked_multiply((double)scale_factor, (Object)object3), v);
                        ++i_9085;
                        continue;
                    }
                    Object object4 = temp__3974__auto__9090 = ((IFn)const__7.getRawRoot()).invoke(seq_9082);
                    if (object4 == null || object4 == Boolean.FALSE) break;
                    Object object5 = temp__3974__auto__9090;
                    temp__3974__auto__9090 = null;
                    Object seq_90822 = object5;
                    Object object6 = ((IFn)const__12.getRawRoot()).invoke(seq_90822);
                    if (object6 != null && object6 != Boolean.FALSE) {
                        Object c__4197__auto__9089 = ((IFn)const__13.getRawRoot()).invoke(seq_90822);
                        Object object7 = seq_90822;
                        seq_90822 = null;
                        Object object8 = c__4197__auto__9089;
                        Object object9 = c__4197__auto__9089;
                        c__4197__auto__9089 = null;
                        i_9085 = (int)0L;
                        count_9084 = RT.count((Object)object9);
                        chunk_9083 = object8;
                        seq_9082 = ((IFn)const__14.getRawRoot()).invoke(object7);
                        continue;
                    }
                    Object k = ((IFn)const__17.getRawRoot()).invoke(seq_90822);
                    Object val = ((ConcurrentSkipListMap)this.samples).remove(k);
                    Object object10 = k;
                    k = null;
                    Object v = val;
                    val = null;
                    ((ConcurrentSkipListMap)this.samples).put(Numbers.unchecked_multiply((double)scale_factor, (Object)object10), v);
                    Object object11 = seq_90822;
                    seq_90822 = null;
                    i_9085 = 0L;
                    count_9084 = 0L;
                    chunk_9083 = null;
                    seq_9082 = ((IFn)const__18.getRawRoot()).invoke(object11);
                }
                ((AtomicLong)this.counter).set(RT.count((Object)this.samples));
                var18_14 = null;
            }
            finally {
                Object object12 = lock__2114__auto__9091;
                lock__2114__auto__9091 = null;
                ((ILock)object12).release_exclusive();
            }
            v13 = var18_14;
        } else {
            v13 = null;
        }
        return v13;
    }
}

