(ns user
  (:require
   [clojure.core.async :as a]
   [discljord.connections.impl :as impl]
   [taoensso.timbre :as log]))

(def token "Bot MzY1NjgxNzk0MjU2NzMyMTYx.DuChHw.Tsa6Q4lksjdGq4SGiHZ2H0yRIOk")

(def events-chan (a/chan 100))

(def gateway (impl/get-websocket-gateway discljord.http/gateway-url token))

(def communication-chan (atom nil))

(defn start-bot
  ([] (start-bot 1))
  ([num-shards]
   (reset! communication-chan (a/chan 100))
   (impl/connect-shards! events-chan @communication-chan (:url gateway) token num-shards (range num-shards))))

(defn stop-bot []
  (a/put! @communication-chan [:disconnect]))

(defn start-print-events []
  (a/go-loop []
    (let [event (a/<! events-chan)]
      (clojure.pprint/pprint event)
      (when-not (= event ::stop-events)
        (recur)))))

(defn stop-print-events []
  (a/put! events-chan ::stop-events))
