/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.S2Point;

public final class S2Edge {
    private final S2Point start;
    private final S2Point end;

    public S2Edge(S2Point start, S2Point end) {
        this.start = start;
        this.end = end;
    }

    public S2Point getStart() {
        return this.start;
    }

    public S2Point getEnd() {
        return this.end;
    }

    public String toString() {
        return String.format("Edge: (%s -> %s)\n   or [%s -> %s]", this.start.toDegreesString(), this.end.toDegreesString(), this.start, this.end);
    }

    public int hashCode() {
        return this.getStart().hashCode() - this.getEnd().hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 == null || !(o2 instanceof S2Edge)) {
            return false;
        }
        S2Edge other = (S2Edge)o2;
        return this.getStart().equals(other.getStart()) && this.getEnd().equals(other.getEnd());
    }
}

