/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.S1Angle;
import com.baidu.common.geometry.S2Point;

public strictfp class S2LatLng {
    public static final double EARTH_RADIUS_METERS = 6367000.0;
    public static final S2LatLng CENTER = new S2LatLng(0.0, 0.0);
    private final double latRadians;
    private final double lngRadians;

    public static S2LatLng fromRadians(double latRadians, double lngRadians) {
        return new S2LatLng(latRadians, lngRadians);
    }

    public static S2LatLng fromDegrees(double latDegrees, double lngDegrees) {
        return new S2LatLng(S1Angle.degrees(latDegrees), S1Angle.degrees(lngDegrees));
    }

    public static S2LatLng fromE5(long latE5, long lngE5) {
        return new S2LatLng(S1Angle.e5(latE5), S1Angle.e5(lngE5));
    }

    public static S2LatLng fromE6(long latE6, long lngE6) {
        return new S2LatLng(S1Angle.e6(latE6), S1Angle.e6(lngE6));
    }

    public static S2LatLng fromE7(long latE7, long lngE7) {
        return new S2LatLng(S1Angle.e7(latE7), S1Angle.e7(lngE7));
    }

    public static S1Angle latitude(S2Point p2) {
        return S1Angle.radians(Math.atan2(p2.get(2), Math.sqrt(p2.get(0) * p2.get(0) + p2.get(1) * p2.get(1))));
    }

    public static S1Angle longitude(S2Point p2) {
        return S1Angle.radians(Math.atan2(p2.get(1), p2.get(0)));
    }

    private S2LatLng(double latRadians, double lngRadians) {
        this.latRadians = latRadians;
        this.lngRadians = lngRadians;
    }

    public S2LatLng(S1Angle lat, S1Angle lng) {
        this(lat.radians(), lng.radians());
    }

    public S2LatLng() {
        this(0.0, 0.0);
    }

    public S2LatLng(S2Point p2) {
        this(Math.atan2(p2.z, Math.sqrt(p2.x * p2.x + p2.y * p2.y)), Math.atan2(p2.y, p2.x));
    }

    public S1Angle lat() {
        return S1Angle.radians(this.latRadians);
    }

    public double latRadians() {
        return this.latRadians;
    }

    public double latDegrees() {
        return 57.29577951308232 * this.latRadians;
    }

    public S1Angle lng() {
        return S1Angle.radians(this.lngRadians);
    }

    public double lngRadians() {
        return this.lngRadians;
    }

    public double lngDegrees() {
        return 57.29577951308232 * this.lngRadians;
    }

    public boolean isValid() {
        return Math.abs(this.lat().radians()) <= 1.5707963267948966 && Math.abs(this.lng().radians()) <= Math.PI;
    }

    public S2LatLng normalized() {
        return new S2LatLng(Math.max(-1.5707963267948966, Math.min(1.5707963267948966, this.lat().radians())), Math.IEEEremainder(this.lng().radians(), Math.PI * 2));
    }

    public S2Point toPoint() {
        double phi = this.lat().radians();
        double theta = this.lng().radians();
        double cosphi = Math.cos(phi);
        return new S2Point(Math.cos(theta) * cosphi, Math.sin(theta) * cosphi, Math.sin(phi));
    }

    public S1Angle getDistance(S2LatLng o2) {
        double lat1 = this.lat().radians();
        double lat2 = o2.lat().radians();
        double lng1 = this.lng().radians();
        double lng2 = o2.lng().radians();
        double dlat = Math.sin(0.5 * (lat2 - lat1));
        double dlng = Math.sin(0.5 * (lng2 - lng1));
        double x = dlat * dlat + dlng * dlng * Math.cos(lat1) * Math.cos(lat2);
        return S1Angle.radians(2.0 * Math.atan2(Math.sqrt(x), Math.sqrt(Math.max(0.0, 1.0 - x))));
    }

    public double getDistance(S2LatLng o2, double radius) {
        return this.getDistance(o2).radians() * radius;
    }

    public double getEarthDistance(S2LatLng o2) {
        return this.getDistance(o2, 6367000.0);
    }

    public S2LatLng add(S2LatLng o2) {
        return new S2LatLng(this.latRadians + o2.latRadians, this.lngRadians + o2.lngRadians);
    }

    public S2LatLng sub(S2LatLng o2) {
        return new S2LatLng(this.latRadians - o2.latRadians, this.lngRadians - o2.lngRadians);
    }

    public S2LatLng mul(double m2) {
        return new S2LatLng(this.latRadians * m2, this.lngRadians * m2);
    }

    public boolean equals(Object that) {
        if (that instanceof S2LatLng) {
            S2LatLng o2 = (S2LatLng)that;
            return this.latRadians == o2.latRadians && this.lngRadians == o2.lngRadians;
        }
        return false;
    }

    public int hashCode() {
        long value = 17L;
        value += 37L * value + Double.doubleToLongBits(this.latRadians);
        value += 37L * value + Double.doubleToLongBits(this.lngRadians);
        return (int)(value ^ value >>> 32);
    }

    public boolean approxEquals(S2LatLng o2, double maxError) {
        return Math.abs(this.latRadians - o2.latRadians) < maxError && Math.abs(this.lngRadians - o2.lngRadians) < maxError;
    }

    public boolean approxEquals(S2LatLng o2) {
        return this.approxEquals(o2, 1.0E-9);
    }

    public String toString() {
        return "(" + this.latRadians + ", " + this.lngRadians + ")";
    }

    public String toStringDegrees() {
        return "(" + this.latDegrees() + ", " + this.lngDegrees() + ")";
    }
}

