/*
 * Decompiled with CFR 0.152.
 */
package com.ipinyou.rpc.dependency;

import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class BufferPool {
    public static final BufferPool instance = new BufferPool();
    private final ConcurrentMap<Integer, Queue<SoftReference<byte[]>>> buffersBySize = new ConcurrentHashMap<Integer, Queue<SoftReference<byte[]>>>();

    private int adjustSize(int size) {
        if (size <= 16) {
            return 16;
        }
        if (size <= 64) {
            return 64;
        }
        if (size <= 256) {
            return 256;
        }
        if (size <= 1024) {
            return 1024;
        }
        if (size <= 4096) {
            return 4096;
        }
        if (size <= 16384) {
            return 16384;
        }
        if (size <= 65536) {
            return 65536;
        }
        if (size <= 262144) {
            return 262144;
        }
        if (size <= 0x100000) {
            return 0x100000;
        }
        if (size <= 0x400000) {
            return 0x400000;
        }
        if (size <= 0x1000000) {
            return 0x1000000;
        }
        if (size <= 0x4000000) {
            return 0x4000000;
        }
        if (size <= 0x10000000) {
            return 0x10000000;
        }
        return size;
    }

    public byte[] getBuffer(int size) {
        SoftReference ref;
        Queue list = (Queue)this.buffersBySize.get(size = this.adjustSize(size));
        if (list == null) {
            return new byte[size];
        }
        while ((ref = (SoftReference)list.poll()) != null) {
            byte[] b2 = (byte[])ref.get();
            if (b2 == null) continue;
            return b2;
        }
        return new byte[size];
    }

    public void returnBuffer(byte[] buf) {
        int size = buf.length;
        Queue<SoftReference<Object>> list = (ConcurrentLinkedQueue<SoftReference<byte[]>>)this.buffersBySize.get(size);
        if (list == null) {
            list = new ConcurrentLinkedQueue<SoftReference<byte[]>>();
            Queue prev = this.buffersBySize.putIfAbsent(size, list);
            if (prev != null) {
                list = prev;
            }
        }
        list.add(new SoftReference<byte[]>(buf));
    }

    int countBuffersOfSize(int size) {
        Queue list = (Queue)this.buffersBySize.get(size = this.adjustSize(size));
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public String toString() {
        return this.buffersBySize.toString();
    }
}

