/*
 * Decompiled with CFR 0.152.
 */
package com.ipinyou.rpc.dependency;

import com.ipinyou.rpc.dependency.BufferPool;
import com.ipinyou.rpc.dependency.In;
import com.ipinyou.rpc.dependency.O;
import com.ipinyou.rpc.dependency.SeekableIS;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

public class Input
implements In {
    private static final BufferPool pool = BufferPool.instance;
    private final int first;
    private final int last;
    private byte[] buf;
    private int cursor;

    public Input(byte[] buf) {
        this.buf = buf;
        this.cursor = 0;
        this.first = 0;
        this.last = buf.length;
    }

    public Input(byte[] buf, int cursor, int length) {
        O.required(cursor >= 0 && cursor <= buf.length, "cursor >= 0 && cursor <= buf.length");
        O.required(length >= 0 && length <= buf.length - cursor, "length >= 0 && length <= buf.length - cursor");
        this.buf = buf;
        this.cursor = cursor;
        this.first = cursor;
        this.last = length + cursor;
    }

    public static Input fromFile(SeekableIS in, long offset, int length) throws IOException {
        try {
            in.seek(offset);
            byte[] buf = pool.getBuffer(length);
            in.readFully(buf, 0, length);
            return new Input(buf, 0, length);
        }
        catch (EOFException e2) {
            throw new RuntimeException("Unexpected EOF!");
        }
    }

    @Override
    public byte read() {
        if (this.cursor >= this.last) {
            throw new RuntimeException("Unexpected EOF!");
        }
        return this.buf[this.cursor++];
    }

    @Override
    public void read(byte[] bytes) {
        this.read(bytes, 0, bytes.length);
    }

    @Override
    public void read(byte[] bytes, int off, int len) {
        if (this.cursor + len > this.last) {
            throw new RuntimeException("Unexpected EOF!");
        }
        System.arraycopy(this.buf, this.cursor, bytes, off, len);
        this.cursor += len;
    }

    public int cursor() {
        return this.cursor;
    }

    public void cursor(int cursor) {
        if (cursor < this.first || cursor > this.last) {
            O.required("cursor >= " + this.first + " && cursor <= " + this.last);
        }
        this.cursor = cursor;
    }

    public int length() {
        return this.last - this.first;
    }

    public int available() {
        return this.last - this.cursor;
    }

    public byte[] buf() {
        return this.buf;
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buf, this.first, this.last);
    }

    public void returnBuf() {
        if (this.buf != null) {
            pool.returnBuffer(this.buf);
        }
        this.buf = null;
        this.cursor = this.last;
    }
}

