/*
 * Decompiled with CFR 0.152.
 */
package convert;

import client.DailyActivity;
import com.baidu.common.geometry.S2CellId;
import java.util.stream.Collectors;
import me.zhenchuan.db.history.DailyModel;
import me.zhenchuan.dict.AppData;
import me.zhenchuan.utils.IpUtils;
import me.zhenchuan.utils.s2.S2GeometryFunctions;

public class DAConverter {
    public static DailyActivity convert(DailyModel dailyModel) {
        DailyActivity dailyActivity = new DailyActivity();
        dailyActivity.setCount(dailyModel.getCount());
        dailyActivity.setDay(String.valueOf(dailyModel.getDay()));
        dailyActivity.setOs(dailyModel.getOs().name());
        dailyActivity.setManufacturer(dailyModel.getManufacturer().name());
        dailyActivity.setApps(dailyModel.getApps().stream().map(app -> AppData.getInstance().name(app.intValue())).collect(Collectors.toSet()));
        dailyActivity.setIps(dailyModel.getIps().stream().map(ip -> IpUtils.toIP(ip)).collect(Collectors.toSet()));
        dailyActivity.setPlatforms(dailyModel.getPlatforms().stream().map(platform -> platform.name()).collect(Collectors.toSet()));
        dailyActivity.setCells(dailyModel.getCells().stream().map(cell -> {
            double[] latLng = S2GeometryFunctions.s2_centroid(new S2CellId((long)cell).toToken());
            return new DailyActivity.Point(latLng);
        }).collect(Collectors.toSet()));
        return dailyActivity;
    }
}

