/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.db.history;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.ipinyou.rpc.dependency.Decoder;
import com.ipinyou.rpc.dependency.Encoder;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.Output;
import java.io.Serializable;
import java.util.Set;
import me.zhenchuan.base.enums.Manufacturer;
import me.zhenchuan.base.enums.OS;
import me.zhenchuan.base.enums.Platform;

public class DailyModel
implements Encoder<DailyModel>,
Decoder<DailyModel>,
Serializable {
    private long version;
    private long day;
    private long count;
    private OS os = OS.NULL;
    private Manufacturer manufacturer = Manufacturer.NULL;
    private Set<Long> ips = Sets.newHashSet();
    private Set<Platform> platforms = Sets.newHashSet();
    private Set<Long> apps = Sets.newHashSet();
    private Set<Long> cells = Sets.newHashSet();

    public DailyModel() {
    }

    public DailyModel(long day) {
        this.day = day;
    }

    @Override
    public DailyModel decode(Input in) {
        int i2;
        this.version = LongCodec.decode(in);
        this.day = (int)LongCodec.decode(in);
        this.count = LongCodec.decode(in);
        this.os = OS.valueOf((int)LongCodec.decode(in));
        this.manufacturer = Manufacturer.valueOf((int)LongCodec.decode(in));
        long size = LongCodec.decode(in);
        if (size > 0L) {
            i2 = 0;
            while ((long)i2 < size) {
                this.ips.add(LongCodec.decode(in));
                ++i2;
            }
        }
        if ((size = LongCodec.decode(in)) > 0L) {
            i2 = 0;
            while ((long)i2 < size) {
                this.platforms.add(Platform.valueOf((int)LongCodec.decode(in)));
                ++i2;
            }
        }
        if ((size = LongCodec.decode(in)) > 0L) {
            i2 = 0;
            while ((long)i2 < size) {
                this.apps.add(LongCodec.decode(in));
                ++i2;
            }
        }
        if ((size = LongCodec.decode(in)) > 0L) {
            i2 = 0;
            while ((long)i2 < size) {
                this.cells.add(LongCodec.decode(in));
                ++i2;
            }
        }
        this.os = this.manufacturer == Manufacturer.Apple ? OS.IOS : OS.Android;
        return this;
    }

    @Override
    public void encode(Output out) {
        LongCodec.encode(this.version, out);
        LongCodec.encode(this.day, out);
        LongCodec.encode(this.count, out);
        LongCodec.encode(this.os.ordinal(), out);
        LongCodec.encode(this.manufacturer.ordinal(), out);
        LongCodec.encode(this.ips.size(), out);
        for (Long ip : this.ips) {
            LongCodec.encode(ip, out);
        }
        LongCodec.encode(this.platforms.size(), out);
        for (Platform platform : this.platforms) {
            LongCodec.encode(platform.ordinal(), out);
        }
        LongCodec.encode(this.apps.size(), out);
        for (Long app : this.apps) {
            LongCodec.encode(app, out);
        }
        LongCodec.encode(this.cells.size(), out);
        for (Long cell : this.cells) {
            LongCodec.encode(cell, out);
        }
    }

    public long getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public long getCount() {
        return this.count;
    }

    public void incrCount(long count) {
        this.count += count;
    }

    public OS getOs() {
        return this.os;
    }

    public void setOs(OS os) {
        if (this.os != OS.NULL) {
            this.os = os;
        }
    }

    public Manufacturer getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(Manufacturer manufacturer) {
        if (manufacturer != Manufacturer.NULL) {
            this.manufacturer = manufacturer;
        }
    }

    public Set<Long> getIps() {
        return this.ips;
    }

    public void addIp(long ip) {
        if (ip > 0L) {
            this.ips.add(ip);
        }
    }

    public Set<Platform> getPlatforms() {
        return this.platforms;
    }

    public void addPlatform(Platform platform) {
        if (platform != Platform.na) {
            this.platforms.add(platform);
        }
    }

    public Set<Long> getApps() {
        return this.apps;
    }

    public void addApp(long app) {
        this.apps.add(app);
    }

    public Set<Long> getCells() {
        return this.cells;
    }

    public void addCell(long cell) {
        this.cells.add(cell);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("day", this.day).add("count", this.count).add("os", (Object)this.os).add("manufacturer", (Object)this.manufacturer).add("ips", this.ips).add("platforms", this.platforms).add("apps", this.apps).add("cells", this.cells).toString();
    }
}

