/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.db.history;

import com.ipinyou.rpc.dependency.Decoder;
import com.ipinyou.rpc.dependency.Encoder;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.Output;
import com.ipinyou.rpc.dependency.StringCodec;
import java.io.Serializable;
import me.zhenchuan.base.enums.Action;
import me.zhenchuan.base.enums.Browser;
import me.zhenchuan.base.enums.MediaType;
import me.zhenchuan.db.Flattening;
import me.zhenchuan.db.history.Device;
import me.zhenchuan.db.history.Location;
import me.zhenchuan.db.history.Media;
import me.zhenchuan.db.history.Time;
import me.zhenchuan.utils.ArrayUtils;
import me.zhenchuan.utils.Tripple;

public class Event
implements Encoder<Event>,
Decoder<Event>,
Serializable,
Flattening {
    Time time;
    Location location;
    Device device;
    Media media;
    Action action = Action.NULL;
    long count;
    String extra = "";
    private static final String[] _LABELS = new String[]{"Extra Info", "Action", "Count"};
    public static final String[] LABELS = ArrayUtils.addAll(Time.LABELS, Location.LABELS, Device.LABELS, Media.LABELS, _LABELS);

    @Override
    public String[] flatten() {
        return ArrayUtils.addAll(this.time.flatten(), this.location.flatten(), this.device.flatten(), this.media.flatten(), new String[]{this.extra, this.action.name(), String.valueOf(this.count)});
    }

    public Event(long start, long end, Location location, Device device, Media media, Action action, long count, String extra) {
        this.time = new Time(start, end);
        this.location = location;
        this.device = device;
        this.media = media;
        this.action = action;
        this.count = count;
        this.extra = extra;
        this.adjust();
    }

    public Event(long start, Long end, Tripple<Device, Location, Media> value, Action view, long count) {
        this(start, end, value.getValueB(), value.getValueA(), value.getValueC(), view, count, "");
    }

    private void adjust() {
        if (!this.media.target.isEmpty()) {
            this.device.browser = Browser.NULL;
        }
    }

    public Event(long start, long end, String ip, String lat, String lng, String network, String ua, MediaType source, String target, Action action, long count, String extra) {
        this(start, end, new Location(ip, lat, lng), new Device(ua), new Media(network, source, target), action, count, extra);
    }

    public Event() {
    }

    public Time getTime() {
        return this.time;
    }

    public Location getLocation() {
        return this.location;
    }

    public Device getDevice() {
        return this.device;
    }

    public Media getMedia() {
        return this.media;
    }

    public Action getAction() {
        return this.action;
    }

    public long getCount() {
        return this.count;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public void encode(Output out) {
        this.time.encode(out);
        this.location.encode(out);
        this.device.encode(out);
        this.media.encode(out);
        LongCodec.encode(this.action.ordinal(), out);
        LongCodec.encode(this.count, out);
        StringCodec.encode(this.extra, out);
    }

    @Override
    public Event decode(Input in) {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Event{");
        sb.append("time=").append(this.time);
        sb.append(", context='").append(this.media).append('\'');
        sb.append(", position=").append(this.location);
        sb.append(", device=").append(this.device);
        sb.append(", action=").append((Object)this.action);
        sb.append(", count=").append(this.count);
        sb.append(", extra='").append(this.extra).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

