/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.db.history;

import com.google.common.collect.Lists;
import com.ipinyou.rpc.dependency.Decoder;
import com.ipinyou.rpc.dependency.Encoder;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.Output;
import com.ipinyou.rpc.dependency.StringCodec;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import me.zhenchuan.db.history.Event;
import me.zhenchuan.db.history.Time;
import me.zhenchuan.uid.UidConfig;
import me.zhenchuan.utils.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidHistory
implements Decoder<UidHistory>,
Encoder<UidHistory>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(UidHistory.class);
    protected int version = 1;
    protected int uid;
    protected String prefix = "";
    private Map<Time, Event> history = new ConcurrentSkipListMap<Time, Event>();
    private boolean merge = false;

    public UidHistory() {
    }

    public UidHistory enableMerge() {
        this.merge = true;
        return this;
    }

    public UidHistory(int uid) {
        this.uid = uid;
    }

    public UidHistory(String key) {
        this.uid = UidConfig.uid(key);
    }

    public void setSuffix(String pyid) {
        if (pyid != null && pyid.length() > 2) {
            this.prefix = pyid.substring(0, 2);
        } else {
            log.warn("invalid uid : {}", (Object)pyid);
        }
    }

    public List<String[]> flatten(String key) {
        ArrayList list = Lists.newArrayList();
        this.history.forEach((time, event) -> list.add(ArrayUtils.addAll(new String[]{key}, event.flatten())));
        return list;
    }

    public void addEvent(Time time, Event event) {
        if (this.history.size() < 500 || this.merge) {
            this.history.put(time, event);
        }
    }

    public void addEvent(Event event) {
        if (this.history.size() < 500 || this.merge) {
            this.history.put(event.time, event);
        }
    }

    public void addHistory(Map<Time, Event> history) {
        this.history.putAll(history);
    }

    public void clear() {
        this.history.clear();
    }

    public Map<Time, Event> getHistory() {
        return this.history;
    }

    public void setHistory(Map<Time, Event> history) {
        this.history = history;
    }

    public int getUid() {
        return this.uid;
    }

    @Override
    public UidHistory decode(Input in) {
        return null;
    }

    @Override
    public void encode(Output out) {
        LongCodec.encode(this.version, out);
        LongCodec.encode(this.uid, out);
        StringCodec.encode(this.prefix, out);
        if (this.history == null || this.history.size() == 0) {
            LongCodec.encode(100000L, out);
        } else {
            LongCodec.encode(100000 + this.history.size(), out);
            this.history.forEach((time, event) -> {
                time.encode(out);
                event.encode(out);
            });
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sb.append("uid : ").append(this.uid);
        sb.append(" prefix : ").append(this.prefix).append("\n");
        this.history.forEach((time, event) -> {
            Time times = event.time;
            sb.append("time[").append(dateFormat.format(new Date(times.start))).append("--").append(dateFormat.format(new Date(times.end))).append("]");
            sb.append(event);
            sb.append("\n");
        });
        return sb.toString();
    }
}

