/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.dict;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import me.zhenchuan.base.ResourceFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppData
extends ResourceFileReader {
    private static final Logger log = LoggerFactory.getLogger(AppData.class);
    private static final Map<String, Integer> appOrder = Maps.newHashMap();
    private static final Map<Integer, String> orderApp = Maps.newHashMap();
    private static volatile boolean loaded = false;
    private static AppData instance = new AppData();

    public static AppData getInstance() {
        return instance;
    }

    private AppData() {
        this.load();
    }

    private synchronized void load() {
        if (loaded) {
            return;
        }
        long s2 = System.currentTimeMillis();
        List<String> lines = this.readLines("/app_secret.txt");
        assert (lines != null);
        for (String line : lines) {
            try {
                String[] items = line.trim().split("\\s+");
                int value = Integer.parseInt(items[1]);
                appOrder.put(items[0], value);
                orderApp.putIfAbsent(value, items[0]);
            }
            catch (Exception e2) {
                log.warn("[" + line + "] failed !!!", (Throwable)e2);
            }
        }
        loaded = true;
    }

    public String name(Integer idx) {
        String value;
        if (!loaded) {
            this.load();
        }
        if ((value = orderApp.get(idx)) != null) {
            return value;
        }
        return "";
    }

    public int index(String name) {
        Integer val;
        if (!loaded) {
            this.load();
        }
        if ((val = appOrder.get(name)) != null) {
            return val;
        }
        return 0;
    }
}

