/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.utils;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import me.zhenchuan.utils.TimeUtils;

public class FastDateFormat {
    private static final char[][] DAY_POOL = new char[1000][8];
    private static final String[] DAY_STRING_POOL = new String[1000];
    private static final int DAY_START;
    private static final SimpleDateFormat format;

    public static String yyyy(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyy").format(Instant.ofEpochMilli(timeMillis));
        }
        return new String(DAY_POOL[dayIndex], 0, 4);
    }

    public static String yyyyMM(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyyMM").format(Instant.ofEpochMilli(timeMillis));
        }
        return new String(DAY_POOL[dayIndex], 0, 6);
    }

    public static String yyyyMMdd(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyyMMdd").format(Instant.ofEpochMilli(timeMillis));
        }
        return DAY_STRING_POOL[dayIndex];
    }

    public static String yyyyMMddHH(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyyMMddHH").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[10];
        System.arraycopy(src, 0, ret, 0, 8);
        int hour = TimeUtils.getHourOfDay(timeMillis);
        ret[8] = (char)(hour / 10 + 48);
        ret[9] = (char)(hour % 10 + 48);
        return new String(ret);
    }

    public static String yyyyMMddHHmm(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyyMMddHHmm").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[12];
        System.arraycopy(src, 0, ret, 0, 8);
        int hour = TimeUtils.getHourOfDay(timeMillis);
        ret[8] = (char)(hour / 10 + 48);
        ret[9] = (char)(hour % 10 + 48);
        int minute = TimeUtils.getMinuteOfDay(timeMillis) % 60;
        ret[10] = (char)(minute / 10 + 48);
        ret[11] = (char)(minute % 10 + 48);
        return new String(ret);
    }

    public static String yyyyMMddHHmmss(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[14];
        System.arraycopy(src, 0, ret, 0, 8);
        int hour = TimeUtils.getHourOfDay(timeMillis);
        ret[8] = (char)(hour / 10 + 48);
        ret[9] = (char)(hour % 10 + 48);
        int minute = TimeUtils.getMinuteOfDay(timeMillis) % 60;
        ret[10] = (char)(minute / 10 + 48);
        ret[11] = (char)(minute % 10 + 48);
        int second = TimeUtils.getSecondOfDay(timeMillis) % 60;
        ret[12] = (char)(second / 10 + 48);
        ret[13] = (char)(second % 10 + 48);
        return new String(ret);
    }

    public static String yyyyMMddHHmmssSSS(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[17];
        System.arraycopy(src, 0, ret, 0, 8);
        int hour = TimeUtils.getHourOfDay(timeMillis);
        ret[8] = (char)(hour / 10 + 48);
        ret[9] = (char)(hour % 10 + 48);
        int minute = TimeUtils.getMinuteOfDay(timeMillis) % 60;
        ret[10] = (char)(minute / 10 + 48);
        ret[11] = (char)(minute % 10 + 48);
        int second = TimeUtils.getSecondOfDay(timeMillis) % 60;
        ret[12] = (char)(second / 10 + 48);
        ret[13] = (char)(second % 10 + 48);
        int millis = (int)(timeMillis % 1000L);
        ret[14] = (char)(millis / 100 + 48);
        ret[15] = (char)(millis / 10 % 10 + 48);
        ret[16] = (char)(millis % 10 + 48);
        return new String(ret);
    }

    public static String yyyy_MM(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyy-MM").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[7];
        System.arraycopy(src, 0, ret, 0, 4);
        ret[4] = 45;
        System.arraycopy(src, 4, ret, 5, 2);
        return new String(ret);
    }

    public static String yyyy_MM_dd(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[10];
        System.arraycopy(src, 0, ret, 0, 4);
        ret[4] = 45;
        System.arraycopy(src, 4, ret, 5, 2);
        ret[7] = 45;
        System.arraycopy(src, 6, ret, 8, 2);
        return new String(ret);
    }

    public static String yyyy_MM_dd_HH(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[13];
        System.arraycopy(src, 0, ret, 0, 4);
        ret[4] = 45;
        System.arraycopy(src, 4, ret, 5, 2);
        ret[7] = 45;
        System.arraycopy(src, 6, ret, 8, 2);
        ret[10] = 32;
        int hour = TimeUtils.getHourOfDay(timeMillis);
        ret[11] = (char)(hour / 10 + 48);
        ret[12] = (char)(hour % 10 + 48);
        return new String(ret);
    }

    public static String yyyy_MM_dd_HH_mm(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[16];
        System.arraycopy(src, 0, ret, 0, 4);
        ret[4] = 45;
        System.arraycopy(src, 4, ret, 5, 2);
        ret[7] = 45;
        System.arraycopy(src, 6, ret, 8, 2);
        ret[10] = 32;
        int hour = TimeUtils.getHourOfDay(timeMillis);
        ret[11] = (char)(hour / 10 + 48);
        ret[12] = (char)(hour % 10 + 48);
        ret[13] = 58;
        int minute = TimeUtils.getMinuteOfDay(timeMillis) % 60;
        ret[14] = (char)(minute / 10 + 48);
        ret[15] = (char)(minute % 10 + 48);
        return new String(ret);
    }

    public static String yyyy_MM_dd_HH_mm_ss(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[19];
        System.arraycopy(src, 0, ret, 0, 4);
        ret[4] = 45;
        System.arraycopy(src, 4, ret, 5, 2);
        ret[7] = 45;
        System.arraycopy(src, 6, ret, 8, 2);
        ret[10] = 32;
        int hour = TimeUtils.getHourOfDay(timeMillis);
        ret[11] = (char)(hour / 10 + 48);
        ret[12] = (char)(hour % 10 + 48);
        ret[13] = 58;
        int minute = TimeUtils.getMinuteOfDay(timeMillis) % 60;
        ret[14] = (char)(minute / 10 + 48);
        ret[15] = (char)(minute % 10 + 48);
        ret[16] = 58;
        int second = TimeUtils.getSecondOfDay(timeMillis) % 60;
        ret[17] = (char)(second / 10 + 48);
        ret[18] = (char)(second % 10 + 48);
        return new String(ret);
    }

    public static String yyyy_MM_dd_HH_mm_ss_SSS(long timeMillis) {
        int dayIndex = TimeUtils.getDayIndex(timeMillis) - DAY_START;
        if (dayIndex < 0 || dayIndex >= 1000) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").format(Instant.ofEpochMilli(timeMillis));
        }
        char[] src = DAY_POOL[dayIndex];
        char[] ret = new char[23];
        System.arraycopy(src, 0, ret, 0, 4);
        ret[4] = 45;
        System.arraycopy(src, 4, ret, 5, 2);
        ret[7] = 45;
        System.arraycopy(src, 6, ret, 8, 2);
        ret[10] = 32;
        int hour = TimeUtils.getHourOfDay(timeMillis);
        ret[11] = (char)(hour / 10 + 48);
        ret[12] = (char)(hour % 10 + 48);
        ret[13] = 58;
        int minute = TimeUtils.getMinuteOfDay(timeMillis) % 60;
        ret[14] = (char)(minute / 10 + 48);
        ret[15] = (char)(minute % 10 + 48);
        ret[16] = 58;
        int second = TimeUtils.getSecondOfDay(timeMillis) % 60;
        ret[17] = (char)(second / 10 + 48);
        ret[18] = (char)(second % 10 + 48);
        ret[19] = 44;
        int millis = (int)(timeMillis % 1000L);
        ret[20] = (char)(millis / 100 + 48);
        ret[21] = (char)(millis / 10 % 10 + 48);
        ret[22] = (char)(millis % 10 + 48);
        return new String(ret);
    }

    public static String day2yyyyMMdd(int dayIndex) {
        int dd = dayIndex - DAY_START;
        if (dd < 0 || dd >= 1000) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").format(Instant.ofEpochMilli((long)dayIndex * 86400000L));
        }
        return DAY_STRING_POOL[dd];
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -360);
        DAY_START = TimeUtils.getDayIndex(cal.getTimeInMillis());
        for (int i2 = 0; i2 < 1000; ++i2) {
            long year = cal.get(1);
            long month = cal.get(2) + 1;
            long day = cal.get(5);
            char[] ymd = DAY_POOL[i2];
            ymd[0] = (char)(year / 1000L + 48L);
            ymd[1] = (char)(year / 100L % 10L + 48L);
            ymd[2] = (char)(year / 10L % 10L + 48L);
            ymd[3] = (char)(year % 10L + 48L);
            ymd[4] = (char)(month / 10L + 48L);
            ymd[5] = (char)(month % 10L + 48L);
            ymd[6] = (char)(day / 10L + 48L);
            ymd[7] = (char)(day % 10L + 48L);
            FastDateFormat.DAY_STRING_POOL[i2] = new String(ymd);
            cal.add(5, 1);
        }
        format = new SimpleDateFormat("");
    }
}

