/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.utils;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;

public class TimeUtils {
    private static final long millisOffset = TimeZone.getDefault().getRawOffset();

    public static void main(String[] args) {
        System.out.println(TimeUtils.rangeInDay(20180101L, 20180104L));
    }

    public static long compound(long start, long end) {
        long s2 = start / 10000L;
        long duration = (end - start) / 1000L % 999L;
        return s2 * 10000L + duration;
    }

    public static long[] deCompound(long time) {
        long s2 = time / 10000L * 10000L;
        long e2 = s2 + time % 10000L * 1000L;
        return new long[]{s2, e2};
    }

    public static long rangeInDay(long date1, long date2) {
        LocalDate day1 = TimeUtils.toDate(date1);
        LocalDate day2 = TimeUtils.toDate(date2);
        return day1.until(day2, ChronoUnit.DAYS) + 1L;
    }

    public static LocalDate toDate(long date) {
        String day = String.valueOf(date);
        return LocalDate.of(Integer.parseInt(day.substring(0, 4)), Integer.parseInt(day.substring(4, 6)), Integer.parseInt(day.substring(6, 8)));
    }

    public static int getSecondOfDay(long timestamp) {
        return (int)((timestamp + millisOffset) % 86400000L / 1000L);
    }

    public static int getMinuteOfDay(long timestamp) {
        return (int)((timestamp + millisOffset) % 86400000L / 60000L);
    }

    public static int getHourOfDay(long timestamp) {
        return (int)((timestamp + millisOffset) % 86400000L / 3600000L);
    }

    public static int getHourIndex(long timestamp) {
        return (int)((timestamp + millisOffset) / 3600000L);
    }

    public static int getDayIndex(long timestamp) {
        return (int)((timestamp + millisOffset) / 86400000L);
    }

    public static int getDayOfWeek(long timestamp) {
        return (int)((timestamp + millisOffset + 259200000L) % 604800000L / 86400000L);
    }

    public static long getMondayMillis(long timestamp) {
        return timestamp - (timestamp + millisOffset + 259200000L) % 604800000L;
    }

    public static long getTimeMillis(int dayIndex, int secondOfDay) {
        return (long)dayIndex * 86400000L - millisOffset + (long)secondOfDay * 1000L;
    }
}

