/*
 * Decompiled with CFR 0.152.
 */
package net.ipip.datx;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import net.ipip.datx.IPv4FormatException;
import net.ipip.datx.Util;

public class District {
    private byte[] data;
    private long indexSize;

    public District(String name) throws IOException {
        Path path = Paths.get(name, new String[0]);
        this.data = Files.readAllBytes(path);
        this.indexSize = Util.bytesToLong(this.data[0], this.data[1], this.data[2], this.data[3]);
    }

    public String[] find(String ips) throws IPv4FormatException {
        if (!Util.isIPv4Address(ips)) {
            throw new IPv4FormatException();
        }
        long val = Util.ip2long(ips);
        int low = 0;
        int mid = 0;
        int high = new Long((this.indexSize - 262144L - 262148L) / 13L).intValue() - 1;
        int pos = 0;
        while (low <= high) {
            mid = (low + high) / 2;
            pos = mid * 13 + 262148;
            long start = Util.bytesToLong(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
            long end = Util.bytesToLong(this.data[pos + 4], this.data[pos + 5], this.data[pos + 6], this.data[pos + 7]);
            if (val > end) {
                low = mid + 1;
                continue;
            }
            if (val < start) {
                high = mid - 1;
                continue;
            }
            long off = Util.bytesToLong(this.data[pos + 11], this.data[pos + 10], this.data[pos + 9], this.data[pos + 8]);
            int len = new Byte(this.data[pos + 12]).intValue();
            int offset = new Long(off - 262144L + this.indexSize).intValue();
            byte[] loc = Arrays.copyOfRange(this.data, offset, offset + len);
            return new String(loc, Charset.forName("UTF-8")).split("\t", -1);
        }
        return null;
    }
}

