/*
 * Decompiled with CFR 0.152.
 */
package store;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicPropertyFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import store.CassandraStore$1;
import store.KVStore;
import store.Metrics;

public class CassandraStore
implements KVStore<List<byte[]>> {
    private static final Logger log = LoggerFactory.getLogger(CassandraStore.class);
    final String keyspace;
    public static final String UID_COLUMN = "uid";
    public static final String TIME_COLUMN = "time";
    public static final String DATA_COLUMN = "data";
    private Session session;
    private Cluster cluster;
    private DynamicPropertyFactory propertyFactory = DynamicPropertyFactory.getInstance();
    static final Map<Long, String> SHARD_TABLE = Maps.newHashMap();
    private static final ThreadPoolExecutor executor;
    private int defaultTTL = 3600;
    final Timer cassandraWriteDurationTimer = Metrics.timer(CassandraStore.class, "time.write");
    final Timer cassandraReadDurationTimer = Metrics.timer(CassandraStore.class, "time.read");
    final Meter writeMeter = Metrics.meter(CassandraStore.class, "meter.write");
    final Meter readMeter = Metrics.meter(CassandraStore.class, "meter.read");
    final Meter readmeMeter = Metrics.meter(CassandraStore.class, "meter.readme.success");
    final Meter readmeErrorMeter = Metrics.meter(CassandraStore.class, "meter.readme.error");

    public CassandraStore(String string) {
        this.keyspace = string;
        log.info("cassandra keyspace:{}", (Object)this.keyspace);
    }

    public CassandraStore(String string, int n2) {
        this(string);
        this.defaultTTL = n2;
    }

    private static ThreadPoolExecutor newFixedThreadPoolWithQueueSize(int n2, int n3) {
        return new ThreadPoolExecutor(n2, n2, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(n3, true), new ThreadFactoryBuilder().setNameFormat("cassandra-cbk-thread-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void connect(String string) {
        Metadata metadata = string.split(",");
        HashSet<InetSocketAddress> hashSet = new HashSet<InetSocketAddress>();
        for (String string2 : metadata) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string2.split(":")[0], Integer.parseInt(string2.split(":")[1]));
            hashSet.add(inetSocketAddress);
        }
        this.cluster = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().build())).withPoolingOptions(this.getPoolingOptions()).addContactPointsWithPorts(hashSet).withRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE).build();
        Metadata metadata2 = this.cluster.getMetadata();
        System.out.printf("Connected to cluster: %s%n", metadata2.getClusterName());
        for (Host host : metadata2.getAllHosts()) {
            System.out.printf("Datacenter: %s; Host: %s; Rack: %s%n", host.getDatacenter(), host.getAddress(), host.getRack());
        }
        try {
            this.session = this.cluster.connect(this.keyspace);
        }
        catch (NoHostAvailableException noHostAvailableException) {
            noHostAvailableException.printStackTrace();
        }
    }

    public void connect() {
        String string = this.propertyFactory.getStringProperty("contactPoints", null).get();
        this.connect(string);
    }

    @Override
    public void shutdown() {
        try {
            executor.shutdown();
            executor.awaitTermination(60L, TimeUnit.SECONDS);
            if (this.session != null) {
                this.session.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public List<byte[]> get(long l2, long l3, long l4, long l5) {
        this.readMeter.mark();
        Select select = this.buildSelect(l2, l3, l4, l5);
        try {
            Timer.Context context = this.cassandraReadDurationTimer.time();
            ResultSetFuture resultSetFuture = this.session.executeAsync((Statement)select);
            ResultSet resultSet = (ResultSet)resultSetFuture.get(15L, TimeUnit.SECONDS);
            context.stop();
            return resultSet.all().stream().map(row -> row.getBytes(DATA_COLUMN).array()).collect(Collectors.toList());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Select buildSelect(long l2, Long l3, Long l4, Long l5) {
        Select select = QueryBuilder.select().column(DATA_COLUMN).from(SHARD_TABLE.get(l2));
        select.where(QueryBuilder.eq((String)UID_COLUMN, (Object)l3)).and(QueryBuilder.gte((String)TIME_COLUMN, (Object)l4)).and(QueryBuilder.lte((String)TIME_COLUMN, (Object)l5));
        return select;
    }

    @Override
    public void asyncGet(long l2, long l3, long l4, long l5, Consumer<List<byte[]>> consumer) {
        this.readMeter.mark();
        Select select = this.buildSelect(l2, l3, l4, l5);
        ResultSetFuture resultSetFuture = this.session.executeAsync((Statement)select);
        Futures.addCallback((ListenableFuture)resultSetFuture, (FutureCallback)new CassandraStore$1(this, consumer), (Executor)executor);
    }

    @Override
    public void asyncSave(long l2, long l3, long l4, byte[] byArray, int n2) {
        this.writeMeter.mark();
        Insert insert = this.buildInsert(l2, l3, l4, byArray, n2);
        this.session.executeAsync((Statement)insert);
    }

    private Insert buildInsert(long l2, long l3, long l4, byte[] byArray, int n2) {
        Insert insert = QueryBuilder.insertInto((String)SHARD_TABLE.get(l2)).value(UID_COLUMN, (Object)l3).value(TIME_COLUMN, (Object)l4).value(DATA_COLUMN, (Object)ByteBuffer.wrap(byArray));
        if (n2 > 0) {
            insert.using(QueryBuilder.ttl((int)n2));
        }
        return insert;
    }

    @Override
    public boolean save(long l2, long l3, long l4, byte[] byArray, int n2) {
        this.writeMeter.mark();
        Insert insert = this.buildInsert(l2, l3, l4, byArray, n2);
        try {
            Timer.Context context = this.cassandraWriteDurationTimer.time();
            this.session.execute((Statement)insert);
            context.stop();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean save(long l2, long l3, long l4, byte[] byArray) {
        return this.save(l2, l3, l4, byArray, 0);
    }

    @Override
    public void asyncSave(long l2, long l3, long l4, byte[] byArray) {
        this.asyncSave(l2, l3, l4, byArray, 0);
    }

    private PoolingOptions getPoolingOptions() {
        int n2 = this.propertyFactory.getIntProperty("connectionsPerHost", 10).get();
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, n2).setMaxConnectionsPerHost(HostDistance.LOCAL, n2).setCoreConnectionsPerHost(HostDistance.REMOTE, 2).setMaxConnectionsPerHost(HostDistance.REMOTE, 4).setHeartbeatIntervalSeconds(60);
        return poolingOptions;
    }

    static /* synthetic */ DynamicPropertyFactory access$000(CassandraStore cassandraStore) {
        return cassandraStore.propertyFactory;
    }

    static {
        LongStream.range(0L, 60L).forEach(l2 -> SHARD_TABLE.put(l2, "S" + l2));
        executor = CassandraStore.newFixedThreadPoolWithQueueSize(Runtime.getRuntime().availableProcessors(), 200000);
    }
}

