/*
 * Decompiled with CFR 0.152.
 */
package client.handi;

import a.b;
import com.b.a.a.g;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.config.DynamicPropertyFactory;
import handi.DailyActivity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.zhenchuan.d.a;
import me.zhenchuan.e.i;
import store.CassandraStore;
import store.KVStore;

public class HistoryClient {
    private KVStore<List<byte[]>> store;
    private KVStore<List<byte[]>> store2;
    private KVStore<List<byte[]>> store3;
    private DynamicPropertyFactory propertyFactory = DynamicPropertyFactory.getInstance();
    private static final HistoryClient historyClient = new HistoryClient();
    private static final Set<Long> store1Shards = Sets.newHashSet((Object[])new Long[]{30L, 33L, 36L, 39L, 42L, 45L, 31L, 34L, 37L, 40L, 43L, 46L, 32L, 35L, 38L, 41L, 44L, 47L});
    private static final Set<Long> store3Shards = Sets.newHashSet((Object[])new Long[]{10L, 12L, 21L, 14L, 16L, 22L, 18L, 20L, 23L, 6L, 7L, 8L});
    private static final Set<Long> store1PartsShards = Sets.newHashSet((Object[])new Long[]{0L, 1L, 2L, 3L, 4L, 5L, 9L, 11L, 13L, 15L, 17L, 19L});

    public static final HistoryClient getInstance() {
        return historyClient;
    }

    private HistoryClient() {
        String string = this.propertyFactory.getStringProperty("handiKeyspace", "se77en").get();
        this.store = new CassandraStore(string);
        String string2 = this.propertyFactory.getStringProperty("contactPoints", null).get();
        this.store.connect(string2);
        String string3 = this.propertyFactory.getStringProperty("contactPoints2", null).get();
        this.store2 = new CassandraStore(string);
        this.store2.connect(string3);
        String string4 = this.propertyFactory.getStringProperty("contactPoints3", null).get();
        this.store3 = new CassandraStore(string);
        this.store3.connect(string4);
    }

    public List<DailyActivity> get(String string, long l2, long l3, boolean bl) {
        List<DailyActivity> list;
        long l4 = a.T(string);
        long l5 = a.S(string);
        List<byte[]> list2 = null;
        if (store1Shards.contains(l5)) {
            list2 = this.store.get(l5, l4, l2, l3);
        } else {
            list2 = this.store2.get(l5, l4, l2, l3);
            if (store1PartsShards.contains(l5)) {
                list = this.store.get(l5, l4, l2, l3);
                list2.addAll(list);
            }
            if (store3Shards.contains(l5)) {
                list = this.store3.get(l5, l4, l2, l3);
                list2.addAll(list);
            }
        }
        list = list2.stream().map(byArray -> b.a(new me.zhenchuan.db.history.DailyActivity().decode(new g((byte[])byArray)))).collect(Collectors.toList());
        list = this.unique(list);
        if (bl) {
            return this.wrapDailyActivityList(list, l2, l3);
        }
        return list;
    }

    private List<DailyActivity> unique(List<DailyActivity> list) {
        HashSet hashSet = Sets.newHashSet();
        ArrayList arrayList = Lists.newArrayList();
        for (DailyActivity dailyActivity : list) {
            int n2 = dailyActivity.getDay();
            if (hashSet.contains(n2)) continue;
            arrayList.add(dailyActivity);
            hashSet.add(n2);
        }
        return arrayList;
    }

    public void asyncGet(String string, long l2, long l3, Consumer<List<DailyActivity>> consumer, boolean bl) {
        long l4 = a.T(string);
        long l5 = a.S(string);
        KVStore<List<byte[]>> kVStore = null;
        kVStore = store1Shards.contains(l5) ? this.store : this.store2;
        kVStore.asyncGet(l5, l4, l2, l3, list -> {
            List<DailyActivity> list2 = list.stream().map(byArray -> b.a(new me.zhenchuan.db.history.DailyActivity().decode(new g((byte[])byArray)))).collect(Collectors.toList());
            if (bl) {
                consumer.accept(this.wrapDailyActivityList(list2, l2, l3));
            } else {
                consumer.accept(list2);
            }
        });
    }

    private List<DailyActivity> wrapDailyActivityList(List<DailyActivity> list, long l3, long l4) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        i.i(l3, l4).forEach(l2 -> linkedHashMap.put(l2.intValue(), DailyActivity.noActivity((int)l2.intValue())));
        list.forEach(dailyActivity -> linkedHashMap.put(dailyActivity.getDay(), dailyActivity));
        return new ArrayList<DailyActivity>(linkedHashMap.values());
    }

    public void close() {
        this.store.shutdown();
        this.store2.shutdown();
        this.store3.shutdown();
    }
}

