(defproject org.theparanoidtimes/clj-pnm "0.2.0"
  :description "A Clojure(Script) library for reading and writing Netpbm format"
  :url "https://github.com/28/clj-pnm"
  :license {:name         "The MIT License"
            :distribution :repo
            :url          "https://opensource.org/licenses/MIT"}
  :pom-addition ([:developers [:developer
                               [:id "28"]
                               [:name "Dejan Josifović"]
                               [:url "https://theparanoidtimes.org"]
                               [:email "theparanoidtimes@posteo.net"]
                               [:roles
                                [:role "developer"]
                                [:role "maintainer"]]]]
                 [:organization ([:name "theparanoidtimes.org"]
                                 [:url "https://theparanoidtimes.org"])])
  :manifest {"Built-By" "28"
             "X-Author" "28"
             "X-Author-Email" "theparanoidtimes@posteo.net"
             "Implementation-Title" ~#(:name %)
             "Implementation-Version" ~#(:version %)
             "Implementation-Vendor" "theparanoidtimes.org"
             "Implementation-URL" ~#(:url %)}
  :min-lein-version "2.7.1"
  :deploy-repositories [["releases" {:url "https://repo.clojars.org"
                                     :creds :gpg}]
                        ["snapshots" {:url "https://repo.clojars.org"
                                      :creds :gpg}]]
  :signing {:gpg-key "theparanoidtimes@posteo.net"}
  :dependencies [[org.clojure/clojure "1.11.1"]
                 [org.clojure/clojurescript "1.11.60"]]
  :source-paths ["src"]
  :test-paths ["test/clj" "test/cljs"]
  :aliases {"fig:build"  ["run" "-m" "figwheel.main" "-b" "dev" "-r"]
            "fig:min"    ["run" "-m" "figwheel.main" "-O" "advanced" "-bo" "dev"]
            "fig:test"   ["run" "-m" "figwheel.main" "-co" "test.cljs.edn" "-m" "clj-pnm.test-runner"]}
  :profiles {:dev {:dependencies [[com.bhauman/figwheel-main "0.2.18"]
                                  [org.slf4j/slf4j-nop "2.0.7"]]
                   :resource-paths ["target"]
                   :clean-targets ^{:protect false} ["target"]}})
