(defproject org.theparanoidtimes/cljs-map-pins "0.1.0"
  :description "cljs-map-pins is a ClojureScript library for drawing a set of pins from an EDN file on a world map."
  :url "https://github.com/28/cljs-map-pins"
  :license {:name "GNU Lesser General Public License v3.0"
            :distribution :repo
            :url "https://www.gnu.org/licenses/lgpl-3.0.en.html"}
  :pom-addition ([:developers [:developer
                               [:id "28"]
                               [:name "Dejan Josifović"]
                               [:url "https://theparanoidtimes.org"]
                               [:email "theparanoidtimes@posteo.net"]
                               [:roles
                                [:role "developer"]
                                [:role "maintainer"]]]]
                 [:organization ([:name "theparanoidtimes.org"]
                                 [:url "https://theparanoidtimes.org"])])
  :manifest {"Built-By" "28"
             "X-Author" "28"
             "X-Author-Email" "theparanoidtimes@posteo.net"
             "Implementation-Title" ~#(:name %)
             "Implementation-Version" ~#(:version %)
             "Implementation-Vendor" "theparanoidtimes.org"
             "Implementation-URL" ~#(:url %)}
  :min-lein-version "2.7.1"
  :deploy-repositories [["releases" {:url "https://repo.clojars.org"
                                     :creds :gpg}]
                        ["snapshots" {:url "https://repo.clojars.org"
                                      :creds :gpg}]]
  :signing {:gpg-key "theparanoidtimes@posteo.net"}
  :dependencies [[org.clojure/clojure "1.11.1"]
                 [org.clojure/clojurescript "1.11.60"]
                 [cljsjs/openlayers "7.2.2-0"]
                 [prismatic/schema "1.4.1"]]
  :source-paths ["src"]
  :jar-exclusions [#"public" #"html"]
  :plugins [[lein-exec "0.3.7"]
            [lein-codox "0.10.8"]]
  :codox {:language :clojurescript
          :output-path "doc/api"}
  :aliases {"full-clean" ["exec" "-e" "(run! (fn [d] (run! #(clojure.java.io/delete-file % true) (reverse (file-seq (clojure.java.io/file d))))) [\"target\" \"resources/public/cljs-out\"])"]
            "fig:build"          ["run" "-m" "figwheel.main" "-b" "dev" "-r"]
            "fig:min"            ["run" "-m" "figwheel.main" "-O" "advanced" "-bo" "dev"]
            "fig:test"           ["run" "-m" "figwheel.main" "-co" "test.cljs.edn" "-m" "cljs-map-pins.test-runner"]
            "fig:test-headless"  ["run" "-m" "figwheel.main" "-co" "test-headless.cljs.edn" "-m" "cljs-map-pins.test-runner"]}
  :profiles {:dev {:dependencies [[com.bhauman/figwheel-main "0.2.18"]
                                  [org.slf4j/slf4j-nop "2.0.7"]]
                   :resource-paths ["target"]
                   :clean-targets ^{:protect false} ["target"]}})
