/*
 * Decompiled with CFR 0.152.
 */
package org.tigerdb.lion.streams;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.mpizutil.electrolist.structure.ElectroList;
import org.tigerdb.lion.streams.OOS;

public class ObjectWriter<T> {
    private OOS oos;
    private final File fileObjects;

    public ObjectWriter(File fileObjects) throws IOException {
        this.oos = new OOS(new FileOutputStream(fileObjects, true));
        this.fileObjects = fileObjects;
    }

    public ObjectWriter(String fileObjectsPath) throws IOException {
        this(new File(fileObjectsPath));
    }

    public void writeObjectAndFlush(T object) throws IOException {
        this.writeObject(object);
        this.flush();
    }

    public void writeObject(T obj) throws IOException {
        this.oos.writeObject(obj);
    }

    public void flush() throws IOException {
        this.oos.flush();
    }

    public void close() throws IOException {
        this.oos.close();
    }

    public void writeObjectsFrom(ElectroList<T> listObjects) throws IOException {
        for (T obj : listObjects) {
            this.oos.writeObject(obj);
        }
        this.oos.flush();
    }

    public void clearFile() throws IOException {
        this.oos = new OOS(new FileOutputStream(this.fileObjects));
    }

    public void update(ElectroList<T> listObjects) throws IOException {
        this.clearFile();
        this.writeObjectsFrom(listObjects);
    }
}

