/*
 * Decompiled with CFR 0.152.
 */
package org.mpizutil.electrolist.structure;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectUtils {
    private static final String BOOLEAN = "boolean";
    private static final String BYTE = "byte";
    private static final String SHORT = "short";
    private static final String INTEGER = "int";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final byte BOOLEAN_SIZE = 1;
    private static final byte BYTE_SIZE = 1;
    private static final byte SHORT_SIZE = 2;
    private static final byte INTEGER_SIZE = 4;
    private static final byte LONG_SIZE = 8;
    private static final byte FLOAT_SIZE = 4;
    private static final byte DOUBLE_SIZE = 8;

    private boolean isNumberClazz(Class clazz) {
        return clazz.getSuperclass().equals(Number.class) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE) || clazz.equals(Byte.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE);
    }

    private boolean isBool(Class clazz) {
        return clazz.getSimpleName().toLowerCase().equals(BOOLEAN);
    }

    private int sizeOfNumber(Number number) {
        String clazzName;
        switch (clazzName = number.getClass().getSimpleName().toLowerCase()) {
            case "float": {
                return 4;
            }
            case "double": {
                return 8;
            }
            case "byte": {
                return 1;
            }
            case "short": {
                return 2;
            }
            case "int": {
                return 4;
            }
        }
        return 8;
    }

    private int sizeOfStr(String str) {
        try {
            return str == null ? 0 : str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException ex) {
            return 0;
        }
    }

    public int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        Class<?> objClazz = obj.getClass();
        if (this.isNumberClazz(objClazz)) {
            return this.sizeOfNumber((Number)obj);
        }
        if (String.class.equals(objClazz)) {
            return this.sizeOfStr(obj.toString());
        }
        if (this.isBool(objClazz)) {
            return 1;
        }
        int sizeof = 0;
        Field[] fields = objClazz.getDeclaredFields();
        int fieldsLen = fields.length;
        for (int i = 0; i < fieldsLen; ++i) {
            try {
                fields[i].setAccessible(true);
                sizeof += this.sizeof(fields[i].get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(ObjectUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        fields = null;
        return sizeof;
    }
}

