/*
 * Decompiled with CFR 0.152.
 */
package org.tigerdb.lion.store.threads;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mpizutil.electrolist.structure.ElectroList;
import org.tigerdb.lion.streams.ObjectWriter;

public class TSaver<T>
extends Thread {
    private final ElectroList<T> listObjects;
    private final ObjectWriter<T> writer;
    private int currentObjectCount;
    private int listSize;
    private boolean save;

    public TSaver(ElectroList<T> listObjects, ObjectWriter<T> writer) {
        this.listObjects = listObjects;
        this.writer = writer;
        this.currentObjectCount = this.listSize = listObjects.size();
        this.setName("TSaver " + this.getId());
    }

    public boolean hasNewObjects() {
        return this.currentObjectCount < this.listObjects.size();
    }

    public void updateCounter() {
        this.listSize = this.currentObjectCount = this.listObjects.size();
    }

    public void saveNow() {
        this.save = true;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.hasNewObjects()) {
                        ElectroList subList = (ElectroList)this.listObjects.subList(this.currentObjectCount, this.listObjects.size());
                        this.updateCounter();
                        for (Object t : subList) {
                            this.writer.writeObject(t);
                        }
                    }
                    Thread.sleep(10L);
                }
            }
            catch (IOException | InterruptedException ex) {
                Logger.getLogger(TSaver.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }
}

