/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.util.Hashtable;

public abstract class ReverseCodeTable {
    static final byte G0 = 0;
    static final byte G1 = 1;
    protected Character lastLookupKey = null;
    protected Hashtable lastLookupValue = null;
    protected byte[] g = new byte[2];
    protected String charsetsUsed;

    public abstract boolean isCombining(Character var1);

    public abstract Hashtable getCharTable(Character var1);

    public ReverseCodeTable() {
        this.init();
    }

    public void init() {
        this.g[0] = 66;
        this.g[1] = 69;
        this.charsetsUsed = "BE";
    }

    public byte getPreviousG0() {
        return this.g[0];
    }

    public byte getPreviousG1() {
        return this.g[1];
    }

    public void setPreviousG0(int table) {
        this.g[0] = (byte)table;
    }

    public void setPreviousG1(int table) {
        this.g[1] = (byte)table;
    }

    public Hashtable codeTableHash(Character c) {
        if (this.lastLookupKey != null && c.equals(this.lastLookupKey)) {
            return this.lastLookupValue;
        }
        this.lastLookupKey = c;
        this.lastLookupValue = this.getCharTable(c);
        return this.lastLookupValue;
    }

    public boolean charHasMatch(Character c) {
        return this.codeTableHash(c) != null;
    }

    public boolean inPreviousG0CharEntry(Character c) {
        Hashtable chars = this.codeTableHash(c);
        return chars != null && chars.get(this.getPreviousG0()) != null;
    }

    public boolean inPreviousG1CharEntry(Character c) {
        Hashtable chars = this.codeTableHash(c);
        return chars != null && chars.get(this.getPreviousG1()) != null;
    }

    public char[] getCurrentG0CharEntry(Character c) {
        return this.getCharEntry(c, this.getPreviousG0());
    }

    public char[] getCurrentG1CharEntry(Character c) {
        return this.getCharEntry(c, this.getPreviousG1());
    }

    public char[] getCharEntry(Character c, int charset) {
        Hashtable chars = this.codeTableHash(c);
        if (chars == null) {
            return new char[0];
        }
        return (char[])chars.get(charset);
    }

    public int getBestCharSet(Character c) {
        Hashtable chars = this.codeTableHash(c);
        if (chars.keySet().size() == 1) {
            return (Integer)chars.keySet().iterator().next();
        }
        for (int i = 0; i < this.charsetsUsed.length(); ++i) {
            char toUse = this.charsetsUsed.charAt(i);
            if (!chars.containsKey(toUse)) continue;
            return toUse;
        }
        int returnVal = chars.containsKey(83) ? 83 : (Integer)chars.keySet().iterator().next();
        this.charsetsUsed = this.charsetsUsed + (char)returnVal;
        return returnVal;
    }

    public static char[] deHexify(String str) {
        char[] result = null;
        if (str.length() == 2) {
            result = new char[]{(char)Integer.parseInt(str, 16)};
        } else if (str.length() == 6) {
            result = new char[]{(char)Integer.parseInt(str.substring(0, 2), 16), (char)Integer.parseInt(str.substring(2, 4), 16), (char)Integer.parseInt(str.substring(4, 6), 16)};
        }
        return result;
    }
}

