/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReverseCodeTableHandler
extends DefaultHandler {
    private Hashtable charset;
    private Vector combiningchars;
    private boolean useAlt = false;
    private Integer isocode;
    private char[] marc;
    private Character ucs;
    private boolean combining;
    private String tag;
    private StringBuffer data;
    private Locator locator;

    public Hashtable getCharSets() {
        return this.charset;
    }

    public Vector getCombiningChars() {
        return this.combiningchars;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXParseException {
        if (name.equals("characterSet")) {
            this.isocode = Integer.valueOf(atts.getValue("ISOcode"), 16);
        } else if (name.equals("marc")) {
            this.data = new StringBuffer();
        } else if (name.equals("codeTables")) {
            this.charset = new Hashtable();
            this.combiningchars = new Vector();
        } else if (name.equals("ucs")) {
            this.data = new StringBuffer();
        } else if (name.equals("alt")) {
            this.data = new StringBuffer();
        } else if (name.equals("code")) {
            this.combining = false;
        } else if (name.equals("isCombining")) {
            this.data = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.data != null) {
            this.data.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXParseException {
        if (name.equals("marc")) {
            String marcstr = this.data.toString();
            if (marcstr.length() == 6) {
                this.marc = new char[3];
                this.marc[0] = (char)Integer.parseInt(marcstr.substring(0, 2), 16);
                this.marc[1] = (char)Integer.parseInt(marcstr.substring(2, 4), 16);
                this.marc[2] = (char)Integer.parseInt(marcstr.substring(4, 6), 16);
            } else {
                this.marc = new char[1];
                this.marc[0] = (char)Integer.parseInt(marcstr, 16);
            }
        } else if (name.equals("ucs")) {
            if (this.data.length() > 0) {
                this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
            } else {
                this.useAlt = true;
            }
        } else if (name.equals("alt")) {
            if (this.useAlt && this.data.length() > 0) {
                this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
                this.useAlt = false;
            }
        } else if (name.equals("code")) {
            if (this.combining) {
                this.combiningchars.add(this.ucs);
            }
            if (this.charset.get(this.ucs) == null) {
                Hashtable<Integer, char[]> h = new Hashtable<Integer, char[]>(1);
                h.put(this.isocode, this.marc);
                this.charset.put(this.ucs, h);
            } else {
                Hashtable h = (Hashtable)this.charset.get(this.ucs);
                h.put(this.isocode, this.marc);
            }
        } else if (name.equals("isCombining") && this.data.toString().equals("true")) {
            this.combining = true;
        }
        this.data = null;
    }
}

